# Generated by Django 2.2.2 on 2019-06-27 02:07

from django.db import migrations, models
import django.utils.timezone


def update_part_revision_configuration(apps, schema_editor):
    Part = apps.get_model('bom', 'Part')
    PartRevision = apps.get_model('bom', 'PartRevision')

    for p in Part.objects.all():
        revs = PartRevision.objects.filter(part=p)
        latest = revs.order_by('-id').first()
        for rev in revs:
            if rev != latest:
                rev.configuration = 'R'
                rev.save()


class Migration(migrations.Migration):

    dependencies = [
        ('bom', '0019_auto_20190624_1246'),
    ]

    operations = [
        migrations.AddField(
            model_name='partrevision',
            name='configuration',
            field=models.CharField(choices=[('R', 'Released'), ('W', 'Working')], default='W', max_length=1),
        ),
        migrations.RunPython(update_part_revision_configuration),
        migrations.AlterField(
            model_name='partrevision',
            name='timestamp',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
    ]
