/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.base.mdarray.MDDoubleArray;
import ch.systemsx.cisd.base.mdarray.MDFloatArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5BooleanReader;
import ch.systemsx.cisd.hdf5.HDF5ByteReader;
import ch.systemsx.cisd.hdf5.HDF5CompoundMappingHints;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5CompoundReader;
import ch.systemsx.cisd.hdf5.HDF5CompoundType;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DataType;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5DateTimeReader;
import ch.systemsx.cisd.hdf5.HDF5DoubleReader;
import ch.systemsx.cisd.hdf5.HDF5EnumReader;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValue;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueArray;
import ch.systemsx.cisd.hdf5.HDF5FileLevelReadOnlyHandler;
import ch.systemsx.cisd.hdf5.HDF5FloatReader;
import ch.systemsx.cisd.hdf5.HDF5IntReader;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.HDF5LongReader;
import ch.systemsx.cisd.hdf5.HDF5MDDataBlock;
import ch.systemsx.cisd.hdf5.HDF5ObjectInformation;
import ch.systemsx.cisd.hdf5.HDF5ObjectReadOnlyInfoProviderHandler;
import ch.systemsx.cisd.hdf5.HDF5ObjectType;
import ch.systemsx.cisd.hdf5.HDF5OpaqueReader;
import ch.systemsx.cisd.hdf5.HDF5OpaqueType;
import ch.systemsx.cisd.hdf5.HDF5ReferenceReader;
import ch.systemsx.cisd.hdf5.HDF5ShortReader;
import ch.systemsx.cisd.hdf5.HDF5StringReader;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationArray;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationReader;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import ch.systemsx.cisd.hdf5.HDF5UnsignedByteReader;
import ch.systemsx.cisd.hdf5.HDF5UnsignedIntReader;
import ch.systemsx.cisd.hdf5.HDF5UnsignedLongReader;
import ch.systemsx.cisd.hdf5.HDF5UnsignedShortReader;
import ch.systemsx.cisd.hdf5.IHDF5BooleanReader;
import ch.systemsx.cisd.hdf5.IHDF5ByteReader;
import ch.systemsx.cisd.hdf5.IHDF5CompoundInformationRetriever;
import ch.systemsx.cisd.hdf5.IHDF5CompoundReader;
import ch.systemsx.cisd.hdf5.IHDF5DateTimeReader;
import ch.systemsx.cisd.hdf5.IHDF5DoubleReader;
import ch.systemsx.cisd.hdf5.IHDF5EnumReader;
import ch.systemsx.cisd.hdf5.IHDF5FileLevelReadOnlyHandler;
import ch.systemsx.cisd.hdf5.IHDF5FloatReader;
import ch.systemsx.cisd.hdf5.IHDF5IntReader;
import ch.systemsx.cisd.hdf5.IHDF5LongReader;
import ch.systemsx.cisd.hdf5.IHDF5ObjectReadOnlyInfoProviderHandler;
import ch.systemsx.cisd.hdf5.IHDF5OpaqueReader;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5ReferenceReader;
import ch.systemsx.cisd.hdf5.IHDF5ShortReader;
import ch.systemsx.cisd.hdf5.IHDF5StringReader;
import ch.systemsx.cisd.hdf5.IHDF5TimeDurationReader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.io.File;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import ncsa.hdf.hdf5lib.exceptions.HDF5DatatypeInterfaceException;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

class HDF5Reader
implements IHDF5Reader {
    private final HDF5BaseReader baseReader;
    private final IHDF5FileLevelReadOnlyHandler fileHandler;
    private final IHDF5ObjectReadOnlyInfoProviderHandler objectHandler;
    private final IHDF5ByteReader byteReader;
    private final IHDF5ByteReader ubyteReader;
    private final IHDF5ShortReader shortReader;
    private final IHDF5ShortReader ushortReader;
    private final IHDF5IntReader intReader;
    private final IHDF5IntReader uintReader;
    protected final IHDF5LongReader longReader;
    private final IHDF5LongReader ulongReader;
    private final IHDF5FloatReader floatReader;
    private final IHDF5DoubleReader doubleReader;
    private final IHDF5BooleanReader booleanReader;
    private final IHDF5StringReader stringReader;
    private final IHDF5EnumReader enumReader;
    private final IHDF5CompoundReader compoundReader;
    private final IHDF5DateTimeReader dateTimeReader;
    private final HDF5TimeDurationReader timeDurationReader;
    private final IHDF5ReferenceReader referenceReader;
    private final IHDF5OpaqueReader opaqueReader;

    HDF5Reader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
        baseReader.setMyReader(this);
        this.fileHandler = new HDF5FileLevelReadOnlyHandler(baseReader);
        this.objectHandler = new HDF5ObjectReadOnlyInfoProviderHandler(baseReader);
        this.byteReader = new HDF5ByteReader(baseReader);
        this.ubyteReader = new HDF5UnsignedByteReader(baseReader);
        this.shortReader = new HDF5ShortReader(baseReader);
        this.ushortReader = new HDF5UnsignedShortReader(baseReader);
        this.intReader = new HDF5IntReader(baseReader);
        this.uintReader = new HDF5UnsignedIntReader(baseReader);
        this.longReader = new HDF5LongReader(baseReader);
        this.ulongReader = new HDF5UnsignedLongReader(baseReader);
        this.floatReader = new HDF5FloatReader(baseReader);
        this.doubleReader = new HDF5DoubleReader(baseReader);
        this.booleanReader = new HDF5BooleanReader(baseReader);
        this.stringReader = new HDF5StringReader(baseReader);
        this.enumReader = new HDF5EnumReader(baseReader);
        this.compoundReader = new HDF5CompoundReader(baseReader, this.enumReader);
        this.dateTimeReader = new HDF5DateTimeReader(baseReader, (HDF5LongReader)this.longReader);
        this.timeDurationReader = new HDF5TimeDurationReader(baseReader, (HDF5LongReader)this.longReader);
        this.referenceReader = new HDF5ReferenceReader(baseReader);
        this.opaqueReader = new HDF5OpaqueReader(baseReader);
    }

    void checkOpen() {
        this.baseReader.checkOpen();
    }

    int getFileId() {
        return this.baseReader.fileId;
    }

    @Override
    public IHDF5FileLevelReadOnlyHandler file() {
        return this.fileHandler;
    }

    @Override
    public boolean isPerformNumericConversions() {
        return this.baseReader.performNumericConversions;
    }

    @Override
    public String getHouseKeepingNameSuffix() {
        return this.baseReader.houseKeepingNameSuffix;
    }

    @Override
    public File getFile() {
        return this.baseReader.hdf5File;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void close() {
        this.baseReader.close();
    }

    @Override
    public boolean isClosed() {
        return this.baseReader.isClosed();
    }

    @Override
    public IHDF5ObjectReadOnlyInfoProviderHandler object() {
        return this.objectHandler;
    }

    @Override
    public HDF5LinkInformation getLinkInformation(String objectPath) {
        return this.objectHandler.getLinkInformation(objectPath);
    }

    @Override
    public HDF5ObjectInformation getObjectInformation(String objectPath) {
        return this.objectHandler.getObjectInformation(objectPath);
    }

    @Override
    public HDF5ObjectType getObjectType(String objectPath, boolean followLink) {
        return this.objectHandler.getObjectType(objectPath, followLink);
    }

    @Override
    public HDF5ObjectType getObjectType(String objectPath) {
        return this.objectHandler.getObjectType(objectPath);
    }

    @Override
    public boolean exists(String objectPath, boolean followLink) {
        return this.objectHandler.exists(objectPath, followLink);
    }

    @Override
    public boolean exists(String objectPath) {
        return this.objectHandler.exists(objectPath);
    }

    @Override
    public String toHouseKeepingPath(String objectPath) {
        return this.objectHandler.toHouseKeepingPath(objectPath);
    }

    @Override
    public boolean isHouseKeepingObject(String objectPath) {
        return this.objectHandler.isHouseKeepingObject(objectPath);
    }

    @Override
    public boolean isGroup(String objectPath, boolean followLink) {
        return this.objectHandler.isGroup(objectPath, followLink);
    }

    @Override
    public boolean isGroup(String objectPath) {
        return this.objectHandler.isGroup(objectPath);
    }

    @Override
    public boolean isDataSet(String objectPath, boolean followLink) {
        return this.objectHandler.isDataSet(objectPath, followLink);
    }

    @Override
    public boolean isDataSet(String objectPath) {
        return this.objectHandler.isDataSet(objectPath);
    }

    @Override
    public boolean isDataType(String objectPath, boolean followLink) {
        return this.objectHandler.isDataType(objectPath, followLink);
    }

    @Override
    public boolean isDataType(String objectPath) {
        return this.objectHandler.isDataType(objectPath);
    }

    @Override
    public boolean isSoftLink(String objectPath) {
        return this.objectHandler.isSoftLink(objectPath);
    }

    @Override
    public boolean isExternalLink(String objectPath) {
        return this.objectHandler.isExternalLink(objectPath);
    }

    @Override
    public boolean isSymbolicLink(String objectPath) {
        return this.objectHandler.isSymbolicLink(objectPath);
    }

    @Override
    public String tryGetSymbolicLinkTarget(String objectPath) {
        return this.objectHandler.tryGetSymbolicLinkTarget(objectPath);
    }

    @Override
    public boolean hasAttribute(String objectPath, String attributeName) {
        return this.objectHandler.hasAttribute(objectPath, attributeName);
    }

    @Override
    public List<String> getAttributeNames(String objectPath) {
        return this.objectHandler.getAttributeNames(objectPath);
    }

    @Override
    public List<String> getAllAttributeNames(String objectPath) {
        return this.objectHandler.getAllAttributeNames(objectPath);
    }

    @Override
    public HDF5DataTypeInformation getAttributeInformation(String objectPath, String attributeName) {
        return this.objectHandler.getAttributeInformation(objectPath, attributeName);
    }

    @Override
    public HDF5DataTypeInformation getAttributeInformation(String objectPath, String attributeName, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        return this.objectHandler.getAttributeInformation(objectPath, attributeName, dataTypeInfoOptions);
    }

    @Override
    public HDF5DataSetInformation getDataSetInformation(String dataSetPath) {
        return this.objectHandler.getDataSetInformation(dataSetPath);
    }

    @Override
    public HDF5DataSetInformation getDataSetInformation(String dataSetPath, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        return this.objectHandler.getDataSetInformation(dataSetPath, dataTypeInfoOptions);
    }

    @Override
    public long getSize(String objectPath) {
        return this.objectHandler.getSize(objectPath);
    }

    @Override
    public long getNumberOfElements(String objectPath) {
        return this.objectHandler.getNumberOfElements(objectPath);
    }

    @Override
    public void copy(String sourceObject, IHDF5Writer destinationWriter, String destinationObject) {
        this.objectHandler.copy(sourceObject, destinationWriter, destinationObject);
    }

    @Override
    public void copy(String sourceObject, IHDF5Writer destinationWriter) {
        this.objectHandler.copy(sourceObject, destinationWriter);
    }

    @Override
    public void copyAll(IHDF5Writer destinationWriter) {
        this.objectHandler.copyAll(destinationWriter);
    }

    @Override
    public List<String> getGroupMembers(String groupPath) {
        return this.objectHandler.getGroupMembers(groupPath);
    }

    @Override
    public List<String> getAllGroupMembers(String groupPath) {
        return this.objectHandler.getAllGroupMembers(groupPath);
    }

    @Override
    public List<String> getGroupMemberPaths(String groupPath) {
        return this.objectHandler.getGroupMemberPaths(groupPath);
    }

    @Override
    public List<HDF5LinkInformation> getGroupMemberInformation(String groupPath, boolean readLinkTargets) {
        return this.objectHandler.getGroupMemberInformation(groupPath, readLinkTargets);
    }

    @Override
    public List<HDF5LinkInformation> getAllGroupMemberInformation(String groupPath, boolean readLinkTargets) {
        return this.objectHandler.getAllGroupMemberInformation(groupPath, readLinkTargets);
    }

    @Override
    public HDF5DataTypeVariant tryGetTypeVariant(String objectPath) {
        return this.objectHandler.tryGetTypeVariant(objectPath);
    }

    @Override
    public HDF5DataTypeVariant tryGetTypeVariant(String objectPath, String attributeName) {
        return this.objectHandler.tryGetTypeVariant(objectPath, attributeName);
    }

    @Override
    public String tryGetDataTypePath(String objectPath) {
        return this.objectHandler.tryGetDataTypePath(objectPath);
    }

    @Override
    public String tryGetDataTypePath(HDF5DataType type) {
        return this.objectHandler.tryGetDataTypePath(type);
    }

    @Override
    public boolean getBooleanAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.booleanReader.getAttr(objectPath, attributeName);
    }

    @Override
    public String getEnumAttributeAsString(String objectPath, String attributeName) throws HDF5JavaException {
        return this.enumReader.getAttrAsString(objectPath, attributeName);
    }

    @Override
    public HDF5EnumerationValue getEnumAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.enumReader.getAttr(objectPath, attributeName);
    }

    @Override
    public <T extends Enum<T>> T getEnumAttribute(String objectPath, String attributeName, Class<T> enumClass) throws HDF5JavaException {
        return this.enumReader.getAttr(objectPath, attributeName, enumClass);
    }

    @Override
    public String[] getEnumArrayAttributeAsString(String objectPath, String attributeName) throws HDF5JavaException {
        return this.enumReader.getArrayAttr(objectPath, attributeName).toStringArray();
    }

    @Override
    public HDF5EnumerationValueArray getEnumArrayAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.enumReader.getArrayAttr(objectPath, attributeName);
    }

    @Override
    public HDF5EnumerationType getEnumType(String dataTypeName) {
        return this.enumReader.getType(dataTypeName);
    }

    @Override
    public HDF5EnumerationType getEnumType(String dataTypeName, String[] values) throws HDF5JavaException {
        return this.enumReader.getType(dataTypeName, values);
    }

    @Override
    public HDF5EnumerationType getEnumType(String dataTypeName, String[] values, boolean check) throws HDF5JavaException {
        return this.enumReader.getType(dataTypeName, values, check);
    }

    @Override
    public HDF5EnumerationType getDataSetEnumType(String dataSetPath) {
        return this.enumReader.getDataSetType(dataSetPath);
    }

    @Override
    public HDF5EnumerationType getEnumTypeForObject(String dataSetPath) {
        return this.enumReader.getDataSetType(dataSetPath);
    }

    @Override
    public String tryGetOpaqueTag(String objectPath) {
        return this.opaqueReader.tryGetOpaqueTag(objectPath);
    }

    @Override
    public HDF5OpaqueType tryGetOpaqueType(String objectPath) {
        return this.opaqueReader.tryGetOpaqueType(objectPath);
    }

    @Override
    public IHDF5OpaqueReader opaque() {
        return this.opaqueReader;
    }

    @Override
    public Iterable<HDF5DataBlock<byte[]>> getAsByteArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.opaqueReader.getArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public byte[] readAsByteArray(String objectPath) {
        return this.opaqueReader.readArray(objectPath);
    }

    @Override
    public byte[] getAttributeAsByteArray(String objectPath, String attributeName) {
        return this.opaqueReader.getArrayAttr(objectPath, attributeName);
    }

    @Override
    public byte[] readAsByteArrayBlock(String objectPath, int blockSize, long blockNumber) throws HDF5JavaException {
        return this.opaqueReader.readArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public byte[] readAsByteArrayBlockWithOffset(String objectPath, int blockSize, long offset) throws HDF5JavaException {
        return this.opaqueReader.readArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public int readAsByteArrayToBlockWithOffset(String objectPath, byte[] buffer, int blockSize, long offset, int memoryOffset) throws HDF5JavaException {
        return this.opaqueReader.readArrayToBlockWithOffset(objectPath, buffer, blockSize, offset, memoryOffset);
    }

    @Override
    public IHDF5BooleanReader bool() {
        return this.booleanReader;
    }

    @Override
    public BitSet readBitField(String objectPath) throws HDF5DatatypeInterfaceException {
        return this.booleanReader.readBitField(objectPath);
    }

    @Override
    public BitSet readBitFieldBlock(String objectPath, int blockSize, long blockNumber) {
        return this.booleanReader.readBitFieldBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public BitSet readBitFieldBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.booleanReader.readBitFieldBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public boolean isBitSetInBitField(String objectPath, int bitIndex) {
        return this.booleanReader.isBitSet(objectPath, bitIndex);
    }

    @Override
    public boolean readBoolean(String objectPath) throws HDF5JavaException {
        return this.booleanReader.read(objectPath);
    }

    @Override
    public IHDF5DateTimeReader time() {
        return this.dateTimeReader;
    }

    @Override
    public IHDF5TimeDurationReader duration() {
        return this.timeDurationReader;
    }

    @Override
    public long getTimeStampAttribute(String objectPath, String attributeName) {
        return this.dateTimeReader.getAttrAsLong(objectPath, attributeName);
    }

    @Override
    public Date getDateAttribute(String objectPath, String attributeName) {
        return this.dateTimeReader.getAttr(objectPath, attributeName);
    }

    @Override
    public boolean isTimeStamp(String objectPath, String attributeName) throws HDF5JavaException {
        return this.dateTimeReader.isTimeStamp(objectPath, attributeName);
    }

    @Override
    public HDF5TimeDuration getTimeDurationAttribute(String objectPath, String attributeName) {
        return this.timeDurationReader.getAttr(objectPath, attributeName);
    }

    @Override
    public boolean isTimeDuration(String objectPath) throws HDF5JavaException {
        return this.timeDurationReader.isTimeDuration(objectPath);
    }

    @Override
    public boolean isTimeStamp(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.isTimeStamp(objectPath);
    }

    @Override
    public boolean isTimeDuration(String objectPath, String attributeName) throws HDF5JavaException {
        return this.timeDurationReader.isTimeDuration(objectPath, attributeName);
    }

    @Override
    public HDF5TimeUnit tryGetTimeUnit(String objectPath, String attributeName) throws HDF5JavaException {
        return this.timeDurationReader.tryGetTimeUnit(objectPath, attributeName);
    }

    @Override
    public long[] getTimeStampArrayAttribute(String objectPath, String attributeName) {
        return this.dateTimeReader.getArrayAttrAsLong(objectPath, attributeName);
    }

    @Override
    public Date[] getDateArrayAttribute(String objectPath, String attributeName) {
        return this.dateTimeReader.getArrayAttr(objectPath, attributeName);
    }

    @Override
    public HDF5TimeDurationArray getTimeDurationArrayAttribute(String objectPath, String attributeName) {
        return this.timeDurationReader.getArrayAttr(objectPath, attributeName);
    }

    @Override
    public HDF5TimeUnit tryGetTimeUnit(String objectPath) throws HDF5JavaException {
        return this.timeDurationReader.tryGetTimeUnit(objectPath);
    }

    @Override
    @Deprecated
    public Iterable<HDF5DataBlock<long[]>> getTimeDurationArrayNaturalBlocks(String dataSetPath, HDF5TimeUnit timeUnit) throws HDF5JavaException {
        return this.timeDurationReader.getTimeDurationArrayNaturalBlocks(dataSetPath, timeUnit);
    }

    @Override
    @Deprecated
    public Iterable<HDF5DataBlock<HDF5TimeDuration[]>> getTimeDurationAndUnitArrayNaturalBlocks(String objectPath) throws HDF5JavaException {
        return this.timeDurationReader.getTimeDurationAndUnitArrayNaturalBlocks(objectPath);
    }

    @Override
    public Iterable<HDF5DataBlock<long[]>> getTimeStampArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.dateTimeReader.getTimeStampArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public Date readDate(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readDate(objectPath);
    }

    @Override
    public Date[] readDateArray(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readDateArray(objectPath);
    }

    @Override
    @Deprecated
    public long readTimeDuration(String objectPath, HDF5TimeUnit timeUnit) throws HDF5JavaException {
        return this.timeDurationReader.readTimeDuration(objectPath, timeUnit);
    }

    @Override
    public HDF5TimeDuration readTimeDuration(String objectPath) throws HDF5JavaException {
        return this.timeDurationReader.read(objectPath);
    }

    @Override
    @Deprecated
    public HDF5TimeDuration readTimeDurationAndUnit(String objectPath) throws HDF5JavaException {
        return this.timeDurationReader.readTimeDurationAndUnit(objectPath);
    }

    @Override
    @Deprecated
    public long[] readTimeDurationArray(String objectPath, HDF5TimeUnit timeUnit) throws HDF5JavaException {
        return this.timeDurationReader.readTimeDurationArray(objectPath, timeUnit);
    }

    @Override
    public HDF5TimeDurationArray readTimeDurationArray(String objectPath) throws HDF5JavaException {
        return this.timeDurationReader.readArray(objectPath);
    }

    @Override
    @Deprecated
    public HDF5TimeDuration[] readTimeDurationAndUnitArray(String objectPath) throws HDF5JavaException {
        return this.timeDurationReader.readTimeDurationAndUnitArray(objectPath);
    }

    @Override
    @Deprecated
    public long[] readTimeDurationArrayBlock(String objectPath, int blockSize, long blockNumber, HDF5TimeUnit timeUnit) {
        return this.timeDurationReader.readTimeDurationArrayBlock(objectPath, blockSize, blockNumber, timeUnit);
    }

    @Override
    @Deprecated
    public long[] readTimeDurationArrayBlockWithOffset(String objectPath, int blockSize, long offset, HDF5TimeUnit timeUnit) {
        return this.timeDurationReader.readTimeDurationArrayBlockWithOffset(objectPath, blockSize, offset, timeUnit);
    }

    @Override
    @Deprecated
    public HDF5TimeDuration[] readTimeDurationAndUnitArrayBlock(String objectPath, int blockSize, long blockNumber) throws HDF5JavaException {
        return this.timeDurationReader.readTimeDurationAndUnitArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    @Deprecated
    public HDF5TimeDuration[] readTimeDurationAndUnitArrayBlockWithOffset(String objectPath, int blockSize, long offset) throws HDF5JavaException {
        return this.timeDurationReader.readTimeDurationAndUnitArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public long readTimeStamp(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readTimeStamp(objectPath);
    }

    @Override
    public long[] readTimeStampArray(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readTimeStampArray(objectPath);
    }

    @Override
    public long[] readTimeStampArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.dateTimeReader.readTimeStampArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public long[] readTimeStampArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.dateTimeReader.readTimeStampArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public IHDF5ReferenceReader reference() {
        return this.referenceReader;
    }

    @Override
    public String readObjectReference(String objectPath) {
        return this.referenceReader.read(objectPath);
    }

    @Override
    public String readObjectReference(String objectPath, boolean resolveName) {
        return this.referenceReader.read(objectPath, resolveName);
    }

    @Override
    public String[] readObjectReferenceArrayBlock(String objectPath, int blockSize, long blockNumber, boolean resolveName) {
        return this.referenceReader.readArrayBlock(objectPath, blockSize, blockNumber, resolveName);
    }

    @Override
    public String[] readObjectReferenceArrayBlockWithOffset(String objectPath, int blockSize, long offset, boolean resolveName) {
        return this.referenceReader.readArrayBlockWithOffset(objectPath, blockSize, offset, resolveName);
    }

    @Override
    public MDArray<String> readObjectReferenceMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber, boolean resolveName) {
        return this.referenceReader.readMDArrayBlock(objectPath, blockDimensions, blockNumber, resolveName);
    }

    @Override
    public MDArray<String> readObjectReferenceMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset, boolean resolveName) {
        return this.referenceReader.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset, resolveName);
    }

    @Override
    public Iterable<HDF5DataBlock<String[]>> getObjectReferenceArrayNaturalBlocks(String dataSetPath, boolean resolveName) {
        return this.referenceReader.getArrayNaturalBlocks(dataSetPath, resolveName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDArray<String>>> getObjectReferenceMDArrayNaturalBlocks(String dataSetPath, boolean resolveName) {
        return this.referenceReader.getMDArrayNaturalBlocks(dataSetPath, resolveName);
    }

    @Override
    public String[] readObjectReferenceArray(String objectPath) {
        return this.referenceReader.readArray(objectPath);
    }

    @Override
    public String[] readObjectReferenceArray(String objectPath, boolean resolveName) {
        return this.referenceReader.readArray(objectPath, resolveName);
    }

    @Override
    public MDArray<String> readObjectReferenceMDArray(String objectPath) {
        return this.referenceReader.readMDArray(objectPath);
    }

    @Override
    public MDArray<String> readObjectReferenceMDArray(String objectPath, boolean resolveName) {
        return this.referenceReader.readMDArray(objectPath, resolveName);
    }

    @Override
    public String getObjectReferenceAttribute(String objectPath, String attributeName, boolean resolveName) {
        return this.referenceReader.getAttr(objectPath, attributeName, resolveName);
    }

    @Override
    public String[] getObjectReferenceArrayAttribute(String objectPath, String attributeName, boolean resolveName) {
        return this.referenceReader.getArrayAttr(objectPath, attributeName, resolveName);
    }

    @Override
    public MDArray<String> getObjectReferenceMDArrayAttribute(String objectPath, String attributeName, boolean resolveName) {
        return this.referenceReader.getMDArrayAttr(objectPath, attributeName, resolveName);
    }

    @Override
    public HDF5TimeDurationArray readTimeDurationArrayBlock(String objectPath, int blockSize, long blockNumber) throws HDF5JavaException {
        return this.timeDurationReader.readArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public HDF5TimeDurationArray readTimeDurationArrayBlockWithOffset(String objectPath, int blockSize, long offset) throws HDF5JavaException {
        return this.timeDurationReader.readArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public Iterable<HDF5DataBlock<HDF5TimeDurationArray>> getTimeDurationArrayNaturalBlocks(String objectPath) throws HDF5JavaException {
        return this.timeDurationReader.getArrayNaturalBlocks(objectPath);
    }

    @Override
    public String resolvePath(String reference) throws HDF5JavaException {
        return this.referenceReader.resolvePath(reference);
    }

    @Override
    public String getObjectReferenceAttribute(String objectPath, String attributeName) {
        return this.referenceReader.getAttr(objectPath, attributeName);
    }

    @Override
    public String[] getObjectReferenceArrayAttribute(String objectPath, String attributeName) {
        return this.referenceReader.getArrayAttr(objectPath, attributeName);
    }

    @Override
    public MDArray<String> getObjectReferenceMDArrayAttribute(String objectPath, String attributeName) {
        return this.referenceReader.getMDArrayAttr(objectPath, attributeName);
    }

    @Override
    public String[] readObjectReferenceArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.referenceReader.readArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public String[] readObjectReferenceArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.referenceReader.readArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDArray<String> readObjectReferenceMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.referenceReader.readMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDArray<String> readObjectReferenceMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.referenceReader.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public Iterable<HDF5DataBlock<String[]>> getObjectReferenceArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.referenceReader.getArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDArray<String>>> getObjectReferenceMDArrayNaturalBlocks(String dataSetPath) {
        return this.referenceReader.getMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public IHDF5StringReader string() {
        return this.stringReader;
    }

    @Override
    public String getStringAttribute(String objectPath, String attributeName) {
        return this.stringReader.getAttr(objectPath, attributeName);
    }

    @Override
    public String[] getStringArrayAttribute(String objectPath, String attributeName) {
        return this.stringReader.getArrayAttr(objectPath, attributeName);
    }

    @Override
    public MDArray<String> getStringMDArrayAttribute(String objectPath, String attributeName) {
        return this.stringReader.getMDArrayAttr(objectPath, attributeName);
    }

    @Override
    public String readString(String objectPath) throws HDF5JavaException {
        return this.stringReader.read(objectPath);
    }

    @Override
    public String[] readStringArray(String objectPath) throws HDF5JavaException {
        return this.stringReader.readArray(objectPath);
    }

    @Override
    public String[] readStringArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.stringReader.readArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public String[] readStringArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.stringReader.readArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDArray<String> readStringMDArray(String objectPath) {
        return this.stringReader.readMDArray(objectPath);
    }

    @Override
    public MDArray<String> readStringMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.stringReader.readMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDArray<String> readStringMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.stringReader.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public Iterable<HDF5DataBlock<String[]>> getStringArrayNaturalBlocks(String objectPath) throws HDF5JavaException {
        return this.stringReader.getArrayNaturalBlocks(objectPath);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDArray<String>>> getStringMDArrayNaturalBlocks(String objectPath) {
        return this.stringReader.getMDArrayNaturalBlocks(objectPath);
    }

    @Override
    public IHDF5EnumReader enums() {
        return this.enumReader;
    }

    @Override
    public IHDF5EnumReader enumeration() {
        return this.enumReader;
    }

    @Override
    public Iterable<HDF5DataBlock<HDF5EnumerationValueArray>> getEnumArrayNaturalBlocks(String objectPath, HDF5EnumerationType enumType) throws HDF5JavaException {
        return this.enumReader.getArrayBlocks(objectPath, enumType);
    }

    @Override
    public Iterable<HDF5DataBlock<HDF5EnumerationValueArray>> getEnumArrayNaturalBlocks(String objectPath) throws HDF5JavaException {
        return this.enumReader.getArrayBlocks(objectPath);
    }

    @Override
    public HDF5EnumerationValue readEnum(String objectPath, HDF5EnumerationType enumType) throws HDF5JavaException {
        return this.enumReader.read(objectPath, enumType);
    }

    @Override
    public HDF5EnumerationValue readEnum(String objectPath) throws HDF5JavaException {
        return this.enumReader.read(objectPath);
    }

    @Override
    public <T extends Enum<T>> T readEnum(String objectPath, Class<T> enumClass) throws HDF5JavaException {
        return this.enumReader.read(objectPath, enumClass);
    }

    @Override
    public HDF5EnumerationValueArray readEnumArray(String objectPath, HDF5EnumerationType enumType) throws HDF5JavaException {
        return this.enumReader.readArray(objectPath, enumType);
    }

    @Override
    public HDF5EnumerationValueArray readEnumArray(String objectPath) throws HDF5JavaException {
        return this.enumReader.readArray(objectPath);
    }

    @Override
    public <T extends Enum<T>> T[] readEnumArray(String objectPath, Class<T> enumClass) throws HDF5JavaException {
        return this.readEnumArray(objectPath).toEnumArray(enumClass);
    }

    @Override
    public String[] readEnumArrayAsString(String objectPath) throws HDF5JavaException {
        return this.enumReader.readArray(objectPath).toStringArray();
    }

    @Override
    public HDF5EnumerationValueArray readEnumArrayBlock(String objectPath, HDF5EnumerationType enumType, int blockSize, long blockNumber) {
        return this.enumReader.readArrayBlock(objectPath, enumType, blockSize, blockNumber);
    }

    @Override
    public HDF5EnumerationValueArray readEnumArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.enumReader.readArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public HDF5EnumerationValueArray readEnumArrayBlockWithOffset(String objectPath, HDF5EnumerationType enumType, int blockSize, long offset) {
        return this.enumReader.readArrayBlockWithOffset(objectPath, enumType, blockSize, offset);
    }

    @Override
    public HDF5EnumerationValueArray readEnumArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.enumReader.readArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public String readEnumAsString(String objectPath) throws HDF5JavaException {
        return this.enumReader.readAsString(objectPath);
    }

    @Override
    public IHDF5CompoundReader compounds() {
        return this.compoundReader;
    }

    @Override
    public IHDF5CompoundReader compound() {
        return this.compoundReader;
    }

    @Override
    public <T> Iterable<HDF5DataBlock<T[]>> getCompoundArrayNaturalBlocks(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.getArrayBlocks(objectPath, type, inspectorOrNull);
    }

    @Override
    public <T> Iterable<HDF5DataBlock<T[]>> getCompoundArrayNaturalBlocks(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.compoundReader.getArrayBlocks(objectPath, type);
    }

    @Override
    public <T> Iterable<HDF5MDDataBlock<MDArray<T>>> getCompoundMDArrayNaturalBlocks(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.getMDArrayBlocks(objectPath, type, inspectorOrNull);
    }

    @Override
    public <T> Iterable<HDF5MDDataBlock<MDArray<T>>> getCompoundMDArrayNaturalBlocks(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.compoundReader.getMDArrayBlocks(objectPath, type);
    }

    @Override
    public <T> Iterable<HDF5DataBlock<T[]>> getCompoundArrayNaturalBlocks(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        return this.compoundReader.getArrayBlocks(objectPath, pojoClass);
    }

    @Override
    public <T> Iterable<HDF5MDDataBlock<MDArray<T>>> getCompoundMDArrayNaturalBlocks(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        return this.compoundReader.getMDArrayBlocks(objectPath, pojoClass);
    }

    @Override
    public HDF5CompoundMemberInformation[] getCompoundDataSetInformation(String dataSetPath, boolean sortAlphabetically) throws HDF5JavaException {
        Object[] compoundInformation = this.compoundReader.getDataSetInfo(dataSetPath, HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
        if (sortAlphabetically) {
            Arrays.sort(compoundInformation);
        }
        return compoundInformation;
    }

    @Override
    public HDF5CompoundMemberInformation[] getCompoundDataSetInformation(String dataSetPath) throws HDF5JavaException {
        return this.compoundReader.getDataSetInfo(dataSetPath);
    }

    @Override
    public <T> HDF5CompoundMemberInformation[] getCompoundMemberInformation(Class<T> compoundClass) {
        return this.compoundReader.getMemberInfo(compoundClass);
    }

    @Override
    public HDF5CompoundMemberInformation[] getCompoundMemberInformation(String dataTypeName) {
        return this.compoundReader.getMemberInfo(dataTypeName);
    }

    @Override
    public <T> HDF5CompoundType<T> getCompoundType(Class<T> pojoClass, HDF5CompoundMemberMapping ... members) {
        return this.compoundReader.getType(pojoClass, members);
    }

    @Override
    public <T> HDF5CompoundType<T> getCompoundType(String name, Class<T> compoundType, HDF5CompoundMemberMapping ... members) {
        return this.compoundReader.getType(name, compoundType, members);
    }

    @Override
    public <T> HDF5CompoundType<T> getDataSetCompoundType(String objectPath, Class<T> compoundClass) {
        return this.compoundReader.getDataSetType(objectPath, compoundClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getAttributeCompoundType(String objectPath, String attributeName, Class<T> pojoClass) {
        return this.compoundReader.getAttributeType(objectPath, attributeName, pojoClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(Class<T> pojoClass) {
        return this.compoundReader.getInferredType(pojoClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(String name, Class<T> compoundType) {
        return this.compoundReader.getInferredType(name, compoundType);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(String name, T template) {
        return this.compoundReader.getInferredType(name, template);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(T template) {
        return this.compoundReader.getInferredType(template);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(String name, T template, HDF5CompoundMappingHints hints) {
        return this.compoundReader.getInferredType(name, template, hints);
    }

    @Override
    public HDF5CompoundType<List<?>> getInferredCompoundType(String name, List<String> memberNames, List<?> template) {
        return this.compoundReader.getInferredType(name, memberNames, template);
    }

    @Override
    public HDF5CompoundType<Object[]> getInferredCompoundType(String name, String[] memberNames, Object[] template) {
        return this.compoundReader.getInferredType(name, memberNames, template);
    }

    @Override
    public HDF5CompoundType<List<?>> getInferredCompoundType(List<String> memberNames, List<?> template) {
        return this.compoundReader.getInferredType(memberNames, template);
    }

    @Override
    public HDF5CompoundType<Object[]> getInferredCompoundType(String[] memberNames, Object[] template) {
        return this.compoundReader.getInferredType(memberNames, template);
    }

    @Override
    public <T> HDF5CompoundType<T> getNamedCompoundType(Class<T> compoundClass) {
        return this.compoundReader.getNamedType(compoundClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getNamedCompoundType(String dataTypeName, Class<T> compoundClass) {
        return this.compoundReader.getNamedType(dataTypeName, compoundClass);
    }

    @Override
    public <T> T readCompound(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.read(objectPath, type, inspectorOrNull);
    }

    @Override
    public <T> T readCompound(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.compoundReader.read(objectPath, type);
    }

    @Override
    public <T> T readCompound(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        return this.compoundReader.read(objectPath, pojoClass);
    }

    @Override
    public <T> T[] readCompoundArray(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.readArray(objectPath, type, inspectorOrNull);
    }

    @Override
    public <T> T[] readCompoundArray(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.compoundReader.readArray(objectPath, type);
    }

    @Override
    public <T> T[] readCompoundArray(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        return this.compoundReader.readArray(objectPath, pojoClass);
    }

    @Override
    public <T> T[] readCompoundArrayBlock(String objectPath, HDF5CompoundType<T> type, int blockSize, long blockNumber, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.readArrayBlock(objectPath, type, blockSize, blockNumber, inspectorOrNull);
    }

    @Override
    public <T> T[] readCompoundArrayBlock(String objectPath, HDF5CompoundType<T> type, int blockSize, long blockNumber) throws HDF5JavaException {
        return this.compoundReader.readArrayBlock(objectPath, type, blockSize, blockNumber);
    }

    @Override
    public <T> T[] readCompoundArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, int blockSize, long offset, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.readArrayBlockWithOffset(objectPath, type, blockSize, offset, inspectorOrNull);
    }

    @Override
    public <T> T[] readCompoundArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, int blockSize, long offset) throws HDF5JavaException {
        return this.compoundReader.readArrayBlockWithOffset(objectPath, type, blockSize, offset);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArray(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.readMDArray(objectPath, type, inspectorOrNull);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArray(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.compoundReader.readMDArray(objectPath, type);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArray(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        return this.compoundReader.readMDArray(objectPath, pojoClass);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArrayBlock(String objectPath, HDF5CompoundType<T> type, int[] blockDimensions, long[] blockNumber, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.readMDArrayBlock(objectPath, type, blockDimensions, blockNumber, inspectorOrNull);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArrayBlock(String objectPath, HDF5CompoundType<T> type, int[] blockDimensions, long[] blockNumber) throws HDF5JavaException {
        return this.compoundReader.readMDArrayBlock(objectPath, type, blockDimensions, blockNumber);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, int[] blockDimensions, long[] offset, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.readMDArrayBlockWithOffset(objectPath, type, blockDimensions, offset, inspectorOrNull);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, int[] blockDimensions, long[] offset) throws HDF5JavaException {
        return this.compoundReader.readMDArrayBlockWithOffset(objectPath, type, blockDimensions, offset);
    }

    @Override
    public byte[] getByteArrayAttribute(String objectPath, String attributeName) {
        return this.byteReader.getArrayAttr(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5DataBlock<byte[]>> getByteArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.byteReader.getArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public byte getByteAttribute(String objectPath, String attributeName) {
        return this.byteReader.getAttr(objectPath, attributeName);
    }

    @Override
    public MDByteArray getByteMDArrayAttribute(String objectPath, String attributeName) {
        return this.byteReader.getMDArrayAttr(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDByteArray>> getByteMDArrayNaturalBlocks(String dataSetPath) {
        return this.byteReader.getMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public byte[][] getByteMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.byteReader.getMatrixAttr(objectPath, attributeName);
    }

    @Override
    public byte readByte(String objectPath) {
        return this.byteReader.read(objectPath);
    }

    @Override
    public byte[] readByteArray(String objectPath) {
        return this.byteReader.readArray(objectPath);
    }

    @Override
    public byte[] readByteArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.byteReader.readArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public byte[] readByteArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.byteReader.readArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDByteArray readByteMDArray(String objectPath) {
        return this.byteReader.readMDArray(objectPath);
    }

    @Override
    public MDByteArray readByteMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.byteReader.readMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDByteArray readByteMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.byteReader.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public byte[][] readByteMatrix(String objectPath) throws HDF5JavaException {
        return this.byteReader.readMatrix(objectPath);
    }

    @Override
    public byte[][] readByteMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        return this.byteReader.readMatrixBlock(objectPath, blockSizeX, blockSizeY, blockNumberX, blockNumberY);
    }

    @Override
    public byte[][] readByteMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        return this.byteReader.readMatrixBlockWithOffset(objectPath, blockSizeX, blockSizeY, offsetX, offsetY);
    }

    @Override
    public int[] readToByteMDArrayBlockWithOffset(String objectPath, MDByteArray array, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        return this.byteReader.readToMDArrayBlockWithOffset(objectPath, array, blockDimensions, offset, memoryOffset);
    }

    @Override
    public int[] readToByteMDArrayWithOffset(String objectPath, MDByteArray array, int[] memoryOffset) {
        return this.byteReader.readToMDArrayWithOffset(objectPath, array, memoryOffset);
    }

    @Override
    public double[] getDoubleArrayAttribute(String objectPath, String attributeName) {
        return this.doubleReader.getArrayAttr(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5DataBlock<double[]>> getDoubleArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.doubleReader.getArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public double getDoubleAttribute(String objectPath, String attributeName) {
        return this.doubleReader.getAttr(objectPath, attributeName);
    }

    @Override
    public MDDoubleArray getDoubleMDArrayAttribute(String objectPath, String attributeName) {
        return this.doubleReader.getMDArrayAttr(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDDoubleArray>> getDoubleMDArrayNaturalBlocks(String dataSetPath) {
        return this.doubleReader.getMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public double[][] getDoubleMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.doubleReader.getMatrixAttr(objectPath, attributeName);
    }

    @Override
    public double readDouble(String objectPath) {
        return this.doubleReader.read(objectPath);
    }

    @Override
    public double[] readDoubleArray(String objectPath) {
        return this.doubleReader.readArray(objectPath);
    }

    @Override
    public double[] readDoubleArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.doubleReader.readArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public double[] readDoubleArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.doubleReader.readArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDDoubleArray readDoubleMDArray(String objectPath) {
        return this.doubleReader.readMDArray(objectPath);
    }

    @Override
    public MDDoubleArray readDoubleMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.doubleReader.readMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDDoubleArray readDoubleMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.doubleReader.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public double[][] readDoubleMatrix(String objectPath) throws HDF5JavaException {
        return this.doubleReader.readMatrix(objectPath);
    }

    @Override
    public double[][] readDoubleMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        return this.doubleReader.readMatrixBlock(objectPath, blockSizeX, blockSizeY, blockNumberX, blockNumberY);
    }

    @Override
    public double[][] readDoubleMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        return this.doubleReader.readMatrixBlockWithOffset(objectPath, blockSizeX, blockSizeY, offsetX, offsetY);
    }

    @Override
    public int[] readToDoubleMDArrayBlockWithOffset(String objectPath, MDDoubleArray array, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        return this.doubleReader.readToMDArrayBlockWithOffset(objectPath, array, blockDimensions, offset, memoryOffset);
    }

    @Override
    public int[] readToDoubleMDArrayWithOffset(String objectPath, MDDoubleArray array, int[] memoryOffset) {
        return this.doubleReader.readToMDArrayWithOffset(objectPath, array, memoryOffset);
    }

    @Override
    public float[] getFloatArrayAttribute(String objectPath, String attributeName) {
        return this.floatReader.getArrayAttr(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5DataBlock<float[]>> getFloatArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.floatReader.getArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public float getFloatAttribute(String objectPath, String attributeName) {
        return this.floatReader.getAttr(objectPath, attributeName);
    }

    @Override
    public MDFloatArray getFloatMDArrayAttribute(String objectPath, String attributeName) {
        return this.floatReader.getMDArrayAttr(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDFloatArray>> getFloatMDArrayNaturalBlocks(String dataSetPath) {
        return this.floatReader.getMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public float[][] getFloatMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.floatReader.getMatrixAttr(objectPath, attributeName);
    }

    @Override
    public float readFloat(String objectPath) {
        return this.floatReader.read(objectPath);
    }

    @Override
    public float[] readFloatArray(String objectPath) {
        return this.floatReader.readArray(objectPath);
    }

    @Override
    public float[] readFloatArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.floatReader.readArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public float[] readFloatArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.floatReader.readArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDFloatArray readFloatMDArray(String objectPath) {
        return this.floatReader.readMDArray(objectPath);
    }

    @Override
    public MDFloatArray readFloatMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.floatReader.readMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDFloatArray readFloatMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.floatReader.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public float[][] readFloatMatrix(String objectPath) throws HDF5JavaException {
        return this.floatReader.readMatrix(objectPath);
    }

    @Override
    public float[][] readFloatMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        return this.floatReader.readMatrixBlock(objectPath, blockSizeX, blockSizeY, blockNumberX, blockNumberY);
    }

    @Override
    public float[][] readFloatMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        return this.floatReader.readMatrixBlockWithOffset(objectPath, blockSizeX, blockSizeY, offsetX, offsetY);
    }

    @Override
    public int[] readToFloatMDArrayBlockWithOffset(String objectPath, MDFloatArray array, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        return this.floatReader.readToMDArrayBlockWithOffset(objectPath, array, blockDimensions, offset, memoryOffset);
    }

    @Override
    public int[] readToFloatMDArrayWithOffset(String objectPath, MDFloatArray array, int[] memoryOffset) {
        return this.floatReader.readToMDArrayWithOffset(objectPath, array, memoryOffset);
    }

    @Override
    public int[] getIntArrayAttribute(String objectPath, String attributeName) {
        return this.intReader.getArrayAttr(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5DataBlock<int[]>> getIntArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.intReader.getArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public int getIntAttribute(String objectPath, String attributeName) {
        return this.intReader.getAttr(objectPath, attributeName);
    }

    @Override
    public MDIntArray getIntMDArrayAttribute(String objectPath, String attributeName) {
        return this.intReader.getMDArrayAttr(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDIntArray>> getIntMDArrayNaturalBlocks(String dataSetPath) {
        return this.intReader.getMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public int[][] getIntMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.intReader.getMatrixAttr(objectPath, attributeName);
    }

    @Override
    public int readInt(String objectPath) {
        return this.intReader.read(objectPath);
    }

    @Override
    public int[] readIntArray(String objectPath) {
        return this.intReader.readArray(objectPath);
    }

    @Override
    public int[] readIntArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.intReader.readArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public int[] readIntArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.intReader.readArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDIntArray readIntMDArray(String objectPath) {
        return this.intReader.readMDArray(objectPath);
    }

    @Override
    public MDIntArray readIntMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.intReader.readMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDIntArray readIntMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.intReader.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public int[][] readIntMatrix(String objectPath) throws HDF5JavaException {
        return this.intReader.readMatrix(objectPath);
    }

    @Override
    public int[][] readIntMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        return this.intReader.readMatrixBlock(objectPath, blockSizeX, blockSizeY, blockNumberX, blockNumberY);
    }

    @Override
    public int[][] readIntMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        return this.intReader.readMatrixBlockWithOffset(objectPath, blockSizeX, blockSizeY, offsetX, offsetY);
    }

    @Override
    public int[] readToIntMDArrayBlockWithOffset(String objectPath, MDIntArray array, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        return this.intReader.readToMDArrayBlockWithOffset(objectPath, array, blockDimensions, offset, memoryOffset);
    }

    @Override
    public int[] readToIntMDArrayWithOffset(String objectPath, MDIntArray array, int[] memoryOffset) {
        return this.intReader.readToMDArrayWithOffset(objectPath, array, memoryOffset);
    }

    @Override
    public long[] getLongArrayAttribute(String objectPath, String attributeName) {
        return this.longReader.getArrayAttr(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5DataBlock<long[]>> getLongArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.longReader.getArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public long getLongAttribute(String objectPath, String attributeName) {
        return this.longReader.getAttr(objectPath, attributeName);
    }

    @Override
    public MDLongArray getLongMDArrayAttribute(String objectPath, String attributeName) {
        return this.longReader.getMDArrayAttr(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDLongArray>> getLongMDArrayNaturalBlocks(String dataSetPath) {
        return this.longReader.getMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public long[][] getLongMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.longReader.getMatrixAttr(objectPath, attributeName);
    }

    @Override
    public long readLong(String objectPath) {
        return this.longReader.read(objectPath);
    }

    @Override
    public long[] readLongArray(String objectPath) {
        return this.longReader.readArray(objectPath);
    }

    @Override
    public long[] readLongArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.longReader.readArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public long[] readLongArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.longReader.readArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDLongArray readLongMDArray(String objectPath) {
        return this.longReader.readMDArray(objectPath);
    }

    @Override
    public MDLongArray readLongMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.longReader.readMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDLongArray readLongMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.longReader.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public long[][] readLongMatrix(String objectPath) throws HDF5JavaException {
        return this.longReader.readMatrix(objectPath);
    }

    @Override
    public long[][] readLongMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        return this.longReader.readMatrixBlock(objectPath, blockSizeX, blockSizeY, blockNumberX, blockNumberY);
    }

    @Override
    public long[][] readLongMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        return this.longReader.readMatrixBlockWithOffset(objectPath, blockSizeX, blockSizeY, offsetX, offsetY);
    }

    @Override
    public int[] readToLongMDArrayBlockWithOffset(String objectPath, MDLongArray array, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        return this.longReader.readToMDArrayBlockWithOffset(objectPath, array, blockDimensions, offset, memoryOffset);
    }

    @Override
    public int[] readToLongMDArrayWithOffset(String objectPath, MDLongArray array, int[] memoryOffset) {
        return this.longReader.readToMDArrayWithOffset(objectPath, array, memoryOffset);
    }

    @Override
    public short[] getShortArrayAttribute(String objectPath, String attributeName) {
        return this.shortReader.getArrayAttr(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5DataBlock<short[]>> getShortArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.shortReader.getArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public short getShortAttribute(String objectPath, String attributeName) {
        return this.shortReader.getAttr(objectPath, attributeName);
    }

    @Override
    public MDShortArray getShortMDArrayAttribute(String objectPath, String attributeName) {
        return this.shortReader.getMDArrayAttr(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDShortArray>> getShortMDArrayNaturalBlocks(String dataSetPath) {
        return this.shortReader.getMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public short[][] getShortMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.shortReader.getMatrixAttr(objectPath, attributeName);
    }

    @Override
    public short readShort(String objectPath) {
        return this.shortReader.read(objectPath);
    }

    @Override
    public short[] readShortArray(String objectPath) {
        return this.shortReader.readArray(objectPath);
    }

    @Override
    public short[] readShortArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.shortReader.readArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public short[] readShortArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.shortReader.readArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDShortArray readShortMDArray(String objectPath) {
        return this.shortReader.readMDArray(objectPath);
    }

    @Override
    public MDShortArray readShortMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.shortReader.readMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDShortArray readShortMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.shortReader.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public short[][] readShortMatrix(String objectPath) throws HDF5JavaException {
        return this.shortReader.readMatrix(objectPath);
    }

    @Override
    public short[][] readShortMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        return this.shortReader.readMatrixBlock(objectPath, blockSizeX, blockSizeY, blockNumberX, blockNumberY);
    }

    @Override
    public short[][] readShortMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        return this.shortReader.readMatrixBlockWithOffset(objectPath, blockSizeX, blockSizeY, offsetX, offsetY);
    }

    @Override
    public int[] readToShortMDArrayBlockWithOffset(String objectPath, MDShortArray array, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        return this.shortReader.readToMDArrayBlockWithOffset(objectPath, array, blockDimensions, offset, memoryOffset);
    }

    @Override
    public int[] readToShortMDArrayWithOffset(String objectPath, MDShortArray array, int[] memoryOffset) {
        return this.shortReader.readToMDArrayWithOffset(objectPath, array, memoryOffset);
    }

    @Override
    public IHDF5ByteReader int8() {
        return this.byteReader;
    }

    @Override
    public IHDF5ByteReader uint8() {
        return this.ubyteReader;
    }

    @Override
    public IHDF5ShortReader int16() {
        return this.shortReader;
    }

    @Override
    public IHDF5ShortReader uint16() {
        return this.ushortReader;
    }

    @Override
    public IHDF5IntReader int32() {
        return this.intReader;
    }

    @Override
    public IHDF5IntReader uint32() {
        return this.uintReader;
    }

    @Override
    public IHDF5LongReader int64() {
        return this.longReader;
    }

    @Override
    public IHDF5LongReader uint64() {
        return this.ulongReader;
    }

    @Override
    public IHDF5FloatReader float32() {
        return this.floatReader;
    }

    @Override
    public IHDF5DoubleReader float64() {
        return this.doubleReader;
    }
}

