/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.args4j;

import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.args4j.spi.BooleanOptionHandler;
import ch.systemsx.cisd.args4j.spi.DoubleOptionHandler;
import ch.systemsx.cisd.args4j.spi.FileOptionHandler;
import ch.systemsx.cisd.args4j.spi.IntOptionHandler;
import ch.systemsx.cisd.args4j.spi.LongOptionHandler;
import ch.systemsx.cisd.args4j.spi.OptionHandler;
import ch.systemsx.cisd.args4j.spi.RegexOptionHandler;
import ch.systemsx.cisd.args4j.spi.Setter;
import ch.systemsx.cisd.args4j.spi.StringOptionHandler;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerClasses {
    static final Map<Class<?>, Constructor<? extends OptionHandler>> handlerClasses = Collections.synchronizedMap(new HashMap());

    static {
        HandlerClasses.registerHandler(Boolean.class, BooleanOptionHandler.class);
        HandlerClasses.registerHandler(Boolean.TYPE, BooleanOptionHandler.class);
        HandlerClasses.registerHandler(File.class, FileOptionHandler.class);
        HandlerClasses.registerHandler(Integer.class, IntOptionHandler.class);
        HandlerClasses.registerHandler(Integer.TYPE, IntOptionHandler.class);
        HandlerClasses.registerHandler(Long.TYPE, LongOptionHandler.class);
        HandlerClasses.registerHandler(Double.class, DoubleOptionHandler.class);
        HandlerClasses.registerHandler(Double.TYPE, DoubleOptionHandler.class);
        HandlerClasses.registerHandler(String.class, StringOptionHandler.class);
        HandlerClasses.registerHandler(Pattern.class, RegexOptionHandler.class);
    }

    public static void registerHandler(Class<?> valueType, Class<? extends OptionHandler> handlerClass) {
        if (valueType == null || handlerClass == null) {
            throw new IllegalArgumentException();
        }
        if (!OptionHandler.class.isAssignableFrom(handlerClass)) {
            throw new IllegalArgumentException("Not an OptionHandler class");
        }
        Constructor<? extends OptionHandler> c = HandlerClasses.getConstructor(handlerClass);
        handlerClasses.put(valueType, c);
    }

    static Constructor<? extends OptionHandler> getConstructor(Class<? extends OptionHandler> handlerClass) {
        try {
            return handlerClass.getConstructor(Option.class, Setter.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(handlerClass + " does not have the proper constructor");
        }
    }
}

