/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.net.LoggingEventPreSerializationTransformer;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.net.JMSAppenderBase;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import java.io.Serializable;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSQueueAppender
extends JMSAppenderBase<ILoggingEvent> {
    static int SUCCESSIVE_FAILURE_LIMIT = 3;
    String queueBindingName;
    String qcfBindingName;
    QueueConnection queueConnection;
    QueueSession queueSession;
    QueueSender queueSender;
    int successiveFailureCount = 0;
    private PreSerializationTransformer<ILoggingEvent> pst = new LoggingEventPreSerializationTransformer();

    public void setQueueConnectionFactoryBindingName(String qcfBindingName) {
        this.qcfBindingName = qcfBindingName;
    }

    public String getQueueConnectionFactoryBindingName() {
        return this.qcfBindingName;
    }

    public void setQueueBindingName(String queueBindingName) {
        this.queueBindingName = queueBindingName;
    }

    public String getQueueBindingName() {
        return this.queueBindingName;
    }

    @Override
    public void start() {
        try {
            Context jndi = this.buildJNDIContext();
            QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)this.lookup(jndi, this.qcfBindingName);
            this.queueConnection = this.userName != null ? queueConnectionFactory.createQueueConnection(this.userName, this.password) : queueConnectionFactory.createQueueConnection();
            this.queueSession = this.queueConnection.createQueueSession(false, 1);
            Queue queue = (Queue)this.lookup(jndi, this.queueBindingName);
            this.queueSender = this.queueSession.createSender(queue);
            this.queueConnection.start();
            jndi.close();
        }
        catch (Exception e) {
            this.addError("Error while activating options for appender named [" + this.name + "].", e);
        }
        if (this.queueConnection != null && this.queueSession != null && this.queueSender != null) {
            super.start();
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        try {
            if (this.queueSession != null) {
                this.queueSession.close();
            }
            if (this.queueConnection != null) {
                this.queueConnection.close();
            }
        }
        catch (Exception e) {
            this.addError("Error while closing JMSAppender [" + this.name + "].", e);
        }
        this.queueSender = null;
        this.queueSession = null;
        this.queueConnection = null;
    }

    @Override
    public void append(ILoggingEvent event) {
        if (!this.isStarted()) {
            return;
        }
        try {
            ObjectMessage msg = this.queueSession.createObjectMessage();
            Serializable so = this.pst.transform(event);
            msg.setObject(so);
            this.queueSender.send((Message)msg);
            this.successiveFailureCount = 0;
        }
        catch (Exception e) {
            ++this.successiveFailureCount;
            if (this.successiveFailureCount > SUCCESSIVE_FAILURE_LIMIT) {
                this.stop();
            }
            this.addError("Could not send message in JMSQueueAppender [" + this.name + "].", e);
        }
    }

    protected QueueConnection getQueueConnection() {
        return this.queueConnection;
    }

    protected QueueSession getQueueSession() {
        return this.queueSession;
    }

    protected QueueSender getQueueSender() {
        return this.queueSender;
    }
}

