/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.sail;

import com.bigdata.rdf.graph.EdgesEnum;
import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.impl.EdgeOnlyFilter;
import com.bigdata.rdf.graph.impl.GASEngine;
import com.bigdata.rdf.graph.impl.sail.Sesame2BigdataIterator;
import com.bigdata.rdf.graph.impl.util.VertexDistribution;
import cutthecrap.utils.striterators.EmptyIterator;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Striterator;
import info.aduna.iteration.CloseableIteration;
import java.util.Iterator;
import java.util.Random;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class SAILGASEngine
extends GASEngine {
    public SAILGASEngine(int nthreads) {
        super(nthreads);
    }

    @Override
    public boolean getSortFrontier() {
        return false;
    }

    public static class SAILGraphAccessor
    implements IGraphAccessor {
        private final SailConnection cxn;
        private final boolean includeInferred;
        private final Resource[] defaultContext;

        public SAILGraphAccessor(SailConnection cxn) {
            this(cxn, true, new Resource[]{null});
        }

        public SAILGraphAccessor(SailConnection cxn, boolean includeInferred, Resource ... defaultContext) {
            if (cxn == null) {
                throw new IllegalArgumentException();
            }
            this.cxn = cxn;
            this.includeInferred = includeInferred;
            this.defaultContext = defaultContext;
        }

        @Override
        public void advanceView() {
        }

        @Override
        public long getEdgeCount(IGASContext<?, ?, ?> ctx, Value u, EdgesEnum edges) {
            long n = 0L;
            Iterator<Statement> itr = this.getEdges(ctx, u, edges);
            while (itr.hasNext()) {
                itr.next();
                ++n;
            }
            return n;
        }

        @Override
        public Iterator<Statement> getEdges(IGASContext<?, ?, ?> p, Value u, EdgesEnum edges) {
            try {
                switch (edges) {
                    case NoEdges: {
                        return EmptyIterator.DEFAULT;
                    }
                    case InEdges: {
                        return this.getEdges(true, p, u);
                    }
                    case OutEdges: {
                        return this.getEdges(false, p, u);
                    }
                    case AllEdges: {
                        IStriterator a = this.getEdges(true, p, u);
                        IStriterator b = this.getEdges(false, p, u);
                        a.append((Iterator)b);
                        return a;
                    }
                }
                throw new UnsupportedOperationException(edges.name());
            }
            catch (SailException ex) {
                throw new RuntimeException(ex);
            }
        }

        private IStriterator getEdges(boolean inEdges, IGASContext<?, ?, ?> ctx, Value u) throws SailException {
            CloseableIteration citr;
            boolean posOptimization;
            URI linkTypeIV = ctx.getLinkType();
            if (linkTypeIV != null) {
                throw new UnsupportedOperationException();
            }
            boolean bl = posOptimization = linkTypeIV != null && inEdges;
            if (posOptimization) {
                citr = this.cxn.getStatements(null, linkTypeIV, u, this.includeInferred, this.defaultContext);
            } else {
                Resource s;
                Value o;
                if (inEdges) {
                    o = u;
                    s = null;
                } else {
                    s = (Resource)u;
                    o = null;
                }
                citr = this.cxn.getStatements(s, null, o, this.includeInferred, this.defaultContext);
            }
            Striterator sitr = new Striterator(new Sesame2BigdataIterator(citr));
            sitr.addFilter(new EdgeOnlyFilter(ctx));
            return sitr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VertexDistribution getDistribution(Random r) {
            try {
                VertexDistribution sample = new VertexDistribution(r);
                try (CloseableIteration citr = this.cxn.getStatements(null, null, null, this.includeInferred, this.defaultContext);){
                    while (citr.hasNext()) {
                        Statement st = (Statement)citr.next();
                        if (!(st.getObject() instanceof Resource) || st.getSubject().equals(st.getObject())) continue;
                        sample.addOutEdgeSample(st.getSubject());
                        sample.addInEdgeSample((Resource)st.getObject());
                    }
                }
                return sample;
            }
            catch (SailException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

