/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.remote.statements;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.http.client.HttpClient;
import org.apache.jena.jdbc.connections.JenaConnection;
import org.apache.jena.jdbc.remote.connections.RemoteEndpointConnection;
import org.apache.jena.jdbc.statements.JenaPreparedStatement;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.apache.jena.sparql.modify.UpdateProcessRemoteBase;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;

public class RemoteEndpointPreparedStatement
extends JenaPreparedStatement {
    private RemoteEndpointConnection remoteConn;
    private HttpClient client;

    public RemoteEndpointPreparedStatement(String sparql, RemoteEndpointConnection connection) throws SQLException {
        this(sparql, connection, null, 1003, 1000, 0, 2);
    }

    public RemoteEndpointPreparedStatement(String sparql, RemoteEndpointConnection connection, HttpClient client, int type, int fetchDir, int fetchSize, int holdability) throws SQLException {
        super(sparql, (JenaConnection)connection, type, fetchDir, fetchSize, holdability, false, 0);
        this.remoteConn = connection;
        this.client = client;
    }

    protected QueryExecution createQueryExecution(Query q) throws SQLException {
        if (this.remoteConn.getQueryEndpoint() == null) {
            throw new SQLException("This statement is backed by a write-only connection, read operations are not supported");
        }
        QueryEngineHTTP exec = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)this.remoteConn.getQueryEndpoint(), (Query)q);
        if (this.client != null) {
            exec.setClient(this.client);
        }
        if (this.remoteConn.getDefaultGraphURIs() != null) {
            exec.setDefaultGraphURIs(this.remoteConn.getDefaultGraphURIs());
        }
        if (this.remoteConn.getNamedGraphURIs() != null) {
            exec.setNamedGraphURIs(this.remoteConn.getNamedGraphURIs());
        }
        if (this.remoteConn.getSelectResultsType() != null) {
            exec.setSelectContentType(this.remoteConn.getSelectResultsType());
        }
        if (this.remoteConn.getModelResultsType() != null) {
            exec.setModelContentType(this.remoteConn.getModelResultsType());
        }
        return exec;
    }

    protected UpdateProcessor createUpdateProcessor(UpdateRequest u) {
        UpdateProcessRemoteBase proc = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemote((UpdateRequest)u, (String)this.remoteConn.getUpdateEndpoint());
        if (this.client != null) {
            proc.setClient(this.client);
        }
        if (this.remoteConn.getUsingGraphURIs() != null) {
            proc.setDefaultGraphs(this.remoteConn.getUsingGraphURIs());
        }
        if (this.remoteConn.getNamedGraphURIs() != null) {
            proc.setNamedGraphs(this.remoteConn.getUsingNamedGraphURIs());
        }
        return proc;
    }

    protected void beginTransaction(ReadWrite type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions against remote endpoint backed connections are not supported");
    }

    protected void commitTransaction() throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions against remote endpoint backed connections are not supported");
    }

    protected void rollbackTransaction() throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions against remote endpoint backed connections are not supported");
    }

    protected boolean hasActiveTransaction() {
        return false;
    }
}

