/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.remote;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.jena.jdbc.JenaDriver;
import org.apache.jena.jdbc.connections.JenaConnection;
import org.apache.jena.jdbc.remote.connections.RemoteEndpointConnection;
import org.apache.jena.sys.JenaSystem;

public class RemoteEndpointDriver
extends JenaDriver {
    public static final String REMOTE_DRIVER_PREFIX = "remote:";
    public static final String PARAM_QUERY_ENDPOINT = "query";
    public static final String PARAM_UPDATE_ENDPOINT = "update";
    public static final String PARAM_DEFAULT_GRAPH_URI = "default-graph-uri";
    public static final String PARAM_NAMED_GRAPH_URI = "named-graph-uri";
    public static final String PARAM_USING_GRAPH_URI = "using-graph-uri";
    public static final String PARAM_USING_NAMED_GRAPH_URI = "using-named-graph-uri";
    public static final String PARAM_SELECT_RESULTS_TYPE = "select-results-type";
    public static final String PARAM_MODEL_RESULTS_TYPE = "model-results-type";
    public static final String PARAM_CLIENT = "client";

    public static synchronized void register() throws SQLException {
        DriverManager.registerDriver((Driver)((Object)new RemoteEndpointDriver()));
    }

    public RemoteEndpointDriver() {
        super(0, 1, REMOTE_DRIVER_PREFIX);
    }

    protected RemoteEndpointDriver(int majorVersion, int minorVersion, String driverPrefix) {
        super(majorVersion, minorVersion, driverPrefix);
    }

    protected JenaConnection connect(Properties props, int compatibilityLevel) throws SQLException {
        String queryEndpoint = props.getProperty(PARAM_QUERY_ENDPOINT);
        String updateEndpoint = props.getProperty(PARAM_UPDATE_ENDPOINT);
        if (queryEndpoint == null && updateEndpoint == null) {
            throw new SQLException("At least one of the query or update connection parameters must be specified to make a remote connection");
        }
        List defaultGraphs = this.getValues(props, PARAM_DEFAULT_GRAPH_URI);
        List namedGraphs = this.getValues(props, PARAM_NAMED_GRAPH_URI);
        List usingGraphs = this.getValues(props, PARAM_USING_GRAPH_URI);
        List usingNamedGraphs = this.getValues(props, PARAM_USING_NAMED_GRAPH_URI);
        HttpClient client = this.configureClient(props);
        String selectResultsType = props.getProperty(PARAM_SELECT_RESULTS_TYPE, null);
        String modelResultsType = props.getProperty(PARAM_MODEL_RESULTS_TYPE, null);
        return this.openConnection(queryEndpoint, updateEndpoint, defaultGraphs, namedGraphs, usingGraphs, usingNamedGraphs, client, 2, compatibilityLevel, selectResultsType, modelResultsType);
    }

    protected HttpClient configureClient(Properties props) throws SQLException {
        String password;
        String user = props.getProperty("user", null);
        if (user != null && user.trim().isEmpty()) {
            user = null;
        }
        if ((password = props.getProperty("password", null)) != null && password.trim().isEmpty()) {
            password = null;
        }
        if (user != null && password != null) {
            BasicCredentialsProvider credsProv = new BasicCredentialsProvider();
            credsProv.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
            return HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProv).build();
        }
        Object client = props.get(PARAM_CLIENT);
        if (client != null) {
            if (!(client instanceof HttpClient)) {
                throw new SQLException("The client parameter is specified but the value is not an object implementing the required HttpClient interface");
            }
            return (HttpClient)client;
        }
        return null;
    }

    protected String getCommonBase(String x, String y) {
        if (x == null) {
            if (y == null) {
                return null;
            }
            return RemoteEndpointDriver.stripIrrelevantComponents(y);
        }
        if (y == null) {
            return RemoteEndpointDriver.stripIrrelevantComponents(x);
        }
        if (x.equals(y)) {
            return RemoteEndpointDriver.stripIrrelevantComponents(x);
        }
        if (x.length() < y.length() && y.startsWith(x)) {
            return RemoteEndpointDriver.stripIrrelevantComponents(x);
        }
        if (y.length() < x.length() && x.startsWith(y)) {
            return RemoteEndpointDriver.stripIrrelevantComponents(y);
        }
        if (x.length() < y.length()) {
            y = RemoteEndpointDriver.stripLastComponent(y);
        } else if (x.length() > y.length()) {
            x = RemoteEndpointDriver.stripLastComponent(x);
        } else {
            x = RemoteEndpointDriver.stripLastComponent(x);
            y = RemoteEndpointDriver.stripLastComponent(y);
        }
        if (x == null || y == null) {
            return null;
        }
        return this.getCommonBase(x, y);
    }

    private static String stripLastComponent(String input) {
        try {
            URI uri = new URI(input);
            if (uri.getFragment() != null) {
                return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null).toString();
            }
            if (uri.getQuery() != null) {
                return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null).toString();
            }
            if (uri.getPath() != null) {
                String currPath = uri.getPath();
                if (currPath.endsWith("/")) {
                    if ((currPath = currPath.substring(0, currPath.length() - 1)).length() == 0) {
                        currPath = null;
                    }
                    return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), currPath, null, null).toString();
                }
                if (currPath.contains("/")) {
                    if ((currPath = currPath.substring(0, currPath.lastIndexOf(47) + 1)).length() == 0) {
                        currPath = null;
                    }
                    return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), currPath, null, null).toString();
                }
                return null;
            }
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static String stripIrrelevantComponents(String input) {
        try {
            URI orig = new URI(input);
            return new URI(orig.getScheme(), orig.getUserInfo(), orig.getHost(), orig.getPort(), orig.getPath(), null, null).toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected RemoteEndpointConnection openConnection(String queryEndpoint, String updateEndpoint, List<String> defaultGraphs, List<String> namedGraphs, List<String> usingGraphs, List<String> usingNamedGraphs, HttpClient client, int holdability, int compatibilityLevel, String selectResultsType, String modelResultsType) throws SQLException {
        return new RemoteEndpointConnection(queryEndpoint, updateEndpoint, defaultGraphs, namedGraphs, usingGraphs, usingNamedGraphs, client, holdability, compatibilityLevel, selectResultsType, modelResultsType);
    }

    protected boolean allowsMultipleValues(String key) {
        if (PARAM_DEFAULT_GRAPH_URI.equals(key) || PARAM_NAMED_GRAPH_URI.equals(key) || PARAM_USING_GRAPH_URI.equals(key) || PARAM_USING_NAMED_GRAPH_URI.equals(key)) {
            return true;
        }
        return super.allowsMultipleValues(key);
    }

    protected DriverPropertyInfo[] getPropertyInfo(Properties connProps, List<DriverPropertyInfo> baseDriverProps) {
        DriverPropertyInfo[] driverProps = new DriverPropertyInfo[10 + baseDriverProps.size()];
        this.copyBaseProperties(driverProps, baseDriverProps, 10);
        driverProps[0] = new DriverPropertyInfo(PARAM_QUERY_ENDPOINT, connProps.getProperty(PARAM_QUERY_ENDPOINT));
        driverProps[0].required = !connProps.containsKey(PARAM_UPDATE_ENDPOINT);
        driverProps[0].description = "Sets the SPARQL Query endpoint to use for query operations, if this is specified and update is not then a read-only connection will be created";
        driverProps[1] = new DriverPropertyInfo(PARAM_UPDATE_ENDPOINT, connProps.getProperty(PARAM_UPDATE_ENDPOINT));
        driverProps[1].required = !connProps.containsKey(PARAM_UPDATE_ENDPOINT);
        driverProps[1].description = "Sets the SPARQL Update endpoint to use for update operations, if this is specified and query is not then a write-only connection will be created";
        driverProps[2] = new DriverPropertyInfo(PARAM_DEFAULT_GRAPH_URI, null);
        driverProps[2].required = false;
        driverProps[2].description = "Sets the URI for a default graph for queries, may be specified multiple times to specify multiple graphs which should form the default graph";
        driverProps[3] = new DriverPropertyInfo(PARAM_NAMED_GRAPH_URI, null);
        driverProps[3].required = false;
        driverProps[3].description = "Sets the URI for a named graph for queries, may be specified multiple times to specify multiple named graphs which should be accessible";
        driverProps[4] = new DriverPropertyInfo(PARAM_USING_GRAPH_URI, null);
        driverProps[4].required = false;
        driverProps[4].description = "Sets the URI for a default graph for updates, may be specified multiple times to specify multiple graphs which should form the default graph";
        driverProps[5] = new DriverPropertyInfo(PARAM_USING_NAMED_GRAPH_URI, null);
        driverProps[5].required = false;
        driverProps[5].description = "Sets the URI for a named graph for updates, may be specified multiple times to specify multiple named graph which should be accessible";
        driverProps[6] = new DriverPropertyInfo(PARAM_SELECT_RESULTS_TYPE, connProps.getProperty(PARAM_SELECT_RESULTS_TYPE));
        driverProps[6].required = false;
        driverProps[6].description = "Sets the results type for SELECT queries that will be requested from the remote endpoint";
        driverProps[7] = new DriverPropertyInfo(PARAM_MODEL_RESULTS_TYPE, connProps.getProperty(PARAM_MODEL_RESULTS_TYPE));
        driverProps[7].required = false;
        driverProps[7].description = "Sets the results type for CONSTRUCT and DESCRIBE queries that will be requested from the remote endpoint";
        driverProps[8] = new DriverPropertyInfo("user", connProps.getProperty("user"));
        driverProps[9] = new DriverPropertyInfo("password", connProps.getProperty("password"));
        return driverProps;
    }

    static {
        try {
            JenaSystem.init();
            RemoteEndpointDriver.register();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to register Jena Remote Endpoint JDBC Driver", e);
        }
    }
}

