/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.types.DayToSecond;

final class TimestampDiff
extends AbstractField<DayToSecond> {
    private static final long serialVersionUID = -4813228000332771961L;
    private final Field<?> timestamp1;
    private final Field<?> timestamp2;

    TimestampDiff(Field<?> timestamp1, Field<?> timestamp2) {
        super(Names.N_TIMESTAMPDIFF, SQLDataType.INTERVALDAYTOSECOND);
        this.timestamp1 = timestamp1;
        this.timestamp2 = timestamp2;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                ctx.sql('(').visit(this.timestamp1).sql(" - ").visit(this.timestamp2).sql(')');
                break;
            }
            case CUBRID: {
                ctx.visit(this.timestamp1.sub(this.timestamp2));
                break;
            }
            case DERBY: {
                ctx.sql("1000 * {fn ").visit(Names.N_TIMESTAMPDIFF).sql('(').visit(DSL.keyword("sql_tsi_second")).sql(", ").visit(this.timestamp2).sql(", ").visit(this.timestamp1).sql(") }");
                break;
            }
            case FIREBIRD: {
                ctx.visit(Names.N_DATEDIFF).sql('(').visit(Keywords.K_MILLISECOND).sql(", ").visit(this.timestamp2).sql(", ").visit(this.timestamp1).sql(')');
                break;
            }
            case H2: 
            case HSQLDB: {
                ctx.visit(Names.N_DATEDIFF).sql("('ms', ").visit(this.timestamp2).sql(", ").visit(this.timestamp1).sql(')');
                break;
            }
            case MARIADB: 
            case MYSQL: {
                ctx.visit(Names.N_TIMESTAMPDIFF).sql('(').visit(DSL.keyword("microsecond")).sql(", ").visit(this.timestamp2).sql(", ").visit(this.timestamp1).sql(") / 1000");
                break;
            }
            case SQLITE: {
                ctx.sql('(').visit(Names.N_STRFTIME).sql("('%s', ").visit(this.timestamp1).sql(") - ").visit(Names.N_STRFTIME).sql("('%s', ").visit(this.timestamp2).sql(")) * 1000");
                break;
            }
            default: {
                ctx.visit(Tools.castIfNeeded(this.timestamp1.sub(this.timestamp2), DayToSecond.class));
            }
        }
    }
}

