/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.DDLExportConfiguration;
import org.jooq.Domain;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Meta;
import org.jooq.MigrationConfiguration;
import org.jooq.Name;
import org.jooq.Named;
import org.jooq.Queries;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractScope;
import org.jooq.impl.DDL;
import org.jooq.impl.DSL;
import org.jooq.impl.Diff;
import org.jooq.impl.FilteredMeta;
import org.jooq.impl.InformationSchemaExport;
import org.jooq.impl.Internal;
import org.jooq.impl.Snapshot;
import org.jooq.util.xml.jaxb.InformationSchema;

abstract class AbstractMeta
extends AbstractScope
implements Meta,
Serializable {
    private static final long serialVersionUID = 910484713008245977L;
    private Map<Name, Catalog> cachedCatalogs;
    private Map<Name, Schema> cachedQualifiedSchemas;
    private Map<Name, Table<?>> cachedQualifiedTables;
    private Map<Name, Domain<?>> cachedQualifiedDomains;
    private Map<Name, Sequence<?>> cachedQualifiedSequences;
    private Map<Name, List<Schema>> cachedUnqualifiedSchemas;
    private Map<Name, List<Table<?>>> cachedUnqualifiedTables;
    private Map<Name, List<Domain<?>>> cachedUnqualifiedDomains;
    private Map<Name, List<Sequence<?>>> cachedUnqualifiedSequences;
    private List<UniqueKey<?>> cachedPrimaryKeys;
    private List<Index> cachedIndexes;

    AbstractMeta(Configuration configuration) {
        super(configuration);
    }

    @Override
    public final Catalog getCatalog(String name) {
        return this.getCatalog(DSL.name(name));
    }

    @Override
    public final Catalog getCatalog(Name name) {
        this.initCatalogs();
        return this.cachedCatalogs.get(name);
    }

    @Override
    public final List<Catalog> getCatalogs() {
        this.initCatalogs();
        return Collections.unmodifiableList(new ArrayList<Catalog>(this.cachedCatalogs.values()));
    }

    private final void initCatalogs() {
        if (this.cachedCatalogs == null) {
            this.cachedCatalogs = new LinkedHashMap<Name, Catalog>();
            for (Catalog catalog : this.getCatalogs0()) {
                this.cachedCatalogs.put(catalog.getQualifiedName(), catalog);
            }
        }
    }

    abstract List<Catalog> getCatalogs0();

    @Override
    public final List<Schema> getSchemas(String name) {
        return this.getSchemas(DSL.name(name));
    }

    @Override
    public final List<Schema> getSchemas(Name name) {
        this.initSchemas();
        return this.get(name, new Iterable<Schema>(){

            @Override
            public Iterator<Schema> iterator() {
                return AbstractMeta.this.getSchemas0().iterator();
            }
        }, this.cachedQualifiedSchemas, this.cachedUnqualifiedSchemas);
    }

    @Override
    public final List<Schema> getSchemas() {
        this.initSchemas();
        return Collections.unmodifiableList(new ArrayList<Schema>(this.cachedQualifiedSchemas.values()));
    }

    private final void initSchemas() {
        if (this.cachedQualifiedSchemas == null) {
            this.cachedQualifiedSchemas = new LinkedHashMap<Name, Schema>();
            this.cachedUnqualifiedSchemas = new LinkedHashMap<Name, List<Schema>>();
            this.get(DSL.name(""), new Iterable<Schema>(){

                @Override
                public Iterator<Schema> iterator() {
                    return AbstractMeta.this.getSchemas0().iterator();
                }
            }, this.cachedQualifiedSchemas, this.cachedUnqualifiedSchemas);
        }
    }

    List<Schema> getSchemas0() {
        ArrayList<Schema> result = new ArrayList<Schema>();
        for (Catalog catalog : this.getCatalogs()) {
            result.addAll(catalog.getSchemas());
        }
        return result;
    }

    @Override
    public final List<Table<?>> getTables(String name) {
        return this.getTables(DSL.name(name));
    }

    @Override
    public final List<Table<?>> getTables(Name name) {
        this.initTables();
        return this.get(name, new Iterable<Table<?>>(){

            @Override
            public Iterator<Table<?>> iterator() {
                return AbstractMeta.this.getTables().iterator();
            }
        }, this.cachedQualifiedTables, this.cachedUnqualifiedTables);
    }

    @Override
    public final List<Table<?>> getTables() {
        this.initTables();
        return Collections.unmodifiableList(new ArrayList(this.cachedQualifiedTables.values()));
    }

    private final void initTables() {
        if (this.cachedQualifiedTables == null) {
            this.cachedQualifiedTables = new LinkedHashMap();
            this.cachedUnqualifiedTables = new LinkedHashMap();
            this.get(DSL.name(""), new Iterable<Table<?>>(){

                @Override
                public Iterator<Table<?>> iterator() {
                    return AbstractMeta.this.getTables0().iterator();
                }
            }, this.cachedQualifiedTables, this.cachedUnqualifiedTables);
        }
    }

    List<Table<?>> getTables0() {
        ArrayList result = new ArrayList();
        for (Schema schema : this.getSchemas()) {
            result.addAll(schema.getTables());
        }
        return result;
    }

    @Override
    public final List<Domain<?>> getDomains(String name) {
        return this.getDomains(DSL.name(name));
    }

    @Override
    public final List<Domain<?>> getDomains(Name name) {
        this.initDomains();
        return this.get(name, new Iterable<Domain<?>>(){

            @Override
            public Iterator<Domain<?>> iterator() {
                return AbstractMeta.this.getDomains().iterator();
            }
        }, this.cachedQualifiedDomains, this.cachedUnqualifiedDomains);
    }

    @Override
    public final List<Domain<?>> getDomains() {
        this.initDomains();
        return Collections.unmodifiableList(new ArrayList(this.cachedQualifiedDomains.values()));
    }

    private final void initDomains() {
        if (this.cachedQualifiedDomains == null) {
            this.cachedQualifiedDomains = new LinkedHashMap();
            this.cachedUnqualifiedDomains = new LinkedHashMap();
            this.get(DSL.name(""), new Iterable<Domain<?>>(){

                @Override
                public Iterator<Domain<?>> iterator() {
                    return AbstractMeta.this.getDomains0().iterator();
                }
            }, this.cachedQualifiedDomains, this.cachedUnqualifiedDomains);
        }
    }

    List<Domain<?>> getDomains0() {
        ArrayList result = new ArrayList();
        for (Schema schema : this.getSchemas()) {
            result.addAll(schema.getDomains());
        }
        return result;
    }

    @Override
    public final List<Sequence<?>> getSequences(String name) {
        return this.getSequences(DSL.name(name));
    }

    @Override
    public final List<Sequence<?>> getSequences(Name name) {
        this.initSequences();
        return this.get(name, new Iterable<Sequence<?>>(){

            @Override
            public Iterator<Sequence<?>> iterator() {
                return AbstractMeta.this.getSequences().iterator();
            }
        }, this.cachedQualifiedSequences, this.cachedUnqualifiedSequences);
    }

    @Override
    public final List<Sequence<?>> getSequences() {
        this.initSequences();
        return Collections.unmodifiableList(new ArrayList(this.cachedQualifiedSequences.values()));
    }

    private final void initSequences() {
        if (this.cachedQualifiedSequences == null) {
            this.cachedQualifiedSequences = new LinkedHashMap();
            this.cachedUnqualifiedSequences = new LinkedHashMap();
            this.get(DSL.name(""), new Iterable<Sequence<?>>(){

                @Override
                public Iterator<Sequence<?>> iterator() {
                    return AbstractMeta.this.getSequences0().iterator();
                }
            }, this.cachedQualifiedSequences, this.cachedUnqualifiedSequences);
        }
    }

    List<Sequence<?>> getSequences0() {
        ArrayList result = new ArrayList();
        for (Schema schema : this.getSchemas()) {
            result.addAll(schema.getSequences());
        }
        return result;
    }

    @Override
    public final List<UniqueKey<?>> getPrimaryKeys() {
        this.initPrimaryKeys();
        return Collections.unmodifiableList(this.cachedPrimaryKeys);
    }

    private final void initPrimaryKeys() {
        if (this.cachedPrimaryKeys == null) {
            this.cachedPrimaryKeys = new ArrayList(this.getPrimaryKeys0());
        }
    }

    List<UniqueKey<?>> getPrimaryKeys0() {
        ArrayList result = new ArrayList();
        for (Table<?> table : this.getTables()) {
            if (table.getPrimaryKey() == null) continue;
            result.add(table.getPrimaryKey());
        }
        return result;
    }

    @Override
    public final List<Index> getIndexes() {
        this.initIndexes();
        return Collections.unmodifiableList(this.cachedIndexes);
    }

    private final void initIndexes() {
        if (this.cachedIndexes == null) {
            this.cachedIndexes = new ArrayList<Index>(this.getIndexes0());
        }
    }

    List<Index> getIndexes0() {
        ArrayList<Index> result = new ArrayList<Index>();
        for (Table<?> table : this.getTables()) {
            result.addAll(table.getIndexes());
        }
        return result;
    }

    private final <T extends Named> List<T> get(Name name, Iterable<T> i, Map<Name, T> qualified, Map<Name, List<T>> unqualified) {
        Named object;
        if (qualified.isEmpty()) {
            for (Named object2 : i) {
                Name q = object2.getQualifiedName();
                Name u = object2.getUnqualifiedName();
                qualified.put(q, object2);
                List<T> list = unqualified.get(u);
                if (list == null) {
                    list = new ArrayList<T>();
                    unqualified.put(u, list);
                }
                list.add(object2);
            }
        }
        if ((object = (Named)qualified.get(name)) != null) {
            return Collections.singletonList(object);
        }
        List<T> list = unqualified.get(name);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public Meta filterCatalogs(Meta.Predicate<? super Catalog> filter) {
        return new FilteredMeta(this, filter, null, null, null, null, null, null);
    }

    @Override
    public Meta filterSchemas(Meta.Predicate<? super Schema> filter) {
        return new FilteredMeta(this, null, filter, null, null, null, null, null);
    }

    @Override
    public Meta filterTables(Meta.Predicate<? super Table<?>> filter) {
        return new FilteredMeta(this, null, null, filter, null, null, null, null);
    }

    @Override
    public Meta filterDomains(Meta.Predicate<? super Domain<?>> filter) {
        return new FilteredMeta(this, null, null, null, filter, null, null, null);
    }

    @Override
    public Meta filterSequences(Meta.Predicate<? super Sequence<?>> filter) {
        return new FilteredMeta(this, null, null, null, null, filter, null, null);
    }

    @Override
    public Meta filterPrimaryKeys(Meta.Predicate<? super UniqueKey<?>> filter) {
        return new FilteredMeta(this, null, null, null, null, null, filter, null);
    }

    @Override
    public Meta filterIndexes(Meta.Predicate<? super Index> filter) {
        return new FilteredMeta(this, null, null, null, null, null, null, filter);
    }

    @Override
    public final Meta snapshot() {
        return new Snapshot(this);
    }

    @Override
    public final Queries ddl() {
        return this.ddl(new DDLExportConfiguration());
    }

    @Override
    public Queries ddl(DDLExportConfiguration exportConfiguration) {
        return new DDL(this.dsl(), exportConfiguration).queries(this);
    }

    @Override
    public final Meta apply(String migration) {
        return this.apply(this.dsl().parser().parse(migration));
    }

    @Override
    public final Meta apply(Query ... migration) {
        return this.apply(this.dsl().queries(migration));
    }

    @Override
    public final Meta apply(Collection<? extends Query> migration) {
        return this.apply(this.dsl().queries(migration));
    }

    @Override
    public final Meta apply(Queries migration) {
        return this.dsl().meta(this.ddl().concat(migration).queries());
    }

    @Override
    public final Queries migrateTo(Meta other) {
        return this.migrateTo(other, new MigrationConfiguration());
    }

    @Override
    public final Queries migrateTo(Meta other, MigrationConfiguration c) {
        return new Diff(this.configuration(), c, this, other).queries();
    }

    @Override
    public InformationSchema informationSchema() {
        return InformationSchemaExport.exportCatalogs(this.configuration(), this.getCatalogs());
    }

    final Table<?> lookupTable(Table<?> table) {
        Catalog catalog = this.getCatalog(table.getCatalog().getName());
        if (catalog == null) {
            return null;
        }
        Schema schema = catalog.getSchema(table.getSchema().getName());
        if (schema == null) {
            return null;
        }
        return schema.getTable(table.getName());
    }

    final <R extends Record> UniqueKey<R> lookupKey(Table<R> in, UniqueKey<?> uk) {
        HashSet ukFields = new HashSet(uk.getFields());
        for (UniqueKey<R> k : in.getKeys()) {
            if (!ukFields.equals(new HashSet(k.getFields()))) continue;
            return k;
        }
        return null;
    }

    final UniqueKey<?> lookupUniqueKey(ForeignKey<?, ?> fk) {
        Table<?> table = this.lookupTable(fk.getKey().getTable());
        if (table == null) {
            return null;
        }
        return this.lookupKey(table, fk.getKey());
    }

    static final <R extends Record> ForeignKey<R, ?> copyFK(Table<R> fkTable, UniqueKey<?> uk, ForeignKey<R, ?> oldFk) {
        Table ukTable = uk.getTable();
        TableField<R, ?>[] oldFkFields = oldFk.getFieldsArray();
        TableField<?, ?>[] oldUkFields = oldFk.getKeyFieldsArray();
        TableField[] fkFields = new TableField[oldFkFields.length];
        TableField[] ukfields = new TableField[oldFkFields.length];
        for (int i = 0; i < oldFkFields.length; ++i) {
            fkFields[i] = (TableField)fkTable.field(oldFkFields[i]);
            ukfields[i] = (TableField)ukTable.field(oldUkFields[i]);
        }
        return Internal.createForeignKey(fkTable, oldFk.getQualifiedName(), fkFields, uk, ukfields, oldFk.enforced());
    }

    public int hashCode() {
        return this.ddl().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Meta) {
            return this.ddl().equals(((Meta)obj).ddl());
        }
        return false;
    }

    public String toString() {
        return this.ddl().toString();
    }
}

