/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLEntityURIConverterStrategy;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

public class OWLEntityURIConverter {
    private final OWLOntologyManager manager;
    private final Collection<OWLOntology> ontologies;
    private final Map<OWLEntity, IRI> replacementMap = new HashMap<OWLEntity, IRI>();
    private final Set<OWLEntity> processedEntities = new HashSet<OWLEntity>();
    private final OWLEntityURIConverterStrategy strategy;

    public OWLEntityURIConverter(OWLOntologyManager manager, Collection<OWLOntology> ontologies, OWLEntityURIConverterStrategy strategy) {
        this.manager = OWLAPIPreconditions.checkNotNull(manager, "manager cannot be null");
        this.ontologies = new ArrayList<OWLOntology>(OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null"));
        this.strategy = OWLAPIPreconditions.checkNotNull(strategy, "strategy cannot be null");
    }

    public List<OWLOntologyChange> getChanges() {
        this.replacementMap.clear();
        this.processedEntities.clear();
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLOntology ont : this.ontologies) {
            ont.classesInSignature().filter(c -> !c.isOWLThing() && !c.isOWLNothing()).forEach(this::processEntity);
            ont.objectPropertiesInSignature().forEach(this::processEntity);
            ont.dataPropertiesInSignature().forEach(this::processEntity);
            ont.individualsInSignature().forEach(this::processEntity);
        }
        OWLObjectDuplicator dup = new OWLObjectDuplicator(this.replacementMap, this.manager);
        for (OWLOntology ont : this.ontologies) {
            ont.axioms().forEach(ax -> {
                OWLAxiom dupAx = dup.duplicateObject(ax);
                if (!dupAx.equals(ax)) {
                    changes.add(new RemoveAxiom(ont, (OWLAxiom)ax));
                    changes.add(new AddAxiom(ont, dupAx));
                }
            });
        }
        return changes;
    }

    private void processEntity(OWLEntity ent) {
        if (this.processedEntities.contains(ent)) {
            return;
        }
        IRI rep = this.getTinyIRI(ent);
        this.replacementMap.put(ent, rep);
        this.processedEntities.add(ent);
    }

    private IRI getTinyIRI(OWLEntity ent) {
        return this.strategy.getConvertedIRI(ent);
    }
}

