/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.AbstractCollector;
import org.semanticweb.owlapi.util.IndividualAppearance;

public class OWLAnonymousIndividualsWithMultipleOccurrences
extends AbstractCollector
implements IndividualAppearance {
    private Set<OWLObject> singleAppearanceAsSubject = new HashSet<OWLObject>();
    private Set<OWLObject> singleAppearance = new HashSet<OWLObject>();
    private Set<OWLObject> multipleAppearances = new HashSet<OWLObject>();

    @Override
    public boolean appearsMultipleTimes(OWLAnonymousIndividual i) {
        return this.multipleAppearances.contains(i);
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.checkAppearanceAsObject(individual);
    }

    @Override
    public void visit(OWLAnnotation a) {
        a.getValue().asAnonymousIndividual().ifPresent(this::checkAppearanceAsObject);
        a.annotations().forEach(a1 -> a1.accept(this));
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
        axiom.annotations().forEach(a1 -> a1.accept(this));
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        axiom.annotations().forEach(a1 -> a1.accept(this));
    }

    @Override
    public void visit(OWLOntology ontology) {
        ontology.annotations().forEach(a1 -> a1.accept(this));
        AxiomType.AXIOM_TYPES.forEach(t -> ontology.axioms(t).forEach(ax -> ax.accept(this)));
        this.singleAppearance.clear();
        this.singleAppearanceAsSubject.clear();
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        ((OWLAnnotationSubject)axiom.getSubject()).asAnonymousIndividual().ifPresent(this::checkAppearanceAsSubject);
        axiom.getValue().asAnonymousIndividual().ifPresent(this::checkAppearanceAsObject);
    }

    protected void checkAppearanceAsObject(OWLAnonymousIndividual a) {
        if (!this.multipleAppearances.contains(a) && !this.singleAppearance.add(a)) {
            this.singleAppearance.remove(a);
            this.multipleAppearances.add(a);
        }
    }

    protected void checkAppearanceAsSubject(OWLAnonymousIndividual a) {
        if (!this.multipleAppearances.contains(a) && !this.singleAppearanceAsSubject.add(a)) {
            this.singleAppearanceAsSubject.remove(a);
            this.multipleAppearances.add(a);
        }
    }
}

