/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.concurrent;

import java.util.concurrent.Future;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutorBase;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParallelTaskBase<T>
implements ParallelTask<T> {
    private static final Logger _log = LoggerFactory.getLogger(ParallelExecutorBase.class);
    protected Future<?> scheduledFuture;

    @Override
    public void cancel() {
        if (this.scheduledFuture != null) {
            if (this.scheduledFuture.isDone()) {
                _log.trace("Task is already done: " + this.toString());
            } else {
                _log.debug("Attempting to cancel task " + this.toString());
                boolean successfullyCanceled = this.scheduledFuture.cancel(true);
                if (!successfullyCanceled) {
                    _log.debug("Task " + this.toString() + " could not be cancelled properly.");
                }
            }
        }
    }

    public void setScheduledFuture(Future<?> future) {
        this.scheduledFuture = future;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (Query: " + this.getQueryInfo().getQueryID() + ")";
    }
}

