/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BigdataGraph;
import com.bigdata.blueprints.BigdataPredicate;
import com.bigdata.blueprints.BlueprintsValueFactory;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Contains;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class BigdataGraphQuery
implements GraphQuery {
    protected static final transient Logger log = Logger.getLogger(BigdataGraphQuery.class);
    protected static List<Class> knownPredicates = Arrays.asList(BigdataPredicate.class, Query.Compare.class, Contains.class, Compare.class);
    private final BigdataGraph graph;
    protected final URI TYPE;
    protected final URI VERTEX;
    protected final URI EDGE;
    protected final URI LABEL;
    private final List<Has> criteria = new LinkedList<Has>();
    private transient int limit = Integer.MAX_VALUE;

    public BigdataGraphQuery(BigdataGraph graph) {
        this.graph = graph;
        this.TYPE = graph.getValueFactory().getTypeURI();
        this.VERTEX = graph.getValueFactory().getVertexURI();
        this.EDGE = graph.getValueFactory().getEdgeURI();
        this.LABEL = graph.getValueFactory().getLabelURI();
    }

    public GraphQuery has(String key) {
        this.criteria.add(new Has(key));
        return this;
    }

    public GraphQuery hasNot(String key) {
        this.criteria.add(new HasNot(key));
        return this;
    }

    public GraphQuery has(String key, Object value) {
        this.criteria.add(new Has(key, value));
        return this;
    }

    public GraphQuery hasNot(String key, Object value) {
        this.criteria.add(new HasNot(key, value));
        return this;
    }

    public GraphQuery has(String key, Predicate predicate, Object value) {
        if (!knownPredicates.contains(predicate.getClass())) {
            throw new IllegalArgumentException();
        }
        this.criteria.add(new Has(key, value, BigdataPredicate.toBigdataPredicate(predicate)));
        return this;
    }

    @Deprecated
    public <T extends Comparable<T>> GraphQuery has(String key, T value, Query.Compare compare) {
        return this.has(key, (Predicate)compare, value);
    }

    public <T extends Comparable<?>> GraphQuery interval(String key, T startValue, T endValue) {
        return this.has(key, BigdataPredicate.GTE, startValue).has(key, (Predicate)BigdataPredicate.LT, endValue);
    }

    public GraphQuery limit(int limit) {
        this.limit = limit;
        return this;
    }

    public Iterable<Edge> edges() {
        try {
            String queryStr = this.toQueryStr(this.EDGE);
            return this.graph.getEdges(queryStr);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Iterable<Vertex> vertices() {
        try {
            String queryStr = this.toQueryStr(this.VERTEX);
            return this.graph.getVertices(queryStr, true);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected String toQueryStr(URI type) {
        StringBuilder sb = new StringBuilder();
        if (type == this.VERTEX) {
            sb.append("construct { ?x <" + this.TYPE + "> <" + type + "> . }\n");
            sb.append("{\n  select distinct ?x where {\n");
        } else {
            sb.append("construct { ?from ?x ?to . }\n");
            sb.append("{\n  select distinct ?from ?x ?to where {\n");
            sb.append("    ?from ?x ?to .\n");
        }
        BlueprintsValueFactory factory = this.graph.factory;
        boolean hasHas = false;
        int i = 1;
        for (Has has : this.criteria) {
            String var;
            String val;
            if (log.isTraceEnabled()) {
                log.trace((Object)has);
            }
            if (has instanceof HasNot) {
                sb.append("    filter not exists { ");
                sb.append("?x <").append(factory.toPropertyURI(has.key)).append("> ");
                if (has.val != null) {
                    val = factory.toLiteral(has.val).toString();
                    sb.append(val).append(" .");
                } else {
                    var = "?val" + i;
                    sb.append(var).append(" .");
                }
                sb.append("}\n");
            } else {
                hasHas = true;
                sb.append("    ?x <").append(factory.toPropertyURI(has.key)).append("> ");
                if (has.val != null && (has.pred == null || has.pred == BigdataPredicate.EQ)) {
                    val = factory.toLiteral(has.val);
                    sb.append((Object)val).append(" .\n");
                } else {
                    var = "?val" + i;
                    sb.append(var).append(" .\n");
                    if (has.pred != null) {
                        sb.append(this.toFilterStr(has.pred, var, has.val)).append("\n");
                    }
                }
            }
            ++i;
        }
        if (!hasHas) {
            sb.append("    ?x <" + this.TYPE + "> <").append(type).append("> .\n");
        }
        sb.append("  }");
        if (this.limit < Integer.MAX_VALUE) {
            sb.append(" limit " + factory.toLiteral(this.limit).getLabel());
        }
        sb.append("\n}");
        if (log.isTraceEnabled()) {
            log.trace((Object)("\n" + sb.toString()));
        }
        return sb.toString();
    }

    private String toFilterStr(BigdataPredicate pred, String var, Object val) {
        BlueprintsValueFactory factory = this.graph.factory;
        StringBuilder sb = new StringBuilder();
        if (pred == BigdataPredicate.EQ) {
            throw new IllegalArgumentException();
        }
        if (pred == BigdataPredicate.GT || pred == BigdataPredicate.GTE || pred == BigdataPredicate.LT || pred == BigdataPredicate.LTE || pred == BigdataPredicate.NE) {
            Literal l = factory.toLiteral(val);
            sb.append("    filter(").append(var);
            switch (pred) {
                case GT: {
                    sb.append(" > ");
                    break;
                }
                case GTE: {
                    sb.append(" >= ");
                    break;
                }
                case LT: {
                    sb.append(" < ");
                    break;
                }
                case LTE: {
                    sb.append(" <= ");
                    break;
                }
                case NE: {
                    sb.append(" != ");
                    break;
                }
            }
            sb.append(l).append(") .");
        } else if (pred == BigdataPredicate.IN || pred == BigdataPredicate.NIN) {
            sb.append("    filter(");
            if (pred == BigdataPredicate.NIN) {
                sb.append("!(");
            }
            sb.append(var).append(" in (");
            Collection c = (Collection)val;
            for (Object o : c) {
                Literal l = factory.toLiteral(o);
                sb.append(l).append(", ");
            }
            sb.setLength(sb.length() - 2);
            if (pred == BigdataPredicate.NIN) {
                sb.append(")");
            }
            sb.append(")) .");
        }
        return sb.toString();
    }

    private class HasNot
    extends Has {
        public HasNot(String key) {
            super(key);
        }

        public HasNot(String key, Object val) {
            super(key, val);
        }
    }

    private class Has {
        private String key;
        private Object val;
        private BigdataPredicate pred;

        public Has(String key) {
            this(key, null, null);
        }

        public Has(String key, Object val) {
            this(key, val, null);
        }

        public Has(String key, Object val, BigdataPredicate pred) {
            if (pred == BigdataPredicate.IN || pred == BigdataPredicate.NIN) {
                if (!(val instanceof Collection)) {
                    throw new IllegalArgumentException();
                }
                if (((Collection)val).size() == 0) {
                    throw new IllegalArgumentException();
                }
            }
            this.key = key;
            if (pred == BigdataPredicate.IN && ((Collection)val).size() == 1) {
                this.val = ((Collection)val).iterator().next();
                this.pred = null;
            } else {
                this.val = val;
                this.pred = pred;
            }
        }

        public String toString() {
            return "key: " + this.key + ", val: " + this.val + ", pred: " + (Object)((Object)this.pred);
        }
    }
}

