/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObliqueStereographicAlternative
extends Projection {
    public static final Identifier STEREA = new Identifier("EPSG", "9809", "Oblique Stereographic Alternative", "STEREA");
    protected final double lat0;
    protected final double lon0 = this.getCentralMeridian();
    protected final double conLat0;
    protected final double FE;
    protected final double FN;
    protected final double k0;
    protected final double R;
    protected final double e;
    protected final double e2;
    protected final double c;
    protected final double n;
    private double PI_2 = 1.5707963267948966;

    public ObliqueStereographicAlternative(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(STEREA, ellipsoid, parameters);
        this.lat0 = this.getLatitudeOfOrigin();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
        this.e = ellipsoid.getEccentricity();
        this.e2 = ellipsoid.getSquareEccentricity();
        this.k0 = this.getScaleFactor();
        this.R = Math.sqrt(ellipsoid.meridionalRadiusOfCurvature(this.lat0) * ellipsoid.transverseRadiusOfCurvature(this.lat0));
        this.n = Math.sqrt(1.0 + this.e2 * Math.pow(Math.cos(this.lat0), 4.0) / (1.0 - this.e2));
        double w1 = this.w(this.lat0);
        double sinki0 = (w1 - 1.0) / (w1 + 1.0);
        this.c = (this.n + Math.sin(this.lat0)) * (1.0 - sinki0) / (this.n - Math.sin(this.lat0)) / (1.0 + sinki0);
        this.conLat0 = Math.asin((this.c * w1 - 1.0) / (this.c * w1 + 1.0));
    }

    private double w(double lat) {
        return Math.pow((1.0 + Math.sin(lat)) / (1.0 - Math.sin(lat)) * Math.pow((1.0 - this.e * Math.sin(lat)) / (1.0 + this.e * Math.sin(lat)), this.e), this.n);
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.AZIMUTHAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.CONFORMAL;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TANGENT;
    }

    @Override
    public double[] transform(double[] coord) throws CoordinateDimensionException {
        double lon = coord[1];
        double lat = coord[0];
        double conLon = this.n * (lon - this.lon0) + this.lon0;
        double conLat = Math.asin((this.c * this.w(lat) - 1.0) / (this.c * this.w(lat) + 1.0));
        double B = 1.0 + Math.sin(conLat) * Math.sin(this.conLat0) + Math.cos(conLat) * Math.cos(this.conLat0) * Math.cos(conLon - this.lon0);
        double dE = 2.0 * this.R * this.k0 * Math.cos(conLat) * Math.sin(conLon - this.lon0) / B;
        double dN = 2.0 * this.R * this.k0 * (Math.sin(conLat) * Math.cos(this.conLat0) - Math.cos(conLat) * Math.sin(this.conLat0) * Math.cos(conLon - this.lon0)) / B;
        coord[0] = this.FE + dE;
        coord[1] = this.FN + dN;
        return coord;
    }

    @Override
    public Projection inverse() throws NonInvertibleOperationException {
        return new ObliqueStereographicAlternative(this.ellipsoid, this.parameters){

            public double[] transform(double[] coord) throws CoordinateDimensionException {
                double dE = coord[0] - this.FE;
                double dN = coord[1] - this.FN;
                double g = 2.0 * this.R * this.k0 * Math.tan((ObliqueStereographicAlternative.this.PI_2 - this.conLat0) / 2.0);
                double h = 4.0 * this.R * this.k0 * Math.tan(this.conLat0) + g;
                double i = Math.atan(dE / (h + dN));
                double j = Math.atan(dE / (g - dN)) - i;
                double conLat = this.conLat0 + 2.0 * Math.atan((dN - dE * Math.tan(j / 2.0)) / 2.0 / this.R / this.k0);
                double conLon = j + 2.0 * i + this.lon0;
                coord[1] = (conLon - this.lon0) / this.n + this.lon0;
                double isoLat = Math.log((1.0 + Math.sin(conLat)) / (1.0 - Math.sin(conLat)) / this.c) / 2.0 / this.n;
                coord[0] = this.ellipsoid.latitude(isoLat);
                return coord;
            }

            public Projection inverse() throws NonInvertibleOperationException {
                return ObliqueStereographicAlternative.this;
            }

            public boolean isDirect() {
                return false;
            }

            public String toString() {
                return ObliqueStereographicAlternative.this.toString() + " inverse";
            }
        };
    }
}

