/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.scenario;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import uk.ac.cam.cares.jps.base.config.KeyValueManager;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.query.ResourcePathConverter;
import uk.ac.cam.cares.jps.base.scenario.JPSContext;
import uk.ac.cam.cares.jps.base.scenario.ScenarioHelper;

public class BucketHelper {
    private static final String SLASH_KB = "/kb/";
    private static final String SLASH_DATA = "/data/";

    public static String getScenarioUrl(String scenarioName) {
        String url = KeyValueManager.getServerAddress() + "/jps/scenario" + "/" + scenarioName;
        return url;
    }

    public static String getScenarioUrl() {
        String scenarioUrl = JPSContext.getScenarioUrl();
        if (scenarioUrl == null) {
            scenarioUrl = BucketHelper.getScenarioUrl("base");
        }
        return scenarioUrl;
    }

    public static String getScenarioName(String scenarioUrl) {
        int i = scenarioUrl.indexOf("/jps/scenario");
        return scenarioUrl.substring(i + "/jps/scenario".length() + 1);
    }

    public static String getIriPrefix() {
        String usecaseUrl = BucketHelper.getUsecaseUrl();
        int iHostEnd = usecaseUrl.indexOf("/jps/scenario");
        int iKbBegin = usecaseUrl.indexOf(SLASH_KB);
        String prefix = usecaseUrl.substring(0, iHostEnd) + "/" + "jps" + usecaseUrl.substring(iKbBegin);
        return prefix;
    }

    public static String getUsecaseUrl() {
        String usecaseUrl = JPSContext.getUsecaseUrl();
        System.out.println("WHAT IS USECASEUrl here? " + usecaseUrl);
        if (usecaseUrl == null) {
            usecaseUrl = BucketHelper.getUsecaseUrl(BucketHelper.getScenarioUrl());
            JPSContext.putUsecaseUrl(usecaseUrl);
        }
        return usecaseUrl;
    }

    public static String getUsecaseUrl(String scenarioUrl) {
        String usecaseID = UUID.randomUUID().toString();
        String usecaseUrl = scenarioUrl + SLASH_KB + usecaseID;
        return usecaseUrl;
    }

    public static String getUsecaseUrlForData() {
        String usecaseUrl = BucketHelper.getUsecaseUrl();
        return usecaseUrl.replace(SLASH_KB, SLASH_DATA);
    }

    public static String getKbScenarioUrl() {
        String scenarioUrl = JPSContext.getScenarioUrl();
        if (scenarioUrl == null) {
            throw new JPSRuntimeException("can't create a scenario kb url for the base scenario");
        }
        return BucketHelper.getScenarioUrl() + "/" + "kb";
    }

    public static boolean isScenarioUrl(String url) {
        return url.indexOf("/jps/scenario") >= 0;
    }

    public static boolean isBaseScenario(String url) {
        if (url == null) {
            return true;
        }
        String scenarioName = BucketHelper.getScenarioName(url);
        return "base".equals(scenarioName);
    }

    public static String getLocalDataPath() {
        String usecaseUrl = BucketHelper.getUsecaseUrlForData();
        return BucketHelper.getLocalPath(usecaseUrl, BucketHelper.getScenarioUrl());
    }

    public static String getLocalDataPathWithoutThreadContext() {
        String usecaseUrl = BucketHelper.getUsecaseUrl(BucketHelper.getScenarioUrl());
        usecaseUrl = usecaseUrl.replace(SLASH_KB, SLASH_DATA);
        return BucketHelper.getLocalPath(usecaseUrl, BucketHelper.getScenarioUrl());
    }

    public static String getLocalPath(String url) {
        String scenarioUrl = JPSContext.getScenarioUrl();
        return BucketHelper.getLocalPath(url, scenarioUrl);
    }

    public static String getLocalPath(String url, String datasetUrl) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        String mapped = "/" + BucketHelper.mapHost(uri);
        if (datasetUrl != null && !BucketHelper.isScenarioUrl(datasetUrl)) {
            int i = datasetUrl.indexOf("/jps/dataset");
            if (i >= 0) {
                String datasetName = datasetUrl.substring(1 + i + "/jps/dataset".length());
                String dir = ScenarioHelper.getJpsWorkingDir() + "/JPS_SCENARIO/dataset/" + datasetName;
                return dir + mapped + uri.getPath();
            }
            throw new JPSRuntimeException("unknown datasetUrl=" + datasetUrl + ", url=" + url);
        }
        String scenarioUrl = datasetUrl;
        if (scenarioUrl == null) {
            scenarioUrl = BucketHelper.getScenarioUrl("base");
        }
        System.out.println("THIS IS SCENARIO URL2= " + scenarioUrl);
        String scenarioName = BucketHelper.getScenarioName(scenarioUrl);
        System.out.println("THIS IS SCENARIO NAME2= " + scenarioName);
        String scenarioBucket = ScenarioHelper.getScenarioBucket(scenarioName);
        System.out.println("THIS IS SCENARIO BUCKET2= " + scenarioBucket);
        if (url.startsWith(scenarioBucket)) {
            return url;
        }
        String path = uri.getPath();
        if (path.startsWith("/jps/scenario")) {
            String relativePath = path.substring("/jps/scenario".length());
            System.out.println("THIS IS RELATIVE PATH**1= " + relativePath);
            int i = relativePath.indexOf(SLASH_DATA);
            if (i > 0) {
                relativePath = relativePath.replace(SLASH_DATA, mapped + SLASH_DATA);
                System.out.println("THIS IS RELATIVE PATH**2= " + relativePath);
            } else {
                i = relativePath.indexOf(SLASH_KB);
                if (i > 0) {
                    relativePath = relativePath.replace(SLASH_KB, mapped + SLASH_KB);
                    System.out.println("THIS IS RELATIVE PATH**3= " + relativePath);
                }
                System.out.println("THIS IS RELATIVE PATH**4= " + relativePath);
            }
            System.out.println("THIS IS RELATIVE PATH2= " + relativePath);
            return ScenarioHelper.getScenarioWorkingDir() + relativePath;
        }
        if ("base".equals(scenarioName) && !path.startsWith("/jps/") && (url.contains(SLASH_KB) || url.contains(SLASH_DATA))) {
            System.out.println("CALLING RESOURCE PATH CONVERTER " + url);
            return ResourcePathConverter.convertToLocalPath(url);
        }
        String relativePath = path;
        if (relativePath.startsWith("/jps/")) {
            relativePath = relativePath.substring(4);
        }
        System.out.println("FINAL RESPONSE PATH = " + scenarioBucket + mapped + relativePath);
        return scenarioBucket + mapped + relativePath;
    }

    private static String mapHost(URI uri) {
        String mapped = uri.getHost().replace(".", "_");
        int port = uri.getPort();
        if (port > 0) {
            mapped = mapped + "_" + port;
        }
        return mapped;
    }
}

