/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query.sparql;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.query.sparql.PrefixToUrlMap;

public class JenaModelWrapper {
    private OntModel model = null;
    private String iri = null;
    private String startSubject = null;

    public JenaModelWrapper(OntModel model, String iri) {
        this.model = model;
        this.iri = iri;
    }

    public OntModel getModel() {
        return this.model;
    }

    public RDFNode getPropertyValue(String startSubject, String ... path) {
        this.startSubject = startSubject;
        Individual currentSubject = this.model.getIndividual(startSubject);
        Property currentProp = null;
        RDFNode currentObject = null;
        int i = 0;
        while (i < path.length - 1) {
            List<RDFNode> objects;
            String prefix;
            String propAsString = JenaModelWrapper.concat(path[i], path[i + 1]);
            boolean noClassRestriction = true;
            String classAsString = null;
            if (i + 2 < path.length && (prefix = PrefixToUrlMap.getPrefixUrl(path[i + 2])) == null) {
                noClassRestriction = false;
                classAsString = path[i + 2];
            }
            if ((objects = this.listProperyValues(currentSubject, currentProp = this.model.getProperty(propAsString))).isEmpty()) {
                currentObject = null;
                break;
            }
            if (noClassRestriction) {
                currentObject = objects.get(0);
            } else {
                OntClass c = this.model.getOntClass(classAsString);
                for (RDFNode current : objects) {
                    if (!((OntResource)current).hasRDFType((Resource)c)) continue;
                    currentObject = current;
                    break;
                }
            }
            if (i < path.length - 2) {
                currentSubject = ((OntResource)currentObject).asIndividual();
            }
            if (noClassRestriction) {
                i += 2;
                continue;
            }
            i += 3;
        }
        return currentObject;
    }

    public RDFNode getPropertyValueWithoutType(String startSubject, String ... path) {
        this.startSubject = startSubject;
        Individual currentSubject = this.model.getIndividual(startSubject);
        Property currentProp = null;
        RDFNode currentObject = null;
        for (int i = 0; i < path.length; i += 2) {
            String propAsString = JenaModelWrapper.concat(path[i], path[i + 1]);
            currentProp = this.model.getProperty(propAsString);
            currentObject = currentSubject.getPropertyValue(currentProp);
            if (i >= path.length - 2) continue;
            currentSubject = ((OntResource)currentObject).asIndividual();
        }
        return currentObject;
    }

    public RDFNode setPropertyValue(String startSubject, Object destObject, String ... path) {
        this.startSubject = startSubject;
        Individual currentSubject = this.model.getIndividual(startSubject);
        ObjectProperty currentProp = null;
        int i = 0;
        while (i < path.length - 1) {
            RDFNode object;
            String prefix;
            String propAsString = JenaModelWrapper.concat(path[i], path[i + 1]);
            boolean noClassRestriction = true;
            String classAsString = null;
            if (i + 2 < path.length && (prefix = PrefixToUrlMap.getPrefixUrl(path[i + 2])) == null) {
                noClassRestriction = false;
                classAsString = path[i + 2];
            }
            boolean isObjectProp = true;
            currentProp = this.model.getObjectProperty(propAsString);
            if (currentProp == null) {
                currentProp = this.model.getDatatypeProperty(propAsString);
                isObjectProp = false;
            }
            if (currentProp == null) {
                throw new JPSRuntimeException("property not found, property = " + propAsString);
            }
            if (i < path.length - 2) {
                List<RDFNode> objects = this.listProperyValues(currentSubject, (Property)currentProp);
                if (!objects.isEmpty()) {
                    object = null;
                    if (noClassRestriction) {
                        object = objects.get(0);
                    } else {
                        OntClass c = this.model.getOntClass(classAsString);
                        for (RDFNode current : objects) {
                            if (!((OntResource)current).hasRDFType((Resource)c)) continue;
                            object = current;
                            break;
                        }
                    }
                    currentSubject = ((OntResource)object).asIndividual();
                } else {
                    RDFNode newObject = this.createObject(currentSubject, (Property)currentProp, i, path);
                    currentSubject.setPropertyValue((Property)currentProp, newObject);
                    currentSubject = ((OntResource)newObject).asIndividual();
                }
            } else {
                currentSubject.removeAll((Property)currentProp);
                if (isObjectProp) {
                    if (destObject instanceof Individual) {
                        currentSubject.setPropertyValue((Property)currentProp, (RDFNode)((Individual)destObject));
                    } else {
                        OntClass c = currentProp.getRange().asClass();
                        object = c.createIndividual((String)destObject);
                        currentSubject.setPropertyValue((Property)currentProp, object);
                    }
                } else {
                    Literal literal = this.model.createTypedLiteral(destObject);
                    currentSubject.setPropertyValue((Property)currentProp, (RDFNode)literal);
                }
            }
            if (noClassRestriction) {
                i += 2;
                continue;
            }
            i += 3;
        }
        return currentSubject.getPropertyValue(currentProp);
    }

    private List<RDFNode> listProperyValues(Individual subject, Property property) {
        ArrayList<RDFNode> result = new ArrayList<RDFNode>();
        NodeIterator it = subject.listPropertyValues(property);
        while (it.hasNext()) {
            RDFNode node = it.nextNode();
            result.add(node);
        }
        return result;
    }

    public RDFNode setPropertyValueWithoutTypes(String startSubject, Object destObject, String ... path) {
        this.startSubject = startSubject;
        Individual currentSubject = this.model.getIndividual(startSubject);
        ObjectProperty currentProp = null;
        for (int i = 0; i < path.length; i += 2) {
            String propAsString = JenaModelWrapper.concat(path[i], path[i + 1]);
            boolean isObjectProp = true;
            currentProp = this.model.getObjectProperty(propAsString);
            if (currentProp == null) {
                currentProp = this.model.getDatatypeProperty(propAsString);
                isObjectProp = false;
            }
            if (currentProp == null) {
                throw new JPSRuntimeException("property not found, property = " + propAsString);
            }
            if (i < path.length - 2) {
                RDFNode object = currentSubject.getPropertyValue((Property)currentProp);
                if (object != null) {
                    currentSubject = ((OntResource)object).asIndividual();
                    continue;
                }
                object = this.createObject(currentSubject, (Property)currentProp, i, path);
                currentSubject.setPropertyValue((Property)currentProp, object);
                currentSubject = ((OntResource)object).asIndividual();
                continue;
            }
            currentSubject.removeAll((Property)currentProp);
            if (isObjectProp) {
                if (destObject instanceof Individual) {
                    currentSubject.setPropertyValue((Property)currentProp, (RDFNode)((Individual)destObject));
                    continue;
                }
                OntClass c = currentProp.getRange().asClass();
                Individual object = c.createIndividual((String)destObject);
                currentSubject.setPropertyValue((Property)currentProp, (RDFNode)object);
                continue;
            }
            Literal literal = this.model.createTypedLiteral(destObject);
            currentSubject.setPropertyValue((Property)currentProp, (RDFNode)literal);
        }
        return currentSubject.getPropertyValue(currentProp);
    }

    private RDFNode createObject(Individual subject, Property prop, int position, String[] path) {
        OntResource range;
        if (position < path.length - 2 && "CLASS".equals(path[position + 2])) {
            String className = JenaModelWrapper.concat(path[position + 3], path[position + 4]);
            OntClass c = this.model.getOntClass(className);
            return c.createIndividual(this.newIri());
        }
        if (position < path.length - 2) {
            String propName = JenaModelWrapper.concat(path[position + 2], path[position + 3]);
            OntResource domain = null;
            ObjectProperty succProp = this.model.getObjectProperty(propName);
            if (succProp != null) {
                domain = succProp.getDomain();
            } else {
                DatatypeProperty succdProp = this.model.getDatatypeProperty(propName);
                domain = succdProp.getDomain();
            }
            if (domain != null) {
                OntClass c = domain.asClass();
                return c.createIndividual(this.newIri());
            }
        }
        if ((range = ((ObjectProperty)prop).getRange()) != null) {
            OntClass c = range.asClass();
            return c.createIndividual(this.newIri());
        }
        return null;
    }

    public static String concat(String prefix, String name) {
        return PrefixToUrlMap.getPrefixUrl(prefix) + name;
    }

    public Individual createIndividual(String prefix, String className) {
        String fullIri = JenaModelWrapper.concat(prefix, className);
        return this.model.getOntClass(fullIri).createIndividual();
    }

    private String newIri() {
        if (this.iri != null) {
            return JenaModelWrapper.newIri(this.iri);
        }
        return JenaModelWrapper.newIri(this.startSubject);
    }

    public static String newIri(String iri) {
        String path = "";
        int i = iri.indexOf("#");
        path = i > 0 ? iri.substring(0, i) + "#" : iri + "#";
        return path + UUID.randomUUID().toString();
    }

    public int removeSubtree(String startSubject, String ... path) {
        this.startSubject = startSubject;
        Individual nodeBeforeLast = null;
        if (path.length <= 2) {
            nodeBeforeLast = this.model.getIndividual(startSubject);
        } else {
            String[] pathMinusLast = new String[path.length - 2];
            for (int i = 0; i < pathMinusLast.length; ++i) {
                pathMinusLast[i] = path[i];
            }
            nodeBeforeLast = this.getPropertyValue(startSubject, pathMinusLast);
        }
        String lastPropName = JenaModelWrapper.concat(path[path.length - 2], path[path.length - 1]);
        Property lastProp = this.model.getProperty(lastPropName);
        String restrictedToPath = startSubject;
        int i = startSubject.lastIndexOf("#");
        if (i >= 0) {
            restrictedToPath = restrictedToPath.substring(0, i);
        }
        Resource lastNode = nodeBeforeLast.asResource().getPropertyResourceValue(lastProp);
        ArrayList<Resource> nodesForRemoval = new ArrayList<Resource>();
        this.removeSubtreeRecursively((RDFNode)lastNode, 20, restrictedToPath, nodesForRemoval);
        System.out.println("number of nodes for removal = " + nodesForRemoval.size());
        for (Resource current : nodesForRemoval) {
            current.removeProperties();
        }
        Statement statement = nodeBeforeLast.asResource().getProperty(lastProp);
        this.model.remove(statement);
        return nodesForRemoval.size();
    }

    private void removeSubtreeRecursively(RDFNode node, int counter, String restrictedToPath, List<Resource> nodesForRemoval) {
        if (counter < 1) {
            return;
        }
        if (node.isResource()) {
            Resource r = node.asResource();
            StmtIterator it = r.listProperties();
            while (it.hasNext()) {
                Statement statement = (Statement)it.next();
                RDFNode object = statement.getObject();
                if (!object.toString().startsWith(restrictedToPath)) continue;
                Property p = statement.getPredicate();
                if (nodesForRemoval.contains(object)) continue;
                this.removeSubtreeRecursively(object, counter - 1, restrictedToPath, nodesForRemoval);
            }
            nodesForRemoval.add(r);
        }
    }
}

