/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.derivation;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedAcyclicGraph;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.derivation.DerivationSparql;
import uk.ac.cam.cares.jps.base.discovery.AgentCaller;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class DerivationClient {
    public static final String AGENT_INPUT_KEY = "agent_input";
    public static final String AGENT_OUTPUT_KEY = "agent_output";
    public static final String DERIVATION_KEY = "derivation";
    StoreClientInterface kbClient;
    DerivationSparql sparqlClient;
    private static final Logger LOGGER = LogManager.getLogger(DerivationClient.class);

    public DerivationClient(StoreClientInterface kbClient) {
        this.kbClient = kbClient;
        this.sparqlClient = new DerivationSparql(kbClient);
    }

    public String createDerivation(List<String> entities, String agentIRI, String agentURL, List<String> inputsIRI) {
        String createdDerivation = this.sparqlClient.createDerivation(entities, agentIRI, agentURL, inputsIRI);
        this.sparqlClient.addTimeInstance(createdDerivation);
        LOGGER.info("Instantiated derivation with time series <" + createdDerivation + ">");
        LOGGER.debug("<" + entities + "> belongsTo <" + createdDerivation + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedFrom <" + inputsIRI + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedUsing <" + agentIRI + "> located at " + agentURL);
        return createdDerivation;
    }

    public List<String> bulkCreateDerivations(List<List<String>> entitiesList, List<String> agentIRIList, List<String> agentURLList, List<List<String>> inputsList) {
        List<String> derivations = this.sparqlClient.bulkCreateDerivations(entitiesList, agentIRIList, agentURLList, inputsList);
        LOGGER.info("Instantiated derivations " + derivations);
        this.sparqlClient.addTimeInstance(derivations);
        return derivations;
    }

    public String createDerivationWithTimeSeries(List<String> entities, String agentIRI, String agentURL, List<String> inputsIRI) {
        String createdDerivation = this.sparqlClient.createDerivationWithTimeSeries(entities, agentIRI, agentURL, inputsIRI);
        this.sparqlClient.addTimeInstance(createdDerivation);
        LOGGER.info("Instantiated derivation with time series <" + createdDerivation + ">");
        LOGGER.debug("<" + entities + "> belongsTo <" + createdDerivation + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedFrom <" + inputsIRI + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedUsing <" + agentIRI + "> located at " + agentURL);
        return createdDerivation;
    }

    public List<String> bulkCreateDerivationsWithTimeSeries(List<List<String>> entitiesList, List<String> agentIRIList, List<String> agentURLList, List<List<String>> inputsList) {
        List<String> derivations = this.sparqlClient.bulkCreateDerivationsWithTimeSeries(entitiesList, agentIRIList, agentURLList, inputsList);
        LOGGER.info("Instantiated derivations with time series " + derivations);
        this.sparqlClient.addTimeInstance(derivations);
        return derivations;
    }

    public void addTimeInstance(String entity) {
        this.sparqlClient.addTimeInstance(entity);
        LOGGER.info("Added timestamp to <" + entity + ">");
    }

    public void addTimeInstance(List<String> entities) {
        this.sparqlClient.addTimeInstance(entities);
        LOGGER.info("Added timestamps to <" + entities + ">");
    }

    public void removeTimeInstance(String entity) {
        this.sparqlClient.removeTimeInstance(entity);
        LOGGER.info("Removed timestamp for <" + entity + ">");
    }

    public void updateTimestamp(String entity) {
        if (this.sparqlClient.hasBelongsTo(entity)) {
            String derivation = this.getDerivationOf(entity);
            LOGGER.info("<" + entity + "> has a derivation instance attached, timestamp of the derivation will get updated");
            this.sparqlClient.updateTimeStamp(derivation);
            LOGGER.info("Updated timestamp of <" + derivation + ">");
        } else {
            this.sparqlClient.updateTimeStamp(entity);
            LOGGER.info("Updated timestamp of <" + entity + ">");
        }
    }

    public void updateDerivation(String derivedIRI) {
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph(DefaultEdge.class);
        try {
            this.updateDerivation(derivedIRI, (DirectedAcyclicGraph<String, DefaultEdge>)graph);
        }
        catch (Exception e) {
            LOGGER.fatal(e.getMessage());
            throw new JPSRuntimeException(e);
        }
    }

    public boolean validateDerivation(String derived) {
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph(DefaultEdge.class);
        try {
            this.validateDerivation(derived, (DirectedAcyclicGraph<String, DefaultEdge>)graph);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
            throw new JPSRuntimeException(e);
        }
    }

    public void dropAllDerivationsAndTimestamps() {
        List<String> inputs = this.sparqlClient.getInputsWithTimestamps();
        for (String input : inputs) {
            this.sparqlClient.removeTimeInstance(input);
        }
        this.sparqlClient.dropAllDerivations();
    }

    private void updateDerivation(String instance, DirectedAcyclicGraph<String, DefaultEdge> graph) {
        List<String> inputsAndDerived = this.sparqlClient.getInputsAndDerived(instance);
        if (!graph.containsVertex((Object)instance)) {
            graph.addVertex((Object)instance);
        }
        for (String input : inputsAndDerived) {
            if (!graph.containsVertex((Object)input)) {
                graph.addVertex((Object)input);
            }
            graph.addEdge((Object)instance, (Object)input);
            this.updateDerivation(input, graph);
        }
        List<String> inputs = this.sparqlClient.getInputs(instance);
        if (inputs.size() > 0 && this.isOutOfDate(instance, inputs)) {
            LOGGER.info("Updating <" + instance + ">");
            LOGGER.debug("<" + instance + "> is out-of-date when compared to <" + inputs + ">");
            String agentURL = this.sparqlClient.getAgentUrl(instance);
            JSONObject requestParams = new JSONObject();
            JSONArray iris = new JSONArray(inputs);
            requestParams.put(AGENT_INPUT_KEY, (Object)iris);
            requestParams.put(DERIVATION_KEY, (Object)instance);
            LOGGER.debug("Updating <" + instance + "> using agent at <" + agentURL + "> with http request " + requestParams);
            String response = AgentCaller.executeGetWithURLAndJSON(agentURL, requestParams.toString());
            LOGGER.debug("Obtained http response from agent: " + response);
            if (!this.sparqlClient.isDerivedWithTimeSeries(instance)) {
                List<String> newEntities = new JSONObject(response).getJSONArray(AGENT_OUTPUT_KEY).toList().stream().map(iri -> (String)iri).collect(Collectors.toList());
                List<String> entities = this.sparqlClient.getDerivedEntities(instance);
                List<List<String>> derivedAndType = this.sparqlClient.getIsDerivedFromEntities(entities);
                this.sparqlClient.deleteInstances(entities);
                LOGGER.debug("Deleted old instances: " + Arrays.asList(entities));
                this.sparqlClient.addNewEntitiesToDerived(instance, newEntities);
                LOGGER.debug("Added new instances <" + newEntities + "> to the derivation <" + instance + ">");
                if (derivedAndType.get(0).size() > 0) {
                    LOGGER.debug("This derivation contains at least one entity which is an input to another derivation");
                    LOGGER.debug("Relinking new instance(s) to the derivation by matching their rdf:type");
                    List<String> classOfNewEntities = this.sparqlClient.getInstanceClass(newEntities);
                    List<String> oldDerivedList = derivedAndType.get(0);
                    List<String> oldTypeList = derivedAndType.get(1);
                    for (int i = 0; i < oldDerivedList.size(); ++i) {
                        LOGGER.debug("Searching within <" + newEntities + "> with rdf:type <" + oldTypeList.get(i) + ">");
                        Integer matchingIndex = null;
                        for (int j = 0; j < classOfNewEntities.size(); ++j) {
                            if (!classOfNewEntities.get(j).contentEquals(oldTypeList.get(i))) continue;
                            if (matchingIndex != null) {
                                throw new JPSRuntimeException("Duplicate rdf:type found within output, the DerivationClient does not support this");
                            }
                            matchingIndex = j;
                        }
                        if (matchingIndex == null) {
                            String reconnectError = "Unable to find an instance with the same rdf:type to reconnect to " + oldDerivedList.get(i);
                            throw new JPSRuntimeException(reconnectError);
                        }
                        this.sparqlClient.reconnectInputToDerived(newEntities.get(matchingIndex), oldDerivedList.get(i));
                    }
                }
            }
            this.sparqlClient.updateTimeStamp(instance);
            LOGGER.info("Updated timestamp of <" + instance + ">");
        }
    }

    private void validateDerivation(String instance, DirectedAcyclicGraph<String, DefaultEdge> graph) {
        List<String> inputsAndDerived = this.sparqlClient.getInputsAndDerived(instance);
        if (!graph.containsVertex((Object)instance)) {
            graph.addVertex((Object)instance);
        }
        for (String input : inputsAndDerived) {
            if (!graph.containsVertex((Object)input)) {
                graph.addVertex((Object)input);
            }
            graph.addEdge((Object)instance, (Object)input);
            this.validateDerivation(input, graph);
        }
        List<String> inputs = this.sparqlClient.getInputs(instance);
        if (inputs.size() > 0) {
            this.sparqlClient.getTimestamp(instance);
            for (String input : inputs) {
                this.sparqlClient.getTimestamp(input);
            }
        }
    }

    private boolean isOutOfDate(String instance, List<String> inputs) {
        boolean outOfDate = false;
        long instanceTimestamp = this.sparqlClient.getTimestamp(instance);
        for (String input : inputs) {
            long inputTimestamp = this.sparqlClient.getTimestamp(input);
            if (inputTimestamp <= instanceTimestamp) continue;
            outOfDate = true;
            return outOfDate;
        }
        return outOfDate;
    }

    public String getDerivationOf(String entity) {
        return this.sparqlClient.getDerivedIRI(entity);
    }
}

