/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.managers.helpers;

import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.openrdf.sail.rdbms.schema.Batch;

public class BatchBlockingQueue
extends AbstractQueue<Batch>
implements BlockingQueue<Batch> {
    private LinkedHashSet<Batch> queue;
    private int capacity;
    private int size;

    public BatchBlockingQueue(int capacity) {
        this.queue = new LinkedHashSet(capacity / 16);
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        LinkedHashSet<Batch> linkedHashSet = this.queue;
        synchronized (linkedHashSet) {
            if (this.queue.remove(o)) {
                this.size -= ((Batch)o).size();
                this.queue.notify();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Batch> iterator() {
        LinkedHashSet<Batch> linkedHashSet = this.queue;
        synchronized (linkedHashSet) {
            Batch[] array = this.queue.toArray(new Batch[this.queue.size()]);
            return Arrays.asList(array).iterator();
        }
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(Batch e) {
        LinkedHashSet<Batch> linkedHashSet = this.queue;
        synchronized (linkedHashSet) {
            boolean added = this.queue.add(e);
            this.size += e.size();
            this.queue.notify();
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Batch peek() {
        LinkedHashSet<Batch> linkedHashSet = this.queue;
        synchronized (linkedHashSet) {
            return (Batch)this.queue.iterator().next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Batch poll() {
        LinkedHashSet<Batch> linkedHashSet = this.queue;
        synchronized (linkedHashSet) {
            Iterator iter = this.queue.iterator();
            if (iter.hasNext()) {
                Batch e = (Batch)iter.next();
                iter.remove();
                this.size -= e.size();
                this.queue.notify();
                return e;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super Batch> c) {
        LinkedHashSet<Batch> linkedHashSet = this.queue;
        synchronized (linkedHashSet) {
            return this.drainTo(c, this.queue.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super Batch> c, int n) {
        LinkedHashSet<Batch> linkedHashSet = this.queue;
        synchronized (linkedHashSet) {
            int i;
            Iterator iter = this.queue.iterator();
            for (i = 0; i < n && iter.hasNext(); ++i) {
                Batch next = (Batch)iter.next();
                c.add(next);
                iter.remove();
                this.size -= next.size();
                this.queue.notify();
            }
            return i;
        }
    }

    @Override
    public boolean offer(Batch e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    @Override
    public Batch poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Batch e) throws InterruptedException {
        LinkedHashSet<Batch> linkedHashSet = this.queue;
        synchronized (linkedHashSet) {
            while (this.size >= this.capacity) {
                this.queue.wait();
            }
            this.queue.add(e);
            this.size += e.size();
            this.queue.notify();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Batch take() throws InterruptedException {
        LinkedHashSet<Batch> linkedHashSet = this.queue;
        synchronized (linkedHashSet) {
            while (this.queue.isEmpty()) {
                this.queue.wait();
            }
            Iterator iter = this.queue.iterator();
            Batch e = (Batch)iter.next();
            iter.remove();
            this.size -= e.size();
            this.queue.notify();
            return e;
        }
    }
}

