/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.httpd;

import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;

public class HTTPHeaderUtility {
    protected static final Logger log = Logger.getLogger(HTTPHeaderUtility.class);
    protected static final String httpTokenPattern = "[^\\p{Cntrl}\\(\\)<>@,;:\\\\\\\"/\\[\\]\\?=\\{\\}\\s\\x09]+";
    protected static final String httpQuotedStringPattern = "\\\"(?:\\\\\"|[^\\p{Cntrl}\\\"])*\\\"";
    protected static final String tok = "[^\\p{Cntrl}\\(\\)<>@,;:\\\\\\\"/\\[\\]\\?=\\{\\}\\s\\x09]+";
    protected static final String qs = "\\\"(?:\\\\\"|[^\\p{Cntrl}\\\"])*\\\"";
    protected static Pattern m_p1 = null;
    protected static Pattern m_p2 = null;

    public static boolean isHttpCtlChar(char ch) {
        char c = ch;
        if (c >= '\u0000' && c <= '\u001f') {
            return true;
        }
        return c == '\u007f';
    }

    public static boolean isHttpSeparatorChar(char ch) {
        switch (ch) {
            case '\t': 
            case ' ': 
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    public static boolean isHttpToken(String token) {
        int len = token.length();
        for (int i = 0; i < len; ++i) {
            char ch = token.charAt(i);
            if (!HTTPHeaderUtility.isHttpCtlChar(ch) && !HTTPHeaderUtility.isHttpSeparatorChar(ch)) continue;
            return false;
        }
        return true;
    }

    protected static void init() {
        try {
            if (m_p1 != null && m_p2 != null) {
                return;
            }
            m_p1 = Pattern.compile("^([^\\p{Cntrl}\\(\\)<>@,;:\\\\\\\"/\\[\\]\\?=\\{\\}\\s\\x09]+)/([^\\p{Cntrl}\\(\\)<>@,;:\\\\\\\"/\\[\\]\\?=\\{\\}\\s\\x09]+)(.*)$");
            m_p2 = Pattern.compile("\\s*;\\s*([^\\p{Cntrl}\\(\\)<>@,;:\\\\\\\"/\\[\\]\\?=\\{\\}\\s\\x09]+)=([^\\p{Cntrl}\\(\\)<>@,;:\\\\\\\"/\\[\\]\\?=\\{\\}\\s\\x09]+|\\\"(?:\\\\\"|[^\\p{Cntrl}\\\"])*\\\")\\s*");
        }
        catch (PatternSyntaxException ex) {
            AssertionError err = new AssertionError((Object)"Could not compile regex patterns.");
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
    }

    public static String quoteString(String value, boolean force) {
        StringBuffer sb = new StringBuffer();
        int len = value.length();
        boolean didEscape = false;
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (HTTPHeaderUtility.isHttpCtlChar(ch) || HTTPHeaderUtility.isHttpSeparatorChar(ch)) {
                sb.append('\\');
                didEscape = true;
            }
            sb.append(ch);
        }
        return didEscape || force ? "\"" + sb.toString() + "\"" : sb.toString();
    }

    public static String unquoteString(String value) throws IllegalArgumentException {
        String originalValue = value;
        if (!value.startsWith("\"")) {
            return value;
        }
        if (!value.endsWith("\"")) {
            throw new IllegalArgumentException("Quoted string does not end with '\"' : " + originalValue);
        }
        value = value.substring(1, value.length() - 1);
        StringBuffer sb = new StringBuffer();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch == '\\') {
                if (++i < len) {
                    ch = value.charAt(i);
                    sb.append(ch);
                    continue;
                }
                throw new IllegalArgumentException("Escape character at end of string : " + originalValue);
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String combineHeaders(Enumeration values, String defaultValue) {
        if (!values.hasMoreElements()) {
            return defaultValue;
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        while (values.hasMoreElements()) {
            String value = (String)values.nextElement();
            if (!first) {
                sb.append(", ");
            }
            sb.append(value);
            first = false;
        }
        return sb.toString();
    }

    public static String[] splitCommaList(String value) {
        log.debug((Object)("Header-Value: " + value));
        String[] values = value.split("\\s*,\\s*");
        log.debug((Object)("Found " + values.length + " elements in list."));
        return values;
    }
}

