/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore;

import com.bigdata.io.IBufferAccess;
import com.bigdata.io.IReopenChannel;
import com.bigdata.io.writecache.IBackingReader;
import com.bigdata.io.writecache.WriteCache;
import com.bigdata.io.writecache.WriteCacheService;
import com.bigdata.quorum.Quorum;
import com.bigdata.rwstore.IWriteCacheManager;
import java.io.IOException;
import java.nio.channels.Channel;
import org.apache.log4j.Logger;

public class RWWriteCacheService
extends WriteCacheService
implements IWriteCacheManager {
    protected static final Logger log = Logger.getLogger(RWWriteCacheService.class);

    public RWWriteCacheService(int nbuffers, int minCleanListSize, int readBuffers, boolean prefixWrites, int compactionThreshold, int hotCacheSize, int hotCacheThreshold, long fileExtent, IReopenChannel<? extends Channel> opener, Quorum quorum, IBackingReader reader) throws InterruptedException, IOException {
        super(nbuffers, minCleanListSize, readBuffers, prefixWrites, compactionThreshold, hotCacheSize, hotCacheThreshold, true, fileExtent, opener, quorum, reader);
    }

    @Override
    protected final boolean canCompact() {
        return true;
    }

    @Override
    public WriteCache newWriteCache(IBufferAccess buf, boolean useChecksum, boolean bufferHasData, IReopenChannel<? extends Channel> opener, long fileExtent) throws InterruptedException {
        boolean highlyAvailable = this.getQuorum() != null;
        return new WriteCache.FileChannelScatteredWriteCache(buf, true, highlyAvailable, bufferHasData, opener, fileExtent, null);
    }

    @Override
    public boolean removeWriteToAddr(long address, int latchedAddr) {
        return this.clearWrite(address, latchedAddr);
    }
}

