/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.io.SerializerUtil;
import com.bigdata.mdi.JournalMetadata;
import com.bigdata.rawstore.IRawStore;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;

public class JournalIndex
extends BTree {
    private final IKeyBuilder keyBuilder = new KeyBuilder(8);

    public static JournalIndex createTransient() {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        metadata.setBTreeClassName(JournalIndex.class.getName());
        metadata.setTupleSerializer(new TupleSerializer(new ASCIIKeyBuilderFactory(8)));
        return (JournalIndex)BTree.createTransient(metadata);
    }

    public JournalIndex(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
        super(store, checkpoint, metadata, readOnly);
    }

    private byte[] getKey(long commitTime) {
        return this.keyBuilder.reset().append(commitTime).getKey();
    }

    public synchronized JournalMetadata find(long timestamp) {
        if (timestamp <= 0L) {
            throw new IllegalArgumentException();
        }
        long index = this.findIndexOf(timestamp);
        if (index == -1L) {
            log.warn((Object)("Not found: " + timestamp));
            return null;
        }
        return this.valueAtIndex(index);
    }

    private JournalMetadata valueAtIndex(long index) {
        byte[] val = super.valueAt(index);
        assert (val != null) : "Entry has null value: index=" + index;
        JournalMetadata entry = (JournalMetadata)SerializerUtil.deserialize(val);
        return entry;
    }

    public synchronized JournalMetadata findNext(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException();
        }
        long index = this.findIndexOf(Math.abs(timestamp)) + 1L;
        if (index == this.nentries) {
            return null;
        }
        return this.valueAtIndex(index);
    }

    public synchronized long findIndexOf(long timestamp) {
        long pos = super.indexOf(this.getKey(timestamp));
        if (pos < 0L) {
            if ((pos = -(pos + 1L)) == 0L) {
                return -1L;
            }
            return --pos;
        }
        return pos;
    }

    public synchronized void add(JournalMetadata resourceMetadata) {
        if (resourceMetadata == null) {
            throw new IllegalArgumentException();
        }
        assert (resourceMetadata.isJournal());
        long createTime = resourceMetadata.getCreateTime();
        if (createTime == 0L) {
            throw new IllegalArgumentException();
        }
        byte[] key = this.getKey(createTime);
        if (super.contains(key)) {
            throw new IllegalArgumentException("entry exists: timestamp=" + createTime);
        }
        super.insert(key, SerializerUtil.serialize(resourceMetadata));
    }

    protected static class TupleSerializer
    extends DefaultTupleSerializer<Long, JournalMetadata> {
        private static final long serialVersionUID = -2851852959439807542L;
        private static final transient byte VERSION0 = 0;
        private static final transient byte VERSION = 0;

        public TupleSerializer() {
        }

        public TupleSerializer(IKeyBuilderFactory keyBuilderFactory) {
            super(keyBuilderFactory);
        }

        @Override
        public Long deserializeKey(ITuple tuple) {
            byte[] key = tuple.getKeyBuffer().array();
            long id = KeyBuilder.decodeLong(key, 0);
            return id;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            byte version = in.readByte();
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown version: " + version);
                }
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeByte(0);
        }
    }
}

