/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval;

import com.bigdata.journal.IIndexManager;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.FlushBufferTask;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.rule.IProgram;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.eval.AbstractStepTask;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.IStepTask;
import com.bigdata.relation.rule.eval.RuleLog;
import com.bigdata.relation.rule.eval.RuleStats;
import com.bigdata.relation.rule.eval.RunRuleAndFlushBufferTask;
import com.bigdata.service.DataService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class MutationTask
extends AbstractStepTask {
    private static final long serialVersionUID = 6503299789509746764L;

    protected MutationTask(ActionEnum action, IJoinNexusFactory joinNexusFactory, IStep step, IIndexManager indexManager, DataService dataService) {
        super(action, joinNexusFactory, step, indexManager, dataService);
    }

    @Override
    public RuleStats call() throws Exception {
        RuleStats totals;
        IJoinNexus joinNexus = this.joinNexusFactory.newInstance(this.indexManager);
        Map<String, IRelation> relations = this.getWriteRelations(this.indexManager, this.step, joinNexus.getWriteTimestamp());
        assert (!relations.isEmpty());
        Map<String, IBuffer<ISolution[]>> buffers = this.getMutationBuffers(joinNexus, relations);
        assert (!buffers.isEmpty());
        List<Callable<RuleStats>> tasks = this.newMutationTasks(this.step, joinNexus, buffers);
        assert (!tasks.isEmpty());
        if (tasks.size() == 1) {
            totals = this.runOne(joinNexus, this.step, tasks.get(0));
        } else if (!joinNexus.forceSerialExecution() && !this.step.isRule() && ((IProgram)this.step).isParallel()) {
            totals = this.runParallel(joinNexus, this.step, tasks);
            this.flushBuffers(joinNexus, buffers);
        } else {
            totals = this.runSequential(joinNexus, this.step, tasks);
        }
        this.getMutationCountFromBuffers(totals, buffers);
        RuleLog.log(totals);
        return totals;
    }

    protected void flushBuffers(IJoinNexus joinNexus, Map<String, IBuffer<ISolution[]>> buffers) throws InterruptedException, ExecutionException {
        if (joinNexus == null) {
            throw new IllegalArgumentException();
        }
        if (buffers == null) {
            throw new IllegalArgumentException();
        }
        int n = buffers.size();
        if (n == 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)"No buffers.");
            }
            return;
        }
        if (n == 1) {
            IBuffer<ISolution[]> buffer = buffers.values().iterator().next();
            if (log.isInfoEnabled()) {
                log.info((Object)("Flushing one buffer: size=" + buffer.size()));
            }
            buffer.flush();
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Flushing " + n + " buffers."));
            }
            ArrayList<FlushBufferTask> tasks = new ArrayList<FlushBufferTask>(n);
            for (IBuffer<ISolution[]> buffer : buffers.values()) {
                tasks.add(new FlushBufferTask(buffer));
            }
            List futures = this.indexManager.getExecutorService().invokeAll(tasks);
            for (Future f : futures) {
                f.get();
            }
        }
    }

    protected long getMutationCountFromBuffers(RuleStats totals, Map<String, IBuffer<ISolution[]>> buffers) {
        if (totals == null) {
            throw new IllegalArgumentException();
        }
        if (buffers == null) {
            throw new IllegalArgumentException();
        }
        long mutationCount = 0L;
        for (IBuffer<ISolution[]> buffer : buffers.values()) {
            mutationCount += buffer.flush();
        }
        totals.mutationCount.compareAndSet(0L, mutationCount);
        return mutationCount;
    }

    protected List<Callable<RuleStats>> newMutationTasks(IStep step, IJoinNexus joinNexus, Map<String, IBuffer<ISolution[]>> buffers) {
        ArrayList<Callable<RuleStats>> tasks;
        if (log.isDebugEnabled()) {
            log.debug((Object)("program=" + step.getName()));
        }
        if (step.isRule()) {
            if (step.isRule() && ((IRule)step).getHead() == null) {
                throw new IllegalArgumentException("No head for this rule: " + step);
            }
            tasks = new ArrayList<Callable<RuleStats>>(1);
            IRule rule = (IRule)step;
            IBuffer<ISolution[]> buffer = buffers.get(rule.getHead().getOnlyRelationName());
            IStepTask task = joinNexus.getRuleTaskFactory(false, rule).newTask(rule, joinNexus, buffer);
            tasks.add(task);
        } else {
            IProgram program = (IProgram)step;
            boolean parallel = program.isParallel();
            tasks = new ArrayList(program.stepCount());
            Iterator<IStep> itr = program.steps();
            while (itr.hasNext()) {
                IRule rule = (IRule)itr.next();
                if (rule.getHead() == null) {
                    throw new IllegalArgumentException("No head for this rule: " + rule);
                }
                IBuffer<ISolution[]> buffer = buffers.get(rule.getHead().getOnlyRelationName());
                IStepTask task = joinNexus.getRuleTaskFactory(parallel, rule).newTask(rule, joinNexus, buffer);
                if (!parallel || joinNexus.forceSerialExecution()) {
                    tasks.add(new RunRuleAndFlushBufferTask(task, buffer));
                    continue;
                }
                tasks.add(task);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + tasks.size() + " mutation tasks: action=" + (Object)((Object)this.action)));
        }
        return tasks;
    }
}

