/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval;

import com.bigdata.journal.IIndexManager;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IRuleTaskFactory;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.IStepTask;
import com.bigdata.relation.rule.eval.pipeline.DistributedJoinMasterTask;
import com.bigdata.relation.rule.eval.pipeline.LocalJoinMasterTask;
import com.bigdata.service.IBigdataFederation;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.log4j.Logger;

public class DefaultRuleTaskFactory
implements IRuleTaskFactory,
Externalizable {
    protected static final Logger log = Logger.getLogger(DefaultRuleTaskFactory.class);
    private static final long serialVersionUID = -6751546625682021618L;
    public static final transient IRuleTaskFactory PIPELINE = new DefaultRuleTaskFactory(false);
    private boolean subquery;
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    public DefaultRuleTaskFactory() {
    }

    public DefaultRuleTaskFactory(boolean subquery) {
        this.subquery = subquery;
    }

    @Override
    public IStepTask newTask(IRule rule, IJoinNexus joinNexus, IBuffer<ISolution[]> buffer) {
        IIndexManager indexManager = joinNexus.getIndexManager();
        if (indexManager instanceof IBigdataFederation) {
            IBigdataFederation fed = (IBigdataFederation)indexManager;
            if (fed.isScaleOut()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("scale-out pipeline joins: indexManager=" + indexManager.getClass() + ", rule=" + rule));
                }
                return new DistributedJoinMasterTask(rule, joinNexus, buffer);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("local pipeline joins: indexManager=" + indexManager.getClass() + ", rule=" + rule));
            }
            return new LocalJoinMasterTask(rule, joinNexus, buffer);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("local pipeline joins: indexManager=" + indexManager.getClass() + ", rule=" + rule));
        }
        return new LocalJoinMasterTask(rule, joinNexus, buffer);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
        this.subquery = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeBoolean(this.subquery);
    }
}

