/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.optimizers.ASTTypeBasedNodeClassifierConstraint;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class ASTTypeBasedNodeClassifier {
    Class<?>[] clazzez;
    Map<Class<?>, ASTTypeBasedNodeClassifierConstraint> clazzConstraints;
    List<IGroupMemberNode> unclassifiedNodes;
    Map<Class<?>, List<IGroupMemberNode>> classifiedNodes;

    public ASTTypeBasedNodeClassifier(Class<?>[] clazzez) {
        this.clazzez = clazzez;
        this.unclassifiedNodes = new LinkedList<IGroupMemberNode>();
        this.classifiedNodes = new HashMap();
        this.clazzConstraints = new HashMap();
    }

    public ASTTypeBasedNodeClassifier(Class<?>[] clazzez, List<IGroupMemberNode> nodeList) {
        this(clazzez);
        this.registerNodes(nodeList);
    }

    public void registerNodes(Iterable<IGroupMemberNode> nodeList) {
        for (Class<?> clazz : this.clazzez) {
            this.classifiedNodes.put(clazz, new LinkedList());
        }
        for (IGroupMemberNode node : nodeList) {
            boolean classified = false;
            for (int i = 0; i < this.clazzez.length && !classified; ++i) {
                ASTTypeBasedNodeClassifierConstraint constraint;
                Class<?> clazz = this.clazzez[i];
                if (!clazz.isInstance(node) || (constraint = this.clazzConstraints.get(clazz)) != null && !constraint.appliesTo(node)) continue;
                this.classifiedNodes.get(clazz).add(node);
                classified = true;
            }
            if (classified) continue;
            this.unclassifiedNodes.add(node);
        }
    }

    public List<IGroupMemberNode> getUnclassifiedNodes() {
        return this.unclassifiedNodes;
    }

    public <T> List<T> get(Class<T> clazz) {
        return this.classifiedNodes.get(clazz);
    }

    public void addConstraintForType(Class<?> clazz, ASTTypeBasedNodeClassifierConstraint c) {
        this.clazzConstraints.put(clazz, c);
    }
}

