/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.ASTUtil;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryBase;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import cutthecrap.utils.striterators.Striterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ASTNamedSubqueryOptimizer
implements IASTOptimizer {
    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSet = input.getBindingSets();
        QueryRoot queryRoot = (QueryRoot)queryNode;
        NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
        if (namedSubqueries == null || namedSubqueries.isEmpty()) {
            return new QueryNodeWithBindingSet(queryRoot, bindingSet);
        }
        ASTNamedSubqueryOptimizer.orderNamedSubqueries(queryRoot, namedSubqueries);
        NamedSubqueryInclude[] allIncludes = ASTNamedSubqueryOptimizer.findAllIncludes(queryRoot);
        ASTNamedSubqueryOptimizer.assertNamedSubqueryForEachInclude(namedSubqueries, allIncludes);
        ASTNamedSubqueryOptimizer.assertEachNamedSubqueryIsUsed(namedSubqueries, allIncludes);
        ASTNamedSubqueryOptimizer.assignJoinVars(queryRoot, context, namedSubqueries, allIncludes);
        return new QueryNodeWithBindingSet(queryRoot, bindingSet);
    }

    private static NamedSubqueryInclude[] findAllIncludes(QueryRoot queryRoot) {
        Striterator itr = new Striterator(BOpUtility.postOrderIterator(queryRoot.getWhereClause()));
        itr.addTypeFilter(NamedSubqueryInclude.class);
        LinkedList<NamedSubqueryInclude> list = new LinkedList<NamedSubqueryInclude>();
        while (itr.hasNext()) {
            list.add((NamedSubqueryInclude)itr.next());
        }
        Striterator itr2 = new Striterator(BOpUtility.postOrderIterator(queryRoot.getWhereClause()));
        itr2.addTypeFilter(SubqueryRoot.class);
        while (itr2.hasNext()) {
            list.addAll(ASTNamedSubqueryOptimizer.findSubqueryIncludes((SubqueryRoot)itr2.next()));
        }
        if (queryRoot.getNamedSubqueries() != null) {
            for (NamedSubqueryRoot root : queryRoot.getNamedSubqueries()) {
                list.addAll(ASTNamedSubqueryOptimizer.findSubqueryIncludes(root));
            }
        }
        return list.toArray(new NamedSubqueryInclude[0]);
    }

    private static List<NamedSubqueryInclude> findSubqueryIncludes(SubqueryBase queryRoot) {
        Striterator itr = new Striterator(BOpUtility.postOrderIterator(queryRoot.getWhereClause()));
        itr.addTypeFilter(NamedSubqueryInclude.class);
        LinkedList<NamedSubqueryInclude> list = new LinkedList<NamedSubqueryInclude>();
        while (itr.hasNext()) {
            list.add((NamedSubqueryInclude)itr.next());
        }
        Striterator itr2 = new Striterator(BOpUtility.postOrderIterator(queryRoot.getWhereClause()));
        itr2.addTypeFilter(SubqueryRoot.class);
        while (itr2.hasNext()) {
            list.addAll(ASTNamedSubqueryOptimizer.findSubqueryIncludes((SubqueryRoot)itr2.next()));
        }
        return list;
    }

    private static void assertNamedSubqueryForEachInclude(NamedSubqueriesNode namedSubqueries, NamedSubqueryInclude[] allIncludes) {
        for (NamedSubqueryInclude anInclude : allIncludes) {
            String namedSet = anInclude.getName();
            if (namedSet == null || namedSet.trim().length() == 0) {
                throw new RuntimeException("Missing or illegal name for include.");
            }
            boolean found = false;
            for (NamedSubqueryRoot aNamedSubquery : namedSubqueries) {
                if (!aNamedSubquery.getName().equals(namedSet)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("No subquery produces that solution set: " + namedSet);
        }
    }

    private static void assertEachNamedSubqueryIsUsed(NamedSubqueriesNode namedSubqueries, NamedSubqueryInclude[] allIncludes) {
        LinkedHashSet<String> namedSets = new LinkedHashSet<String>();
        for (NamedSubqueryRoot aNamedSubquery : namedSubqueries) {
            String namedSet = aNamedSubquery.getName();
            if (!namedSets.add(namedSet)) {
                throw new RuntimeException("NamedSet declared more than once: " + namedSet);
            }
            if (namedSet == null || namedSet.trim().length() == 0) {
                throw new RuntimeException("Missing or illegal name for named subquery.");
            }
            LinkedList<NamedSubqueryInclude> includes = new LinkedList<NamedSubqueryInclude>();
            for (NamedSubqueryInclude anInclude : allIncludes) {
                if (!namedSet.equals(anInclude.getName())) continue;
                includes.add(anInclude);
            }
            if (!includes.isEmpty()) continue;
            throw new RuntimeException("Named subquery results are not used by this query: " + namedSet);
        }
    }

    private static void assignJoinVars(QueryRoot queryRoot, AST2BOpContext context, NamedSubqueriesNode namedSubqueries, NamedSubqueryInclude[] allIncludes) {
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        for (NamedSubqueryRoot aNamedSubquery : namedSubqueries) {
            String namedSet = aNamedSubquery.getName();
            LinkedList<NamedSubqueryInclude> includes = new LinkedList<NamedSubqueryInclude>();
            for (NamedSubqueryInclude anInclude : allIncludes) {
                if (!namedSet.equals(anInclude.getName())) continue;
                includes.add(anInclude);
            }
            LinkedHashSet<JoinVars> distinctJoinVarsSet = new LinkedHashSet<JoinVars>();
            for (NamedSubqueryInclude anInclude : includes) {
                Object[] joinvars;
                if (anInclude.getJoinVars() == null) {
                    LinkedHashSet set = new LinkedHashSet();
                    sa.getJoinVars(aNamedSubquery, anInclude, set);
                    joinvars = set.toArray(new IVariable[set.size()]);
                    Arrays.sort(joinvars);
                    anInclude.setJoinVars(ASTUtil.convert((IVariable[])joinvars));
                } else {
                    joinvars = ASTUtil.convert(anInclude.getJoinVars());
                    Arrays.sort(joinvars);
                    anInclude.setJoinVars(ASTUtil.convert((IVariable[])joinvars));
                }
                distinctJoinVarsSet.add(new JoinVars((IVariable<?>[])joinvars));
            }
            int nhashIndices = distinctJoinVarsSet.size();
            if (nhashIndices > 1) {
                LinkedHashSet sharedVariables = new LinkedHashSet();
                for (JoinVars joinVars : distinctJoinVarsSet) {
                    sharedVariables.addAll(joinVars.vars());
                }
                for (JoinVars joinVars : distinctJoinVarsSet) {
                    sharedVariables.retainAll(joinVars.vars());
                }
                VarNode[] sharedJoinVars = ASTUtil.convert(sharedVariables.toArray(new IVariable[0]));
                aNamedSubquery.setJoinVars(sharedJoinVars);
                for (NamedSubqueryInclude anInclude : includes) {
                    anInclude.setJoinVars(sharedJoinVars);
                }
                continue;
            }
            JoinVars joinVars = (JoinVars)distinctJoinVarsSet.iterator().next();
            aNamedSubquery.setJoinVars(ASTUtil.convert(joinVars.toArray()));
        }
    }

    private static void orderNamedSubqueries(QueryRoot queryRoot, NamedSubqueriesNode namedSubqueries) {
        LinkedHashMap<String, NamedSubqueryRoot> nameToSubquery = new LinkedHashMap<String, NamedSubqueryRoot>();
        for (NamedSubqueryRoot aNamedSubquery : namedSubqueries) {
            nameToSubquery.put(aNamedSubquery.getName(), aNamedSubquery);
        }
        LinkedHashMap subqueryToIncludes = new LinkedHashMap();
        for (NamedSubqueryRoot aNamedSubquery : namedSubqueries) {
            LinkedList<String> includes = new LinkedList<String>();
            subqueryToIncludes.put(aNamedSubquery, includes);
            for (NamedSubqueryInclude include : ASTNamedSubqueryOptimizer.findSubqueryIncludes(aNamedSubquery)) {
                includes.add(include.getName());
            }
            aNamedSubquery.setDependsOn(includes.toArray(new String[0]));
        }
        HashSet<String> processed = new HashSet<String>();
        NamedSubqueriesNode newNode = new NamedSubqueriesNode();
        Iterator iter = subqueryToIncludes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            NamedSubqueryRoot namedSubquery = (NamedSubqueryRoot)entry.getKey();
            if (((List)entry.getValue()).size() != 0) continue;
            newNode.add(namedSubquery);
            processed.add(namedSubquery.getName());
            iter.remove();
        }
        while (subqueryToIncludes.size() > 0) {
            iter = subqueryToIncludes.entrySet().iterator();
            while (iter.hasNext()) {
                boolean ok = true;
                Map.Entry entry = iter.next();
                for (String dep : (List)entry.getValue()) {
                    if (processed.contains(dep)) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                newNode.add((IQueryNode)entry.getKey());
                processed.add(((NamedSubqueryRoot)entry.getKey()).getName());
                iter.remove();
            }
        }
        queryRoot.setNamedSubqueries(newNode);
    }

    private static class JoinVars {
        private final Set<IVariable<?>> vars = new LinkedHashSet();
        private final int hashCode;

        public Set<IVariable<?>> vars() {
            return Collections.unmodifiableSet(this.vars);
        }

        public IVariable<?>[] toArray() {
            return this.vars.toArray(new IVariable[this.vars.size()]);
        }

        public JoinVars(IVariable<?>[] vars) {
            for (int i = 0; i < vars.length; ++i) {
                this.vars.add(vars[i]);
            }
            this.hashCode = Arrays.hashCode(vars);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JoinVars)) {
                return false;
            }
            JoinVars t = (JoinVars)o;
            return this.vars.equals(t.vars);
        }
    }
}

