/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.GroupNodeVarBindingInfo;
import com.bigdata.rdf.sparql.ast.GroupNodeVarBindingInfoMap;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.explainhints.JoinOrderExplainHint;
import com.bigdata.rdf.sparql.ast.optimizers.ASTFilterPlacer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTJoinGroupFilterExistsInfo;
import com.bigdata.rdf.sparql.ast.optimizers.ASTJoinGroupPartition;
import com.bigdata.rdf.sparql.ast.optimizers.ASTJoinGroupPartitions;
import com.bigdata.rdf.sparql.ast.optimizers.ASTStaticJoinOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTTypeBasedNodeClassifier;
import com.bigdata.rdf.sparql.ast.optimizers.ASTTypeBasedNodeClassifierConstraint;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.TypeBasedASTJoinGroupPartitionReorderer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ASTJoinGroupOrderOptimizer
extends AbstractJoinGroupOptimizer
implements IASTOptimizer {
    private final boolean assertCorrectnessOnly;

    public ASTJoinGroupOrderOptimizer() {
        this(false);
    }

    public ASTJoinGroupOrderOptimizer(boolean assertCorrectnessOnly) {
        this.assertCorrectnessOnly = assertCorrectnessOnly;
    }

    @Override
    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode joinGroup) {
        boolean reorderNodes = ASTStaticJoinOptimizer.isStaticOptimizer(ctx, joinGroup);
        Set<IVariable<?>> externallyIncoming = sa.getDefinitelyIncomingBindings(joinGroup, new HashSet());
        ASTJoinGroupFilterExistsInfo fExInfo = new ASTJoinGroupFilterExistsInfo(joinGroup);
        GroupNodeVarBindingInfoMap bindingInfoMap = new GroupNodeVarBindingInfoMap(joinGroup, sa, fExInfo);
        ASTFilterPlacer filterPlacer = new ASTFilterPlacer(joinGroup, fExInfo);
        ASTJoinGroupPartitions partitions = new ASTJoinGroupPartitions(filterPlacer.getNonFilterNodes(), bindingInfoMap, externallyIncoming);
        if (reorderNodes && !this.assertCorrectnessOnly) {
            this.optimizeAcrossPartitions(joinGroup, partitions, bindingInfoMap, externallyIncoming);
        }
        if (reorderNodes) {
            this.optimizeWithinPartitions(partitions, bindingInfoMap, this.assertCorrectnessOnly);
        }
        filterPlacer.placeFiltersInPartitions(partitions);
        LinkedList<IGroupMemberNode> nodeList = partitions.extractNodeList(true);
        for (int i = 0; i < joinGroup.arity(); ++i) {
            joinGroup.setArg(i, nodeList.get(i));
        }
    }

    void optimizeAcrossPartitions(JoinGroupNode joinGroup, ASTJoinGroupPartitions partitions, GroupNodeVarBindingInfoMap bindingInfoMap, Set<IVariable<?>> externallyKnownProduced) {
        int i;
        List<ASTJoinGroupPartition> partitionList = partitions.getPartitionList();
        ArrayList definitelyProducedUpToPartition = new ArrayList(partitionList.size());
        HashSet producedUpToPartition = new HashSet(externallyKnownProduced);
        for (i = 0; i < partitionList.size(); ++i) {
            if (i > 0) {
                producedUpToPartition.addAll(partitionList.get(i - 1).getDefinitelyProduced());
            }
            definitelyProducedUpToPartition.add(new HashSet(producedUpToPartition));
        }
        for (i = 1; i < partitionList.size(); ++i) {
            ASTJoinGroupPartition partition = partitionList.get(i);
            ArrayList<IGroupMemberNode> unmovableNodes = new ArrayList<IGroupMemberNode>();
            for (IGroupMemberNode candidate : partition.nonOptionalNonMinusNodes) {
                Integer partitionForCandidate = null;
                for (int j = i - 1; j >= 0; --j) {
                    ASTJoinGroupPartition candidatePartition = partitionList.get(j);
                    HashSet<Object> conflictingVars = candidatePartition.optionalOrMinus == null ? new HashSet() : new HashSet(bindingInfoMap.get(candidatePartition.optionalOrMinus).getMaybeProduced());
                    GroupNodeVarBindingInfo candidateBindingInfo = bindingInfoMap.get(candidate);
                    conflictingVars.retainAll(candidateBindingInfo.getMaybeProduced());
                    conflictingVars.removeAll((Collection)definitelyProducedUpToPartition.get(j + 1));
                    if (!conflictingVars.isEmpty() || !((Set)definitelyProducedUpToPartition.get(j)).containsAll(candidateBindingInfo.getRequiredBound())) {
                        JoinOrderExplainHint explainHint = new JoinOrderExplainHint("The referenced AST node cannot be moved in front of an OPTIONAL or MINUS expression. Blazegraph tries to do so in order to assert best performance, but in this it seems like query semantics might change if we move the node. Please review your query and move the node to in front of all OPTIONAL or MINUS nodes manually if this is what you wanted to implement. Note that this hint does not imply that your query is wrong, but there might be a problem with it.", candidate);
                        joinGroup.addExplainHint(explainHint);
                        break;
                    }
                    partitionForCandidate = j;
                }
                if (partitionForCandidate != null) {
                    ASTJoinGroupPartition partitionToMove = partitionList.get(partitionForCandidate);
                    partitionToMove.addNonOptionalNonMinusNodeToPartition(candidate);
                    for (int k = partitionForCandidate + 1; k <= i; ++k) {
                        ((Set)definitelyProducedUpToPartition.get(k)).addAll(bindingInfoMap.get(candidate).getDefinitelyProduced());
                    }
                    continue;
                }
                unmovableNodes.add(candidate);
            }
            partition.replaceNonOptionalNonMinusNodesWith(unmovableNodes, true);
        }
    }

    void optimizeWithinPartitions(ASTJoinGroupPartitions partitions, GroupNodeVarBindingInfoMap bindingInfoMap, boolean assertCorrectnessOnly) {
        List<ASTJoinGroupPartition> partitionList = partitions.getPartitionList();
        HashSet knownBoundFromPrevPartitions = new HashSet();
        for (ASTJoinGroupPartition partition : partitionList) {
            this.optimizeWithinPartition(partition, assertCorrectnessOnly, bindingInfoMap, knownBoundFromPrevPartitions);
        }
    }

    void optimizeWithinPartition(ASTJoinGroupPartition partition, boolean assertCorrectnessOnly, final GroupNodeVarBindingInfoMap bindingInfoMap, Set<IVariable<?>> knownBoundFromPrevPartitions) {
        ASTTypeBasedNodeClassifier classifier = new ASTTypeBasedNodeClassifier(new Class[]{ServiceNode.class, AssignmentNode.class, BindingsClause.class, IGroupMemberNode.class});
        classifier.addConstraintForType(ServiceNode.class, new ASTTypeBasedNodeClassifierConstraint(){

            @Override
            boolean appliesTo(IGroupMemberNode node) {
                if (node instanceof ServiceNode) {
                    ServiceNode sn = (ServiceNode)node;
                    if (!sn.getResponsibleServiceFactory().equals(ServiceRegistry.getInstance().getDefaultServiceFactory())) {
                        return true;
                    }
                    if (!sn.getServiceRef().isConstant()) {
                        return true;
                    }
                }
                return false;
            }
        });
        classifier.addConstraintForType(IGroupMemberNode.class, new ASTTypeBasedNodeClassifierConstraint(){

            @Override
            boolean appliesTo(IGroupMemberNode node) {
                HashSet reqBoundInNode = new HashSet(bindingInfoMap.get(node).getRequiredBound());
                reqBoundInNode.removeAll(bindingInfoMap.get(node).getMaybeProduced());
                return !reqBoundInNode.isEmpty();
            }
        });
        classifier.registerNodes(partition.extractNodeList(false));
        ArrayList<IGroupMemberNode> toRemove = new ArrayList<IGroupMemberNode>();
        toRemove.addAll(classifier.get(ServiceNode.class));
        toRemove.addAll(classifier.get(AssignmentNode.class));
        toRemove.addAll(classifier.get(BindingsClause.class));
        toRemove.addAll(classifier.get(IGroupMemberNode.class));
        partition.removeNodesFromPartition(toRemove);
        if (!assertCorrectnessOnly) {
            TypeBasedASTJoinGroupPartitionReorderer reorderer = new TypeBasedASTJoinGroupPartitionReorderer();
            reorderer.reorderNodes(partition);
        }
        LinkedList<IGroupMemberNode> nonValueNodesToBePlaced = new LinkedList<IGroupMemberNode>();
        nonValueNodesToBePlaced.addAll(classifier.get(AssignmentNode.class));
        nonValueNodesToBePlaced.addAll(classifier.get(ServiceNode.class));
        nonValueNodesToBePlaced.addAll(classifier.get(IGroupMemberNode.class));
        for (IGroupMemberNode iGroupMemberNode : classifier.get(BindingsClause.class)) {
            BindingsClause bc = (BindingsClause)iGroupMemberNode;
            LinkedHashSet<IVariable<?>> declaredVars = bc.getDeclaredVariables();
            HashSet intersectionWithNonValueNodesToBePlaced = new HashSet();
            for (IGroupMemberNode cur : nonValueNodesToBePlaced) {
                intersectionWithNonValueNodesToBePlaced.addAll(bindingInfoMap.get(cur).leftToBeBound(knownBoundFromPrevPartitions));
            }
            intersectionWithNonValueNodesToBePlaced.retainAll(declaredVars);
            if (intersectionWithNonValueNodesToBePlaced.isEmpty()) {
                partition.placeAtFirstContributingPosition(iGroupMemberNode, knownBoundFromPrevPartitions, false);
                continue;
            }
            partition.placeAtFirstPossiblePosition(iGroupMemberNode, knownBoundFromPrevPartitions, false);
        }
        HashSet knownBoundSomewhere = new HashSet(partition.definitelyProduced);
        List<IGroupMemberNode> list = this.orderNodesByDependencies(nonValueNodesToBePlaced, partition.bindingInfoMap, knownBoundSomewhere);
        for (IGroupMemberNode node : list) {
            boolean runFirst = false;
            if (node instanceof ServiceNode) {
                ServiceNode sn = (ServiceNode)node;
                runFirst = sn.getResponsibleServiceFactory().getServiceOptions().isRunFirst();
            }
            if (runFirst) {
                partition.placeAtFirstPossiblePosition(node, knownBoundFromPrevPartitions, false);
                continue;
            }
            partition.placeAtFirstContributingPosition(node, knownBoundFromPrevPartitions, false);
        }
        knownBoundFromPrevPartitions.addAll(partition.getDefinitelyProduced());
    }

    List<IGroupMemberNode> orderNodesByDependencies(List<IGroupMemberNode> nodes, GroupNodeVarBindingInfoMap bindingInfoMap, Set<IVariable<?>> knownBoundSomewhere) {
        ArrayList<IGroupMemberNode> ordered = new ArrayList<IGroupMemberNode>(nodes.size());
        LinkedList<IGroupMemberNode> toBePlaced = new LinkedList<IGroupMemberNode>(nodes);
        HashSet knownBound = new HashSet(knownBoundSomewhere);
        block0: while (!toBePlaced.isEmpty()) {
            for (int i = 0; i < toBePlaced.size(); ++i) {
                IGroupMemberNode node = toBePlaced.get(i);
                GroupNodeVarBindingInfo nodeBindingInfo = bindingInfoMap.get(node);
                if (!nodeBindingInfo.leftToBeBound(knownBound).isEmpty() && i + 1 != toBePlaced.size()) continue;
                ordered.add(node);
                toBePlaced.remove(i);
                knownBound.addAll(nodeBindingInfo.getDefinitelyProduced());
                continue block0;
            }
        }
        return ordered;
    }
}

