/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.QueryNodeBase;
import com.bigdata.rdf.sparql.ast.eval.DataSetSummary;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.relation.accesspath.IElementFilter;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.openrdf.query.Dataset;

public class DatasetNode
extends QueryNodeBase {
    private static final long serialVersionUID = 1L;

    public DatasetNode(DatasetNode op) {
        super(op);
    }

    public DatasetNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    private static final DataSetSummary asDataSetSummary(Set<IV> ivs, boolean update) {
        return new DataSetSummary(ivs == null ? Collections.emptySet() : ivs, update);
    }

    public DatasetNode(Set<IV> defaultGraphs, Set<IV> namedGraphs, boolean update) {
        this(DatasetNode.asDataSetSummary(defaultGraphs, update), DatasetNode.asDataSetSummary(namedGraphs, update));
    }

    public DatasetNode(Set<IV> defaultGraphs, Set<IV> namedGraphs, IElementFilter<ISPO> defaultGraphFilter, IElementFilter<ISPO> namedGraphFilter, boolean update) {
        this(DatasetNode.asDataSetSummary(defaultGraphs, update), DatasetNode.asDataSetSummary(namedGraphs, update), defaultGraphFilter, namedGraphFilter);
    }

    public DatasetNode(DataSetSummary defaultGraphs, DataSetSummary namedGraphs) {
        this(defaultGraphs, namedGraphs, null, null);
    }

    public DatasetNode(Dataset dataset, boolean update) {
        this(DataSetSummary.toInternalValues(dataset.getDefaultGraphs()), DataSetSummary.toInternalValues(dataset.getNamedGraphs()), update);
    }

    public DatasetNode(DataSetSummary defaultGraphs, DataSetSummary namedGraphs, IElementFilter<ISPO> defaultGraphFilter, IElementFilter<ISPO> namedGraphFilter) {
        this.setDefaultGraphs(defaultGraphs);
        this.setNamedGraphs(namedGraphs);
        this.setDefaultGraphFilter(defaultGraphFilter);
        this.setNamedGraphFilter(namedGraphFilter);
    }

    public void setDefaultGraphs(DataSetSummary defaultGraphs) {
        this.setProperty("defaultGraphs", defaultGraphs);
    }

    public void setNamedGraphs(DataSetSummary namedGraphs) {
        this.setProperty("namedGraphs", namedGraphs);
    }

    public void setDefaultGraphFilter(IElementFilter<ISPO> defaultGraphFilter) {
        this.setProperty("defaultGraphFilter", defaultGraphFilter);
    }

    public void setNamedGraphFilter(IElementFilter<ISPO> namedGraphFilter) {
        this.setProperty("namedGraphFilter", namedGraphFilter);
    }

    public DataSetSummary getDefaultGraphs() {
        return (DataSetSummary)this.getProperty("defaultGraphs");
    }

    public DataSetSummary getNamedGraphs() {
        return (DataSetSummary)this.getProperty("namedGraphs");
    }

    public IElementFilter<ISPO> getDefaultGraphFilter() {
        return (IElementFilter)this.getProperty("defaultGraphFilter");
    }

    public IElementFilter<ISPO> getNamedGraphFilter() {
        return (IElementFilter)this.getProperty("namedGraphFilter");
    }

    @Override
    public String toString(int indent) {
        String s = DatasetNode.indent(indent);
        StringBuilder sb = new StringBuilder();
        DataSetSummary defaultGraphs = this.getDefaultGraphs();
        DataSetSummary namedGraphs = this.getNamedGraphs();
        IElementFilter<ISPO> defaultGraphFilter = this.getDefaultGraphFilter();
        IElementFilter<ISPO> namedGraphFilter = this.getNamedGraphFilter();
        if (defaultGraphs != null) {
            sb.append("\n");
            sb.append(s);
            sb.append("defaultGraphs=");
            sb.append(defaultGraphs.toString());
        }
        if (namedGraphs != null) {
            sb.append("\n");
            sb.append(s);
            sb.append("namedGraphs=");
            sb.append(namedGraphs.toString());
        }
        if (defaultGraphFilter != null) {
            sb.append("\n");
            sb.append(s);
            sb.append("defaultGraphFilter=" + defaultGraphFilter);
        }
        if (namedGraphFilter != null) {
            sb.append("\n");
            sb.append(s);
            sb.append("namedGraphFilter=" + namedGraphFilter);
        }
        return sb.toString();
    }

    static interface Annotations
    extends QueryNodeBase.Annotations {
        public static final String DEFAULT_GRAPHS = "defaultGraphs";
        public static final String DEFAULT_GRAPH_FILTER = "defaultGraphFilter";
        public static final String NAMED_GRAPHS = "namedGraphs";
        public static final String NAMED_GRAPH_FILTER = "namedGraphFilter";
    }
}

