/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.CreateGraph;
import com.bigdata.rdf.sparql.ast.DropGraph;
import com.bigdata.rdf.sparql.ast.GraphManagement;
import com.bigdata.rdf.sparql.ast.UpdateType;
import java.util.Map;

public abstract class AbstractOneGraphManagement
extends GraphManagement {
    private static final long serialVersionUID = 1L;

    public AbstractOneGraphManagement(UpdateType updateType) {
        super(updateType);
    }

    public AbstractOneGraphManagement(AbstractOneGraphManagement op) {
        super(op);
    }

    public AbstractOneGraphManagement(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    final boolean isTargetGraph() {
        return this.getProperty("target") instanceof ConstantNode;
    }

    public final boolean isTargetSolutionSet() {
        return this.getProperty("target") instanceof String;
    }

    @Override
    public final ConstantNode getTargetGraph() {
        Object o = this.getProperty("target");
        if (o instanceof ConstantNode) {
            return (ConstantNode)o;
        }
        return null;
    }

    @Override
    public final void setTargetGraph(ConstantNode targetGraph) {
        if (targetGraph == null) {
            throw new IllegalArgumentException();
        }
        this.setProperty("target", targetGraph);
    }

    public final String getTargetSolutionSet() {
        Object o = this.getProperty("target");
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public final void setTargetSolutionSet(String targetSolutionSet) {
        if (targetSolutionSet == null) {
            throw new IllegalArgumentException();
        }
        this.setProperty("target", targetSolutionSet);
    }

    @Override
    public final String toString(int indent) {
        CreateGraph t;
        BigdataStatement[] params;
        StringBuilder sb = new StringBuilder();
        sb.append(AbstractOneGraphManagement.indent(indent));
        sb.append((Object)this.getUpdateType());
        if (this.isSilent()) {
            sb.append(" SILENT");
        }
        ConstantNode targetGraph = this.getTargetGraph();
        String targetSolutionSet = this.getTargetSolutionSet();
        if (targetGraph != null) {
            sb.append(" targetGraph=" + targetGraph);
        }
        if (targetSolutionSet != null) {
            sb.append(" targetSolutionSet=" + targetSolutionSet);
        }
        if (this instanceof DropGraph) {
            DropGraph t2 = (DropGraph)this;
            if (t2.isAllGraphs()) {
                sb.append(" ALL-GRAPHS");
            }
            if (t2.isAllSolutionSets()) {
                sb.append(" ALL-SOLUTIONS");
            }
        } else if (this instanceof CreateGraph && (params = (t = (CreateGraph)this).getParams()) != null) {
            String s = AbstractOneGraphManagement.indent(indent + 1);
            sb.append("\n").append(s).append("PARAMS {");
            for (BigdataStatement v : params) {
                sb.append(v.toString());
            }
            sb.append("\n").append(s).append("}");
        }
        sb.append("\n");
        return sb.toString();
    }
}

