/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio.json;

import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.input.ReaderInputStream;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResultHandler;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.helpers.RDFParserBase;

public class BigdataSPARQLResultsJSONParserForConstruct
extends RDFParserBase
implements RDFParser,
TupleQueryResultHandler {
    private final BigdataSPARQLResultsJSONParser parser;

    public BigdataSPARQLResultsJSONParserForConstruct() {
        this.parser = new BigdataSPARQLResultsJSONParser();
    }

    public BigdataSPARQLResultsJSONParserForConstruct(ValueFactory vf) {
        this.parser = new BigdataSPARQLResultsJSONParser(vf);
        this.parser.setQueryResultHandler((QueryResultHandler)this);
    }

    public RDFFormat getRDFFormat() {
        return ServiceProviderHook.JSON_RDR;
    }

    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        try {
            this.parser.parseQueryResult(in);
        }
        catch (QueryResultParseException e) {
            throw new RDFParseException((Throwable)e);
        }
        catch (QueryResultHandlerException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.parse((InputStream)new ReaderInputStream(reader), baseURI);
    }

    public void handleBoolean(boolean value) throws QueryResultHandlerException {
    }

    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        try {
            this.getRDFHandler().startRDF();
        }
        catch (RDFHandlerException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
        try {
            this.getRDFHandler().endRDF();
        }
        catch (RDFHandlerException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void handleSolution(BindingSet bs) throws TupleQueryResultHandlerException {
        if (!bs.hasBinding("subject")) {
            throw new TupleQueryResultHandlerException("no subject: " + bs);
        }
        if (!bs.hasBinding("predicate")) {
            throw new TupleQueryResultHandlerException("no predicate: " + bs);
        }
        if (!bs.hasBinding("object")) {
            throw new TupleQueryResultHandlerException("no object: " + bs);
        }
        Resource s = (Resource)bs.getValue("subject");
        URI p = (URI)bs.getValue("predicate");
        Value o = bs.getValue("object");
        Resource c = bs.hasBinding("context") ? (Resource)bs.getBinding("context") : null;
        Statement stmt = this.valueFactory.createStatement(s, p, o, c);
        try {
            this.getRDFHandler().handleStatement(stmt);
        }
        catch (RDFHandlerException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }
}

