/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.io.LongPacker;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.DTEExtension;
import com.bigdata.rdf.internal.IPv4Address;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUnicode;
import com.bigdata.rdf.internal.InlineLiteralIV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractIV;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.internal.impl.bnode.FullyInlineUnicodeBNodeIV;
import com.bigdata.rdf.internal.impl.bnode.NumericBNodeIV;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.internal.impl.bnode.UUIDBNodeIV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.IPv4AddrIV;
import com.bigdata.rdf.internal.impl.literal.LiteralArrayIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.MockedValueIV;
import com.bigdata.rdf.internal.impl.literal.PackedLongIV;
import com.bigdata.rdf.internal.impl.literal.PartlyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.UUIDLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.internal.impl.literal.XSDDecimalIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedByteIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedIntIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedLongIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedShortIV;
import com.bigdata.rdf.internal.impl.uri.FullyInlineURIIV;
import com.bigdata.rdf.internal.impl.uri.PartlyInlineURIIV;
import com.bigdata.rdf.internal.impl.uri.URIExtensionIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIByteIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIShortIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.UUID;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.XMLSchema;

public class IVUtility {
    public static final boolean PACK_TIDS = false;

    public static boolean equals(IV iv1, IV iv2) {
        if (iv1 == iv2) {
            return true;
        }
        if (iv1 == null || iv2 == null) {
            return false;
        }
        return iv1.equals(iv2);
    }

    public static int compare(IV iv1, IV iv2) {
        if (iv1 == iv2) {
            return 0;
        }
        if (iv1 == null) {
            return -1;
        }
        if (iv2 == null) {
            return 1;
        }
        return iv1.compareTo(iv2);
    }

    public static IKeyBuilder encode(IKeyBuilder keyBuilder, IV iv) {
        if (iv == null) {
            TermId.NullIV.encode(keyBuilder);
        } else {
            iv.encode(keyBuilder);
        }
        return keyBuilder;
    }

    public static IV decode(byte[] key) {
        return IVUtility.decodeFromOffset(key, 0);
    }

    public static IV[] decode(byte[] key, int numTerms) {
        return IVUtility.decode(key, 0, numTerms);
    }

    public static IV[] decode(byte[] key, int offset, int numTerms) {
        if (numTerms <= 0) {
            return new IV[0];
        }
        IV[] ivs = new IV[numTerms];
        int o = offset;
        for (int i = 0; i < numTerms; ++i) {
            if (o >= key.length) {
                throw new IllegalArgumentException("key is not long enough to decode " + numTerms + " terms.");
            }
            ivs[i] = IVUtility.decodeFromOffset(key, o);
            o += ivs[i] == null ? TermId.NullIV.byteLength() : ivs[i].byteLength();
        }
        return ivs;
    }

    public static IV[] decodeAll(byte[] key) {
        return IVUtility.decodeAll(key, 0, key.length);
    }

    public static IV[] decodeAll(byte[] key, int off, int len) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (off < 0) {
            throw new IllegalArgumentException();
        }
        int limit = off + len;
        if (len < 0 || limit > key.length) {
            throw new IllegalArgumentException();
        }
        LinkedList<IV> ivs = new LinkedList<IV>();
        while (off < limit) {
            IV iv = IVUtility.decodeFromOffset(key, off);
            ivs.add(iv);
            off += iv == null ? TermId.NullIV.byteLength() : iv.byteLength();
        }
        return ivs.toArray(new IV[ivs.size()]);
    }

    public static IV decodeFromOffset(byte[] key, int offset) {
        return IVUtility.decodeFromOffset(key, offset, true);
    }

    public static IV decodeFromOffset(byte[] key, int offset, boolean nullIsNullRef) {
        byte flags;
        int o = offset;
        if (!AbstractIV.isInline(flags = KeyBuilder.decodeByte(key[o++]))) {
            if (AbstractIV.isExtension(flags)) {
                byte extensionByte;
                if ((extensionByte = KeyBuilder.decodeByte(key[o++])) < 0) {
                    IV extensionIV = IVUtility.decodeFromOffset(key, o);
                    AbstractLiteralIV delegate = (AbstractLiteralIV)IVUtility.decodeFromOffset(key, o += extensionIV.byteLength());
                    switch (AbstractIV.getInternalValueTypeEnum(flags)) {
                        case URI: {
                            return new PartlyInlineURIIV(delegate, extensionIV);
                        }
                        case LITERAL: {
                            return new PartlyInlineTypedLiteralIV(delegate, extensionIV);
                        }
                    }
                    throw new AssertionError();
                }
                int hashCode = KeyBuilder.decodeInt(key, o);
                short counter = KeyBuilder.decodeShort(key, o += 4);
                o += 2;
                BlobIV iv = new BlobIV(flags, hashCode, counter);
                return iv;
            }
            long termId = KeyBuilder.decodeLong(key, o);
            if (termId == 0L) {
                if (nullIsNullRef) {
                    return null;
                }
                return TermId.mockIV(VTE.valueOf(flags));
            }
            return new TermId(flags, termId);
        }
        VTE vte = AbstractIV.getInternalValueTypeEnum(flags);
        switch (vte) {
            case STATEMENT: {
                SPO spo = SPOKeyOrder.SPO.decodeKey(key, o);
                spo.setStatementType(StatementEnum.Explicit);
                return new SidIV(spo);
            }
            case BNODE: {
                return IVUtility.decodeInlineBNode(flags, key, o);
            }
            case URI: {
                return IVUtility.decodeInlineURI(flags, key, o);
            }
            case LITERAL: {
                return IVUtility.decodeInlineLiteral(flags, key, o);
            }
        }
        throw new AssertionError();
    }

    private static IV decodeInlineBNode(byte flags, byte[] key, int o) {
        DTE dte = AbstractIV.getDTE(flags);
        switch (dte) {
            case XSDInt: {
                int x = KeyBuilder.decodeInt(key, o);
                return new NumericBNodeIV(x);
            }
            case UUID: {
                UUID x = KeyBuilder.decodeUUID(key, o);
                return new UUIDBNodeIV(x);
            }
            case XSDString: {
                String str1;
                int nbytes;
                StringBuilder sb = new StringBuilder();
                try {
                    nbytes = IVUnicode.decode(new ByteArrayInputStream(key, o, key.length - o), sb);
                    str1 = sb.toString();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new FullyInlineUnicodeBNodeIV(str1, 1 + nbytes);
            }
        }
        throw new UnsupportedOperationException("dte=" + (Object)((Object)dte));
    }

    private static IV decodeInlineURI(byte flags, byte[] key, int o) {
        if (AbstractIV.isExtension(flags)) {
            IV namespaceIV = IVUtility.decodeFromOffset(key, o);
            AbstractLiteralIV localNameIV = (AbstractLiteralIV)IVUtility.decodeFromOffset(key, o += namespaceIV.byteLength());
            URIExtensionIV iv = new URIExtensionIV(localNameIV, namespaceIV);
            return iv;
        }
        DTE dte = AbstractIV.getDTE(flags);
        switch (dte) {
            case XSDByte: {
                byte x = key[o];
                return new VocabURIByteIV(x);
            }
            case XSDShort: {
                short x = KeyBuilder.decodeShort(key, o);
                return new VocabURIShortIV(x);
            }
            case XSDString: {
                String str1;
                int nbytes;
                StringBuilder sb = new StringBuilder();
                try {
                    nbytes = IVUnicode.decode(new ByteArrayInputStream(key, o, key.length - o), sb);
                    str1 = sb.toString();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new FullyInlineURIIV((URI)new URIImpl(str1), 1 + nbytes);
            }
        }
        throw new UnsupportedOperationException("dte=" + (Object)((Object)dte));
    }

    private static IV decodeInlineLiteral(byte flags, byte[] key, int o) {
        IV datatype;
        DTE dte = AbstractIV.getDTE(flags);
        DTEExtension dtex = dte == DTE.Extension ? DTEExtension.valueOf(key[o++]) : null;
        boolean isExtension = AbstractIV.isExtension(flags);
        if (isExtension) {
            datatype = IVUtility.decodeFromOffset(key, o);
            o += datatype.byteLength();
        } else {
            datatype = null;
        }
        switch (dte) {
            case XSDBoolean: {
                byte x = KeyBuilder.decodeByte(key[o]);
                XSDBooleanIV<BigdataLiteral> iv = x == 0 ? XSDBooleanIV.FALSE : XSDBooleanIV.TRUE;
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case XSDByte: {
                byte x = KeyBuilder.decodeByte(key[o]);
                XSDNumericIV<BigdataLiteral> iv = new XSDNumericIV<BigdataLiteral>(x);
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case XSDShort: {
                short x = KeyBuilder.decodeShort(key, o);
                XSDNumericIV<BigdataLiteral> iv = new XSDNumericIV<BigdataLiteral>(x);
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case XSDInt: {
                int x = KeyBuilder.decodeInt(key, o);
                XSDNumericIV<BigdataLiteral> iv = new XSDNumericIV<BigdataLiteral>(x);
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case XSDLong: {
                long x = KeyBuilder.decodeLong(key, o);
                XSDNumericIV<BigdataLiteral> iv = new XSDNumericIV<BigdataLiteral>(x);
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case XSDFloat: {
                float x = KeyBuilder.decodeFloat(key, o);
                XSDNumericIV<BigdataLiteral> iv = new XSDNumericIV<BigdataLiteral>(x);
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case XSDDouble: {
                double x = KeyBuilder.decodeDouble(key, o);
                XSDNumericIV<BigdataLiteral> iv = new XSDNumericIV<BigdataLiteral>(x);
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case XSDInteger: {
                BigInteger x = KeyBuilder.decodeBigInteger(o, key);
                XSDIntegerIV<BigdataLiteral> iv = new XSDIntegerIV<BigdataLiteral>(x);
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case XSDDecimal: {
                BigDecimal x = KeyBuilder.decodeBigDecimal(o, key);
                XSDDecimalIV<BigdataLiteral> iv = new XSDDecimalIV<BigdataLiteral>(x);
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case UUID: {
                UUID x = KeyBuilder.decodeUUID(key, o);
                UUIDLiteralIV<BigdataLiteral> iv = new UUIDLiteralIV<BigdataLiteral>(x);
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case XSDUnsignedByte: {
                byte x = KeyBuilder.decodeByte(key[o]);
                XSDUnsignedByteIV<BigdataLiteral> iv = new XSDUnsignedByteIV<BigdataLiteral>(x);
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case XSDUnsignedShort: {
                short x = KeyBuilder.decodeShort(key, o);
                XSDUnsignedShortIV<BigdataLiteral> iv = new XSDUnsignedShortIV<BigdataLiteral>(x);
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case XSDUnsignedInt: {
                int x = KeyBuilder.decodeInt(key, o);
                XSDUnsignedIntIV<BigdataLiteral> iv = new XSDUnsignedIntIV<BigdataLiteral>(x);
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case XSDUnsignedLong: {
                long x = KeyBuilder.decodeLong(key, o);
                XSDUnsignedLongIV<BigdataLiteral> iv = new XSDUnsignedLongIV<BigdataLiteral>(x);
                return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
            }
            case XSDString: {
                if (isExtension) {
                    String str1;
                    int nread;
                    byte termCode = key[o++];
                    assert (termCode == 2) : "termCode=" + termCode;
                    StringBuilder sb = new StringBuilder();
                    try {
                        nread = IVUnicode.decode(new ByteArrayInputStream(key, o, key.length - o), sb);
                        str1 = sb.toString();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    FullyInlineTypedLiteralIV<BigdataLiteral> iv = new FullyInlineTypedLiteralIV<BigdataLiteral>(str1, null, null, 2 + nread);
                    return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
                }
                return IVUtility.decodeInlineUnicodeLiteral(key, o);
            }
            case Extension: {
                switch (dtex) {
                    case IPV4: {
                        byte[] addr = new byte[5];
                        System.arraycopy(key, o, addr, 0, 5);
                        IPv4Address ip = new IPv4Address(addr);
                        IPv4AddrIV<BigdataLiteral> iv = new IPv4AddrIV<BigdataLiteral>(ip);
                        return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
                    }
                    case PACKED_LONG: {
                        PackedLongIV<BigdataLiteral> iv = new PackedLongIV<BigdataLiteral>(LongPacker.unpackLong(key, o));
                        return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
                    }
                    case MOCKED_IV: {
                        return new MockedValueIV(IVUtility.decodeFromOffset(key, o));
                    }
                    case ARRAY: {
                        int n = (key[o++] & 0xFF) + 1;
                        IV[] ivs = IVUtility.decode(key, o, n);
                        InlineLiteralIV[] args = new InlineLiteralIV[n];
                        for (int i = 0; i < n; ++i) {
                            if (!(ivs[i] instanceof InlineLiteralIV)) {
                                throw new UnsupportedOperationException("InlineArrayIV only supports InlineLiteralIV delegates");
                            }
                            args[i] = (InlineLiteralIV)ivs[i];
                        }
                        LiteralArrayIV iv = new LiteralArrayIV(args);
                        return isExtension ? new LiteralExtensionIV(iv, datatype) : iv;
                    }
                }
                throw new UnsupportedOperationException("dte=" + (Object)((Object)dte));
            }
        }
        throw new UnsupportedOperationException("dte=" + (Object)((Object)dte));
    }

    private static FullyInlineTypedLiteralIV<BigdataLiteral> decodeInlineUnicodeLiteral(byte[] key, int offset) {
        FullyInlineTypedLiteralIV<BigdataLiteral> iv;
        String str2;
        String str1;
        int nbytes;
        int nstrings;
        int o = offset;
        byte termCode = key[o++];
        switch (termCode) {
            case 2: {
                nstrings = 1;
                break;
            }
            case 3: {
                nstrings = 2;
                break;
            }
            case 4: {
                nstrings = 2;
                break;
            }
            default: {
                throw new AssertionError((Object)("termCode=" + termCode));
            }
        }
        int nread = 0;
        StringBuilder sb = new StringBuilder();
        try {
            nbytes = IVUnicode.decode(new ByteArrayInputStream(key, o, key.length - o), sb);
            str1 = sb.toString();
            nread += nbytes;
            o += nbytes;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (nstrings == 2) {
            sb.setLength(0);
            try {
                nbytes = IVUnicode.decode(new ByteArrayInputStream(key, o, key.length - o), sb);
                str2 = sb.toString();
                nread += nbytes;
                o += nbytes;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            str2 = null;
        }
        int byteLength = 2 + nread;
        switch (termCode) {
            case 2: {
                iv = new FullyInlineTypedLiteralIV<BigdataLiteral>(str1, null, null, byteLength);
                break;
            }
            case 3: {
                iv = new FullyInlineTypedLiteralIV(str2, str1, null, byteLength);
                break;
            }
            case 4: {
                iv = new FullyInlineTypedLiteralIV(str2, null, (URI)new URIImpl(str1), byteLength);
                break;
            }
            default: {
                throw new AssertionError((Object)("termCode=" + termCode));
            }
        }
        return iv;
    }

    public static IV decode(String val, String type) {
        DTE dte = Enum.valueOf(DTE.class, type);
        switch (dte) {
            case XSDBoolean: {
                boolean b = Boolean.valueOf(val);
                if (b) {
                    return XSDBooleanIV.TRUE;
                }
                return XSDBooleanIV.FALSE;
            }
            case XSDByte: {
                byte x = Byte.valueOf(val);
                return new XSDNumericIV(x);
            }
            case XSDShort: {
                short x = Short.valueOf(val);
                return new XSDNumericIV(x);
            }
            case XSDInt: {
                int x = Integer.valueOf(val);
                return new XSDNumericIV(x);
            }
            case XSDLong: {
                long x = Long.valueOf(val);
                return new XSDNumericIV(x);
            }
            case XSDFloat: {
                float x = Float.valueOf(val).floatValue();
                return new XSDNumericIV(x);
            }
            case XSDDouble: {
                double x = Double.valueOf(val);
                return new XSDNumericIV(x);
            }
            case UUID: {
                UUID x = UUID.fromString(val);
                return new UUIDLiteralIV(x);
            }
            case XSDInteger: {
                BigInteger x = new BigInteger(val);
                return new XSDIntegerIV(x);
            }
            case XSDDecimal: {
                BigDecimal x = new BigDecimal(val);
                return new XSDDecimalIV(x);
            }
            case XSDString: {
                return new FullyInlineTypedLiteralIV(val, null, XMLSchema.STRING);
            }
            case XSDUnsignedByte: {
                return new XSDUnsignedByteIV((byte)(Byte.valueOf(val) + -128));
            }
            case XSDUnsignedShort: {
                return new XSDUnsignedShortIV((short)(Short.valueOf(val) + Short.MIN_VALUE));
            }
            case XSDUnsignedInt: {
                return new XSDUnsignedIntIV(Integer.valueOf(val) + Integer.MIN_VALUE);
            }
            case XSDUnsignedLong: {
                return new XSDUnsignedLongIV(Long.valueOf(val) + Long.MIN_VALUE);
            }
        }
        throw new UnsupportedOperationException("dte=" + (Object)((Object)dte));
    }
}

