/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.inf.ClosureStats;
import com.bigdata.rdf.inf.Justification;
import com.bigdata.rdf.inf.SPOAssertionBuffer;
import com.bigdata.rdf.inf.SPORetractionBuffer;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rules.InferenceEngine;
import com.bigdata.rdf.spo.ExplicitSPOFilter;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOArrayIterator;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class TruthMaintenance {
    protected static final Logger log = Logger.getLogger(TruthMaintenance.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    protected final AbstractTripleStore database;
    protected final InferenceEngine inferenceEngine;

    public TempTripleStore newTempTripleStore() {
        Properties properties = this.database.getProperties();
        properties.setProperty(AbstractTripleStore.Options.LEXICON, "false");
        properties.setProperty(AbstractTripleStore.Options.BLOOM_FILTER, "false");
        TempTripleStore tempStore = new TempTripleStore(this.database.getIndexManager().getTempStore(), properties, this.database);
        return tempStore;
    }

    public AbstractTripleStore getDatabase() {
        return this.database;
    }

    public TruthMaintenance(InferenceEngine inferenceEngine) {
        if (inferenceEngine == null) {
            throw new IllegalArgumentException();
        }
        this.database = inferenceEngine.database;
        this.inferenceEngine = inferenceEngine;
    }

    public static int applyExistingStatements(AbstractTripleStore focusStore, AbstractTripleStore database, IElementFilter<ISPO> filter) {
        return TruthMaintenance.applyExistingStatements(focusStore, database, filter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int applyExistingStatements(AbstractTripleStore focusStore, AbstractTripleStore database, IElementFilter<ISPO> filter, IChangeLog changeLog) {
        if (INFO) {
            log.info((Object)"Filtering statements already known to the database");
        }
        long begin = System.currentTimeMillis();
        IChunkedOrderedIterator<ISPO> itr = focusStore.getAccessPath(SPOKeyOrder.SPO, ExplicitSPOFilter.INSTANCE).iterator();
        int nremoved = 0;
        int nupgraded = 0;
        try {
            long focusStoreSize = focusStore.getStatementCount();
            int capacity = (int)Math.min(focusStoreSize, 1000000L);
            SPOAssertionBuffer assertionBuffer = new SPOAssertionBuffer(database, database, filter, capacity, false, changeLog);
            SPORetractionBuffer retractionBuffer = new SPORetractionBuffer(focusStore, capacity, false);
            while (itr.hasNext()) {
                ISPO[] chunk = (ISPO[])itr.nextChunk();
                for (int i = 0; i < chunk.length; ++i) {
                    SPO spo = (SPO)chunk[i];
                    ISPO tmp = database.getStatement(spo.s, spo.p, spo.o);
                    if (tmp == null) continue;
                    if (tmp.getStatementType() == StatementEnum.Explicit) {
                        retractionBuffer.add(spo);
                        ++nremoved;
                        continue;
                    }
                    assertionBuffer.add(spo);
                }
            }
            assertionBuffer.flush();
            retractionBuffer.flush();
        }
        finally {
            itr.close();
        }
        long elapsed = System.currentTimeMillis() - begin;
        if (INFO) {
            log.info((Object)("Removed " + nremoved + " statements from the focusStore" + " and upgraded " + nupgraded + " statements in the database in " + elapsed + " ms."));
        }
        return nremoved;
    }

    public ClosureStats assertAll(TempTripleStore tempStore) {
        return this.assertAll(tempStore, null);
    }

    public ClosureStats assertAll(TempTripleStore tempStore, IChangeLog changeLog) {
        if (tempStore == null) {
            throw new IllegalArgumentException();
        }
        long begin = System.currentTimeMillis();
        long ngiven = tempStore.getStatementCount();
        if (ngiven == 0L) {
            return new ClosureStats();
        }
        long nbeforeClosure = tempStore.getStatementCount();
        if (INFO) {
            log.info((Object)("Computing closure of the temporary store with " + nbeforeClosure + " statements"));
        }
        TruthMaintenance.applyExistingStatements(tempStore, this.database, this.inferenceEngine.doNotAddFilter, changeLog);
        ClosureStats stats = this.inferenceEngine.computeClosure(tempStore);
        long nafterClosure = tempStore.getStatementCount();
        if (INFO) {
            log.info((Object)("There are " + nafterClosure + " statements in the temporary store after closure"));
        }
        if (INFO) {
            log.info((Object)"Copying statements from the temporary store to the database");
        }
        long ncopied = tempStore.copyStatements(this.database, null, true, changeLog);
        if (INFO) {
            log.info((Object)("Copied " + ncopied + " statements that were new to the database."));
        }
        long elapsed = System.currentTimeMillis() - begin;
        stats.elapsed.add(elapsed);
        if (INFO) {
            log.info((Object)("Computed closure in " + elapsed + "ms"));
        }
        if (DEBUG) {
            log.debug((Object)("\n\ntempStore:\n" + tempStore.dumpStore(this.database, true, true, false, true)));
        }
        tempStore.close();
        return stats;
    }

    public ClosureStats retractAll(TempTripleStore tempStore) {
        return this.retractAll(tempStore, null);
    }

    public ClosureStats retractAll(TempTripleStore tempStore, IChangeLog changeLog) {
        long begin = System.currentTimeMillis();
        ClosureStats stats = new ClosureStats();
        if (tempStore == null) {
            throw new IllegalArgumentException();
        }
        long ngiven = tempStore.getStatementCount();
        if (ngiven == 0L) {
            return stats;
        }
        if (INFO) {
            log.info((Object)("Computing closure of the temporary store with " + ngiven + " statements"));
        }
        if (this.database.getStatementIdentifiers()) {
            AbstractTripleStore.fixPointStatementIdentifiers(this.database, tempStore);
            if (INFO) {
                log.info((Object)("Computing closure of the temporary store with " + ngiven + " statements (after fix point of statement identifiers)"));
            }
        }
        this.retractAll(stats, tempStore, 0, changeLog);
        MDC.remove((String)"depth");
        assert (!tempStore.isOpen());
        long elapsed = System.currentTimeMillis() - begin;
        if (INFO) {
            log.info((Object)("Retracted " + ngiven + " given and updated closure on the database in " + elapsed + " ms"));
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retractAll(ClosureStats stats, TempTripleStore tempStore, int depth, IChangeLog changeLog) {
        long focusStoreCount;
        long nretracted;
        long ndowngraded;
        MDC.put((String)"depth", (Object)("depth=" + depth));
        long tempStoreCount = tempStore.getStatementCount();
        int capacity = (int)Math.min(10000L, tempStoreCount);
        if (INFO) {
            log.info((Object)("Doing truth maintenance with " + tempStoreCount + " statements : depth=" + depth));
        }
        TempTripleStore focusStore = this.newTempTripleStore();
        try (IChunkedOrderedIterator<ISPO> itr = tempStore.getAccessPath(SPOKeyOrder.SPO).iterator();){
            boolean testFocusStore;
            SPOAssertionBuffer ungroundedBuffer = new SPOAssertionBuffer(focusStore, this.database, null, capacity, false);
            SPOAssertionBuffer downgradeBuffer = new SPOAssertionBuffer(this.database, this.database, null, capacity, false, changeLog);
            SPORetractionBuffer retractionBuffer = new SPORetractionBuffer(this.database, capacity, false, changeLog);
            boolean testHead = depth > 0;
            boolean bl = testFocusStore = depth == 0;
            while (itr.hasNext()) {
                ISPO[] chunk = (ISPO[])itr.nextChunk();
                for (int i = 0; i < chunk.length; ++i) {
                    SPO tmp;
                    SPO spo = (SPO)chunk[i];
                    assert (spo.isFullyBound());
                    if (depth == 0) assert (spo.isExplicit());
                    if (spo.getStatementType() == StatementEnum.Axiom) {
                        if (!INFO) continue;
                        log.info((Object)("Ignoring axiom in the tempStore: " + spo));
                        continue;
                    }
                    if (depth > 0 && spo.getStatementType() == StatementEnum.Explicit) {
                        throw new AssertionError((Object)("Explicit statement in the tempStore at depth=" + depth + ", " + spo.toString(this.database)));
                    }
                    if (this.database.isAxiom(spo.s(), spo.p(), spo.o())) {
                        tmp = new SPO(spo.s(), spo.p(), spo.o(), StatementEnum.Axiom);
                        tmp.setOverride(true);
                        downgradeBuffer.add(tmp, null);
                        if (!INFO) continue;
                        log.info((Object)("Downgrading to axiom: " + spo.toString(this.database)));
                        continue;
                    }
                    if (depth == 0 && Justification.isGrounded(this.inferenceEngine, tempStore, this.database, spo, testHead, testFocusStore)) {
                        tmp = new SPO(spo.s, spo.p, spo.o, StatementEnum.Inferred);
                        tmp.setOverride(true);
                        downgradeBuffer.add(tmp, null);
                        if (!INFO) continue;
                        log.info((Object)("Downgrading to inferred: " + spo.toString(this.database)));
                        continue;
                    }
                    if (depth > 0 && Justification.isGrounded(this.inferenceEngine, tempStore, this.database, spo, testHead, testFocusStore)) {
                        if (!INFO) continue;
                        log.info((Object)(spo.toString(this.database) + " is grounded"));
                        continue;
                    }
                    if (!this.database.hasStatement(spo.s, spo.p, spo.o)) {
                        if (!INFO) continue;
                        log.info((Object)("Statement not in database: " + spo.toString(this.database)));
                        continue;
                    }
                    retractionBuffer.add(spo);
                    if (INFO) {
                        log.info((Object)("Retracting: " + spo.toString(this.database)));
                    }
                    ungroundedBuffer.add(spo);
                }
            }
            ndowngraded = downgradeBuffer.flush();
            nretracted = retractionBuffer.flush();
            int nungrounded = ungroundedBuffer.flush();
            if (INFO) {
                log.info((Object)("#downgraded=" + ndowngraded + ", #retracted=" + nretracted + ", #ungrounded=" + nungrounded));
            }
        }
        tempStore.close();
        if (nretracted == 0L && ndowngraded == 0L) {
            log.info((Object)"Done - nothing was retracted from the database");
            return;
        }
        if (DEBUG && this.database.getStatementCount() < 200L) {
            log.debug((Object)("dumping database after retraction: depth=" + depth + "\n" + this.database.dumpStore(this.database, true, true, false, true)));
        }
        if ((focusStoreCount = focusStore.getStatementCount()) == 0L) {
            log.info((Object)"Done - focus store is empty after retraction.");
            return;
        }
        SPOArrayIterator tmp = new SPOArrayIterator(focusStore, focusStore.getAccessPath(SPOKeyOrder.SPO), 0, null);
        if (DEBUG && this.database.getStatementCount() < 200L) {
            log.debug((Object)("focusStore before closure: depth=" + depth + "\n" + focusStore.dumpStore(this.database, true, true, false, true)));
        }
        stats.add(this.inferenceEngine.computeClosure(focusStore, false));
        if (DEBUG && this.database.getStatementCount() < 200L) {
            log.debug((Object)("focusStore after closure: depth=" + depth + "\n" + focusStore.dumpStore(this.database, true, true, false, true)));
        }
        long nremoved = focusStore.removeStatements(tmp, false);
        if (DEBUG && this.database.getStatementCount() < 200L) {
            log.debug((Object)("focusStore after subtracting out tmp: depth=" + depth + "\n" + focusStore.dumpStore(this.database, true, true, false, true)));
        }
        if (INFO) {
            log.info((Object)("removed " + nremoved + " from focusStore"));
        }
        if (focusStore.getAccessPath(SPOKeyOrder.SPO).isEmpty()) {
            log.info((Object)"Done - closure of focusStore produced no entailments to consider.");
            return;
        }
        this.retractAll(stats, focusStore, depth + 1, changeLog);
    }
}

