/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.inf.IJustificationIterator;
import com.bigdata.rdf.inf.Justification;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class JustificationIterator
implements IJustificationIterator {
    private static final transient Logger log = Logger.getLogger(JustificationIterator.class);
    private static final transient int MAXIMUM_CAPACITY = 10240;
    private boolean open = true;
    private final int capacity;
    private int numBuffered;
    private int numReadByCaller;
    private int nchunks = 0;
    private ArrayBlockingQueue<Justification> buffer;
    private ITupleIterator<?> src;
    private final FutureTask<Object> ft;
    private final AtomicBoolean readerDone = new AtomicBoolean(false);
    private static final int MIN_CHUNK_SIZE = 100;

    public JustificationIterator(IIndexManager indexManager, IIndex ndx, int capacity) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        if (ndx == null) {
            throw new IllegalArgumentException();
        }
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        boolean async = true;
        long rangeCount = ndx.rangeCount();
        if (capacity == 0) {
            capacity = capacity > 10240 || rangeCount > 10240L ? 10240 : (int)rangeCount;
        } else if ((long)capacity > rangeCount) {
            capacity = (int)rangeCount;
            async = false;
        }
        if (rangeCount < 100L) {
            async = false;
        }
        if (capacity == 0) {
            capacity = 1;
        }
        this.capacity = capacity;
        this.src = ndx.rangeIterator(null, null, 0, 1, null);
        this.buffer = new ArrayBlockingQueue(capacity);
        if (async) {
            this.ft = new FutureTask<Object>(new Reader());
            indexManager.getExecutorService().submit(this.ft);
        } else {
            this.ft = null;
            this.fillBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fillBuffer() {
        boolean bl;
        this.assertOpen();
        if (this.ft != null) {
            throw new AssertionError();
        }
        try {
            while (this.src.hasNext() && this.buffer.remainingCapacity() > 0) {
                Justification jst = (Justification)this.src.next().getObject();
                try {
                    this.buffer.put(jst);
                    ++this.numBuffered;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            boolean bl2 = bl = !this.buffer.isEmpty();
        }
        catch (Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("(Re-)filled buffer: size=" + this.buffer.size() + ", remainingCapacity=" + this.buffer.remainingCapacity() + ", done=" + !this.src.hasNext()));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("(Re-)filled buffer: size=" + this.buffer.size() + ", remainingCapacity=" + this.buffer.remainingCapacity() + ", done=" + !this.src.hasNext()));
        }
        return bl;
    }

    public boolean hasNext() {
        if (!this.open) {
            return false;
        }
        if (this.buffer.isEmpty()) {
            if (this.ft != null) {
                this.awaitReader();
            } else {
                this.fillBuffer();
            }
            if (this.buffer.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Justification next() {
        Justification t;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            t = this.buffer.take();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        ++this.numReadByCaller;
        return t;
    }

    public Justification[] nextChunk() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.ft != null) {
            this.awaitReader();
        }
        int n = this.buffer.size();
        Justification[] stmts = new Justification[n];
        for (int i = 0; i < n; ++i) {
            stmts[i] = this.next();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("chunkSize=" + n + ", nchunks=" + this.nchunks + ", #read(caller)=" + this.numReadByCaller + ", #read(src)=" + this.numBuffered));
        }
        return stmts;
    }

    private void awaitReader() {
        int N;
        if (this.ft == null) {
            throw new AssertionError();
        }
        int n = N = this.capacity < 100 ? this.capacity : 100;
        while (this.buffer.size() < N && !this.readerDone.get()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public void remove() {
        this.assertOpen();
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (!this.open) {
            return;
        }
        log.debug((Object)"Closing iterator");
        this.open = false;
        if (this.ft != null) {
            this.ft.cancel(true);
        }
        this.buffer.clear();
        this.buffer = null;
        this.src = null;
    }

    private final void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException();
        }
    }

    private class Reader
    implements Callable<Object> {
        private Reader() {
        }

        @Override
        public Object call() throws Exception {
            while (JustificationIterator.this.src.hasNext()) {
                Justification t = (Justification)JustificationIterator.this.src.next().getObject();
                try {
                    JustificationIterator.this.buffer.put(t);
                    JustificationIterator.this.numBuffered++;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            JustificationIterator.this.readerDone.set(true);
            return null;
        }
    }
}

