/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.aggregate;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.aggregate.AggregateBase;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.constraints.MathBOp;
import com.bigdata.rdf.internal.constraints.MathUtility;
import com.bigdata.rdf.internal.impl.literal.NumericIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import java.util.Map;
import org.openrdf.model.Literal;

public class AVERAGE
extends AggregateBase<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 1L;
    private transient NumericIV aggregated = ZERO;
    private transient long n = 0L;
    private transient Throwable firstCause = null;

    public AVERAGE(AVERAGE op) {
        super(op);
    }

    public AVERAGE(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public AVERAGE(boolean distinct, IValueExpression<IV> expr) {
        super(distinct, expr);
    }

    @Override
    public synchronized void reset() {
        this.aggregated = ZERO;
        this.n = 0L;
        this.firstCause = null;
    }

    @Override
    public synchronized IV done() {
        if (this.firstCause != null) {
            throw new RuntimeException(this.firstCause);
        }
        if (this.n == 0L) {
            return ZERO;
        }
        return MathUtility.literalMath(this.aggregated, new XSDNumericIV(this.n), MathBOp.MathOp.DIVIDE);
    }

    @Override
    public synchronized IV get(IBindingSet bindingSet) {
        try {
            return this.doGet(bindingSet);
        }
        catch (Throwable t) {
            if (this.firstCause == null) {
                this.firstCause = t;
            }
            throw new RuntimeException(t);
        }
    }

    private IV doGet(IBindingSet bindingSet) {
        IValueExpression expr = (IValueExpression)this.get(0);
        IV iv = (IV)expr.get(bindingSet);
        if (iv != null) {
            Literal lit = IVValueExpression.asLiteral(iv);
            if (!MathUtility.checkNumericDatatype(lit)) {
                throw new SparqlTypeErrorException();
            }
            this.aggregated = MathUtility.literalMath(this.aggregated, lit, MathBOp.MathOp.PLUS);
            ++this.n;
        }
        return this.aggregated;
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.ALWAYS;
    }
}

