/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.engine.IHaltOpMessage;
import com.bigdata.io.LongPacker;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;

public class HaltOpMessage
implements Externalizable,
IHaltOpMessage {
    private static final long serialVersionUID = 1L;
    private UUID queryId;
    private UUID serviceId;
    private int bopId;
    private int partitionId;
    private int sinkMessagesOut;
    private int altSinkMessagesOut;
    private BOpStats stats;
    private Throwable cause;

    public HaltOpMessage() {
    }

    public HaltOpMessage(UUID queryId, int bopId, int partitionId, UUID serviceId, Throwable cause, int sinkMessagesOut, int altSinkMessagesOut, BOpStats taskStats) {
        this.queryId = queryId;
        this.bopId = bopId;
        this.partitionId = partitionId;
        this.serviceId = serviceId;
        this.cause = cause;
        this.sinkMessagesOut = sinkMessagesOut;
        this.altSinkMessagesOut = altSinkMessagesOut;
        this.stats = taskStats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("{queryId=" + this.queryId);
        sb.append(",bopId=" + this.bopId);
        sb.append(",partitionId=" + this.partitionId);
        sb.append(",serviceId=" + this.serviceId);
        sb.append(",sinkChunksOut=" + this.sinkMessagesOut);
        sb.append(",altSinkChunksOut=" + this.altSinkMessagesOut);
        sb.append(",stats=" + this.stats);
        if (this.cause != null) {
            sb.append(",cause=" + this.cause);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public UUID getQueryId() {
        return this.queryId;
    }

    @Override
    public int getBOpId() {
        return this.bopId;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public UUID getServiceId() {
        return this.serviceId;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public int getSinkMessagesOut() {
        return this.sinkMessagesOut;
    }

    @Override
    public int getAltSinkMessagesOut() {
        return this.altSinkMessagesOut;
    }

    @Override
    public BOpStats getStats() {
        return this.stats;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.queryId.getMostSignificantBits());
        out.writeLong(this.queryId.getLeastSignificantBits());
        out.writeLong(this.serviceId.getMostSignificantBits());
        out.writeLong(this.serviceId.getLeastSignificantBits());
        out.writeInt(this.bopId);
        out.writeInt(this.partitionId);
        LongPacker.packLong(out, (long)this.sinkMessagesOut);
        LongPacker.packLong(out, (long)this.altSinkMessagesOut);
        out.writeObject(this.stats);
        out.writeObject(this.cause);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.queryId = new UUID(in.readLong(), in.readLong());
        this.serviceId = new UUID(in.readLong(), in.readLong());
        this.bopId = in.readInt();
        this.partitionId = in.readInt();
        this.sinkMessagesOut = LongPacker.unpackInt(in);
        this.altSinkMessagesOut = LongPacker.unpackInt(in);
        this.stats = (BOpStats)in.readObject();
        this.cause = (Throwable)in.readObject();
    }
}

