# fsleyes-plugin-mrs
An [FSLeyes](https://fsl.fmrib.ox.ac.uk/fsl/fslwiki/FSLeyes) plugin for viewing the [NIfTI-MRS](https://github.com/wexeee/mrs_nifti_standard/) format.

This plugin adds an additional MRS specific view panel to FSLeyes which displays spectra in the frequency domain. Higher dimensions of data stored in NIfTI-MRS format may be explored.

This plugin also loads and displays results from FSL-MRS's mrsi fitting routine `fsl_mrsi`. The plugin displays the spectral fit for each voxel and creates an interface for loading output metabolite maps easily.

## Installation
Relies on [FSLeyes](https://fsl.fmrib.ox.ac.uk/fsl/fslwiki/FSLeyes) (version >= 1.0.10). This package must be installed in the same environment as FSLeyes is run from.

Install using conda, pip, or by cloning this repository. For full installation instructions please see the [documentation](https://open.win.ox.ac.uk/pages/wclarke/fsleyes-plugin-mrs/install.html).

### Conda
After activating the target environment run

    conda install -c conda-forge fsleyes-plugin-mrs

### PyPI

    pip install fsleyes-plugin-mrs

### Cloning from git

    git clone https://git.fmrib.ox.ac.uk/wclarke/fsleyes-plugin-mrs
    cd fsleyes-plugin-mrs
    pip install .

## Quick start guide
For full instructions please see the [documentation](https://open.win.ox.ac.uk/pages/wclarke/fsleyes-plugin-mrs/index.html).

### NIfTI-MRS viewer
Start the dedicated MRSView by selecting `MRSView` in the `View` menu.

Once open the NIfTI-MRS dimension selector can be opened by clicking the ![](fsleyes_plugin_mrs/icons/nifti_mrs_icon-mrs_icon_highlight_thumb24.png) icon.

Alternatively, a built-in MRS layout can be loaded from the `View - Layouts` menu, or the command line using:
    
    fsleyes -smrs ...

for example with data

    fsleyes -smrs t1.nii.gz svs.nii.gz

### MRSI results viewer
A results folder generated by FSL-MRS's `fsl_mrsi` script can be loaded by using the `Tools - Load FSL-MRS fit` menu item.

The spectral fit, baseline, and residual is displayed in the MRSView. Metabolite maps and QC metrics can be loaded using the `FSL-MRS Results` panel added to the bottom of the orthographic view.

## Acknowledgements and referencing
If you use this tool in your research please cite: TBC

Thanks to Paul McCarthy for his significant input into development of this plugin.
