"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

# A log message and metadata. Logs come in a few different forms:
#
#  1. A tokenized log message (recommended for production)
#  2. A non-tokenized log message (good for development)
#  3. A "log missed" tombstone, indicating that some logs were dropped
#
# Size analysis for tokenized log messages, including each field's proto tag:
#
#  - message     - 6-12 bytes, depending on number and value of arguments
#  - line_level  - 3 bytes; 4 bytes if line > 2048 (uncommon)
#  - timestamp   - 3 bytes; assuming delta encoding
#  - thread_name - 6 bytes
#
# Adding the fields gives the total proto message size:
#
#    6-12 bytes - log
#    9-15 bytes - log + level + line
#   12-18 bytes - log + level + line + timestamp
#
# An analysis of a project's log token database revealed the following
# distribution of the number of arguments to log messages:
#
#   # args   # messages
#     0         2,700
#     1         2,400
#     2         1,200
#     3+        1,000
#
# Note: The below proto makes some compromises compared to what one might
# expect for a "clean" proto design, in order to shave bytes off of the
# messages. It is critical that the log messages are as small as possible to
# enable storing more logs in limited memory. This is why, for example, there
# is no separate "DroppedLog" type, or a "TokenizedLog" and "StringLog", which
# would add at least 2 extra bytes per message
class LogEntry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    MESSAGE_FIELD_NUMBER: builtins.int
    LINE_LEVEL_FIELD_NUMBER: builtins.int
    FLAGS_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    TIME_SINCE_LAST_ENTRY_FIELD_NUMBER: builtins.int
    DROPPED_FIELD_NUMBER: builtins.int
    MODULE_FIELD_NUMBER: builtins.int
    # The log message, which may be tokenized.
    #
    # If tokenized logging is used, implementations may encode metadata in the
    # log message rather than as separate proto fields. This reduces the size of
    # the protobuf with no overhead.
    #
    # The standard format for encoding metadata in the log message is defined by
    # the pw_log_tokenized module. The message and metadata are encoded as
    # key-value pairs using ■ and ♦ as delimiters. For example:
    #
    #  ■msg♦This is the log message: %d■module♦wifi■file♦../path/to/file.cc
    #
    # See http://pigweed.dev/pw_log_tokenized for full details. When
    # pw_log_tokenized is used, this metadata is automatically included as
    # described.
    #
    # The level and flags are not included since they may be runtime values and
    # thus cannot always be tokenized. The line number is not included because
    # line numbers change frequently and a new token is created for each line.
    #
    # Size analysis when tokenized:
    #
    #   tag+wire = 1 byte
    #   size     = 1 byte; payload will almost always be < 127 bytes
    #   payload  = N bytes; typically 4-10 in practice
    #
    # Total: 2 + N ~= 6-12 bytes
    message: builtins.bytes = ...
    # Packed log level and line number. Structure:
    #
    #   Level: Bottom 3 bits; level = line_level & 0x7
    #   Line: Remaining bits; line = (line_level >> 3)
    #
    # Note: This packing saves two bytes per log message in most cases compared
    # to having line and level separately; and is zero-cost if the log backend
    # omits the line number.
    line_level: builtins.int = ...
    # Some log messages have flags to indicate attributes such as whether they
    # are from an assert or if they contain PII. The particular flags are
    # product- and implementation-dependent.
    flags: builtins.int = ...
    # The absolute timestamp in implementation-defined ticks. Applications
    # determine how to interpret this on the receiving end. In the simplest
    # case, these ticks might be milliseconds or microseconds since boot.
    # Applications could also access clock information out-of-band with a
    # ClockParameters protobuf.
    timestamp: builtins.int = ...
    # Time since the last entry in implementation-defined ticks, as for the
    # timestamp field. This enables delta encoding when batching entries
    # together.
    #
    # Size analysis for this field including tag and varint, assuming 1 kHz
    # ticks:
    #
    #           < 127 ms gap == 127 ms      ==  7 bits == 2 bytes
    #        < 16,000 ms gap ==  16 seconds == 14 bits == 3 bytes
    #     < 2,000,000 ms gap ==  35 minutes == 21 bits == 4 bytes
    #   < 300,000,000 ms gap ==  74 hours   == 28 bits == 5 bytes
    #
    # Log bursts will thus consume just 2 bytes (tag + up to 127ms delta) for
    # the timestamp, which is a good improvement over an absolute timestamp.
    time_since_last_entry: builtins.int = ...
    # When the log buffers are full but more logs come in, the logs are counted
    # and a special log message is omitted with only counts for the number of
    # messages dropped.
    dropped: builtins.int = ...
    # The PW_LOG_MODULE_NAME for this log message.
    module: builtins.bytes = ...
    def __init__(self,
        *,
        message : builtins.bytes = ...,
        line_level : builtins.int = ...,
        flags : builtins.int = ...,
        timestamp : builtins.int = ...,
        time_since_last_entry : builtins.int = ...,
        dropped : builtins.int = ...,
        module : builtins.bytes = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"_dropped",b"_dropped",u"_flags",b"_flags",u"_line_level",b"_line_level",u"_message",b"_message",u"_module",b"_module",u"dropped",b"dropped",u"flags",b"flags",u"line_level",b"line_level",u"message",b"message",u"module",b"module",u"time",b"time",u"time_since_last_entry",b"time_since_last_entry",u"timestamp",b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"_dropped",b"_dropped",u"_flags",b"_flags",u"_line_level",b"_line_level",u"_message",b"_message",u"_module",b"_module",u"dropped",b"dropped",u"flags",b"flags",u"line_level",b"line_level",u"message",b"message",u"module",b"module",u"time",b"time",u"time_since_last_entry",b"time_since_last_entry",u"timestamp",b"timestamp"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_dropped",b"_dropped"]) -> typing.Optional[typing_extensions.Literal["dropped"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_flags",b"_flags"]) -> typing.Optional[typing_extensions.Literal["flags"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_line_level",b"_line_level"]) -> typing.Optional[typing_extensions.Literal["line_level"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_message",b"_message"]) -> typing.Optional[typing_extensions.Literal["message"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_module",b"_module"]) -> typing.Optional[typing_extensions.Literal["module"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"time",b"time"]) -> typing.Optional[typing_extensions.Literal["timestamp","time_since_last_entry"]]: ...
global___LogEntry = LogEntry

# This will include fields for configuring log filtering.
class LogRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    def __init__(self,
        ) -> None: ...
global___LogRequest = LogRequest

class LogEntries(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    ENTRIES_FIELD_NUMBER: builtins.int
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LogEntry]: ...
    def __init__(self,
        *,
        entries : typing.Optional[typing.Iterable[global___LogEntry]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"entries",b"entries"]) -> None: ...
global___LogEntries = LogEntries

class FilterRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    # Log level values match pw_log/levels.h. Enum names avoid collissions with
    # possible macros.
    class Level(_Level, metaclass=_LevelEnumTypeWrapper):
        pass
    class _Level:
        V = typing.NewType('V', builtins.int)
    class _LevelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Level.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        ANY_LEVEL = FilterRule.Level.V(0)
        DEBUG_LEVEL = FilterRule.Level.V(1)
        INFO_LEVEL = FilterRule.Level.V(2)
        WARN_LEVEL = FilterRule.Level.V(3)
        ERROR_LEVEL = FilterRule.Level.V(4)
        CRITICAL_LEVEL = FilterRule.Level.V(5)
        FATAL_LEVEL = FilterRule.Level.V(7)

    ANY_LEVEL = FilterRule.Level.V(0)
    DEBUG_LEVEL = FilterRule.Level.V(1)
    INFO_LEVEL = FilterRule.Level.V(2)
    WARN_LEVEL = FilterRule.Level.V(3)
    ERROR_LEVEL = FilterRule.Level.V(4)
    CRITICAL_LEVEL = FilterRule.Level.V(5)
    FATAL_LEVEL = FilterRule.Level.V(7)

    # Action to take if all conditions are met and rule is not inactive.
    class Action(_Action, metaclass=_ActionEnumTypeWrapper):
        pass
    class _Action:
        V = typing.NewType('V', builtins.int)
    class _ActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Action.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        # Ignore the rule entirely.
        INACTIVE = FilterRule.Action.V(0)
        # Keep the log entry if all conditions are met.
        KEEP = FilterRule.Action.V(1)
        # Drop the log entry if all conditions are met
        DROP = FilterRule.Action.V(2)

    # Ignore the rule entirely.
    INACTIVE = FilterRule.Action.V(0)
    # Keep the log entry if all conditions are met.
    KEEP = FilterRule.Action.V(1)
    # Drop the log entry if all conditions are met
    DROP = FilterRule.Action.V(2)

    LEVEL_GREATER_THAN_OR_EQUAL_FIELD_NUMBER: builtins.int
    MODULE_EQUALS_FIELD_NUMBER: builtins.int
    ANY_FLAGS_SET_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    # Condition 1: log.level >= level_greater_than_or_equal.
    level_greater_than_or_equal: global___FilterRule.Level.V = ...
    # Condition 2: (module_equals.size() == 0) || (log.module == module_equals);
    module_equals: builtins.bytes = ...
    # Condition 3: (any_flags_set == 0) || (log.flags & any_flags_set) != 0))
    any_flags_set: builtins.int = ...
    action: global___FilterRule.Action.V = ...
    def __init__(self,
        *,
        level_greater_than_or_equal : global___FilterRule.Level.V = ...,
        module_equals : builtins.bytes = ...,
        any_flags_set : builtins.int = ...,
        action : global___FilterRule.Action.V = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"action",b"action",u"any_flags_set",b"any_flags_set",u"level_greater_than_or_equal",b"level_greater_than_or_equal",u"module_equals",b"module_equals"]) -> None: ...
global___FilterRule = FilterRule

# A filter is a series of rules. First matching rule wins.
class Filter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    RULE_FIELD_NUMBER: builtins.int
    @property
    def rule(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FilterRule]: ...
    def __init__(self,
        *,
        rule : typing.Optional[typing.Iterable[global___FilterRule]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"rule",b"rule"]) -> None: ...
global___Filter = Filter

class SetFilterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    FILTER_ID_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    # A filter can be identified by a human readable string, token, or number.
    filter_id: builtins.bytes = ...
    @property
    def filter(self) -> global___Filter: ...
    def __init__(self,
        *,
        filter_id : builtins.bytes = ...,
        filter : typing.Optional[global___Filter] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"filter",b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"filter",b"filter",u"filter_id",b"filter_id"]) -> None: ...
global___SetFilterRequest = SetFilterRequest

class GetFilterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    FILTER_ID_FIELD_NUMBER: builtins.int
    filter_id: builtins.bytes = ...
    def __init__(self,
        *,
        filter_id : builtins.bytes = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"filter_id",b"filter_id"]) -> None: ...
global___GetFilterRequest = GetFilterRequest

class FilterIdListRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    def __init__(self,
        ) -> None: ...
global___FilterIdListRequest = FilterIdListRequest

class FilterIdListResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    FILTER_ID_FIELD_NUMBER: builtins.int
    @property
    def filter_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bytes]: ...
    def __init__(self,
        *,
        filter_id : typing.Optional[typing.Iterable[builtins.bytes]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"filter_id",b"filter_id"]) -> None: ...
global___FilterIdListResponse = FilterIdListResponse
