## django-versionlog 代码结构

----

```bash
├─ docs
├─ version_log
│  ├─ templates
│  ├─ static
│  ├─ migrations
│  ├─ __init__.py
│  ├─ apps.py
│  ├─ config.py
│  ├─ decorators.py
│  ├─ middleware.py
│  ├─ models.py
│  ├─ urls.py
│  ├─ utils.py
│  └─ views.py
```

* docs: 项目文档
* version_log: 源码
  * templates: 模版文件
  * static: 静态文件
  * migrations: 迁移文件
  * apps.py: app信息
  * config.py: 配置项
  * decorators.py: 装饰器
  * middleware.py: 中间件
  * models.py: 数据模型
  * urls.py: 路由配置
  * utils.py: 工具函数
  * views.py: 视图函数
