from ....Internal.Core import Core
from ....Internal.CommandsGroup import CommandsGroup
from ....Internal import Conversions


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Path:
	"""Path commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("path", core, parent)

	def get_count(self) -> int:
		"""[SOURce]:BB:PATH:COUNt \n
		No command help available \n
			:return: count: No help available
		"""
		response = self._core.io.query_str('SOURce:BB:PATH:COUNt?')
		return Conversions.str_to_int(response)
