from ............Internal.Core import Core
from ............Internal.CommandsGroup import CommandsGroup
from ............Internal import Conversions
from ............ import enums
from ............ import repcap


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class BbSet1:
	"""BbSet1 commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("bbSet1", core, parent)

	def set(self, dl_bwp_bundle_set_1: enums.PrbBundleSizeSet1, channel=repcap.Channel.Default, stream=repcap.Stream.Default, numSuffix=repcap.NumSuffix.Default) -> None:
		"""[SOURce<HW>]:BB:NR5G:UBWP:USER<CH>:CELL<ST>:DL:BWP<DIR>:PDSCh:PREC:BBSet1 \n
		Configures the dynamic PRB bundle type. Only available if 'Precoding' is enabled and 'Dynamic' is selected as 'PRB
		Bundling Type'. \n
			:param dl_bwp_bundle_set_1: N4| WIDeband| N2WB| N4WB N4 Default value. Dynamic PRB bundle size set 1 is set to N4. WIDeband Dynamic PRB bundle size set 1 is set to wideband. N2WB Dynamic PRB bundle size set 1 is set to N2-wideband. N4WB Dynamic PRB bundle size set 1 is set to N4-wideband.
			:param channel: optional repeated capability selector. Default value: Nr1 (settable in the interface 'User')
			:param stream: optional repeated capability selector. Default value: Nr1 (settable in the interface 'Cell')
			:param numSuffix: optional repeated capability selector. Default value: Nr0 (settable in the interface 'Bwp')"""
		param = Conversions.enum_scalar_to_str(dl_bwp_bundle_set_1, enums.PrbBundleSizeSet1)
		channel_cmd_val = self._base.get_repcap_cmd_value(channel, repcap.Channel)
		stream_cmd_val = self._base.get_repcap_cmd_value(stream, repcap.Stream)
		numSuffix_cmd_val = self._base.get_repcap_cmd_value(numSuffix, repcap.NumSuffix)
		self._core.io.write(f'SOURce<HwInstance>:BB:NR5G:UBWP:USER{channel_cmd_val}:CELL{stream_cmd_val}:DL:BWP{numSuffix_cmd_val}:PDSCh:PREC:BBSet1 {param}')

	# noinspection PyTypeChecker
	def get(self, channel=repcap.Channel.Default, stream=repcap.Stream.Default, numSuffix=repcap.NumSuffix.Default) -> enums.PrbBundleSizeSet1:
		"""[SOURce<HW>]:BB:NR5G:UBWP:USER<CH>:CELL<ST>:DL:BWP<DIR>:PDSCh:PREC:BBSet1 \n
		Configures the dynamic PRB bundle type. Only available if 'Precoding' is enabled and 'Dynamic' is selected as 'PRB
		Bundling Type'. \n
			:param channel: optional repeated capability selector. Default value: Nr1 (settable in the interface 'User')
			:param stream: optional repeated capability selector. Default value: Nr1 (settable in the interface 'Cell')
			:param numSuffix: optional repeated capability selector. Default value: Nr0 (settable in the interface 'Bwp')
			:return: dl_bwp_bundle_set_1: N4| WIDeband| N2WB| N4WB N4 Default value. Dynamic PRB bundle size set 1 is set to N4. WIDeband Dynamic PRB bundle size set 1 is set to wideband. N2WB Dynamic PRB bundle size set 1 is set to N2-wideband. N4WB Dynamic PRB bundle size set 1 is set to N4-wideband."""
		channel_cmd_val = self._base.get_repcap_cmd_value(channel, repcap.Channel)
		stream_cmd_val = self._base.get_repcap_cmd_value(stream, repcap.Stream)
		numSuffix_cmd_val = self._base.get_repcap_cmd_value(numSuffix, repcap.NumSuffix)
		response = self._core.io.query_str(f'SOURce<HwInstance>:BB:NR5G:UBWP:USER{channel_cmd_val}:CELL{stream_cmd_val}:DL:BWP{numSuffix_cmd_val}:PDSCh:PREC:BBSet1?')
		return Conversions.str_to_scalar_enum(response, enums.PrbBundleSizeSet1)
