from .........Internal.Core import Core
from .........Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Fcorrection:
	"""Fcorrection commands group definition. 2 total commands, 1 Sub-groups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("fcorrection", core, parent)

	def clone(self) -> 'Fcorrection':
		"""Clones the group by creating new object from it and its whole existing sub-groups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Fcorrection(self._core, self._base.parent)
		self._base.synchronize_repcaps(new_group)
		return new_group

	@property
	def fixed(self):
		"""fixed commands group. 1 Sub-classes, 1 commands."""
		if not hasattr(self, '_fixed'):
			from .Fcorrection_.Fixed import Fixed
			self._fixed = Fixed(self._core, self._base)
		return self._fixed
