from ..........Internal.Core import Core
from ..........Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Harq:
	"""Harq commands group definition. 4 total commands, 4 Sub-groups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("harq", core, parent)

	def clone(self) -> 'Harq':
		"""Clones the group by creating new object from it and its whole existing sub-groups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Harq(self._core, self._base.parent)
		self._base.synchronize_repcaps(new_group)
		return new_group

	@property
	def bits(self):
		"""bits commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_bits'):
			from .Harq_.Bits import Bits
			self._bits = Bits(self._core, self._base)
		return self._bits

	@property
	def mode(self):
		"""mode commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_mode'):
			from .Harq_.Mode import Mode
			self._mode = Mode(self._core, self._base)
		return self._mode

	@property
	def nbundled(self):
		"""nbundled commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_nbundled'):
			from .Harq_.Nbundled import Nbundled
			self._nbundled = Nbundled(self._core, self._base)
		return self._nbundled

	@property
	def pattern(self):
		"""pattern commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_pattern'):
			from .Harq_.Pattern import Pattern
			self._pattern = Pattern(self._core, self._base)
		return self._pattern
