from .....Internal.Core import Core
from .....Internal.CommandsGroup import CommandsGroup
from .....Internal import Conversions


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Qhs:
	"""Qhs commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("qhs", core, parent)

	def get_state(self) -> bool:
		"""[SOURce<HW>]:BB:BTOoth:QHS:STATe \n
		No command help available \n
			:return: qhs_state: No help available
		"""
		response = self._core.io.query_str('SOURce<HwInstance>:BB:BTOoth:QHS:STATe?')
		return Conversions.str_to_bool(response)

	def set_state(self, qhs_state: bool) -> None:
		"""[SOURce<HW>]:BB:BTOoth:QHS:STATe \n
		No command help available \n
			:param qhs_state: No help available
		"""
		param = Conversions.bool_to_str(qhs_state)
		self._core.io.write(f'SOURce<HwInstance>:BB:BTOoth:QHS:STATe {param}')
