"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvaluateExpression = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const sfn = require("@aws-cdk/aws-stepfunctions");
/**
 * (experimental) A Step Functions Task to evaluate an expression.
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 * @experimental
 */
class EvaluateExpression extends sfn.TaskStateBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        this.evalFn = createEvalFn((_b = this.props.runtime) !== null && _b !== void 0 ? _b : lambda.Runtime.NODEJS_14_X, this);
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: [this.evalFn.functionArn],
                actions: ['lambda:InvokeFunction'],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        const matches = this.props.expression.match(/\$[.\[][.a-zA-Z[\]0-9-_]+/g);
        let expressionAttributeValues = {};
        if (matches) {
            expressionAttributeValues = matches.reduce((acc, m) => ({
                ...acc,
                [m]: sfn.JsonPath.stringAt(m),
            }), {});
        }
        const parameters = {
            expression: this.props.expression,
            expressionAttributeValues,
        };
        return {
            Resource: this.evalFn.functionArn,
            Parameters: sfn.FieldUtils.renderObject(parameters),
        };
    }
}
exports.EvaluateExpression = EvaluateExpression;
_a = JSII_RTTI_SYMBOL_1;
EvaluateExpression[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EvaluateExpression", version: "1.98.0" };
function createEvalFn(runtime, scope) {
    const lambdaPurpose = 'Eval';
    const nodeJsGuids = {
        [lambda.Runtime.NODEJS_14_X.name]: 'da2d1181-604e-4a45-8694-1a6abd7fe42d',
        [lambda.Runtime.NODEJS_12_X.name]: '2b81e383-aad2-44db-8aaf-b4809ae0e3b4',
        [lambda.Runtime.NODEJS_10_X.name]: 'a0d2ce44-871b-4e74-87a1-f5e63d7c3bdc',
    };
    switch (runtime) {
        case lambda.Runtime.NODEJS_14_X:
        case lambda.Runtime.NODEJS_12_X:
        case lambda.Runtime.NODEJS_10_X:
            const uuid = nodeJsGuids[runtime.name];
            if (uuid) {
                return new lambda.SingletonFunction(scope, 'EvalFunction', {
                    runtime,
                    uuid,
                    handler: 'index.handler',
                    lambdaPurpose,
                    code: lambda.Code.fromAsset(path.join(__dirname, 'eval-nodejs-handler')),
                });
            }
            break;
    }
    throw new Error(`The runtime ${runtime.name} is currently not supported.`);
}
//# sourceMappingURL=data:application/json;base64,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