import * as apigatewayv2 from '@aws-cdk/aws-apigatewayv2';
import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
import { CallApiGatewayEndpointBase } from './base';
import { CallApiGatewayEndpointBaseProps } from './base-types';
/**
 * Properties for calling an HTTP API Endpoint.
 *
 * @stability stable
 */
export interface CallApiGatewayHttpApiEndpointProps extends CallApiGatewayEndpointBaseProps {
    /**
     * API to call.
     *
     * @stability stable
     */
    readonly api: apigatewayv2.IHttpApi;
    /**
     * Name of the stage where the API is deployed to in API Gateway.
     *
     * @default '$default'
     * @stability stable
     */
    readonly stageName?: string;
}
/**
 * Call HTTP API endpoint as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 * @stability stable
 */
export declare class CallApiGatewayHttpApiEndpoint extends CallApiGatewayEndpointBase {
    private readonly props;
    /**
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig | undefined;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[] | undefined;
    /**
     * @stability stable
     */
    protected readonly apiEndpoint: string;
    /**
     * @stability stable
     */
    protected readonly arnForExecuteApi: string;
    /**
     * @stability stable
     */
    protected readonly stageName?: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: CallApiGatewayHttpApiEndpointProps);
    private getApiEndpoint;
    private getArnForExecuteApi;
}
