"""
    VRChat API Documentation


    The version of the OpenAPI document: 1.6.3
    Contact: me@ruby.js.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrchatapi.api_client import ApiClient, Endpoint as _Endpoint
from vrchatapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from vrchatapi.model.avatar import Avatar
from vrchatapi.model.create_avatar_request import CreateAvatarRequest
from vrchatapi.model.current_user import CurrentUser
from vrchatapi.model.error import Error
from vrchatapi.model.update_avatar_request import UpdateAvatarRequest


class AvatarsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_avatar_endpoint = _Endpoint(
            settings={
                'response_type': (Avatar,),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/avatars',
                'operation_id': 'create_avatar',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_avatar_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_avatar_request':
                        (CreateAvatarRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_avatar_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_avatar_endpoint = _Endpoint(
            settings={
                'response_type': (Avatar,),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/avatars/{avatarId}',
                'operation_id': 'delete_avatar',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'avatar_id',
                ],
                'required': [
                    'avatar_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'avatar_id':
                        (str,),
                },
                'attribute_map': {
                    'avatar_id': 'avatarId',
                },
                'location_map': {
                    'avatar_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_avatar_endpoint = _Endpoint(
            settings={
                'response_type': (Avatar,),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/avatars/{avatarId}',
                'operation_id': 'get_avatar',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'avatar_id',
                ],
                'required': [
                    'avatar_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'avatar_id':
                        (str,),
                },
                'attribute_map': {
                    'avatar_id': 'avatarId',
                },
                'location_map': {
                    'avatar_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_favorited_avatars_endpoint = _Endpoint(
            settings={
                'response_type': ([Avatar],),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/avatars/favorites',
                'operation_id': 'get_favorited_avatars',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'featured',
                    'sort',
                    'n',
                    'order',
                    'offset',
                    'search',
                    'tag',
                    'notag',
                    'release_status',
                    'max_unity_version',
                    'min_unity_version',
                    'platform',
                    'user_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                    'release_status',
                ],
                'validation': [
                    'n',
                    'offset',
                ]
            },
            root_map={
                'validations': {
                    ('n',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('offset',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "POPULARITY": "popularity",
                        "HEAT": "heat",
                        "TRUST": "trust",
                        "SHUFFLE": "shuffle",
                        "RANDOM": "random",
                        "FAVORITES": "favorites",
                        "REPORTSCORE": "reportScore",
                        "REPORTCOUNT": "reportCount",
                        "PUBLICATIONDATE": "publicationDate",
                        "LABSPUBLICATIONDATE": "labsPublicationDate",
                        "CREATED": "created",
                        "_CREATED_AT": "_created_at",
                        "UPDATED": "updated",
                        "_UPDATED_AT": "_updated_at",
                        "ORDER": "order",
                        "RELEVANCE": "relevance",
                        "MAGIC": "magic",
                        "NAME": "name"
                    },
                    ('order',): {

                        "ASCENDING": "ascending",
                        "DESCENDING": "descending"
                    },
                    ('release_status',): {

                        "PUBLIC": "public",
                        "PRIVATE": "private",
                        "HIDDEN": "hidden",
                        "ALL": "all"
                    },
                },
                'openapi_types': {
                    'featured':
                        (str,),
                    'sort':
                        (str,),
                    'n':
                        (int,),
                    'order':
                        (str,),
                    'offset':
                        (int,),
                    'search':
                        (str,),
                    'tag':
                        (str,),
                    'notag':
                        (str,),
                    'release_status':
                        (str,),
                    'max_unity_version':
                        (str,),
                    'min_unity_version':
                        (str,),
                    'platform':
                        (str,),
                    'user_id':
                        (str,),
                },
                'attribute_map': {
                    'featured': 'featured',
                    'sort': 'sort',
                    'n': 'n',
                    'order': 'order',
                    'offset': 'offset',
                    'search': 'search',
                    'tag': 'tag',
                    'notag': 'notag',
                    'release_status': 'releaseStatus',
                    'max_unity_version': 'maxUnityVersion',
                    'min_unity_version': 'minUnityVersion',
                    'platform': 'platform',
                    'user_id': 'userId',
                },
                'location_map': {
                    'featured': 'query',
                    'sort': 'query',
                    'n': 'query',
                    'order': 'query',
                    'offset': 'query',
                    'search': 'query',
                    'tag': 'query',
                    'notag': 'query',
                    'release_status': 'query',
                    'max_unity_version': 'query',
                    'min_unity_version': 'query',
                    'platform': 'query',
                    'user_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.search_avatars_endpoint = _Endpoint(
            settings={
                'response_type': ([Avatar],),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/avatars',
                'operation_id': 'search_avatars',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'featured',
                    'sort',
                    'user',
                    'user_id',
                    'n',
                    'order',
                    'offset',
                    'tag',
                    'notag',
                    'release_status',
                    'max_unity_version',
                    'min_unity_version',
                    'platform',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'user',
                    'order',
                    'release_status',
                ],
                'validation': [
                    'n',
                    'offset',
                ]
            },
            root_map={
                'validations': {
                    ('n',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('offset',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "POPULARITY": "popularity",
                        "HEAT": "heat",
                        "TRUST": "trust",
                        "SHUFFLE": "shuffle",
                        "RANDOM": "random",
                        "FAVORITES": "favorites",
                        "REPORTSCORE": "reportScore",
                        "REPORTCOUNT": "reportCount",
                        "PUBLICATIONDATE": "publicationDate",
                        "LABSPUBLICATIONDATE": "labsPublicationDate",
                        "CREATED": "created",
                        "_CREATED_AT": "_created_at",
                        "UPDATED": "updated",
                        "_UPDATED_AT": "_updated_at",
                        "ORDER": "order",
                        "RELEVANCE": "relevance",
                        "MAGIC": "magic",
                        "NAME": "name"
                    },
                    ('user',): {

                        "ME": "me"
                    },
                    ('order',): {

                        "ASCENDING": "ascending",
                        "DESCENDING": "descending"
                    },
                    ('release_status',): {

                        "PUBLIC": "public",
                        "PRIVATE": "private",
                        "HIDDEN": "hidden",
                        "ALL": "all"
                    },
                },
                'openapi_types': {
                    'featured':
                        (str,),
                    'sort':
                        (str,),
                    'user':
                        (str,),
                    'user_id':
                        (str,),
                    'n':
                        (int,),
                    'order':
                        (str,),
                    'offset':
                        (int,),
                    'tag':
                        (str,),
                    'notag':
                        (str,),
                    'release_status':
                        (str,),
                    'max_unity_version':
                        (str,),
                    'min_unity_version':
                        (str,),
                    'platform':
                        (str,),
                },
                'attribute_map': {
                    'featured': 'featured',
                    'sort': 'sort',
                    'user': 'user',
                    'user_id': 'userId',
                    'n': 'n',
                    'order': 'order',
                    'offset': 'offset',
                    'tag': 'tag',
                    'notag': 'notag',
                    'release_status': 'releaseStatus',
                    'max_unity_version': 'maxUnityVersion',
                    'min_unity_version': 'minUnityVersion',
                    'platform': 'platform',
                },
                'location_map': {
                    'featured': 'query',
                    'sort': 'query',
                    'user': 'query',
                    'user_id': 'query',
                    'n': 'query',
                    'order': 'query',
                    'offset': 'query',
                    'tag': 'query',
                    'notag': 'query',
                    'release_status': 'query',
                    'max_unity_version': 'query',
                    'min_unity_version': 'query',
                    'platform': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.select_avatar_endpoint = _Endpoint(
            settings={
                'response_type': (CurrentUser,),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/avatars/{avatarId}/select',
                'operation_id': 'select_avatar',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'avatar_id',
                ],
                'required': [
                    'avatar_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'avatar_id':
                        (str,),
                },
                'attribute_map': {
                    'avatar_id': 'avatarId',
                },
                'location_map': {
                    'avatar_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.select_fallback_avatar_endpoint = _Endpoint(
            settings={
                'response_type': (CurrentUser,),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/avatars/{avatarId}/selectFallback',
                'operation_id': 'select_fallback_avatar',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'avatar_id',
                ],
                'required': [
                    'avatar_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'avatar_id':
                        (str,),
                },
                'attribute_map': {
                    'avatar_id': 'avatarId',
                },
                'location_map': {
                    'avatar_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_avatar_endpoint = _Endpoint(
            settings={
                'response_type': (Avatar,),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/avatars/{avatarId}',
                'operation_id': 'update_avatar',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'avatar_id',
                    'update_avatar_request',
                ],
                'required': [
                    'avatar_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'avatar_id':
                        (str,),
                    'update_avatar_request':
                        (UpdateAvatarRequest,),
                },
                'attribute_map': {
                    'avatar_id': 'avatarId',
                },
                'location_map': {
                    'avatar_id': 'path',
                    'update_avatar_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_avatar(
        self,
        **kwargs
    ):
        """Create Avatar  # noqa: E501

        Create an avatar. It's possible to optionally specify a ID if you want a custom one. Attempting to create an Avatar with an already claimed ID will result in a DB error.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_avatar(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            create_avatar_request (CreateAvatarRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Avatar
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.create_avatar_endpoint.call_with_http_info(**kwargs)

    def delete_avatar(
        self,
        avatar_id,
        **kwargs
    ):
        """Delete Avatar  # noqa: E501

        Delete an avatar. Notice an avatar is never fully \"deleted\", only its ReleaseStatus is set to \"hidden\" and the linked Files are deleted. The AvatarID is permanently reserved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_avatar(avatar_id, async_req=True)
        >>> result = thread.get()

        Args:
            avatar_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Avatar
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['avatar_id'] = \
            avatar_id
        return self.delete_avatar_endpoint.call_with_http_info(**kwargs)

    def get_avatar(
        self,
        avatar_id,
        **kwargs
    ):
        """Get Avatar  # noqa: E501

        Get information about a specific Avatar.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_avatar(avatar_id, async_req=True)
        >>> result = thread.get()

        Args:
            avatar_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Avatar
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['avatar_id'] = \
            avatar_id
        return self.get_avatar_endpoint.call_with_http_info(**kwargs)

    def get_favorited_avatars(
        self,
        **kwargs
    ):
        """List Favorited Avatars  # noqa: E501

        Search and list favorited avatars by query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_favorited_avatars(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            featured (str): Filters on featured results.. [optional]
            sort (str): [optional] if omitted the server will use the default value of "popularity"
            n (int): The number of objects to return.. [optional] if omitted the server will use the default value of 60
            order (str): [optional] if omitted the server will use the default value of "descending"
            offset (int): A zero-based offset from the default object sorting from where search results start.. [optional]
            search (str): Filters by world name.. [optional]
            tag (str): Tags to include (comma-separated). Any of the tags needs to be present.. [optional]
            notag (str): Tags to exclude (comma-separated).. [optional]
            release_status (str): Filter by ReleaseStatus.. [optional] if omitted the server will use the default value of "public"
            max_unity_version (str): The maximum Unity version supported by the asset.. [optional]
            min_unity_version (str): The minimum Unity version supported by the asset.. [optional]
            platform (str): The platform the asset supports.. [optional]
            user_id (str): Target user to see information on, admin-only.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Avatar]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_favorited_avatars_endpoint.call_with_http_info(**kwargs)

    def search_avatars(
        self,
        **kwargs
    ):
        """Search Avatars  # noqa: E501

        Search and list avatars by query filters. You can only search your own or featured avatars. It is not possible as a normal user to search other peoples avatars.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_avatars(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            featured (str): Filters on featured results.. [optional]
            sort (str): [optional] if omitted the server will use the default value of "popularity"
            user (str): Set to `me` for searching own avatars.. [optional] if omitted the server will use the default value of "me"
            user_id (str): Filter by UserID.. [optional]
            n (int): The number of objects to return.. [optional] if omitted the server will use the default value of 60
            order (str): [optional] if omitted the server will use the default value of "descending"
            offset (int): A zero-based offset from the default object sorting from where search results start.. [optional]
            tag (str): Tags to include (comma-separated). Any of the tags needs to be present.. [optional]
            notag (str): Tags to exclude (comma-separated).. [optional]
            release_status (str): Filter by ReleaseStatus.. [optional] if omitted the server will use the default value of "public"
            max_unity_version (str): The maximum Unity version supported by the asset.. [optional]
            min_unity_version (str): The minimum Unity version supported by the asset.. [optional]
            platform (str): The platform the asset supports.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Avatar]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.search_avatars_endpoint.call_with_http_info(**kwargs)

    def select_avatar(
        self,
        avatar_id,
        **kwargs
    ):
        """Select Avatar  # noqa: E501

        Switches into that avatar.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.select_avatar(avatar_id, async_req=True)
        >>> result = thread.get()

        Args:
            avatar_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CurrentUser
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['avatar_id'] = \
            avatar_id
        return self.select_avatar_endpoint.call_with_http_info(**kwargs)

    def select_fallback_avatar(
        self,
        avatar_id,
        **kwargs
    ):
        """Select Fallback Avatar  # noqa: E501

        Switches into that avatar as your fallback avatar.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.select_fallback_avatar(avatar_id, async_req=True)
        >>> result = thread.get()

        Args:
            avatar_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CurrentUser
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['avatar_id'] = \
            avatar_id
        return self.select_fallback_avatar_endpoint.call_with_http_info(**kwargs)

    def update_avatar(
        self,
        avatar_id,
        **kwargs
    ):
        """Update Avatar  # noqa: E501

        Update information about a specific avatar.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_avatar(avatar_id, async_req=True)
        >>> result = thread.get()

        Args:
            avatar_id (str):

        Keyword Args:
            update_avatar_request (UpdateAvatarRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Avatar
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['avatar_id'] = \
            avatar_id
        return self.update_avatar_endpoint.call_with_http_info(**kwargs)

