#include "quadrature.h"

double QUADRATURE_POINTS[98][101] = {
	{-0.7745966692414834, 0.0, 0.7745966692414834},
	{-0.8611363115940526, -0.33998104358485626, 0.33998104358485626, 0.8611363115940526},
	{-0.906179845938664, -0.5384693101056831, 0.0, 0.5384693101056831, 0.906179845938664},
	{-0.932469514203152, -0.6612093864662645, -0.23861918608319693, 0.23861918608319693, 0.6612093864662645, 0.932469514203152},
	{-0.9491079123427585, -0.7415311855993945, -0.4058451513773972, 0.0, 0.4058451513773972, 0.7415311855993945, 0.9491079123427585},
	{-0.9602898564975362, -0.7966664774136267, -0.525532409916329, -0.18343464249564978, 0.18343464249564978, 0.525532409916329, 0.7966664774136267, 0.9602898564975362},
	{-0.9681602395076261, -0.8360311073266358, -0.6133714327005904, -0.3242534234038089, 0.0, 0.3242534234038089, 0.6133714327005904, 0.8360311073266358, 0.9681602395076261},
	{-0.9739065285171717, -0.8650633666889845, -0.6794095682990244, -0.4333953941292472, -0.14887433898163122, 0.14887433898163122, 0.4333953941292472, 0.6794095682990244, 0.8650633666889845, 0.9739065285171717},
	{-0.978228658146057, -0.8870625997680953, -0.7301520055740494, -0.5190961292068118, -0.26954315595234496, 0.0, 0.26954315595234496, 0.5190961292068118, 0.7301520055740494, 0.8870625997680953, 0.978228658146057},
	{-0.9815606342467192, -0.9041172563704748, -0.7699026741943047, -0.5873179542866175, -0.3678314989981802, -0.1252334085114689, 0.1252334085114689, 0.3678314989981802, 0.5873179542866175, 0.7699026741943047, 0.9041172563704748, 0.9815606342467192},
	{-0.9841830547185881, -0.9175983992229779, -0.8015780907333099, -0.6423493394403402, -0.4484927510364468, -0.23045831595513477, 0.0, 0.23045831595513477, 0.4484927510364468, 0.6423493394403402, 0.8015780907333099, 0.9175983992229779, 0.9841830547185881},
	{-0.9862838086968123, -0.9284348836635735, -0.827201315069765, -0.6872929048116855, -0.5152486363581541, -0.31911236892788974, -0.10805494870734367, 0.10805494870734367, 0.31911236892788974, 0.5152486363581541, 0.6872929048116855, 0.827201315069765, 0.9284348836635735, 0.9862838086968123},
	{-0.9879925180204854, -0.937273392400706, -0.8482065834104272, -0.7244177313601701, -0.5709721726085388, -0.3941513470775634, -0.20119409399743451, 0.0, 0.20119409399743451, 0.3941513470775634, 0.5709721726085388, 0.7244177313601701, 0.8482065834104272, 0.937273392400706, 0.9879925180204854},
	{-0.9894009349916499, -0.9445750230732326, -0.8656312023878318, -0.755404408355003, -0.6178762444026438, -0.45801677765722737, -0.2816035507792589, -0.09501250983763745, 0.09501250983763745, 0.2816035507792589, 0.45801677765722737, 0.6178762444026438, 0.755404408355003, 0.8656312023878318, 0.9445750230732326, 0.9894009349916499},
	{-0.9905754753144174, -0.9506755217687678, -0.8802391537269859, -0.7815140038968014, -0.6576711592166908, -0.5126905370864769, -0.3512317634538763, -0.17848418149584785, 0.0, 0.17848418149584785, 0.3512317634538763, 0.5126905370864769, 0.6576711592166908, 0.7815140038968014, 0.8802391537269859, 0.9506755217687678, 0.9905754753144174},
	{-0.9915651684209309, -0.9558239495713978, -0.8926024664975557, -0.8037049589725231, -0.6916870430603532, -0.5597708310739475, -0.41175116146284263, -0.2518862256915055, -0.08477501304173529, 0.08477501304173529, 0.2518862256915055, 0.41175116146284263, 0.5597708310739475, 0.6916870430603532, 0.8037049589725231, 0.8926024664975557, 0.9558239495713978, 0.9915651684209309},
	{-0.9924068438435844, -0.96020815213483, -0.9031559036148179, -0.8227146565371428, -0.7209661773352294, -0.600545304661681, -0.46457074137596094, -0.31656409996362983, -0.1603586456402254, 0.0, 0.1603586456402254, 0.31656409996362983, 0.46457074137596094, 0.600545304661681, 0.7209661773352294, 0.8227146565371428, 0.9031559036148179, 0.96020815213483, 0.9924068438435844},
	{-0.9931285991850949, -0.9639719272779138, -0.9122344282513258, -0.8391169718222188, -0.7463319064601508, -0.636053680726515, -0.5108670019508271, -0.37370608871541955, -0.2277858511416451, -0.07652652113349734, 0.07652652113349734, 0.2277858511416451, 0.37370608871541955, 0.5108670019508271, 0.636053680726515, 0.7463319064601508, 0.8391169718222188, 0.9122344282513258, 0.9639719272779138, 0.9931285991850949},
	{-0.9937521706203895, -0.9672268385663063, -0.9200993341504008, -0.8533633645833173, -0.7684399634756779, -0.6671388041974123, -0.5516188358872198, -0.4243421202074388, -0.2880213168024011, -0.1455618541608951, 0.0, 0.1455618541608951, 0.2880213168024011, 0.4243421202074388, 0.5516188358872198, 0.6671388041974123, 0.7684399634756779, 0.8533633645833173, 0.9200993341504008, 0.9672268385663063, 0.9937521706203895},
	{-0.9942945854823992, -0.9700604978354287, -0.926956772187174, -0.8658125777203002, -0.7878168059792081, -0.6944872631866827, -0.5876404035069116, -0.46935583798675706, -0.34193582089208424, -0.2078604266882213, -0.06973927331972221, 0.06973927331972221, 0.2078604266882213, 0.34193582089208424, 0.46935583798675706, 0.5876404035069116, 0.6944872631866827, 0.7878168059792081, 0.8658125777203002, 0.926956772187174, 0.9700604978354287, 0.9942945854823992},
	{-0.9947693349975522, -0.9725424712181152, -0.9329710868260161, -0.8767523582704416, -0.8048884016188399, -0.7186613631319502, -0.6196098757636461, -0.5095014778460075, -0.3903010380302908, -0.26413568097034495, -0.1332568242984661, 0.0, 0.1332568242984661, 0.26413568097034495, 0.3903010380302908, 0.5095014778460075, 0.6196098757636461, 0.7186613631319502, 0.8048884016188399, 0.8767523582704416, 0.9329710868260161, 0.9725424712181152, 0.9947693349975522},
	{-0.9951872199970213, -0.9747285559713095, -0.9382745520027328, -0.886415527004401, -0.820001985973903, -0.7401241915785544, -0.6480936519369755, -0.5454214713888396, -0.4337935076260451, -0.3150426796961634, -0.1911188674736163, -0.06405689286260563, 0.06405689286260563, 0.1911188674736163, 0.3150426796961634, 0.4337935076260451, 0.5454214713888396, 0.6480936519369755, 0.7401241915785544, 0.820001985973903, 0.886415527004401, 0.9382745520027328, 0.9747285559713095, 0.9951872199970213},
	{-0.995556969790498, -0.9766639214595175, -0.9429745712289743, -0.8949919978782753, -0.833442628760834, -0.7592592630373576, -0.6735663684734684, -0.577662930241223, -0.473002731445715, -0.36117230580938786, -0.24386688372098841, -0.1228646926107104, 0.0, 0.1228646926107104, 0.24386688372098841, 0.36117230580938786, 0.473002731445715, 0.577662930241223, 0.6735663684734684, 0.7592592630373576, 0.833442628760834, 0.8949919978782753, 0.9429745712289743, 0.9766639214595175, 0.995556969790498},
	{-0.9958857011456169, -0.9783854459564709, -0.9471590666617142, -0.9026378619843071, -0.845445942788498, -0.7763859488206788, -0.6964272604199573, -0.6066922930176181, -0.5084407148245057, -0.4030517551234863, -0.2920048394859569, -0.17685882035689018, -0.05923009342931321, 0.05923009342931321, 0.17685882035689018, 0.2920048394859569, 0.4030517551234863, 0.5084407148245057, 0.6066922930176181, 0.6964272604199573, 0.7763859488206788, 0.845445942788498, 0.9026378619843071, 0.9471590666617142, 0.9783854459564709, 0.9958857011456169},
	{-0.9961792628889885, -0.9799234759615012, -0.9509005578147051, -0.9094823206774911, -0.8562079080182945, -0.7917716390705083, -0.7170134737394237, -0.6329079719464952, -0.540551564579457, -0.44114825175002687, -0.3359939036385089, -0.22645936543953685, -0.11397258560952997, 0.0, 0.11397258560952997, 0.22645936543953685, 0.3359939036385089, 0.44114825175002687, 0.540551564579457, 0.6329079719464952, 0.7170134737394237, 0.7917716390705083, 0.8562079080182945, 0.9094823206774911, 0.9509005578147051, 0.9799234759615012, 0.9961792628889885},
	{-0.9964424975739544, -0.9813031653708728, -0.9542592806289382, -0.9156330263921321, -0.865892522574395, -0.8056413709171791, -0.7356108780136318, -0.656651094038865, -0.5697204718114017, -0.4758742249551183, -0.3762515160890787, -0.2720616276351781, -0.1645692821333808, -0.055079289884034266, 0.055079289884034266, 0.1645692821333808, 0.2720616276351781, 0.3762515160890787, 0.4758742249551183, 0.5697204718114017, 0.656651094038865, 0.7356108780136318, 0.8056413709171791, 0.865892522574395, 0.9156330263921321, 0.9542592806289382, 0.9813031653708728, 0.9964424975739544},
	{-0.9966794422605966, -0.9825455052614132, -0.9572855957780877, -0.9211802329530587, -0.8746378049201028, -0.8181854876152524, -0.7524628517344771, -0.6782145376026865, -0.5962817971382278, -0.5075929551242276, -0.41315288817400864, -0.31403163786763993, -0.21135228616600107, -0.10627823013267923, 0.0, 0.10627823013267923, 0.21135228616600107, 0.31403163786763993, 0.41315288817400864, 0.5075929551242276, 0.5962817971382278, 0.6782145376026865, 0.7524628517344771, 0.8181854876152524, 0.8746378049201028, 0.9211802329530587, 0.9572855957780877, 0.9825455052614132, 0.9966794422605966},
	{-0.9968934840746495, -0.9836681232797473, -0.9600218649683075, -0.9262000474292743, -0.8825605357920526, -0.8295657623827684, -0.7677774321048262, -0.6978504947933158, -0.6205261829892429, -0.5366241481420199, -0.44703376953808915, -0.3527047255308781, -0.25463692616788985, -0.15386991360858354, -0.0514718425553177, 0.0514718425553177, 0.15386991360858354, 0.25463692616788985, 0.3527047255308781, 0.44703376953808915, 0.5366241481420199, 0.6205261829892429, 0.6978504947933158, 0.7677774321048262, 0.8295657623827684, 0.8825605357920526, 0.9262000474292743, 0.9600218649683075, 0.9836681232797473, 0.9968934840746495},
	{-0.997087481819477, -0.9846859096651525, -0.9625039250929497, -0.9307569978966481, -0.8897600299482711, -0.8399203201462674, -0.7817331484166249, -0.7157767845868533, -0.6427067229242603, -0.5632491614071493, -0.4781937820449025, -0.38838590160823294, -0.29471806998170164, -0.19812119933557062, -0.09955531215234152, 0.0, 0.09955531215234152, 0.19812119933557062, 0.29471806998170164, 0.38838590160823294, 0.4781937820449025, 0.5632491614071493, 0.6427067229242603, 0.7157767845868533, 0.7817331484166249, 0.8399203201462674, 0.8897600299482711, 0.9307569978966481, 0.9625039250929497, 0.9846859096651525, 0.997087481819477},
	{-0.9972638618494816, -0.9856115115452684, -0.9647622555875064, -0.9349060759377397, -0.8963211557660522, -0.84936761373257, -0.7944837959679424, -0.7321821187402897, -0.6630442669302152, -0.5877157572407623, -0.5068999089322294, -0.42135127613063533, -0.33186860228212767, -0.23928736225213706, -0.1444719615827965, -0.04830766568773831, 0.04830766568773831, 0.1444719615827965, 0.23928736225213706, 0.33186860228212767, 0.42135127613063533, 0.5068999089322294, 0.5877157572407623, 0.6630442669302152, 0.7321821187402897, 0.7944837959679424, 0.84936761373257, 0.8963211557660522, 0.9349060759377397, 0.9647622555875064, 0.9856115115452684, 0.9972638618494816},
	{-0.9974246942464552, -0.9864557262306425, -0.9668229096899927, -0.9386943726111683, -0.9023167677434336, -0.8580096526765041, -0.8061623562741667, -0.7472304964495622, -0.6817319599697428, -0.610242345836379, -0.5333899047863476, -0.45185001727245067, -0.36633925774807335, -0.27760909715249704, -0.18643929882799157, -0.0936310658547334, 0.0, 0.0936310658547334, 0.18643929882799157, 0.27760909715249704, 0.36633925774807335, 0.45185001727245067, 0.5333899047863476, 0.610242345836379, 0.6817319599697428, 0.7472304964495622, 0.8061623562741667, 0.8580096526765041, 0.9023167677434336, 0.9386943726111683, 0.9668229096899927, 0.9864557262306425, 0.9974246942464552},
	{-0.997571753790842, -0.9872278164063095, -0.9687082625333443, -0.9421623974051071, -0.9078096777183245, -0.8659346383345644, -0.8168842279009336, -0.761064876629873, -0.6989391132162629, -0.6310217270805285, -0.5578755006697467, -0.480106545190327, -0.39835927775864594, -0.3133110813394632, -0.22566669161644948, -0.13615235725918298, -0.04550982195310253, 0.04550982195310253, 0.13615235725918298, 0.22566669161644948, 0.3133110813394632, 0.39835927775864594, 0.480106545190327, 0.5578755006697467, 0.6310217270805285, 0.6989391132162629, 0.761064876629873, 0.8168842279009336, 0.8659346383345644, 0.9078096777183245, 0.9421623974051071, 0.9687082625333443, 0.9872278164063095, 0.997571753790842},
	{-0.9977065690996003, -0.9879357644438516, -0.9704376160392298, -0.9453451482078273, -0.9128542613593176, -0.8732191250252224, -0.8267498990922254, -0.7738102522869126, -0.7148145015566287, -0.6502243646658904, -0.5805453447497645, -0.5063227732414886, -0.42813754151781425, -0.346601554430814, -0.2623529412092961, -0.17605106116598956, -0.08837134327565926, 0.0, 0.08837134327565926, 0.17605106116598956, 0.2623529412092961, 0.346601554430814, 0.42813754151781425, 0.5063227732414886, 0.5805453447497645, 0.6502243646658904, 0.7148145015566287, 0.7738102522869126, 0.8267498990922254, 0.8732191250252224, 0.9128542613593176, 0.9453451482078273, 0.9704376160392298, 0.9879357644438516, 0.9977065690996003},
	{-0.9978304624840858, -0.9885864789022123, -0.972027691049698, -0.9482729843995076, -0.9174977745156591, -0.8799298008903971, -0.8358471669924753, -0.7855762301322066, -0.7294891715935566, -0.668001236585521, -0.6015676581359806, -0.5306802859262452, -0.45586394443342027, -0.37767254711968923, -0.29668499534402826, -0.2135008923168656, -0.1287361038093848, -0.04301819847370861, 0.04301819847370861, 0.1287361038093848, 0.2135008923168656, 0.29668499534402826, 0.37767254711968923, 0.45586394443342027, 0.5306802859262452, 0.6015676581359806, 0.668001236585521, 0.7294891715935566, 0.7855762301322066, 0.8358471669924753, 0.8799298008903971, 0.9174977745156591, 0.9482729843995076, 0.972027691049698, 0.9885864789022123, 0.9978304624840858},
	{-0.9979445824779136, -0.9891859632143192, -0.9734930300564858, -0.9509723432620948, -0.9217814374124638, -0.8861249621554861, -0.844252987340556, -0.7964592005099023, -0.7430788339819653, -0.6844863091309593, -0.6210926084089244, -0.5533423918615817, -0.48171087780320554, -0.40670050931832613, -0.328837429883707, -0.24866779279136575, -0.16675393023985197, -0.0836704089547699, 0.0, 0.0836704089547699, 0.16675393023985197, 0.24866779279136575, 0.328837429883707, 0.40670050931832613, 0.48171087780320554, 0.5533423918615817, 0.6210926084089244, 0.6844863091309593, 0.7430788339819653, 0.7964592005099023, 0.844252987340556, 0.8861249621554861, 0.9217814374124638, 0.9509723432620948, 0.9734930300564858, 0.9891859632143192, 0.9979445824779136},
	{-0.9980499305356876, -0.9897394542663855, -0.9748463285901535, -0.9534663309335296, -0.9257413320485843, -0.8918557390046322, -0.8520350219323621, -0.8065441676053169, -0.7556859037539707, -0.6997986803791844, -0.6392544158296817, -0.5744560210478071, -0.5058347179279311, -0.4338471694323765, -0.358972440479435, -0.28170880979016527, -0.2025704538921167, -0.12208402533786741, -0.04078514790457824, 0.04078514790457824, 0.12208402533786741, 0.2025704538921167, 0.28170880979016527, 0.358972440479435, 0.4338471694323765, 0.5058347179279311, 0.5744560210478071, 0.6392544158296817, 0.6997986803791844, 0.7556859037539707, 0.8065441676053169, 0.8520350219323621, 0.8918557390046322, 0.9257413320485843, 0.9534663309335296, 0.9748463285901535, 0.9897394542663855, 0.9980499305356876},
	{-0.9981473830664329, -0.990251536854686, -0.9760987093334711, -0.9557752123246522, -0.9294091484867382, -0.8971671192929929, -0.8592529379999062, -0.8159062974301431, -0.7674012429310635, -0.7140444358945347, -0.656173213432011, -0.594153454957278, -0.5283772686604374, -0.45926051230913606, -0.38724016397156147, -0.3127715592481859, -0.23632551246183575, -0.1583853399978378, -0.07944380460875547, 0.0, 0.07944380460875547, 0.1583853399978378, 0.23632551246183575, 0.3127715592481859, 0.38724016397156147, 0.45926051230913606, 0.5283772686604374, 0.594153454957278, 0.656173213432011, 0.7140444358945347, 0.7674012429310635, 0.8159062974301431, 0.8592529379999062, 0.8971671192929929, 0.9294091484867382, 0.9557752123246522, 0.9760987093334711, 0.990251536854686, 0.9981473830664329},
	{-0.9982377097105593, -0.9907262386994571, -0.9772599499837743, -0.9579168192137917, -0.9328128082786765, -0.9020988069688743, -0.8659595032122596, -0.8246122308333117, -0.7783056514265194, -0.7273182551899271, -0.6719566846141796, -0.6125538896679803, -0.5494671250951282, -0.4830758016861787, -0.413779204371605, -0.3419940908257585, -0.2681521850072537, -0.1926975807013711, -0.11608407067525521, -0.038772417506050816, 0.038772417506050816, 0.11608407067525521, 0.1926975807013711, 0.2681521850072537, 0.3419940908257585, 0.413779204371605, 0.4830758016861787, 0.5494671250951282, 0.6125538896679803, 0.6719566846141796, 0.7273182551899271, 0.7783056514265194, 0.8246122308333117, 0.8659595032122596, 0.9020988069688743, 0.9328128082786765, 0.9579168192137917, 0.9772599499837743, 0.9907262386994571, 0.9982377097105593},
	{-0.9983215885747715, -0.9911671096990163, -0.9783386735610834, -0.9599068917303463, -0.9359769874978539, -0.9066859447581012, -0.8722015116924414, -0.8327212004013613, -0.7884711450474093, -0.7397048030699263, -0.6867015020349513, -0.6297648390721963, -0.5692209416102159, -0.5054165991994061, -0.43871727705140706, -0.36950502264048146, -0.2981762773418249, -0.22513960563342278, -0.15081335486399217, -0.075623258989163, 0.0, 0.075623258989163, 0.15081335486399217, 0.22513960563342278, 0.2981762773418249, 0.36950502264048146, 0.43871727705140706, 0.5054165991994061, 0.5692209416102159, 0.6297648390721963, 0.6867015020349513, 0.7397048030699263, 0.7884711450474093, 0.8327212004013613, 0.8722015116924414, 0.9066859447581012, 0.9359769874978539, 0.9599068917303463, 0.9783386735610834, 0.9911671096990163, 0.9983215885747715},
	{-0.9983996189900625, -0.9915772883408609, -0.9793425080637482, -0.9617593653382045, -0.9389235573549881, -0.9109597249041275, -0.8780205698121728, -0.8402859832618169, -0.7979620532554874, -0.7512799356894805, -0.7004945905561712, -0.6458833888692479, -0.5877445974851093, -0.5263957499311923, -0.46217191207042196, -0.39542385204297503, -0.3265161244654115, -0.25582507934287907, -0.18373680656485455, -0.11064502720851986, -0.03694894316535177, 0.03694894316535177, 0.11064502720851986, 0.18373680656485455, 0.25582507934287907, 0.3265161244654115, 0.39542385204297503, 0.46217191207042196, 0.5263957499311923, 0.5877445974851093, 0.6458833888692479, 0.7004945905561712, 0.7512799356894805, 0.7979620532554874, 0.8402859832618169, 0.8780205698121728, 0.9109597249041275, 0.9389235573549881, 0.9617593653382045, 0.9793425080637482, 0.9915772883408609, 0.9983996189900625},
	{-0.9984723322425076, -0.9919595575932442, -0.9802782209802554, -0.96348661301408, -0.9416719568476378, -0.9149479072061387, -0.8834537652186168, -0.8473537162093151, -0.8068359641369386, -0.7621117471949551, -0.7134142352689571, -0.6609973137514982, -0.605134259639601, -0.5461163166600848, -0.4842511767857347, -0.41986137602926926, -0.3532826128643038, -0.2848619980329136, -0.2149562448605182, -0.1439298095107133, -0.07215299087458624, 0.0, 0.07215299087458624, 0.1439298095107133, 0.2149562448605182, 0.2848619980329136, 0.3532826128643038, 0.41986137602926926, 0.4842511767857347, 0.5461163166600848, 0.605134259639601, 0.6609973137514982, 0.7134142352689571, 0.7621117471949551, 0.8068359641369386, 0.8473537162093151, 0.8834537652186168, 0.9149479072061387, 0.9416719568476378, 0.96348661301408, 0.9802782209802554, 0.9919595575932442, 0.9984723322425076},
	{-0.9985402006367742, -0.9923163921385159, -0.981151833077914, -0.9650996504224931, -0.9442395091181941, -0.9186752599841758, -0.8885342382860432, -0.8539665950047104, -0.815144539645135, -0.7722614792487559, -0.725531053660717, -0.6751860706661224, -0.6214773459035758, -0.5646724531854708, -0.5050543913882023, -0.4429201745254115, -0.37857935201470716, -0.3123524665027858, -0.24456945692820126, -0.17556801477551678, -0.10569190170865325, -0.035289236964135356, 0.035289236964135356, 0.10569190170865325, 0.17556801477551678, 0.24456945692820126, 0.3123524665027858, 0.37857935201470716, 0.4429201745254115, 0.5050543913882023, 0.5646724531854708, 0.6214773459035758, 0.6751860706661224, 0.725531053660717, 0.7722614792487559, 0.815144539645135, 0.8539665950047104, 0.8885342382860432, 0.9186752599841758, 0.9442395091181941, 0.9650996504224931, 0.981151833077914, 0.9923163921385159, 0.9985402006367742},
	{-0.9986036451819367, -0.9926499984472038, -0.9819687150345406, -0.9666083103968945, -0.946641690995629, -0.9221639367190004, -0.8932916717532418, -0.8601624759606642, -0.8229342205020864, -0.7817843125939063, -0.7369088489454904, -0.6885216807712006, -0.6368533944532233, -0.5821502125693532, -0.5246728204629161, -0.4646951239196351, -0.4025029438585419, -0.33839265425060217, -0.27266976975237756, -0.20564748978326375, -0.13764520598325303, -0.06898698016314417, 0.0, 0.06898698016314417, 0.13764520598325303, 0.20564748978326375, 0.27266976975237756, 0.33839265425060217, 0.4025029438585419, 0.4646951239196351, 0.5246728204629161, 0.5821502125693532, 0.6368533944532233, 0.6885216807712006, 0.7369088489454904, 0.7817843125939063, 0.8229342205020864, 0.8601624759606642, 0.8932916717532418, 0.9221639367190004, 0.946641690995629, 0.9666083103968945, 0.9819687150345406, 0.9926499984472038, 0.9986036451819367},
	{-0.998663042133818, -0.9929623489061743, -0.9827336698041669, -0.9680213918539919, -0.9488923634460897, -0.925433798806754, -0.897752711533942, -0.865975394866858, -0.8302468370660661, -0.7907300570752742, -0.747605359615666, -0.7010695120204057, -0.6513348462019977, -0.5986282897127152, -0.5431903302618026, -0.4852739183881647, -0.4251433132828284, -0.3630728770209957, -0.29934582270187005, -0.23425292220626975, -0.16809117946710353, -0.10116247530558424, -0.03377219001605204, 0.03377219001605204, 0.10116247530558424, 0.16809117946710353, 0.23425292220626975, 0.29934582270187005, 0.3630728770209957, 0.4251433132828284, 0.4852739183881647, 0.5431903302618026, 0.5986282897127152, 0.6513348462019977, 0.7010695120204057, 0.747605359615666, 0.7907300570752742, 0.8302468370660661, 0.865975394866858, 0.897752711533942, 0.925433798806754, 0.9488923634460897, 0.9680213918539919, 0.9827336698041669, 0.9929623489061743, 0.998663042133818},
	{-0.9987187285842121, -0.9932552109877686, -0.9834510030716237, -0.9693467873265644, -0.9510039692577085, -0.9285026930123607, -0.9019413294385253, -0.8714360157968963, -0.8371201398999021, -0.799143754167742, -0.7576729184454386, -0.7128889734090643, -0.6649877473903327, -0.6141786999563736, -0.5606840059346642, -0.5047375838635779, -0.4465840731048557, -0.38647776408466716, -0.3246814863377359, -0.26146545921497455, -0.19710611027911182, -0.1318848665545149, -0.06608692391635568, 0.0, 0.06608692391635568, 0.1318848665545149, 0.19710611027911182, 0.26146545921497455, 0.3246814863377359, 0.38647776408466716, 0.4465840731048557, 0.5047375838635779, 0.5606840059346642, 0.6141786999563736, 0.6649877473903327, 0.7128889734090643, 0.7576729184454386, 0.799143754167742, 0.8371201398999021, 0.8714360157968963, 0.9019413294385253, 0.9285026930123607, 0.9510039692577085, 0.9693467873265644, 0.9834510030716237, 0.9932552109877686, 0.9987187285842121},
	{-0.9987710072524261, -0.9935301722663508, -0.9841245837228269, -0.9705915925462473, -0.9529877031604309, -0.9313866907065543, -0.9058791367155696, -0.8765720202742479, -0.8435882616243935, -0.8070662040294426, -0.7671590325157404, -0.7240341309238146, -0.6778723796326639, -0.6288673967765136, -0.5772247260839727, -0.523160974722233, -0.4669029047509584, -0.4086864819907167, -0.34875588629216075, -0.28736248735545555, -0.22476379039468905, -0.1612223560688917, -0.0970046992094627, -0.03238017096286937, 0.03238017096286937, 0.0970046992094627, 0.1612223560688917, 0.22476379039468905, 0.28736248735545555, 0.34875588629216075, 0.4086864819907167, 0.4669029047509584, 0.523160974722233, 0.5772247260839727, 0.6288673967765136, 0.6778723796326639, 0.7240341309238146, 0.7671590325157404, 0.8070662040294426, 0.8435882616243935, 0.8765720202742479, 0.9058791367155696, 0.9313866907065543, 0.9529877031604309, 0.9705915925462473, 0.9841245837228269, 0.9935301722663508, 0.9987710072524261},
	{-0.9988201506066353, -0.9937886619441678, -0.984757895914213, -0.9717622009015554, -0.9548536586741372, -0.9341002947558101, -0.9095856558280733, -0.8814084455730089, -0.8496821198441658, -0.8145344273598554, -0.7761068943454467, -0.7345542542374027, -0.6900438244251321, -0.6427548324192377, -0.5928776941089007, -0.5406132469917261, -0.48617194145249204, -0.42977299334157654, -0.3716435012622849, -0.31201753211974875, -0.2511351786125773, -0.1892415924618136, -0.12658599726967204, -0.06342068498268678, 0.0, 0.06342068498268678, 0.12658599726967204, 0.1892415924618136, 0.2511351786125773, 0.31201753211974875, 0.3716435012622849, 0.42977299334157654, 0.48617194145249204, 0.5406132469917261, 0.5928776941089007, 0.6427548324192377, 0.6900438244251321, 0.7345542542374027, 0.7761068943454467, 0.8145344273598554, 0.8496821198441658, 0.8814084455730089, 0.9095856558280733, 0.9341002947558101, 0.9548536586741372, 0.9717622009015554, 0.984757895914213, 0.9937886619441678, 0.9988201506066353},
	{-0.998866404420071, -0.9940319694320907, -0.9853540840480058, -0.972864385106692, -0.9566109552428079, -0.936656618944878, -0.9130785566557919, -0.8859679795236131, -0.8554297694299461, -0.821582070859336, -0.7845558329003992, -0.7444943022260686, -0.7015524687068222, -0.6558964656854394, -0.6077029271849502, -0.55715830451465, -0.5044581449074642, -0.44980633497403877, -0.39341431189756515, -0.33550024541943735, -0.27628819377953195, -0.21600723687604176, -0.1548905899981459, -0.09317470156008613, -0.031098338327188876, 0.031098338327188876, 0.09317470156008613, 0.1548905899981459, 0.21600723687604176, 0.27628819377953195, 0.33550024541943735, 0.39341431189756515, 0.44980633497403877, 0.5044581449074642, 0.55715830451465, 0.6077029271849502, 0.6558964656854394, 0.7015524687068222, 0.7444943022260686, 0.7845558329003992, 0.821582070859336, 0.8554297694299461, 0.8859679795236131, 0.9130785566557919, 0.936656618944878, 0.9566109552428079, 0.972864385106692, 0.9853540840480058, 0.9940319694320907, 0.998866404420071},
	{-0.9989099908489035, -0.9942612604367526, -0.985915991735903, -0.9739033680193239, -0.9582678486139082, -0.9390675440029623, -0.9163738623097802, -0.8902712180295274, -0.8608567111822923, -0.8282397638230649, -0.7925417120993812, -0.7538953544853755, -0.7124444575770367, -0.66834322117537, -0.6217557046007233, -0.5728552163513039, -0.5218236693661858, -0.4688509042860411, -0.4141339832263039, -0.3578764566884095, -0.3002876063353319, -0.24158166644779872, -0.18197702695707754, -0.12169542101888878, -0.06096110015057872, 0.0, 0.06096110015057872, 0.12169542101888878, 0.18197702695707754, 0.24158166644779872, 0.3002876063353319, 0.3578764566884095, 0.4141339832263039, 0.4688509042860411, 0.5218236693661858, 0.5728552163513039, 0.6217557046007233, 0.66834322117537, 0.7124444575770367, 0.7538953544853755, 0.7925417120993812, 0.8282397638230649, 0.8608567111822923, 0.8902712180295274, 0.9163738623097802, 0.9390675440029623, 0.9582678486139082, 0.9739033680193239, 0.985915991735903, 0.9942612604367526, 0.9989099908489035},
	{-0.9989511111039503, -0.9944775909292161, -0.9864461956515499, -0.9748838842217445, -0.9598318269330866, -0.9413438536413591, -0.9194861289164246, -0.8943368905344953, -0.8659861628460676, -0.8345354323267345, -0.8000972834304683, -0.7627949951937449, -0.7227620997499832, -0.6801419042271677, -0.6350869776952459, -0.5877586049795791, -0.5383262092858274, -0.48696674569809606, -0.4338640677187617, -0.3792082691160937, -0.32319500343480784, -0.2660247836050018, -0.20790226415636606, -0.14903550860694917, -0.08963524464890057, -0.029914109797338766, 0.029914109797338766, 0.08963524464890057, 0.14903550860694917, 0.20790226415636606, 0.2660247836050018, 0.32319500343480784, 0.3792082691160937, 0.4338640677187617, 0.48696674569809606, 0.5383262092858274, 0.5877586049795791, 0.6350869776952459, 0.6801419042271677, 0.7227620997499832, 0.7627949951937449, 0.8000972834304683, 0.8345354323267345, 0.8659861628460676, 0.8943368905344953, 0.9194861289164246, 0.9413438536413591, 0.9598318269330866, 0.9748838842217445, 0.9864461956515499, 0.9944775909292161, 0.9989511111039503},
	{-0.9989899477763282, -0.9946819193080071, -0.9869470350233716, -0.9758102337149845, -0.9613096946231363, -0.9434953534644419, -0.9224286030428122, -0.8981820578754266, -0.8708392975582413, -0.8404945765458014, -0.8072524984168955, -0.7712276549255324, -0.7325442308075103, -0.6913355756013667, -0.6477437439165101, -0.6019190057137693, -0.5540193282770679, -0.5042098316571334, -0.4526622194618458, -0.39955418695395295, -0.34506880849572236, -0.2893939064516262, -0.23272140372427258, -0.17524666215532575, -0.11716780907195515, -0.05868505430025947, 0.0, 0.05868505430025947, 0.11716780907195515, 0.17524666215532575, 0.23272140372427258, 0.2893939064516262, 0.34506880849572236, 0.39955418695395295, 0.4526622194618458, 0.5042098316571334, 0.5540193282770679, 0.6019190057137693, 0.6477437439165101, 0.6913355756013667, 0.7325442308075103, 0.7712276549255324, 0.8072524984168955, 0.8404945765458014, 0.8708392975582413, 0.8981820578754266, 0.9224286030428122, 0.9434953534644419, 0.9613096946231363, 0.9758102337149845, 0.9869470350233716, 0.9946819193080071, 0.9989899477763282},
	{-0.999026666867341, -0.9948751170183389, -0.9874206373973435, -0.9766863288579033, -0.9627076457859236, -0.9455309751649958, -0.9252133598666514, -0.9018222862847016, -0.8754354540655689, -0.8461405159707729, -0.8140347859135678, -0.779224915346254, -0.7418265388091843, -0.7019638897191729, -0.6597693876319831, -0.6153831983311273, -0.5689527681952095, -0.520632334385933, -0.4705824124813823, -0.41896926325520456, -0.36596434037219117, -0.3117437208344682, -0.2564875200699973, -0.20037929360621357, -0.14360542731625614, -0.08635451826324822, -0.028816748199341775, 0.028816748199341775, 0.08635451826324822, 0.14360542731625614, 0.20037929360621357, 0.2564875200699973, 0.3117437208344682, 0.36596434037219117, 0.41896926325520456, 0.4705824124813823, 0.520632334385933, 0.5689527681952095, 0.6153831983311273, 0.6597693876319831, 0.7019638897191729, 0.7418265388091843, 0.779224915346254, 0.8140347859135678, 0.8461405159707729, 0.8754354540655689, 0.9018222862847016, 0.9252133598666514, 0.9455309751649958, 0.9627076457859236, 0.9766863288579033, 0.9874206373973435, 0.9948751170183389, 0.999026666867341},
	{-0.9990614195648185, -0.9950579778474119, -0.9878689411988892, -0.9775157355039892, -0.9640313285931352, -0.9474588680412107, -0.9278514247207917, -0.905271800744, -0.8797923224198955, -0.8514946066171545, -0.8204692985593209, -0.7868157811276224, -0.7506418563480219, -0.7120633999866378, -0.6712039903198264, -0.6281945122499282, -0.5831727380260321, -0.5362828859083433, -0.4876751581874741, -0.4375052600371746, -0.38593390074097944, -0.3331262788900239, -0.2792515532008065, -0.22448230064784547, -0.1689939636468732, -0.11296428805932926, -0.05657275381833678, 0.0, 0.05657275381833678, 0.11296428805932926, 0.1689939636468732, 0.22448230064784547, 0.2792515532008065, 0.3331262788900239, 0.38593390074097944, 0.4375052600371746, 0.4876751581874741, 0.5362828859083433, 0.5831727380260321, 0.6281945122499282, 0.6712039903198264, 0.7120633999866378, 0.7506418563480219, 0.7868157811276224, 0.8204692985593209, 0.8514946066171545, 0.8797923224198955, 0.905271800744, 0.9278514247207917, 0.9474588680412107, 0.9640313285931352, 0.9775157355039892, 0.9878689411988892, 0.9950579778474119, 0.9990614195648185},
	{-0.9990943438014656, -0.9952312260810697, -0.9882937155401615, -0.9783017091402564, -0.9652859019054902, -0.9492864795619627, -0.9303528802474963, -0.9085436204206555, -0.8839261083278276, -0.8565764337627486, -0.8265791321428817, -0.7940269228938666, -0.7590204227051289, -0.7216678344501881, -0.6820846126944704, -0.6403931068070069, -0.5967221827706634, -0.5512068248555346, -0.5039877183843817, -0.4552108148784596, -0.40502688092709127, -0.3535910321749545, -0.3010622538672207, -0.24760290943433721, -0.19337823863527526, -0.13855584681037625, -0.08330518682243537, -0.02779703528727544, 0.02779703528727544, 0.08330518682243537, 0.13855584681037625, 0.19337823863527526, 0.24760290943433721, 0.3010622538672207, 0.3535910321749545, 0.40502688092709127, 0.4552108148784596, 0.5039877183843817, 0.5512068248555346, 0.5967221827706634, 0.6403931068070069, 0.6820846126944704, 0.7216678344501881, 0.7590204227051289, 0.7940269228938666, 0.8265791321428817, 0.8565764337627486, 0.8839261083278276, 0.9085436204206555, 0.9303528802474963, 0.9492864795619627, 0.9652859019054902, 0.9783017091402564, 0.9882937155401615, 0.9952312260810697, 0.9990943438014656},
	{-0.9991255656252629, -0.9953955236784303, -0.988696577650222, -0.9790472267094688, -0.9664760851718867, -0.9510206264478767, -0.9327269610671016, -0.9116496785213912, -0.8878516788822213, -0.8614039832620469, -0.8323855211504392, -0.8008828945472183, -0.7669901193594502, -0.7308083447445233, -0.6924455511995177, -0.6520162282809769, -0.6096410329087154, -0.5654464292692367, -0.5195643113911876, -0.4721316095179757, -0.42328988145156393, -0.37318489008659445, -0.3219661683953786, -0.26978657316183874, -0.21680182879612403, -0.16317006259126426, -0.1090513328087878, -0.05460715100164683, 0.0, 0.05460715100164683, 0.1090513328087878, 0.16317006259126426, 0.21680182879612403, 0.26978657316183874, 0.3219661683953786, 0.37318489008659445, 0.42328988145156393, 0.4721316095179757, 0.5195643113911876, 0.5654464292692367, 0.6096410329087154, 0.6520162282809769, 0.6924455511995177, 0.7308083447445233, 0.7669901193594502, 0.8008828945472183, 0.8323855211504392, 0.8614039832620469, 0.8878516788822213, 0.9116496785213912, 0.9327269610671016, 0.9510206264478767, 0.9664760851718867, 0.9790472267094688, 0.988696577650222, 0.9953955236784303, 0.9991255656252629},
	{-0.9991552004073866, -0.9955514765972909, -0.9890790082484426, -0.9797550146943503, -0.9676062025029241, -0.9526675575188691, -0.9349821375882593, -0.9146009285643526, -0.8915826920220302, -0.8659937940748075, -0.8379080133393734, -0.8074063279130882, -0.7745766817496528, -0.7395137310200423, -0.7023185711539081, -0.6630984453321253, -0.6219664352630792, -0.579041135130225, -0.5344463096488477, -0.48831053721671847, -0.44076683918683957, -0.3919522963307531, -0.34200765359799523, -0.2910769143111092, -0.23930692496615347, -0.18684695183576133, -0.13384825059546684, -0.08046363021414274, -0.02684701236594236, 0.02684701236594236, 0.08046363021414274, 0.13384825059546684, 0.18684695183576133, 0.23930692496615347, 0.2910769143111092, 0.34200765359799523, 0.3919522963307531, 0.44076683918683957, 0.48831053721671847, 0.5344463096488477, 0.579041135130225, 0.6219664352630792, 0.6630984453321253, 0.7023185711539081, 0.7395137310200423, 0.7745766817496528, 0.8074063279130882, 0.8379080133393734, 0.8659937940748075, 0.8915826920220302, 0.9146009285643526, 0.9349821375882593, 0.9526675575188691, 0.9676062025029241, 0.9797550146943503, 0.9890790082484426, 0.9955514765972909, 0.9991552004073866},
	{-0.9991833539092947, -0.995699640383246, -0.9894423651337309, -0.9804275739567156, -0.9686802216817816, -0.9542330093769511, -0.9371261903534539, -0.9174074387881552, -0.8951317117434721, -0.8703610942928822, -0.8431646258168722, -0.8136181072882116, -0.7818038898623609, -0.7478106452786403, -0.7117331186771978, -0.6736718645049372, -0.6337329662388501, -0.5920277407040302, -0.5486724278083964, -0.503787866557718, -0.4574991582532667, -0.409935317810419, -0.3612289141697948, -0.3115157008030137, -0.2609342373428117, -0.20962550339203656, -0.15773250558785798, -0.10539987901634415, -0.05277348408831001, 0.0, 0.05277348408831001, 0.10539987901634415, 0.15773250558785798, 0.20962550339203656, 0.2609342373428117, 0.3115157008030137, 0.3612289141697948, 0.409935317810419, 0.4574991582532667, 0.503787866557718, 0.5486724278083964, 0.5920277407040302, 0.6337329662388501, 0.6736718645049372, 0.7117331186771978, 0.7478106452786403, 0.7818038898623609, 0.8136181072882116, 0.8431646258168722, 0.8703610942928822, 0.8951317117434721, 0.9174074387881552, 0.9371261903534539, 0.9542330093769511, 0.9686802216817816, 0.9804275739567156, 0.9894423651337309, 0.995699640383246, 0.9991833539092947},
	{-0.9992101232274361, -0.9958405251188381, -0.9897878952222218, -0.9810672017525982, -0.9697017887650528, -0.955722255839996, -0.9391662761164232, -0.9200784761776275, -0.898510310810046, -0.8745199226468983, -0.8481719847859297, -0.8195375261621458, -0.7886937399322641, -0.7557237753065857, -0.7207165133557304, -0.6837663273813555, -0.6449728284894771, -0.6044405970485104, -0.5622789007539446, -0.5186014000585697, -0.4735258417617071, -0.42717374158307836, -0.379670056576798, -0.3311428482684482, -0.2817229374232617, -0.23154355137602933, -0.18073996487342542, -0.129449135396945, -0.07780933394953657, -0.025959772301247803, 0.025959772301247803, 0.07780933394953657, 0.129449135396945, 0.18073996487342542, 0.23154355137602933, 0.2817229374232617, 0.3311428482684482, 0.379670056576798, 0.42717374158307836, 0.4735258417617071, 0.5186014000585697, 0.5622789007539446, 0.6044405970485104, 0.6449728284894771, 0.6837663273813555, 0.7207165133557304, 0.7557237753065857, 0.7886937399322641, 0.8195375261621458, 0.8481719847859297, 0.8745199226468983, 0.898510310810046, 0.9200784761776275, 0.9391662761164232, 0.955722255839996, 0.9697017887650528, 0.9810672017525982, 0.9897878952222218, 0.9958405251188381, 0.9992101232274361},
	{-0.9992355976313635, -0.9959745998151203, -0.990116745232517, -0.981676011284037, -0.9706742588331829, -0.9571401519129841, -0.9411089866813611, -0.9226225813829553, -0.9017291624740011, -0.878483237214881, -0.8529454508476634, -0.8251824281086599, -0.7952665992823597, -0.7632760111723123, -0.7292941234494651, -0.6934095908944912, -0.6557160320950709, -0.6163117851979217, -0.5752996513508306, -0.5327866265029253, -0.4888836222622521, -0.4437051765385316, -0.3973691547257566, -0.34999644220406684, -0.3017106289630307, -0.2526376871690535, -0.20290564251805848, -0.1526442402308153, -0.10198460656227407, -0.051058906707974354, 0.0, 0.051058906707974354, 0.10198460656227407, 0.1526442402308153, 0.20290564251805848, 0.2526376871690535, 0.3017106289630307, 0.34999644220406684, 0.3973691547257566, 0.4437051765385316, 0.4888836222622521, 0.5327866265029253, 0.5752996513508306, 0.6163117851979217, 0.6557160320950709, 0.6934095908944912, 0.7292941234494651, 0.7632760111723123, 0.7952665992823597, 0.8251824281086599, 0.8529454508476634, 0.878483237214881, 0.9017291624740011, 0.9226225813829553, 0.9411089866813611, 0.9571401519129841, 0.9706742588331829, 0.981676011284037, 0.990116745232517, 0.9959745998151203, 0.9992355976313635},
	{-0.999259859308777, -0.9961022963162671, -0.9904299711892903, -0.9822559490972367, -0.9716007233716518, -0.958491172973927, -0.9429604013923285, -0.9250476356362037, -0.9047981225210935, -0.8822630128318973, -0.857499231512071, -0.8305693336040049, -0.8015413461039764, -0.7704885960554193, -0.7374895252831567, -0.702627492222297, -0.6659905613354795, -0.6276712806468852, -0.5877664479530873, -0.5463768663002511, -0.503607089344756, -0.4595651572401134, -0.41436232371712606, -0.36811277504656453, -0.320933341594194, -0.27294320269672634, -0.22426358560416554, -0.17501745924901563, -0.12532922361589682, -0.07532439549623433, -0.025129291421820615, 0.025129291421820615, 0.07532439549623433, 0.12532922361589682, 0.17501745924901563, 0.22426358560416554, 0.27294320269672634, 0.320933341594194, 0.36811277504656453, 0.41436232371712606, 0.4595651572401134, 0.503607089344756, 0.5463768663002511, 0.5877664479530873, 0.6276712806468852, 0.6659905613354795, 0.702627492222297, 0.7374895252831567, 0.7704885960554193, 0.8015413461039764, 0.8305693336040049, 0.857499231512071, 0.8822630128318973, 0.9047981225210935, 0.9250476356362037, 0.9429604013923285, 0.958491172973927, 0.9716007233716518, 0.9822559490972367, 0.9904299711892903, 0.9961022963162671, 0.999259859308777},
	{-0.9992829840291237, -0.9962240127779701, -0.9907285468921895, -0.9828088105937273, -0.97248403469757, -0.9597794497589419, -0.9447261340410098, -0.9273609206218432, -0.9077263027785316, -0.8858703285078534, -0.8618464823641238, -0.8357135543195029, -0.8075354957734567, -0.7773812629903724, -0.7453246483178474, -0.7114440995848458, -0.6758225281149861, -0.6385471058213654, -0.5997090518776252, -0.559403409486285, -0.5177288132900333, -0.47478724799480443, -0.4306837987951116, -0.3855263942122479, -0.3394255419745844, -0.29249405858625144, -0.24484679324595338, -0.19660034679150667, -0.14787278635787196, -0.09878335644694528, -0.04945218711615963, 0.0, 0.04945218711615963, 0.09878335644694528, 0.14787278635787196, 0.19660034679150667, 0.24484679324595338, 0.29249405858625144, 0.3394255419745844, 0.3855263942122479, 0.4306837987951116, 0.47478724799480443, 0.5177288132900333, 0.559403409486285, 0.5997090518776252, 0.6385471058213654, 0.6758225281149861, 0.7114440995848458, 0.7453246483178474, 0.7773812629903724, 0.8075354957734567, 0.8357135543195029, 0.8618464823641238, 0.8858703285078534, 0.9077263027785316, 0.9273609206218432, 0.9447261340410098, 0.9597794497589419, 0.97248403469757, 0.9828088105937273, 0.9907285468921895, 0.9962240127779701, 0.9992829840291237},
	{-0.9993050417357722, -0.9963401167719552, -0.9910133714767443, -0.983336253884626, -0.973326827789911, -0.9610087996520538, -0.9464113748584028, -0.9295691721319396, -0.9105221370785028, -0.8893154459951141, -0.8659993981540928, -0.8406292962525803, -0.8132653151227975, -0.7839723589433414, -0.7528199072605319, -0.7198818501716108, -0.6852363130542333, -0.6489654712546573, -0.6111553551723933, -0.571895646202634, -0.5312794640198946, -0.48940314570705296, -0.4463660172534641, -0.4022701579639916, -0.3572201583376681, -0.31132287199021097, -0.2646871622087674, -0.21742364374000708, -0.1696444204239928, -0.12146281929612056, -0.07299312178779904, -0.02435029266342443, 0.02435029266342443, 0.07299312178779904, 0.12146281929612056, 0.1696444204239928, 0.21742364374000708, 0.2646871622087674, 0.31132287199021097, 0.3572201583376681, 0.4022701579639916, 0.4463660172534641, 0.48940314570705296, 0.5312794640198946, 0.571895646202634, 0.6111553551723933, 0.6489654712546573, 0.6852363130542333, 0.7198818501716108, 0.7528199072605319, 0.7839723589433414, 0.8132653151227975, 0.8406292962525803, 0.8659993981540928, 0.8893154459951141, 0.9105221370785028, 0.9295691721319396, 0.9464113748584028, 0.9610087996520538, 0.973326827789911, 0.983336253884626, 0.9910133714767443, 0.9963401167719552, 0.9993050417357722},
	{-0.9993260970754129, -0.9964509480618492, -0.9912852761768016, -0.983839812187035, -0.9741315398335512, -0.9621827547180553, -0.9480209281684076, -0.9316786282287494, -0.9131934405428462, -0.8926078805047389, -0.8699692949264071, -0.8453297528999303, -0.8187459259226515, -0.7902789574921218, -0.7599943224419998, -0.7279616763294247, -0.6942546952139916, -0.6589509061936252, -0.6221315090854003, -0.5838811896604873, -0.5442879248622271, -0.5034427804550069, -0.46143970156914504, -0.418375296623409, -0.374348615122066, -0.3294609198374864, -0.2838154539022487, -0.2375172033464168, -0.19067265562614277, -0.14338955469897519, -0.09577665320919751, -0.04794346235317186, 0.0, 0.04794346235317186, 0.09577665320919751, 0.14338955469897519, 0.19067265562614277, 0.2375172033464168, 0.2838154539022487, 0.3294609198374864, 0.374348615122066, 0.418375296623409, 0.46143970156914504, 0.5034427804550069, 0.5442879248622271, 0.5838811896604873, 0.6221315090854003, 0.6589509061936252, 0.6942546952139916, 0.7279616763294247, 0.7599943224419998, 0.7902789574921218, 0.8187459259226515, 0.8453297528999303, 0.8699692949264071, 0.8926078805047389, 0.9131934405428462, 0.9316786282287494, 0.9480209281684076, 0.9621827547180553, 0.9741315398335512, 0.983839812187035, 0.9912852761768016, 0.9964509480618492, 0.9993260970754129},
	{-0.9993462098721778, -0.9965568210895527, -0.9915450303833757, -0.9843209049351401, -0.9749004277462859, -0.9633045868592574, -0.9495592462062353, -0.9336950725447924, -0.915747462945207, -0.8957564644465639, -0.8737666841669447, -0.8498271895360162, -0.8239913986955876, -0.7963169612458245, -0.7668656295753196, -0.7357031210495129, -0.7028989713588742, -0.6685263793509676, -0.6326620436909631, -0.5953859917141384, -0.5567814008517231, -0.5169344130282315, -0.47593394244423687, -0.43387147717337066, -0.3908408750161829, -0.34693815406633755, -0.3022612784564361, -0.2569099397615302, -0.210985334548079, -0.1645899385647146, -0.11782727807867599, -0.0708016988681416, -0.023618133385924566, 0.023618133385924566, 0.0708016988681416, 0.11782727807867599, 0.1645899385647146, 0.210985334548079, 0.2569099397615302, 0.3022612784564361, 0.34693815406633755, 0.3908408750161829, 0.43387147717337066, 0.47593394244423687, 0.5169344130282315, 0.5567814008517231, 0.5953859917141384, 0.6326620436909631, 0.6685263793509676, 0.7028989713588742, 0.7357031210495129, 0.7668656295753196, 0.7963169612458245, 0.8239913986955876, 0.8498271895360162, 0.8737666841669447, 0.8957564644465639, 0.915747462945207, 0.9336950725447924, 0.9495592462062353, 0.9633045868592574, 0.9749004277462859, 0.9843209049351401, 0.9915450303833757, 0.9965568210895527, 0.9993462098721778},
	{-0.9993654355529769, -0.9966580272061137, -0.9917933470823096, -0.9847808477559511, -0.9756355839229081, -0.9643773304277126, -0.9510304595401454, -0.9356238732707509, -0.9181909368127386, -0.8987694049613204, -0.8774013398316587, -0.8541330195370507, -0.8290148378533012, -0.8021011950216944, -0.7734503798999803, -0.7431244437043663, -0.7111890656100404, -0.6777134104982808, -0.6427699791566154, -0.6064344512555574, -0.568785521441471, -0.529904728900236, -0.4898762807606466, -0.4487868697198909, -0.4067254862860139, -0.3637832260439542, -0.3200530923625363, -0.2756297949696896, -0.23060954483211574, -0.18508984578364018, -0.13916928335352372, -0.09294731125207989, -0.046524035976017224, 0.0, 0.046524035976017224, 0.09294731125207989, 0.13916928335352372, 0.18508984578364018, 0.23060954483211574, 0.2756297949696896, 0.3200530923625363, 0.3637832260439542, 0.4067254862860139, 0.4487868697198909, 0.4898762807606466, 0.529904728900236, 0.568785521441471, 0.6064344512555574, 0.6427699791566154, 0.6777134104982808, 0.7111890656100404, 0.7431244437043663, 0.7734503798999803, 0.8021011950216944, 0.8290148378533012, 0.8541330195370507, 0.8774013398316587, 0.8987694049613204, 0.9181909368127386, 0.9356238732707509, 0.9510304595401454, 0.9643773304277126, 0.9756355839229081, 0.9847808477559511, 0.9917933470823096, 0.9966580272061137, 0.9993654355529769},
	{-0.9993838255297044, -0.9967548366766643, -0.9920308877424485, -0.9852208614402447, -0.976338950400357, -0.9654038025821998, -0.952438404479602, -0.9374700183128009, -0.9205301208479182, -0.9016543359201078, -0.8808823590174559, -0.8582578735826598, -0.8338284590416709, -0.8076454906897087, -0.7797640316188976, -0.7502427169029166, -0.719143630276473, -0.6865321735660129, -0.6524769291446769, -0.6170495156998834, -0.5803244376163508, -0.5423789282910034, -0.5032927877090849, -0.46314821462293904, -0.4220296336863136, -0.38002351790767447, -0.33721820679588077, -0.29370372058063876, -0.24957157089841672, -0.2049145683419393, -0.15982662727797897, -0.11440256834391069, -0.06873791903837714, -0.022928712825422352, 0.022928712825422352, 0.06873791903837714, 0.11440256834391069, 0.15982662727797897, 0.2049145683419393, 0.24957157089841672, 0.29370372058063876, 0.33721820679588077, 0.38002351790767447, 0.4220296336863136, 0.46314821462293904, 0.5032927877090849, 0.5423789282910034, 0.5803244376163508, 0.6170495156998834, 0.6524769291446769, 0.6865321735660129, 0.719143630276473, 0.7502427169029166, 0.7797640316188976, 0.8076454906897087, 0.8338284590416709, 0.8582578735826598, 0.8808823590174559, 0.9016543359201078, 0.9205301208479182, 0.9374700183128009, 0.952438404479602, 0.9654038025821998, 0.976338950400357, 0.9852208614402447, 0.9920308877424485, 0.9967548366766643, 0.9993838255297044},
	{-0.9994014275432448, -0.9968475004851951, -0.9922582667168531, -0.9856420800226375, -0.9770123316220942, -0.9663866216428606, -0.9537866478051819, -0.9392381470416085, -0.922770839180445, -0.9044183649858272, -0.8842182169472524, -0.8622116624727441, -0.8384436594805043, -0.8129627645002956, -0.7858210334467598, -0.7570739152558379, -0.7267801385960081, -0.6950015918829284, -0.6618031968410782, -0.6272527758698494, -0.5914209134845558, -0.554380812115132, -0.5162081425569337, -0.4769808893790457, -0.43677919160584444, -0.3956851789972444, -0.3537828042620663, -0.3111576715472812, -0.26789686155350345, -0.22408875363399902, -0.17982284524064318, -0.135189569085683, -0.09028010839282874, -0.045186210615101724, 0.0, 0.045186210615101724, 0.09028010839282874, 0.135189569085683, 0.17982284524064318, 0.22408875363399902, 0.26789686155350345, 0.3111576715472812, 0.3537828042620663, 0.3956851789972444, 0.43677919160584444, 0.4769808893790457, 0.5162081425569337, 0.554380812115132, 0.5914209134845558, 0.6272527758698494, 0.6618031968410782, 0.6950015918829284, 0.7267801385960081, 0.7570739152558379, 0.7858210334467598, 0.8129627645002956, 0.8384436594805043, 0.8622116624727441, 0.8842182169472524, 0.9044183649858272, 0.922770839180445, 0.9392381470416085, 0.9537866478051819, 0.9663866216428606, 0.9770123316220942, 0.9856420800226375, 0.9922582667168531, 0.9968475004851951, 0.9994014275432448},
	{-0.9994182859735758, -0.9969362519616801, -0.99247605521169, -0.9860455580703986, -0.9776574059575924, -0.9673282236649865, -0.9550785091142928, -0.9409325790038153, -0.9249185168979345, -0.9070681162609229, -0.8874168168633482, -0.8660036342138586, -0.8428710819989802, -0.8180650876254412, -0.7916349010078928, -0.7636329967718996, -0.7341149700609426, -0.7031394261515286, -0.6707678640940774, -0.6370645546097781, -0.6020964124853555, -0.5659328637188082, -0.5286457076797111, -0.4903089745576366, -0.45099877838164787, -0.4107931659026306, -0.3697719616384619, -0.3280166093896433, -0.2856100105400379, -0.24263635946374065, -0.19918097636485765, -0.15533013788207023, -0.1111709057942987, -0.06679095416755133, -0.022278395286140312, 0.022278395286140312, 0.06679095416755133, 0.1111709057942987, 0.15533013788207023, 0.19918097636485765, 0.24263635946374065, 0.2856100105400379, 0.3280166093896433, 0.3697719616384619, 0.4107931659026306, 0.45099877838164787, 0.4903089745576366, 0.5286457076797111, 0.5659328637188082, 0.6020964124853555, 0.6370645546097781, 0.6707678640940774, 0.7031394261515286, 0.7341149700609426, 0.7636329967718996, 0.7916349010078928, 0.8180650876254412, 0.8428710819989802, 0.8660036342138586, 0.8874168168633482, 0.9070681162609229, 0.9249185168979345, 0.9409325790038153, 0.9550785091142928, 0.9673282236649865, 0.9776574059575924, 0.9860455580703986, 0.99247605521169, 0.9969362519616801, 0.9994182859735758},
	{-0.9994344421197369, -0.9970213082512551, -0.9926847848706416, -0.9864322772682613, -0.9782757361136017, -0.9682308774263253, -0.9563170810410528, -0.9425573399222712, -0.9269782122508714, -0.9096097689845344, -0.8904855353552066, -0.8696424259563074, -0.8471206733918739, -0.8229637505675528, -0.7972182867493179, -0.7699339775410367, -0.7411634889493769, -0.7109623557185444, -0.6793888741296445, -0.6465039894707877, -0.6123711783946824, -0.5770563263905198, -0.5406276006064874, -0.5031553182682901, -0.46471181094759784, -0.42537128494236953, -0.3852096780385273, -0.344304512929447, -0.3027347475761914, -0.26058062279731864, -0.21792350738245334, -0.17484574102858486, -0.1314304754022661, -0.08776151363450069, -0.043923148558135325, 0.0, 0.043923148558135325, 0.08776151363450069, 0.1314304754022661, 0.17484574102858486, 0.21792350738245334, 0.26058062279731864, 0.3027347475761914, 0.344304512929447, 0.3852096780385273, 0.42537128494236953, 0.46471181094759784, 0.5031553182682901, 0.5406276006064874, 0.5770563263905198, 0.6123711783946824, 0.6465039894707877, 0.6793888741296445, 0.7109623557185444, 0.7411634889493769, 0.7699339775410367, 0.7972182867493179, 0.8229637505675528, 0.8471206733918739, 0.8696424259563074, 0.8904855353552066, 0.9096097689845344, 0.9269782122508714, 0.9425573399222712, 0.9563170810410528, 0.9682308774263253, 0.9782757361136017, 0.9864322772682613, 0.9926847848706416, 0.9970213082512551, 0.9994344421197369},
	{-0.9994499344529626, -0.997102871642729, -0.992884951016802, -0.9868031523758305, -0.9788687785572338, -0.9690966979987804, -0.9575052475776983, -0.9441161852725379, -0.928954645880918, -0.9120490926886715, -0.8934312635880912, -0.8731361112987789, -0.8512017376544379, -0.8276693220227543, -0.8025830439692918, -0.7759900002999826, -0.7479401166328323, -0.718486053662235, -0.6876831082904677, -0.6555891098112011, -0.6222643113394681, -0.5877712766916556, -0.5521747629277144, -0.5155415987760036, -0.47794055916894046, -0.43944223612496075, -0.40011890621916163, -0.36004439489141926, -0.3192939378467122, -0.2779440398078476, -0.23607233088575993, -0.19375742083702607, -0.15107875148221003, -0.10811644756210281, -0.06495116631185711, -0.02166394603542405, 0.02166394603542405, 0.06495116631185711, 0.10811644756210281, 0.15107875148221003, 0.19375742083702607, 0.23607233088575993, 0.2779440398078476, 0.3192939378467122, 0.36004439489141926, 0.40011890621916163, 0.43944223612496075, 0.47794055916894046, 0.5155415987760036, 0.5521747629277144, 0.5877712766916556, 0.6222643113394681, 0.6555891098112011, 0.6876831082904677, 0.718486053662235, 0.7479401166328323, 0.7759900002999826, 0.8025830439692918, 0.8276693220227543, 0.8512017376544379, 0.8731361112987789, 0.8934312635880912, 0.9120490926886715, 0.928954645880918, 0.9441161852725379, 0.9575052475776983, 0.9690966979987804, 0.9788687785572338, 0.9868031523758305, 0.992884951016802, 0.997102871642729, 0.9994499344529626},
	{-0.9994647988458811, -0.9971811307716113, -0.9930770155889451, -0.9871590366249321, -0.9794378920564837, -0.9699276590549859, -0.9586457006979743, -0.9456126216894836, -0.9308522273812245, -0.9143914791762564, -0.8962604448466912, -0.8764922434206515, -0.8551229845942995, -0.8321917027249097, -0.8077402855027359, -0.7818133974216448, -0.7544583981833235, -0.7257252561815598, -0.6956664572232627, -0.6643369086521963, -0.6317938390501184, -0.598096693698271, -0.5633070259900165, -0.527488384992871, -0.490706199365252, -0.45302765783994536, -0.41452158649257576, -0.3752583230192515, -0.3353095882530225, -0.2947483551538368, -0.2536487155113014, -0.21208574460373053, -0.17013536406070076, -0.1278742031796143, -0.0853794589495963, -0.04272875503841399, 0.0, 0.04272875503841399, 0.0853794589495963, 0.1278742031796143, 0.17013536406070076, 0.21208574460373053, 0.2536487155113014, 0.2947483551538368, 0.3353095882530225, 0.3752583230192515, 0.41452158649257576, 0.45302765783994536, 0.490706199365252, 0.527488384992871, 0.5633070259900165, 0.598096693698271, 0.6317938390501184, 0.6643369086521963, 0.6956664572232627, 0.7257252561815598, 0.7544583981833235, 0.7818133974216448, 0.8077402855027359, 0.8321917027249097, 0.8551229845942995, 0.8764922434206515, 0.8962604448466912, 0.9143914791762564, 0.9308522273812245, 0.9456126216894836, 0.9586457006979743, 0.9699276590549859, 0.9794378920564837, 0.9871590366249321, 0.9930770155889451, 0.9971811307716113, 0.9994647988458811},
	{-0.9994790687803295, -0.9972562617110163, -0.993261409804645, -0.9875007266162386, -0.9799843454313003, -0.9707256040425187, -0.9597409554595289, -0.947049926428385, -0.9326750794620545, -0.9166419716429065, -0.8989791087618958, -0.8797178944520888, -0.8588925742659835, -0.8365401747428157, -0.8127004375519744, -0.7874157488195755, -0.7607310637589945, -0.7326938267368803, -0.7033538869154419, -0.6727634096202476, -0.6409767835906924, -0.6080505242777798, -0.5740431733609942, -0.5390151946628171, -0.5030288666458852, -0.4661481716838812, -0.4284386823030033, -0.38996744459625077, -0.35080285901779806, -0.31101455876939066, -0.2706732859949804, -0.22985076600371704, -0.18861957974491858, -0.1470530347617534, -0.10522503485307097, -0.0632099486751163, -0.021082477516748306, 0.021082477516748306, 0.0632099486751163, 0.10522503485307097, 0.1470530347617534, 0.18861957974491858, 0.22985076600371704, 0.2706732859949804, 0.31101455876939066, 0.35080285901779806, 0.38996744459625077, 0.4284386823030033, 0.4661481716838812, 0.5030288666458852, 0.5390151946628171, 0.5740431733609942, 0.6080505242777798, 0.6409767835906924, 0.6727634096202476, 0.7033538869154419, 0.7326938267368803, 0.7607310637589945, 0.7874157488195755, 0.8127004375519744, 0.8365401747428157, 0.8588925742659835, 0.8797178944520888, 0.8989791087618958, 0.9166419716429065, 0.9326750794620545, 0.947049926428385, 0.9597409554595289, 0.9707256040425187, 0.9799843454313003, 0.9875007266162386, 0.993261409804645, 0.9972562617110163, 0.9994790687803295},
	{-0.9994927755360354, -0.9973284289622318, -0.9934385365788927, -0.9878289667675245, -0.9805093245974166, -0.9714922563430638, -0.9607933637418923, -0.9484311650792874, -0.9344270599641071, -0.9188052912283939, -0.9015929025484463, -0.8828196914478955, -0.8625181576268834, -0.840723446654958, -0.8174732891035413, -0.7928079352135635, -0.7667700852066419, -0.7394048153580325, -0.7107594999580411, -0.6808837292962696, -0.6498292238102622, -0.617649744546926, -0.5844010000915779, -0.5501405501256456, -0.5149277057799166, -0.47882342695580316, -0.4418902167923483, -0.4041920134616536, -0.36579407948003595, -0.3267628887265263, -0.28716601136429726, -0.24707199686423476, -0.2065502553331596, -0.16567093735213784, -0.12450481253290026, -0.083123147002611, -0.041597580029079456, 0.0, 0.041597580029079456, 0.083123147002611, 0.12450481253290026, 0.16567093735213784, 0.2065502553331596, 0.24707199686423476, 0.28716601136429726, 0.3267628887265263, 0.36579407948003595, 0.4041920134616536, 0.4418902167923483, 0.47882342695580316, 0.5149277057799166, 0.5501405501256456, 0.5844010000915779, 0.617649744546926, 0.6498292238102622, 0.6808837292962696, 0.7107594999580411, 0.7394048153580325, 0.7667700852066419, 0.7928079352135635, 0.8174732891035413, 0.840723446654958, 0.8625181576268834, 0.8828196914478955, 0.9015929025484463, 0.9188052912283939, 0.9344270599641071, 0.9484311650792874, 0.9607933637418923, 0.9714922563430638, 0.9805093245974166, 0.9878289667675245, 0.9934385365788927, 0.9973284289622318, 0.9994927755360354},
	{-0.9995059483621531, -0.9973977863553555, -0.993608772723527, -0.9881444533598375, -0.9810139389756559, -0.9722292285203769, -0.9618051267587678, -0.9497592077108964, -0.9361117819348108, -0.9208858612521501, -0.9041071195455668, -0.8858038492920828, -0.8660069137719819, -0.8447496949833424, -0.8220680373289746, -0.7980001871612001, -0.7725867282818097, -0.7458705135036104, -0.7178965923877036, -0.6887121352776406, -0.6583663537581427, -0.6269104176722665, -0.594397368836793, -0.5608820316012375, -0.5264209204012426, -0.4910721444621939, -0.45489530981372633, -0.4179514187803273, -0.38030276711750444, -0.34201283896696205, -0.3031461998079078, -0.26376838758499427, -0.22394580219647414, -0.18374559352891448, -0.14323554822726753, -0.10248397539122703, -0.06155959139061121, -0.020531403993998637, 0.020531403993998637, 0.06155959139061121, 0.10248397539122703, 0.14323554822726753, 0.18374559352891448, 0.22394580219647414, 0.26376838758499427, 0.3031461998079078, 0.34201283896696205, 0.38030276711750444, 0.4179514187803273, 0.45489530981372633, 0.4910721444621939, 0.5264209204012426, 0.5608820316012375, 0.594397368836793, 0.6269104176722665, 0.6583663537581427, 0.6887121352776406, 0.7178965923877036, 0.7458705135036104, 0.7725867282818097, 0.7980001871612001, 0.8220680373289746, 0.8447496949833424, 0.8660069137719819, 0.8858038492920828, 0.9041071195455668, 0.9208858612521501, 0.9361117819348108, 0.9497592077108964, 0.9618051267587678, 0.9722292285203769, 0.9810139389756559, 0.9881444533598375, 0.993608772723527, 0.9973977863553555, 0.9995059483621531},
	{-0.99951861463341, -0.9974644778692141, -0.9937724709498782, -0.9884478382225613, -0.9814992273311385, -0.9729380307491085, -0.9627783064677343, -0.9510367436005919, -0.9377326319590611, -0.9228878293594022, -0.9065267253212578, -0.8886762008255641, -0.8693655840677341, -0.848626602229624, -0.8264933293290021, -0.8030021302229252, -0.7781916008525431, -0.7521025048252159, -0.7247777064369118, -0.6962621002442422, -0.6666025373014515, -0.6358477481833124, -0.6040482629202574, -0.5712563279771983, -0.5375258204123777, -0.5029121593572515, -0.46747221496281177, -0.4312642149619357, -0.39434764900126357, -0.35678317089978107, -0.3186324989946873, -0.27995831473827615, -0.2408241597124322, -0.20129433122994436, -0.16143377669416092, -0.12130798689055258, -0.08098288838550313, -0.040524735209115925, 0.0, 0.040524735209115925, 0.08098288838550313, 0.12130798689055258, 0.16143377669416092, 0.20129433122994436, 0.2408241597124322, 0.27995831473827615, 0.3186324989946873, 0.35678317089978107, 0.39434764900126357, 0.4312642149619357, 0.46747221496281177, 0.5029121593572515, 0.5375258204123777, 0.5712563279771983, 0.6040482629202574, 0.6358477481833124, 0.6666025373014515, 0.6962621002442422, 0.7247777064369118, 0.7521025048252159, 0.7781916008525431, 0.8030021302229252, 0.8264933293290021, 0.848626602229624, 0.8693655840677341, 0.8886762008255641, 0.9065267253212578, 0.9228878293594022, 0.9377326319590611, 0.9510367436005919, 0.9627783064677343, 0.9729380307491085, 0.9814992273311385, 0.9884478382225613, 0.9937724709498782, 0.9974644778692141, 0.99951861463341},
	{-0.9995307999924238, -0.9975286383787244, -0.9939299616944888, -0.9887397320937175, -0.9819661630995505, -0.9736200785062364, -0.9637148359867559, -0.9522662946898633, -0.9392927869149466, -0.9248150877800638, -0.9088563815731883, -0.8914422244588186, -0.8726005034727246, -0.8523613918225577, -0.8307573005459112, -0.8078228265942017, -0.7835946974211427, -0.7581117121623153, -0.7314146794988304, -0.7035463523039238, -0.6745513591767508, -0.6444761329727928, -0.6133688364451848, -0.5812792851159517, -0.5482588675006126, -0.514360462813864, -0.47963835628810725, -0.4441481522404086, -0.4079466850270984, -0.37109192802859625, -0.3336429008102106, -0.29565957460758013, -0.25720277628811244, -0.21833409094221198, -0.17911576326028916, -0.1396105978534836, -0.09988185867772842, -0.0599931677222177, -0.02000840312451792, 0.02000840312451792, 0.0599931677222177, 0.09988185867772842, 0.1396105978534836, 0.17911576326028916, 0.21833409094221198, 0.25720277628811244, 0.29565957460758013, 0.3336429008102106, 0.37109192802859625, 0.4079466850270984, 0.4441481522404086, 0.47963835628810725, 0.514360462813864, 0.5482588675006126, 0.5812792851159517, 0.6133688364451848, 0.6444761329727928, 0.6745513591767508, 0.7035463523039238, 0.7314146794988304, 0.7581117121623153, 0.7835946974211427, 0.8078228265942017, 0.8307573005459112, 0.8523613918225577, 0.8726005034727246, 0.8914422244588186, 0.9088563815731883, 0.9248150877800638, 0.9392927869149466, 0.9522662946898633, 0.9637148359867559, 0.9736200785062364, 0.9819661630995505, 0.9887397320937175, 0.9939299616944888, 0.9975286383787244, 0.9995307999924238},
	{-0.9995425284795698, -0.9975903943369414, -0.9940815547855426, -0.9890207076877844, -0.9824156592512789, -0.9742766995978072, -0.9646165291148647, -0.9534502278892691, -0.9407952293065772, -0.9266712918809039, -0.9111004680345809, -0.8941070695042351, -0.8757176293035295, -0.8559608602552193, -0.8348676101377779, -0.8124708135078068, -0.7888054402691977, -0.7639084410671702, -0.7378186895912782, -0.7105769218768242, -0.6822256726990711, -0.652809209159344, -0.6223734615665772, -0.59096595172214, -0.558635718719859, -0.5254332423770546, -0.49141036441611985, -0.4566202075196891, -0.42111709238577194, -0.38495645291235087, -0.3481947496438679, -0.31088938161473645, -0.27309859672752357, -0.23488140080573192, -0.19629746546318466, -0.1574070349338616, -0.11827083200766088, -0.07894996321895441, -0.039505823435974065, 0.0, 0.039505823435974065, 0.07894996321895441, 0.11827083200766088, 0.1574070349338616, 0.19629746546318466, 0.23488140080573192, 0.27309859672752357, 0.31088938161473645, 0.3481947496438679, 0.38495645291235087, 0.42111709238577194, 0.4566202075196891, 0.49141036441611985, 0.5254332423770546, 0.558635718719859, 0.59096595172214, 0.6223734615665772, 0.652809209159344, 0.6822256726990711, 0.7105769218768242, 0.7378186895912782, 0.7639084410671702, 0.7888054402691977, 0.8124708135078068, 0.8348676101377779, 0.8559608602552193, 0.8757176293035295, 0.8941070695042351, 0.9111004680345809, 0.9266712918809039, 0.9407952293065772, 0.9534502278892691, 0.9646165291148647, 0.9742766995978072, 0.9824156592512789, 0.9890207076877844, 0.9940815547855426, 0.9975903943369414, 0.9995425284795698},
	{-0.9995538226516306, -0.9976498643982377, -0.9942275409656882, -0.9892913024997555, -0.9828485727386291, -0.9749091405857278, -0.9654850890437993, -0.9545907663436349, -0.9422427613098727, -0.9284598771724458, -0.9132631025717577, -0.8966755794387706, -0.8787225676782139, -0.859431406663111, -0.8388314735802553, -0.8169541386814635, -0.7938327175046055, -0.7695024201350413, -0.7440002975835973, -0.7173651853620999, -0.6896376443420276, -0.6608598989861199, -0.631075773046872, -0.6003306228297517, -0.5686712681227097, -0.536145920897132, -0.5028041118887849, -0.4686966151705445, -0.4338753708317561, -0.39839340588196925, -0.3623047534994873, -0.32566437074770194, -0.28852805488451183, -0.25095235839227215, -0.21299450285766613, -0.1747122918326468, -0.1361640228091439, -0.09740839844158461, -0.058504437152420666, -0.019511383256793996, 0.019511383256793996, 0.058504437152420666, 0.09740839844158461, 0.1361640228091439, 0.1747122918326468, 0.21299450285766613, 0.25095235839227215, 0.28852805488451183, 0.32566437074770194, 0.3623047534994873, 0.39839340588196925, 0.4338753708317561, 0.4686966151705445, 0.5028041118887849, 0.536145920897132, 0.5686712681227097, 0.6003306228297517, 0.631075773046872, 0.6608598989861199, 0.6896376443420276, 0.7173651853620999, 0.7440002975835973, 0.7695024201350413, 0.7938327175046055, 0.8169541386814635, 0.8388314735802553, 0.859431406663111, 0.8787225676782139, 0.8966755794387706, 0.9132631025717577, 0.9284598771724458, 0.9422427613098727, 0.9545907663436349, 0.9654850890437993, 0.9749091405857278, 0.9828485727386291, 0.9892913024997555, 0.9942275409656882, 0.9976498643982377, 0.9995538226516306},
	{-0.999564703690319, -0.9977071599883465, -0.9943681932852199, -0.989552021371022, -0.9832657085664303, -0.9755185726723613, -0.9663221163380561, -0.9556899997564026, -0.9436380176528139, -0.9301840749151675, -0.9153481596407507, -0.8991523132861565, -0.8816205978467202, -0.8627790600697919, -0.842655692736467, -0.8212803930609103, -0.7986849182650283, -0.7749028383924235, -0.7499694864306207, -0.7239219058150526, -0.6967987953924356, -0.6686404519250901, -0.6394887102214946, -0.6093868809819365, -0.5783796864515514, -0.5465131939763113, -0.5138347475606582, -0.48039289752844827, -0.44623732839169905, -0.4114187850342975, -0.3759889973203313, -0.34000060323904835, -0.30350707070062616, -0.26656261809893533, -0.2292221337593161, -0.19154109439104286, -0.15357548266563065, -0.11538170404343671, -0.07701650297212717, -0.03853687858151199, 0.0, 0.03853687858151199, 0.07701650297212717, 0.11538170404343671, 0.15357548266563065, 0.19154109439104286, 0.2292221337593161, 0.26656261809893533, 0.30350707070062616, 0.34000060323904835, 0.3759889973203313, 0.4114187850342975, 0.44623732839169905, 0.48039289752844827, 0.5138347475606582, 0.5465131939763113, 0.5783796864515514, 0.6093868809819365, 0.6394887102214946, 0.6686404519250901, 0.6967987953924356, 0.7239219058150526, 0.7499694864306207, 0.7749028383924235, 0.7986849182650283, 0.8212803930609103, 0.842655692736467, 0.8627790600697919, 0.8816205978467202, 0.8991523132861565, 0.9153481596407507, 0.9301840749151675, 0.9436380176528139, 0.9556899997564026, 0.9663221163380561, 0.9755185726723613, 0.9832657085664303, 0.989552021371022, 0.9943681932852199, 0.9977071599883465, 0.999564703690319},
	{-0.9995751915016526, -0.9977623858263859, -0.9945037683780756, -0.989803338839909, -0.9836678235220077, -0.9761060970944988, -0.9671291162525907, -0.9567498938616109, -0.9449834774389605, -0.9318469264546229, -0.9173592872532801, -0.9015415652888412, -0.8844166945967247, -0.8660095045047654, -0.8463466836129137, -0.8254567410857676, -0.8033699653101083, -0.7801183799753583, -0.7557356976395604, -0.7302572708475963, -0.7037200408721667, -0.676162484151647, -0.6476245565023466, -0.6181476351859787, -0.5877744589162849, -0.5565490658917638, -0.5245167299443277, -0.4917238948964493, -0.4582181072219632, -0.42404794710815075, -0.3892629580190548, -0.3539135748621479, -0.3180510508625015, -0.2817273832504801, -0.24499523787070454, -0.20790787282159234, -0.17051906123619015, -0.13288301331625751, -0.09505429773264487, -0.05708776250592693, -0.019038455482006812, 0.019038455482006812, 0.05708776250592693, 0.09505429773264487, 0.13288301331625751, 0.17051906123619015, 0.20790787282159234, 0.24499523787070454, 0.2817273832504801, 0.3180510508625015, 0.3539135748621479, 0.3892629580190548, 0.42404794710815075, 0.4582181072219632, 0.4917238948964493, 0.5245167299443277, 0.5565490658917638, 0.5877744589162849, 0.6181476351859787, 0.6476245565023466, 0.676162484151647, 0.7037200408721667, 0.7302572708475963, 0.7557356976395604, 0.7801183799753583, 0.8033699653101083, 0.8254567410857676, 0.8463466836129137, 0.8660095045047654, 0.8844166945967247, 0.9015415652888412, 0.9173592872532801, 0.9318469264546229, 0.9449834774389605, 0.9567498938616109, 0.9671291162525907, 0.9761060970944988, 0.9836678235220077, 0.989803338839909, 0.9945037683780756, 0.9977623858263859, 0.9995751915016526},
	{-0.9995853048070493, -0.99781564040343, -0.9946345076317803, -0.9900457012972652, -0.9840556295966815, -0.9766727500728429, -0.9679075054501287, -0.9577722991227671, -0.9462814750117909, -0.9334512964018387, -0.9192999225872079, -0.9038473830228995, -0.8871155489050634, -0.8691281021787169, -0.8499105019989338, -0.8294899486849843, -0.8078953452145896, -0.7851572563108158, -0.7613078651784587, -0.7363809279505643, -0.7104117259092174, -0.6834370155480218, -0.6554949765468238, -0.6266251577322394, -0.5968684211004183, -0.5662668839812408, -0.5348638594257853, -0.5027037949014261, -0.4698322093813203, -0.43629562891731927, -0.4021415207874887, -0.3674182263114404, -0.3321748924285642, -0.2964614021360032, -0.2603283038848259, -0.2238267400343274, -0.1870083744657227, -0.14992531945768683, -0.11263006192724032, -0.07517538914037727, -0.03761431399758438, 0.0, 0.03761431399758438, 0.07517538914037727, 0.11263006192724032, 0.14992531945768683, 0.1870083744657227, 0.2238267400343274, 0.2603283038848259, 0.2964614021360032, 0.3321748924285642, 0.3674182263114404, 0.4021415207874887, 0.43629562891731927, 0.4698322093813203, 0.5027037949014261, 0.5348638594257853, 0.5662668839812408, 0.5968684211004183, 0.6266251577322394, 0.6554949765468238, 0.6834370155480218, 0.7104117259092174, 0.7363809279505643, 0.7613078651784587, 0.7851572563108158, 0.8078953452145896, 0.8294899486849843, 0.8499105019989338, 0.8691281021787169, 0.8871155489050634, 0.9038473830228995, 0.9192999225872079, 0.9334512964018387, 0.9462814750117909, 0.9577722991227671, 0.9679075054501287, 0.9766727500728429, 0.9840556295966815, 0.9900457012972652, 0.9946345076317803, 0.99781564040343, 0.9995853048070493},
	{-0.9995950612269232, -0.9978670164217119, -0.9947606382612846, -0.9902795289653566, -0.9844297971275817, -0.9772195073583158, -0.9686586181736219, -0.9587589587296934, -0.9475342099474431, -0.9349998847635588, -0.9211733063630512, -0.9060735840940084, -0.8897215869883155, -0.872139914883579, -0.8533528671689187, -0.8333864091900214, -0.812268136356123, -0.7900272359965969, -0.7666944470188363, -0.7423020174226099, -0.7168836597292748, -0.6904745043872484, -0.6631110512180146, -0.6348311189696915, -0.6056737930478334, -0.5756793714956742, -0.5448893092984497, -0.5133461610887614, -0.4810935223321562, -0.4481759690742023, -0.4146389963323312, -0.38052895521758867, -0.3458929888731971, -0.310778967318464, -0.27523542128808853, -0.23931147515830337, -0.20305677905255348, -0.16652144022054816, -0.12975595378552474, -0.09281113295543789, -0.05573803879452822, -0.018587909652332132, 0.018587909652332132, 0.05573803879452822, 0.09281113295543789, 0.12975595378552474, 0.16652144022054816, 0.20305677905255348, 0.23931147515830337, 0.27523542128808853, 0.310778967318464, 0.3458929888731971, 0.38052895521758867, 0.4146389963323312, 0.4481759690742023, 0.4810935223321562, 0.5133461610887614, 0.5448893092984497, 0.5756793714956742, 0.6056737930478334, 0.6348311189696915, 0.6631110512180146, 0.6904745043872484, 0.7168836597292748, 0.7423020174226099, 0.7666944470188363, 0.7900272359965969, 0.812268136356123, 0.8333864091900214, 0.8533528671689187, 0.872139914883579, 0.8897215869883155, 0.9060735840940084, 0.9211733063630512, 0.9349998847635588, 0.9475342099474431, 0.9587589587296934, 0.9686586181736219, 0.9772195073583158, 0.9844297971275817, 0.9902795289653566, 0.9947606382612846, 0.9978670164217119, 0.9995950612269232},
	{-0.9996044773574785, -0.997916601198117, -0.9948823742956163, -0.990505217716416, -0.9847909576855804, -0.9777472884122433, -0.9693837119236783, -0.9597115159571884, -0.948743756254579, -0.9364952381164307, -0.9229824960960901, -0.9082237715390918, -0.8922389878913559, -0.8750497237690971, -0.8566791838099562, -0.8371521673370826, -0.8164950348747916, -0.7947356725591165, -0.7719034544902931, -0.748029203077434, -0.723145147428601, -0.6972848798422495, -0.6704833104586627, -0.6427766201325147, -0.614202211590137, -0.5847986589373881, -0.5546056555862694, -0.5236639606705679, -0.4920153440228513, -0.4597025297870887, -0.4267691387430097, -0.3932596294200592, -0.35921923808043804, -0.32469391765224753, -0.28973027569517373, -0.2543755114824535, -0.21867735228405902, -0.18268398893711268, -0.146444010790511, -0.11000634011157723, -0.07342016604329113, -0.03673487820124966, 0.0, 0.03673487820124966, 0.07342016604329113, 0.11000634011157723, 0.146444010790511, 0.18268398893711268, 0.21867735228405902, 0.2543755114824535, 0.28973027569517373, 0.32469391765224753, 0.35921923808043804, 0.3932596294200592, 0.4267691387430097, 0.4597025297870887, 0.4920153440228513, 0.5236639606705679, 0.5546056555862694, 0.5847986589373881, 0.614202211590137, 0.6427766201325147, 0.6704833104586627, 0.6972848798422495, 0.723145147428601, 0.748029203077434, 0.7719034544902931, 0.7947356725591165, 0.8164950348747916, 0.8371521673370826, 0.8566791838099562, 0.8750497237690971, 0.8922389878913559, 0.9082237715390918, 0.9229824960960901, 0.9364952381164307, 0.948743756254579, 0.9597115159571884, 0.9693837119236783, 0.9777472884122433, 0.9847909576855804, 0.990505217716416, 0.9948823742956163, 0.997916601198117, 0.9996044773574785},
	{-0.9996135688413259, -0.9979644770352439, -0.9949999174853379, -0.9907231407455187, -0.9851397067325024, -0.9782569602536847, -0.9700839726857401, -0.9606315209428984, -0.9499120708522102, -0.9379397599098925, -0.924730378322862, -0.9103013480461658, -0.8946716997394464, -0.877862047633366, -0.8598945623226849, -0.8407929415144331, -0.8205823787661602, -0.7992895302536618, -0.7769424796110234, -0.7535707008888088, -0.7292050196789284, -0.7038775724572677, -0.6776217641975886, -0.6504722243125263, -0.6224647609797508, -0.593636313913498, -0.5640249056437413, -0.5336695913672487, -0.5026104074366573, -0.4708883185554978, -0.4385451637488091, -0.4056236011806004, -0.3721670518909396, -0.33821964252687264, -0.3038261471427057, -0.2690319281464103, -0.23388287647003747, -0.19842535104305142, -0.1627061176484117, -0.12677228724204825, -0.09067125381708016, -0.054450631894731205, -0.018158193724385818, 0.018158193724385818, 0.054450631894731205, 0.09067125381708016, 0.12677228724204825, 0.1627061176484117, 0.19842535104305142, 0.23388287647003747, 0.2690319281464103, 0.3038261471427057, 0.33821964252687264, 0.3721670518909396, 0.4056236011806004, 0.4385451637488091, 0.4708883185554978, 0.5026104074366573, 0.5336695913672487, 0.5640249056437413, 0.593636313913498, 0.6224647609797508, 0.6504722243125263, 0.6776217641975886, 0.7038775724572677, 0.7292050196789284, 0.7535707008888088, 0.7769424796110234, 0.7992895302536618, 0.8205823787661602, 0.8407929415144331, 0.8598945623226849, 0.877862047633366, 0.8946716997394464, 0.9103013480461658, 0.924730378322862, 0.9379397599098925, 0.9499120708522102, 0.9606315209428984, 0.9700839726857401, 0.9782569602536847, 0.9851397067325024, 0.9907231407455187, 0.9949999174853379, 0.9979644770352439, 0.9996135688413259},
	{-0.9996223504324843, -0.9980107215629823, -0.995113458137992, -0.9909336501109646, -0.9854766060684204, -0.9787493410038163, -0.9707605197472843, -0.9615204369360731, -0.9510410013893136, -0.9393357199742057, -0.9264196798912372, -0.9123095290941229, -0.8970234547675694, -0.8805811598520419, -0.8630038376297066, -0.8443141443970352, -0.8245361702557805, -0.8036954080581777, -0.7818187205454378, -0.7589343057213493, -0.7350716605053138, -0.7102615427114729, -0.6845359314028236, -0.6579279856713494, -0.6304720018972505, -0.6022033695423352, -0.5731585255345304, -0.5433749073022933, -0.5128909045194523, -0.4817458096226668, -0.44997976716528437, -0.4176337220728691, -0.3847493668670969, -0.3513690879260413, -0.31753591085011573, -0.28329344500409187, -0.24868582730667713, -0.2137576653401016, -0.17855397985304422, -0.14312014673100815, -0.10750183850894277, -0.07174496550149943, -0.035895616626800894, 0.0, 0.035895616626800894, 0.07174496550149943, 0.10750183850894277, 0.14312014673100815, 0.17855397985304422, 0.2137576653401016, 0.24868582730667713, 0.28329344500409187, 0.31753591085011573, 0.3513690879260413, 0.3847493668670969, 0.4176337220728691, 0.44997976716528437, 0.4817458096226668, 0.5128909045194523, 0.5433749073022933, 0.5731585255345304, 0.6022033695423352, 0.6304720018972505, 0.6579279856713494, 0.6845359314028236, 0.7102615427114729, 0.7350716605053138, 0.7589343057213493, 0.7818187205454378, 0.8036954080581777, 0.8245361702557805, 0.8443141443970352, 0.8630038376297066, 0.8805811598520419, 0.8970234547675694, 0.9123095290941229, 0.9264196798912372, 0.9393357199742057, 0.9510410013893136, 0.9615204369360731, 0.9707605197472843, 0.9787493410038163, 0.9854766060684204, 0.9909336501109646, 0.995113458137992, 0.9980107215629823, 0.9996223504324843},
	{-0.9996308360562707, -0.9980554080532497, -0.9952231758879889, -0.9911370781540155, -0.9858021860877636, -0.9792252031542967, -0.9714144101413222, -0.9623796460637707, -0.9521322934638021, -0.9406852633026436, -0.928052978394692, -0.9142513551045272, -0.899297783230057, -0.8832111040594506, -0.8660115866137813, -0.847720902098209, -0.8283620965904562, -0.8079595619992365, -0.7865390053282871, -0.7641274162842069, -0.7407530332686078, -0.7164453077972505, -0.6912348673908805, -0.6651534769844532, -0.6382339989033264, -0.610510351456819, -0.5820174662012874, -0.5527912439265554, -0.5228685094211437, -0.49228696507328673, -0.4610851433661965, -0.42930235832742436, -0.396978655993491, -0.3641547639521983, -0.3308720400261963, -0.2971724201624643, -0.2630983655933626, -0.2286928093358313, -0.1939991020961468, -0.1590609576483942, -0.12392239775547906, -0.08862769670207607, -0.053221325509403575, -0.017747895902112096, 0.017747895902112096, 0.053221325509403575, 0.08862769670207607, 0.12392239775547906, 0.1590609576483942, 0.1939991020961468, 0.2286928093358313, 0.2630983655933626, 0.2971724201624643, 0.3308720400261963, 0.3641547639521983, 0.396978655993491, 0.42930235832742436, 0.4610851433661965, 0.49228696507328673, 0.5228685094211437, 0.5527912439265554, 0.5820174662012874, 0.610510351456819, 0.6382339989033264, 0.6651534769844532, 0.6912348673908805, 0.7164453077972505, 0.7407530332686078, 0.7641274162842069, 0.7865390053282871, 0.8079595619992365, 0.8283620965904562, 0.847720902098209, 0.8660115866137813, 0.8832111040594506, 0.899297783230057, 0.9142513551045272, 0.928052978394692, 0.9406852633026436, 0.9521322934638021, 0.9623796460637707, 0.9714144101413222, 0.9792252031542967, 0.9858021860877636, 0.9911370781540155, 0.9952231758879889, 0.9980554080532497, 0.9996308360562707},
	{-0.9996390388645334, -0.998098605710274, -0.9953292404067497, -0.9913337388086653, -0.9861169478611037, -0.9796852765838766, -0.9720466427489094, -0.9632104546565354, -0.953187597292841, -0.9419904181702149, -0.9296327118237186, -0.9161297026888234, -0.9014980262839978, -0.88575570868447, -0.8689221442970837, -0.8510180719566774, -0.8320655493700791, -0.812087925937486, -0.7911098139837933, -0.7691570584348011, -0.74625670497536, -0.7224369667285082, -0.6977271894965399, -0.6721578156067596, -0.6457603464064199, -0.6185673034530191, -0.5906121884477524, -0.5619294419614643, -0.5325544010039439, -0.5025232554888296, -0.4718730036477532, -0.4406414064486518, -0.4088669410743988, -0.3765887535190676, -0.34384661036022796, -0.3106808497666898, -0.2771323318020521, -0.24324238808528204, -0.20905277087034174, -0.17460560160759628, -0.13994331905037422, -0.1051086269706134, -0.0701444415480058, -0.03509383849745701, 0.0, 0.03509383849745701, 0.0701444415480058, 0.1051086269706134, 0.13994331905037422, 0.17460560160759628, 0.20905277087034174, 0.24324238808528204, 0.2771323318020521, 0.3106808497666898, 0.34384661036022796, 0.3765887535190676, 0.4088669410743988, 0.4406414064486518, 0.4718730036477532, 0.5025232554888296, 0.5325544010039439, 0.5619294419614643, 0.5906121884477524, 0.6185673034530191, 0.6457603464064199, 0.6721578156067596, 0.6977271894965399, 0.7224369667285082, 0.74625670497536, 0.7691570584348011, 0.7911098139837933, 0.812087925937486, 0.8320655493700791, 0.8510180719566774, 0.8689221442970837, 0.88575570868447, 0.9014980262839978, 0.9161297026888234, 0.9296327118237186, 0.9419904181702149, 0.953187597292841, 0.9632104546565354, 0.9720466427489094, 0.9796852765838766, 0.9861169478611037, 0.9913337388086653, 0.9953292404067497, 0.998098605710274, 0.9996390388645334},
	{-0.9996469712866385, -0.9981403799385682, -0.9954318120583446, -0.9915239288110628, -0.9864213650578328, -0.9801302513451484, -0.9726581620901932, -0.9640140981715055, -0.9542084738815003, -0.9432531036453577, -0.931161187500432, -0.9179472950665863, -0.9036273479313027, -0.888218600434746, -0.8717396188629034, -0.8542102590670719, -0.8356516425333771, -0.816086130929481, -0.7955372991582481, -0.7740299069503342, -0.7515898690296384, -0.7282442238873904, -0.7040211012023911, -0.6789496879465972, -0.6530601932168422, -0.6263838118350451, -0.5989526867607422, -0.5707998703612209, -0.5419592845859134, -0.512465680093028, -0.4823545943776657, -0.4516623089518694, -0.42042580562819776, -0.3886827219594982, -0.35647130588856785, -0.32383036966234596, -0.29079924306616667, -0.25741772603442015, -0.22372604069472285, -0.189764782903379, -0.1555748733305291, -0.12119750815392408, -0.08667410942073478, -0.05204627513720694, -0.017355729146299653, 0.017355729146299653, 0.05204627513720694, 0.08667410942073478, 0.12119750815392408, 0.1555748733305291, 0.189764782903379, 0.22372604069472285, 0.25741772603442015, 0.29079924306616667, 0.32383036966234596, 0.35647130588856785, 0.3886827219594982, 0.42042580562819776, 0.4516623089518694, 0.4823545943776657, 0.512465680093028, 0.5419592845859134, 0.5707998703612209, 0.5989526867607422, 0.6263838118350451, 0.6530601932168422, 0.6789496879465972, 0.7040211012023911, 0.7282442238873904, 0.7515898690296384, 0.7740299069503342, 0.7955372991582481, 0.816086130929481, 0.8356516425333771, 0.8542102590670719, 0.8717396188629034, 0.888218600434746, 0.9036273479313027, 0.9179472950665863, 0.931161187500432, 0.9432531036453577, 0.9542084738815003, 0.9640140981715055, 0.9726581620901932, 0.9801302513451484, 0.9864213650578328, 0.9915239288110628, 0.9954318120583446, 0.9981403799385682, 0.9996469712866385},
	{-0.9996546450765761, -0.9981807925905347, -0.9955310425053524, -0.9917079288172771, -0.9867158857234698, -0.9805607802412134, -0.9732498618306907, -0.9647917457472761, -0.9551964007322764, -0.9444751365457187, -0.9326405903562645, -0.9197067117234505, -0.9056887460965719, -0.8906032168143975, -0.8744679056122304, -0.8573018316526426, -0.839125229101387, -0.8199595232732804, -0.7998273053752922, -0.7787523058761223, -0.7567593665333693, -0.7338744111110947, -0.7101244148221939, -0.6855373725315247, -0.6601422657572348, -0.6339690285091533, -0.607048512004496, -0.5794124483024631, -0.5510934129005836, -0.5221247863368906, -0.4925407148431834, -0.46237607009575143, -0.4316664081110018, -0.4004479273344393, -0.3687574259723996, -0.3366322586168285, -0.3041102922142353, -0.27122986143071925, -0.23802972346568213, -0.20454901236748876, -0.17082719290492515, -0.1369040140488264, -0.10281946211870771, -0.06861371364962542, -0.03432708803482533, 0.0, 0.03432708803482533, 0.06861371364962542, 0.10281946211870771, 0.1369040140488264, 0.17082719290492515, 0.20454901236748876, 0.23802972346568213, 0.27122986143071925, 0.3041102922142353, 0.3366322586168285, 0.3687574259723996, 0.4004479273344393, 0.4316664081110018, 0.46237607009575143, 0.4925407148431834, 0.5221247863368906, 0.5510934129005836, 0.5794124483024631, 0.607048512004496, 0.6339690285091533, 0.6601422657572348, 0.6855373725315247, 0.7101244148221939, 0.7338744111110947, 0.7567593665333693, 0.7787523058761223, 0.7998273053752922, 0.8199595232732804, 0.839125229101387, 0.8573018316526426, 0.8744679056122304, 0.8906032168143975, 0.9056887460965719, 0.9197067117234505, 0.9326405903562645, 0.9444751365457187, 0.9551964007322764, 0.9647917457472761, 0.9732498618306907, 0.9805607802412134, 0.9867158857234698, 0.9917079288172771, 0.9955310425053524, 0.9981807925905347, 0.9996546450765761},
	{-0.9996620713565245, -0.9982199021954502, -0.9956270752692151, -0.9918860044372535, -0.987000933924012, -0.980977481210154, -0.973822588026942, -0.9655445044215959, -0.9561527771340069, -0.945658237884363, -0.9340729906070955, -0.9214103973710761, -0.907685062910925, -0.8929128177527762, -0.8771106999395697, -0.8602969353704469, -0.842490916773781, -0.8237131813364887, -0.8039853870145665, -0.78333028755169, -0.7617717062344163, -0.7393345084140881, -0.7160445728270332, -0.691928761746073, -0.6670148899977241, -0.6413316928808015, -0.6149087930234077, -0.5877766662165204, -0.5599666062635777, -0.5315106888865979, -0.5024417347304565, -0.47279327150799183, -0.44259949532959425, -0.4118952312618817, -0.38071589316095056, -0.34909744282652816, -0.31707634852413813, -0.28468954292311693, -0.2519743804989962, -0.21896859444938016, -0.18571025317301246, -0.152237716362227, -0.11858959075942593, -0.08480468562861401, -0.05092196799334792, -0.016980517692728233, 0.016980517692728233, 0.05092196799334792, 0.08480468562861401, 0.11858959075942593, 0.152237716362227, 0.18571025317301246, 0.21896859444938016, 0.2519743804989962, 0.28468954292311693, 0.31707634852413813, 0.34909744282652816, 0.38071589316095056, 0.4118952312618817, 0.44259949532959425, 0.47279327150799183, 0.5024417347304565, 0.5315106888865979, 0.5599666062635777, 0.5877766662165204, 0.6149087930234077, 0.6413316928808015, 0.6670148899977241, 0.691928761746073, 0.7160445728270332, 0.7393345084140881, 0.7617717062344163, 0.78333028755169, 0.8039853870145665, 0.8237131813364887, 0.842490916773781, 0.8602969353704469, 0.8771106999395697, 0.8929128177527762, 0.907685062910925, 0.9214103973710761, 0.9340729906070955, 0.945658237884363, 0.9561527771340069, 0.9655445044215959, 0.973822588026942, 0.980977481210154, 0.987000933924012, 0.9918860044372535, 0.9956270752692151, 0.9982199021954502, 0.9996620713565245},
	{-0.9996692606571687, -0.9982577641714128, -0.9957200462489502, -0.9920584071920627, -0.9872769112685723, -0.9813809395335016, -0.9743771421334104, -0.9662734230400591, -0.9570789290651234, -0.9468040388484754, -0.9354603508751892, -0.9230606702658535, -0.9096189942656765, -0.895150496414999, -0.8796715094050029, -0.8631995066316017, -0.8457530824652613, -0.8273519312574519, -0.8080168251065866, -0.7877695904080753, -0.7666330832146929, -0.7446311634349144, -0.7217886678982397, -0.6981313823178534, -0.6736860121822279, -0.6484801526084999, -0.6225422571916356, -0.595901605884536, -0.5685882719453317, -0.5406330879891732, -0.5120676111828354, -0.4829240876214217, -0.45323541592737976, -0.42303511011291894, -0.3923572617477494, -0.3612365014748497, -0.32970795991770563, -0.2978072280231479, -0.2655703168845569, -0.23303361709078646, -0.2002338576466961, -0.16720806451166345, -0.13399351880288074, -0.10062771471061727, -0.06714831717295511, -0.03359311935777656, 0.0, 0.03359311935777656, 0.06714831717295511, 0.10062771471061727, 0.13399351880288074, 0.16720806451166345, 0.2002338576466961, 0.23303361709078646, 0.2655703168845569, 0.2978072280231479, 0.32970795991770563, 0.3612365014748497, 0.3923572617477494, 0.42303511011291894, 0.45323541592737976, 0.4829240876214217, 0.5120676111828354, 0.5406330879891732, 0.5685882719453317, 0.595901605884536, 0.6225422571916356, 0.6484801526084999, 0.6736860121822279, 0.6981313823178534, 0.7217886678982397, 0.7446311634349144, 0.7666330832146929, 0.7877695904080753, 0.8080168251065866, 0.8273519312574519, 0.8457530824652613, 0.8631995066316017, 0.8796715094050029, 0.895150496414999, 0.9096189942656765, 0.9230606702658535, 0.9354603508751892, 0.9468040388484754, 0.9570789290651234, 0.9662734230400591, 0.9743771421334104, 0.9813809395335016, 0.9872769112685723, 0.9920584071920627, 0.9957200462489502, 0.9982577641714128, 0.9996692606571687},
	{-0.9996762229550498, -0.9982944310216876, -0.9958100842017189, -0.9922253754008766, -0.9875441983204798, -0.9817717098833783, -0.9749142837904651, -0.9669794958813434, -0.957976113742955, -0.9479140863487617, -0.9368045328028254, -0.9246597299379515, -0.9114930986940575, -0.897319189258768, -0.8821536649728723, -0.8660132850121987, -0.8489158858620334, -0.8308803616030174, -0.8119266430294829, -0.7920756756228452, -0.7713493964041237, -0.7497707096910136, -0.727363461786199, -0.7041524146248203, -0.6801632184101726, -0.6554223832678553, -0.6299572499496732, -0.6037959596196573, -0.5769674227555817, -0.5495012872003404, -0.5214279053984839, -0.49277830085411933, -0.4635841338472393, -0.4338776664463639, -0.40369172685615895, -0.37305967313942784, -0.3420153563535674, -0.31059308314222417, -0.27882757782349027, -0.24675394401653425, -0.2144076258490726, -0.18182436878855096, -0.14904018014031928, -0.11609128925645443, -0.08301410749920224, -0.049845188003282914, -0.016621185281526032, 0.016621185281526032, 0.049845188003282914, 0.08301410749920224, 0.11609128925645443, 0.14904018014031928, 0.18182436878855096, 0.2144076258490726, 0.24675394401653425, 0.27882757782349027, 0.31059308314222417, 0.3420153563535674, 0.37305967313942784, 0.40369172685615895, 0.4338776664463639, 0.4635841338472393, 0.49277830085411933, 0.5214279053984839, 0.5495012872003404, 0.5769674227555817, 0.6037959596196573, 0.6299572499496732, 0.6554223832678553, 0.6801632184101726, 0.7041524146248203, 0.727363461786199, 0.7497707096910136, 0.7713493964041237, 0.7920756756228452, 0.8119266430294829, 0.8308803616030174, 0.8489158858620334, 0.8660132850121987, 0.8821536649728723, 0.897319189258768, 0.9114930986940575, 0.9246597299379515, 0.9368045328028254, 0.9479140863487617, 0.957976113742955, 0.9669794958813434, 0.9749142837904651, 0.9817717098833783, 0.9875441983204798, 0.9922253754008766, 0.9958100842017189, 0.9982944310216876, 0.9996762229550498},
	{-0.999682967707192, -0.9983299525167464, -0.9958973111884234, -0.9923871350035014, -0.9878031559060813, -0.9821503182216257, -0.9754347334114409, -0.9676636660221966, -0.9588455238479094, -0.9489898481742954, -0.938107303198478, -0.9262096643777198, -0.9133098056340674, -0.8994216853963932, -0.8845603314814405, -0.8687418248241299, -0.8519832820717843, -0.8343028370596013, -0.8157196211866097, -0.7962537427128932, -0.775926265000224, -0.7547591837194924, -0.7327754030495022, -0.7099987108928231, -0.6864537531354822, -0.6621660069783181, -0.6371617533688401, -0.6114680485634107, -0.5851126948505141, -0.5581242104667844, -0.5305317987383433, -0.502365316480834, -0.4736552416923438, -0.4444326405741703, -0.4147291339151185, -0.38457686287569903, -0.3540084542092533, -0.3230569849576369, -0.2917559466596621, -0.2601392091110289, -0.2282409837149581, -0.19609578646318276, -0.16373840058735595, -0.13120383892128715, -0.09852730601473486, -0.0657441600397498, -0.03288987453078894, 0.0, 0.03288987453078894, 0.0657441600397498, 0.09852730601473486, 0.13120383892128715, 0.16373840058735595, 0.19609578646318276, 0.2282409837149581, 0.2601392091110289, 0.2917559466596621, 0.3230569849576369, 0.3540084542092533, 0.38457686287569903, 0.4147291339151185, 0.4444326405741703, 0.4736552416923438, 0.502365316480834, 0.5305317987383433, 0.5581242104667844, 0.5851126948505141, 0.6114680485634107, 0.6371617533688401, 0.6621660069783181, 0.6864537531354822, 0.7099987108928231, 0.7327754030495022, 0.7547591837194924, 0.775926265000224, 0.7962537427128932, 0.8157196211866097, 0.8343028370596013, 0.8519832820717843, 0.8687418248241299, 0.8845603314814405, 0.8994216853963932, 0.9133098056340674, 0.9262096643777198, 0.938107303198478, 0.9489898481742954, 0.9588455238479094, 0.9676636660221966, 0.9754347334114409, 0.9821503182216257, 0.9878031559060813, 0.9923871350035014, 0.9958973111884234, 0.9983299525167464, 0.999682967707192},
	{-0.9996895038832307, -0.9983643758631817, -0.9959818429872093, -0.9925439003237626, -0.9880541263296237, -0.9825172635630147, -0.9759391745851365, -0.9683268284632642, -0.9596882914487426, -0.9500327177844377, -0.9393703397527552, -0.9277124567223087, -0.9150714231208981, -0.9014606353158523, -0.8868945174024204, -0.8713885059092965, -0.8549590334346014, -0.8376235112281871, -0.8194003107379317, -0.8003087441391408, -0.7803690438674332, -0.7596023411766475, -0.7380306437444001, -0.7156768123489676, -0.6925645366421715, -0.6687183100439161, -0.6441634037849671, -0.6189258401254686, -0.593032364777572, -0.5665104185613972, -0.5393881083243575, -0.5116941771546677, -0.48345797392059636, -0.454709422167743, -0.42547898840730053, -0.3957976498289086, -0.3656968614723136, -0.3352085228926254, -0.30436494435449635, -0.27319881259104917, -0.24174315616384, -0.2100313104605672, -0.17809688236761861, -0.14597371465489695, -0.11369585011066592, -0.08129749546442556, -0.04881298513604973, -0.01627674484960297, 0.01627674484960297, 0.04881298513604973, 0.08129749546442556, 0.11369585011066592, 0.14597371465489695, 0.17809688236761861, 0.2100313104605672, 0.24174315616384, 0.27319881259104917, 0.30436494435449635, 0.3352085228926254, 0.3656968614723136, 0.3957976498289086, 0.42547898840730053, 0.454709422167743, 0.48345797392059636, 0.5116941771546677, 0.5393881083243575, 0.5665104185613972, 0.593032364777572, 0.6189258401254686, 0.6441634037849671, 0.6687183100439161, 0.6925645366421715, 0.7156768123489676, 0.7380306437444001, 0.7596023411766475, 0.7803690438674332, 0.8003087441391408, 0.8194003107379317, 0.8376235112281871, 0.8549590334346014, 0.8713885059092965, 0.8868945174024204, 0.9014606353158523, 0.9150714231208981, 0.9277124567223087, 0.9393703397527552, 0.9500327177844377, 0.9596882914487426, 0.9683268284632642, 0.9759391745851365, 0.9825172635630147, 0.9880541263296237, 0.9925439003237626, 0.9959818429872093, 0.9983643758631817, 0.9996895038832307},
	{-0.9996958399952467, -0.9983977458605664, -0.9960637894774884, -0.9926958747785516, -0.9882974345018388, -0.9828730196135284, -0.9764282563086197, -0.968969833034951, -0.9605054916527872, -0.9510440187666391, -0.940595236358028, -0.9291699914816192, -0.9167801449531889, -0.9034385590101216, -0.8891590839443003, -0.8739565437154142, -0.8578467205567903, -0.8408463385882867, -0.8229730464524845, -0.8042453989917706, -0.7846828379850858, -0.7643056719641821, -0.7431350551302539, -0.7211929653927706, -0.6985021815532712, -0.675086259657785, -0.6509695085424083, -0.6261769645974139, -0.6007343657760842, -0.5746681248752441, -0.5480053021152277, -0.5207735770477429, -0.4930012198207932, -0.46471706183048883, -0.4359504657902099, -0.4067312952481959, -0.3770898835852041, -0.34705700252442134, -0.31666383018631916, -0.2859419187216169, -0.2549231615559514, -0.22363976028025953, -0.19212419122124463, -0.16040917172663133, -0.12852762620020855, -0.09651265192192161, -0.06439748468849585, -0.032215464310261704, 0.0, 0.032215464310261704, 0.06439748468849585, 0.09651265192192161, 0.12852762620020855, 0.16040917172663133, 0.19212419122124463, 0.22363976028025953, 0.2549231615559514, 0.2859419187216169, 0.31666383018631916, 0.34705700252442134, 0.3770898835852041, 0.4067312952481959, 0.4359504657902099, 0.46471706183048883, 0.4930012198207932, 0.5207735770477429, 0.5480053021152277, 0.5746681248752441, 0.6007343657760842, 0.6261769645974139, 0.6509695085424083, 0.675086259657785, 0.6985021815532712, 0.7211929653927706, 0.7431350551302539, 0.7643056719641821, 0.7846828379850858, 0.8042453989917706, 0.8229730464524845, 0.8408463385882867, 0.8578467205567903, 0.8739565437154142, 0.8891590839443003, 0.9034385590101216, 0.9167801449531889, 0.9291699914816192, 0.940595236358028, 0.9510440187666391, 0.9605054916527872, 0.968969833034951, 0.9764282563086197, 0.9828730196135284, 0.9882974345018388, 0.9926958747785516, 0.9960637894774884, 0.9983977458605664, 0.9996958399952467},
	{-0.9997019841254909, -0.9984301050472305, -0.9961432549968593, -0.9928432515369068, -0.9885333889891582, -0.983218036293723, -0.9769025950638861, -0.9695934871007945, -0.9612981460028911, -0.9520250089864015, -0.9417835080627118, -0.9305840603393071, -0.9184380573735681, -0.9053578535598391, -0.8913567535488911, -0.8764489987068441, -0.8606497526245518, -0.8439750856907705, -0.8264419587440479, -0.8080682058195343, -0.7888725160080223, -0.7688744144455177, -0.7480942424525925, -0.7265531368436585, -0.7042730084271774, -0.6812765197186463, -0.657587061889015, -0.6332287309719699, -0.6082263033542795, -0.582605210574124, -0.5563915134530406, -0.5296118755877949, -0.5022935362291369, -0.4744642825750288, -0.44615242150652545, -0.41738675079505433, -0.3881965298103839, -0.35861144975907194, -0.32866160348366813, -0.29837745485338757, -0.2677898077773914, -0.23692977487219216, -0.20582874581505378, -0.17451835541557656, -0.14303045143794288, -0.11139706220655361, -0.07965036402800599, -0.04782264846254933, -0.0159462894783094, 0.0159462894783094, 0.04782264846254933, 0.07965036402800599, 0.11139706220655361, 0.14303045143794288, 0.17451835541557656, 0.20582874581505378, 0.23692977487219216, 0.2677898077773914, 0.29837745485338757, 0.32866160348366813, 0.35861144975907194, 0.3881965298103839, 0.41738675079505433, 0.44615242150652545, 0.4744642825750288, 0.5022935362291369, 0.5296118755877949, 0.5563915134530406, 0.582605210574124, 0.6082263033542795, 0.6332287309719699, 0.657587061889015, 0.6812765197186463, 0.7042730084271774, 0.7265531368436585, 0.7480942424525925, 0.7688744144455177, 0.7888725160080223, 0.8080682058195343, 0.8264419587440479, 0.8439750856907705, 0.8606497526245518, 0.8764489987068441, 0.8913567535488911, 0.9053578535598391, 0.9184380573735681, 0.9305840603393071, 0.9417835080627118, 0.9520250089864015, 0.9612981460028911, 0.9695934871007945, 0.9769025950638861, 0.983218036293723, 0.9885333889891582, 0.9928432515369068, 0.9961432549968593, 0.9984301050472305, 0.9997019841254909},
	{-0.9997079439521693, -0.9984614938358414, -0.9962203386730886, -0.9929862141331123, -0.9887622829898737, -0.98355274115628, -0.9773627767507059, -0.9701985580742902, -0.962067225640902, -0.9529768844533735, -0.9429365956884794, -0.931956367561497, -0.9200471453005002, -0.9072208002105736, -0.8934901178264142, -0.8788687851595138, -0.8633713770499171, -0.8470133416347742, -0.8298109849474306, -0.8117814546619891, -0.7929427229993089, -0.7733135688113362, -0.7529135588615381, -0.7317630283200436, -0.7098830604928968, -0.6872954658056091, -0.6640227600619385, -0.6400881419995625, -0.6155154701650072, -0.5903292391308785, -0.5645545550791016, -0.5382171107745011, -0.511343159953671, -0.4839594911546597, -0.45609340101355667, -0.4277726670545996, -0.39902552000092417, -0.3698806156335562, -0.34036700622669946, -0.31051411158779074, -0.2803516897311913, -0.24990980721474654, -0.21921880916878408, -0.18830928904742447, -0.1572120581323584, -0.12595811481948846, -0.09457861371905203, -0.06310483460002624, -0.03156815120977227, 0.0, 0.03156815120977227, 0.06310483460002624, 0.09457861371905203, 0.12595811481948846, 0.1572120581323584, 0.18830928904742447, 0.21921880916878408, 0.24990980721474654, 0.2803516897311913, 0.31051411158779074, 0.34036700622669946, 0.3698806156335562, 0.39902552000092417, 0.4277726670545996, 0.45609340101355667, 0.4839594911546597, 0.511343159953671, 0.5382171107745011, 0.5645545550791016, 0.5903292391308785, 0.6155154701650072, 0.6400881419995625, 0.6640227600619385, 0.6872954658056091, 0.7098830604928968, 0.7317630283200436, 0.7529135588615381, 0.7733135688113362, 0.7929427229993089, 0.8117814546619891, 0.8298109849474306, 0.8470133416347742, 0.8633713770499171, 0.8788687851595138, 0.8934901178264142, 0.9072208002105736, 0.9200471453005002, 0.931956367561497, 0.9429365956884794, 0.9529768844533735, 0.962067225640902, 0.9701985580742902, 0.9773627767507059, 0.98355274115628, 0.9887622829898737, 0.9929862141331123, 0.9962203386730886, 0.9984614938358414, 0.9997079439521693},
	{-0.9997137267734413, -0.9984919506395958, -0.9962951347331251, -0.9931249370374434, -0.9889843952429918, -0.983877540706057, -0.9778093584869183, -0.9707857757637064, -0.9628136542558156, -0.9539007829254917, -0.944055870136256, -0.9332885350430795, -0.921609298145334, -0.9090295709825297, -0.895561644970727, -0.8812186793850184, -0.8660146884971647, -0.8499645278795913, -0.8330838798884008, -0.8153892383391762, -0.7968978923903145, -0.7776279096494955, -0.7575981185197072, -0.7368280898020207, -0.7153381175730564, -0.693149199355802, -0.670283015603141, -0.6467619085141293, -0.6226088602037078, -0.5978474702471788, -0.5725019326213812, -0.5465970120650941, -0.520158019881763, -0.49321078920819095, -0.465781649773358, -0.4378974021720315, -0.40958529167830154, -0.38087298162462996, -0.3517885263724217, -0.32236034390052914, -0.292617188038472, -0.2625881203715035, -0.23230248184497396, -0.20178986409573602, -0.17108008053860327, -0.14020313723611397, -0.10918920358006111, -0.07806858281343663, -0.046871682421591634, -0.015628984421543084, 0.015628984421543084, 0.046871682421591634, 0.07806858281343663, 0.10918920358006111, 0.14020313723611397, 0.17108008053860327, 0.20178986409573602, 0.23230248184497396, 0.2625881203715035, 0.292617188038472, 0.32236034390052914, 0.3517885263724217, 0.38087298162462996, 0.40958529167830154, 0.4378974021720315, 0.465781649773358, 0.49321078920819095, 0.520158019881763, 0.5465970120650941, 0.5725019326213812, 0.5978474702471788, 0.6226088602037078, 0.6467619085141293, 0.670283015603141, 0.693149199355802, 0.7153381175730564, 0.7368280898020207, 0.7575981185197072, 0.7776279096494955, 0.7968978923903145, 0.8153892383391762, 0.8330838798884008, 0.8499645278795913, 0.8660146884971647, 0.8812186793850184, 0.895561644970727, 0.9090295709825297, 0.921609298145334, 0.9332885350430795, 0.944055870136256, 0.9539007829254917, 0.9628136542558156, 0.9707857757637064, 0.9778093584869183, 0.983877540706057, 0.9889843952429918, 0.9931249370374434, 0.9962951347331251, 0.9984919506395958, 0.9997137267734413},
};

double QUADRATURE_WEIGHTS[98][101] = {
	{0.5555555555555557, 0.8888888888888888, 0.5555555555555557},
	{0.3478548451374537, 0.6521451548625462, 0.6521451548625462, 0.3478548451374537},
	{0.23692688505618942, 0.4786286704993662, 0.568888888888889, 0.4786286704993662, 0.23692688505618942},
	{0.17132449237916975, 0.36076157304813894, 0.46791393457269137, 0.46791393457269137, 0.36076157304813894, 0.17132449237916975},
	{0.12948496616887065, 0.2797053914892766, 0.3818300505051183, 0.41795918367346896, 0.3818300505051183, 0.2797053914892766, 0.12948496616887065},
	{0.10122853629037669, 0.22238103445337434, 0.31370664587788705, 0.36268378337836177, 0.36268378337836177, 0.31370664587788705, 0.22238103445337434, 0.10122853629037669},
	{0.08127438836157472, 0.18064816069485712, 0.26061069640293566, 0.3123470770400028, 0.33023935500125967, 0.3123470770400028, 0.26061069640293566, 0.18064816069485712, 0.08127438836157472},
	{0.06667134430868807, 0.14945134915058036, 0.219086362515982, 0.2692667193099965, 0.295524224714753, 0.295524224714753, 0.2692667193099965, 0.219086362515982, 0.14945134915058036, 0.06667134430868807},
	{0.055668567116173164, 0.1255803694649047, 0.18629021092773443, 0.23319376459199068, 0.26280454451024676, 0.2729250867779009, 0.26280454451024676, 0.23319376459199068, 0.18629021092773443, 0.1255803694649047, 0.055668567116173164},
	{0.04717533638651202, 0.10693932599531888, 0.1600783285433461, 0.20316742672306565, 0.23349253653835464, 0.2491470458134027, 0.2491470458134027, 0.23349253653835464, 0.20316742672306565, 0.1600783285433461, 0.10693932599531888, 0.04717533638651202},
	{0.04048400476531588, 0.0921214998377286, 0.13887351021978736, 0.17814598076194552, 0.20781604753688857, 0.22628318026289715, 0.2325515532308739, 0.22628318026289715, 0.20781604753688857, 0.17814598076194552, 0.13887351021978736, 0.0921214998377286, 0.04048400476531588},
	{0.035119460331752374, 0.0801580871597603, 0.12151857068790296, 0.1572031671581934, 0.18553839747793763, 0.20519846372129555, 0.21526385346315766, 0.21526385346315766, 0.20519846372129555, 0.18553839747793763, 0.1572031671581934, 0.12151857068790296, 0.0801580871597603, 0.035119460331752374},
	{0.030753241996118647, 0.07036604748810807, 0.10715922046717177, 0.1395706779261539, 0.16626920581699378, 0.18616100001556188, 0.19843148532711125, 0.2025782419255609, 0.19843148532711125, 0.18616100001556188, 0.16626920581699378, 0.1395706779261539, 0.10715922046717177, 0.07036604748810807, 0.030753241996118647},
	{0.027152459411754037, 0.062253523938647706, 0.09515851168249259, 0.12462897125553403, 0.14959598881657676, 0.16915651939500262, 0.1826034150449236, 0.18945061045506859, 0.18945061045506859, 0.1826034150449236, 0.16915651939500262, 0.14959598881657676, 0.12462897125553403, 0.09515851168249259, 0.062253523938647706, 0.027152459411754037},
	{0.02414830286854952, 0.0554595293739866, 0.08503614831717908, 0.11188384719340365, 0.13513636846852523, 0.15404576107681012, 0.16800410215644995, 0.17656270536699253, 0.17944647035620653, 0.17656270536699253, 0.16800410215644995, 0.15404576107681012, 0.13513636846852523, 0.11188384719340365, 0.08503614831717908, 0.0554595293739866, 0.02414830286854952},
	{0.02161601352648413, 0.04971454889496922, 0.07642573025488925, 0.10094204410628699, 0.12255520671147836, 0.14064291467065063, 0.15468467512626521, 0.16427648374583273, 0.16914238296314363, 0.16914238296314363, 0.16427648374583273, 0.15468467512626521, 0.14064291467065063, 0.12255520671147836, 0.10094204410628699, 0.07642573025488925, 0.04971454889496922, 0.02161601352648413},
	{0.01946178822972761, 0.04481422676569981, 0.06904454273764107, 0.09149002162244985, 0.11156664554733375, 0.1287539625393362, 0.14260670217360638, 0.15276604206585945, 0.15896884339395415, 0.16105444984878345, 0.15896884339395415, 0.15276604206585945, 0.14260670217360638, 0.1287539625393362, 0.11156664554733375, 0.09149002162244985, 0.06904454273764107, 0.04481422676569981, 0.01946178822972761},
	{0.017614007139153273, 0.04060142980038622, 0.06267204833410944, 0.08327674157670467, 0.10193011981724026, 0.11819453196151825, 0.13168863844917653, 0.14209610931838187, 0.14917298647260366, 0.15275338713072578, 0.15275338713072578, 0.14917298647260366, 0.14209610931838187, 0.13168863844917653, 0.11819453196151825, 0.10193011981724026, 0.08327674157670467, 0.06267204833410944, 0.04060142980038622, 0.017614007139153273},
	{0.016017228257774137, 0.03695378977085292, 0.057134425426857156, 0.07610011362837935, 0.09344442345603382, 0.10879729916714831, 0.12183141605372842, 0.13226893863333739, 0.13988739479107312, 0.14452440398997007, 0.14608113364969047, 0.14452440398997007, 0.13988739479107312, 0.13226893863333739, 0.12183141605372842, 0.10879729916714831, 0.09344442345603382, 0.07610011362837935, 0.057134425426857156, 0.03695378977085292, 0.016017228257774137},
	{0.014627995298274705, 0.03377490158481518, 0.05229333515268287, 0.0697964684245202, 0.0859416062170674, 0.10041414444288072, 0.11293229608053883, 0.12325237681051199, 0.13117350478706188, 0.13654149834601478, 0.13925187285563156, 0.13925187285563156, 0.13654149834601478, 0.13117350478706188, 0.12325237681051199, 0.11293229608053883, 0.10041414444288072, 0.0859416062170674, 0.0697964684245202, 0.05229333515268287, 0.03377490158481518, 0.014627995298274705},
	{0.013411859487141846, 0.030988005856979497, 0.04803767173108495, 0.06423242140852606, 0.07928141177671887, 0.09291576606003524, 0.10489209146454138, 0.1149966402224113, 0.12304908430672945, 0.128905722188082, 0.13246203940469642, 0.13365457218610594, 0.13246203940469642, 0.128905722188082, 0.12304908430672945, 0.1149966402224113, 0.10489209146454138, 0.09291576606003524, 0.07928141177671887, 0.06423242140852606, 0.04803767173108495, 0.030988005856979497, 0.013411859487141846},
	{0.012341229799987091, 0.028531388628933743, 0.04427743881741955, 0.05929858491543674, 0.07334648141108041, 0.08619016153195329, 0.09761865210411406, 0.1074442701159656, 0.11550566805372561, 0.12167047292780342, 0.1258374563468283, 0.12793819534675221, 0.12793819534675221, 0.1258374563468283, 0.12167047292780342, 0.11550566805372561, 0.1074442701159656, 0.09761865210411406, 0.08619016153195329, 0.07334648141108041, 0.05929858491543674, 0.04427743881741955, 0.028531388628933743, 0.012341229799987091},
	{0.011393798501027593, 0.026354986615031908, 0.0409391567013065, 0.05490469597583544, 0.06803833381235701, 0.08014070033500098, 0.09102826198296338, 0.10053594906705049, 0.10851962447426344, 0.11485825914571146, 0.1194557635357845, 0.12224244299030987, 0.12317605372671524, 0.12224244299030987, 0.1194557635357845, 0.11485825914571146, 0.10851962447426344, 0.10053594906705049, 0.09102826198296338, 0.08014070033500098, 0.06803833381235701, 0.05490469597583544, 0.0409391567013065, 0.026354986615031908, 0.011393798501027593},
	{0.010551372617343395, 0.024417851092631938, 0.03796238329436312, 0.05097582529714808, 0.06327404632957467, 0.07468414976565976, 0.08504589431348507, 0.09421380035591416, 0.10205916109442532, 0.10847184052857647, 0.11336181654631956, 0.11666044348529646, 0.11832141527926213, 0.11832141527926213, 0.11666044348529646, 0.11336181654631956, 0.10847184052857647, 0.10205916109442532, 0.09421380035591416, 0.08504589431348507, 0.07468414976565976, 0.06327404632957467, 0.05097582529714808, 0.03796238329436312, 0.024417851092631938, 0.010551372617343395},
	{0.009798996051294204, 0.022686231596180995, 0.03529705375741918, 0.047449412520615374, 0.05898353685983364, 0.06974882376624564, 0.07960486777305782, 0.08842315854375683, 0.0960887273700285, 0.10250163781774586, 0.10757828578853317, 0.11125248835684516, 0.1134763461089652, 0.11422086737895706, 0.1134763461089652, 0.11125248835684516, 0.10757828578853317, 0.10250163781774586, 0.0960887273700285, 0.08842315854375683, 0.07960486777305782, 0.06974882376624564, 0.05898353685983364, 0.047449412520615374, 0.03529705375741918, 0.022686231596180995, 0.009798996051294204},
	{0.009124282593094397, 0.02113211259277127, 0.03290142778230452, 0.044272934759003985, 0.055107345675716936, 0.06527292396699975, 0.07464621423456881, 0.08311341722890093, 0.09057174439303285, 0.09693065799792992, 0.10211296757806078, 0.10605576592284637, 0.10871119225829413, 0.11004701301647524, 0.11004701301647524, 0.10871119225829413, 0.10605576592284637, 0.10211296757806078, 0.09693065799792992, 0.09057174439303285, 0.08311341722890093, 0.07464621423456881, 0.06527292396699975, 0.055107345675716936, 0.044272934759003985, 0.03290142778230452, 0.02113211259277127, 0.009124282593094397},
	{0.008516903878747237, 0.019732085056123293, 0.03074049220209336, 0.04140206251868274, 0.051594826902497753, 0.06120309065707902, 0.07011793325505114, 0.07823832713576369, 0.0854722573661724, 0.0917377571392587, 0.09696383409440848, 0.10109127375991488, 0.10407331007772933, 0.10587615509732079, 0.10647938171831416, 0.10587615509732079, 0.10407331007772933, 0.10109127375991488, 0.09696383409440848, 0.0917377571392587, 0.0854722573661724, 0.07823832713576369, 0.07011793325505114, 0.06120309065707902, 0.051594826902497753, 0.04140206251868274, 0.03074049220209336, 0.019732085056123293, 0.008516903878747237},
	{0.007968192496169523, 0.018466468311091087, 0.028784707883322873, 0.03879919256962679, 0.048402672830594434, 0.05749315621761909, 0.06597422988218032, 0.0737559747377048, 0.08075589522941981, 0.0868997872010827, 0.09212252223778579, 0.09636873717464399, 0.09959342058679493, 0.10176238974840521, 0.10285265289355848, 0.10285265289355848, 0.10176238974840521, 0.09959342058679493, 0.09636873717464399, 0.09212252223778579, 0.0868997872010827, 0.08075589522941981, 0.0737559747377048, 0.06597422988218032, 0.05749315621761909, 0.048402672830594434, 0.03879919256962679, 0.028784707883322873, 0.018466468311091087, 0.007968192496169523},
	{0.007470831579250505, 0.017318620790311306, 0.027009019184978618, 0.036432273912385876, 0.045493707527200826, 0.05410308242491656, 0.06217478656102859, 0.06962858323541009, 0.07639038659877649, 0.08239299176158905, 0.08757674060847766, 0.09189011389364135, 0.09529024291231938, 0.09774333538632848, 0.09922501122667204, 0.0997205447934263, 0.09922501122667204, 0.09774333538632848, 0.09529024291231938, 0.09189011389364135, 0.08757674060847766, 0.08239299176158905, 0.07639038659877649, 0.06962858323541009, 0.06217478656102859, 0.05410308242491656, 0.045493707527200826, 0.036432273912385876, 0.027009019184978618, 0.017318620790311306, 0.007470831579250505},
	{0.007018610009469298, 0.016274394730905965, 0.025392065309262427, 0.034273862913021626, 0.042835898022226426, 0.050998059262376244, 0.058684093478535704, 0.06582222277636175, 0.07234579410884845, 0.07819389578707031, 0.08331192422694685, 0.08765209300440391, 0.09117387869576386, 0.09384439908080457, 0.09563872007927483, 0.09654008851472781, 0.09654008851472781, 0.09563872007927483, 0.09384439908080457, 0.09117387869576386, 0.08765209300440391, 0.08331192422694685, 0.07819389578707031, 0.07234579410884845, 0.06582222277636175, 0.058684093478535704, 0.050998059262376244, 0.042835898022226426, 0.034273862913021626, 0.025392065309262427, 0.016274394730905965, 0.007018610009469298},
	{0.006606227847588961, 0.015321701512935035, 0.023915548101749375, 0.032300358632329156, 0.040401541331669406, 0.048147742818711606, 0.05547084663166331, 0.06230648253031735, 0.06859457281865657, 0.07427985484395408, 0.0793123647948866, 0.08364787606703859, 0.08724828761884415, 0.09008195866063844, 0.09212398664331668, 0.09335642606559598, 0.09376844616020981, 0.09335642606559598, 0.09212398664331668, 0.09008195866063844, 0.08724828761884415, 0.08364787606703859, 0.0793123647948866, 0.07427985484395408, 0.06859457281865657, 0.06230648253031735, 0.05547084663166331, 0.048147742818711606, 0.040401541331669406, 0.032300358632329156, 0.023915548101749375, 0.015321701512935035, 0.006606227847588961},
	{0.006229140555910033, 0.014450162748594548, 0.022563721985495038, 0.030491380638445777, 0.038166593796386906, 0.04552561152335378, 0.05250741457267806, 0.059054135827524654, 0.06511152155407646, 0.07062937581425573, 0.0755619746600318, 0.07986844433977182, 0.08351309969984552, 0.08646573974703567, 0.08870189783569374, 0.09020304437064061, 0.09095674033025979, 0.09095674033025979, 0.09020304437064061, 0.08870189783569374, 0.08646573974703567, 0.08351309969984552, 0.07986844433977182, 0.0755619746600318, 0.07062937581425573, 0.06511152155407646, 0.059054135827524654, 0.05250741457267806, 0.04552561152335378, 0.038166593796386906, 0.030491380638445777, 0.022563721985495038, 0.014450162748594548, 0.006229140555910033},
	{0.00588343342044155, 0.013650828348361326, 0.021322979911483672, 0.028829260108894132, 0.03611011586346367, 0.04310842232617002, 0.04976937040135368, 0.056040816212370004, 0.06187367196608038, 0.06722228526908706, 0.07204479477256023, 0.07630345715544233, 0.07996494224232442, 0.08300059372885674, 0.08538665339209921, 0.08710444699718374, 0.08814053043027563, 0.08848679490710447, 0.08814053043027563, 0.08710444699718374, 0.08538665339209921, 0.08300059372885674, 0.07996494224232442, 0.07630345715544233, 0.07204479477256023, 0.06722228526908706, 0.06187367196608038, 0.056040816212370004, 0.04976937040135368, 0.04310842232617002, 0.03611011586346367, 0.028829260108894132, 0.021322979911483672, 0.013650828348361326, 0.00588343342044155},
	{0.005565719664247784, 0.012915947284064104, 0.020181515297735174, 0.027298621498568355, 0.03421381077030748, 0.04087575092364523, 0.04723508349026605, 0.05324471397775968, 0.05886014424532455, 0.06403979735501543, 0.0687453238357363, 0.072941885005653, 0.07659841064587063, 0.07968782891207156, 0.08218726670433965, 0.08407821897966179, 0.0853466857393385, 0.08598327567039463, 0.08598327567039463, 0.0853466857393385, 0.08407821897966179, 0.08218726670433965, 0.07968782891207156, 0.07659841064587063, 0.072941885005653, 0.0687453238357363, 0.06403979735501543, 0.05886014424532455, 0.05324471397775968, 0.04723508349026605, 0.04087575092364523, 0.03421381077030748, 0.027298621498568355, 0.020181515297735174, 0.012915947284064104, 0.005565719664247784},
	{0.005273057279501005, 0.012238780100306875, 0.01912904448908302, 0.025886036990559313, 0.0324616398475212, 0.03880960250193438, 0.04488536466243705, 0.05064629765482456, 0.05605198799827474, 0.06106451652322591, 0.06564872287275128, 0.06977245155570029, 0.07340677724848815, 0.07652620757052905, 0.07910886183752924, 0.08113662450846486, 0.0825952722364371, 0.0834745736258626, 0.08376836099313872, 0.0834745736258626, 0.0825952722364371, 0.08113662450846486, 0.07910886183752924, 0.07652620757052905, 0.07340677724848815, 0.06977245155570029, 0.06564872287275128, 0.06106451652322591, 0.05605198799827474, 0.05064629765482456, 0.04488536466243705, 0.03880960250193438, 0.0324616398475212, 0.025886036990559313, 0.01912904448908302, 0.012238780100306875, 0.005273057279501005},
	{0.005002880749638933, 0.011613444716468455, 0.01815657770961341, 0.024579739738232007, 0.03083950054517572, 0.03689408159402486, 0.0427031585046747, 0.04822806186075853, 0.053432019910332196, 0.058280399146997154, 0.06274093339213317, 0.06678393797914038, 0.07038250706689894, 0.07351269258474341, 0.07615366354844648, 0.07828784465821098, 0.07990103324352782, 0.08098249377059706, 0.0815250292803858, 0.0815250292803858, 0.08098249377059706, 0.07990103324352782, 0.07828784465821098, 0.07615366354844648, 0.07351269258474341, 0.07038250706689894, 0.06678393797914038, 0.06274093339213317, 0.058280399146997154, 0.053432019910332196, 0.04822806186075853, 0.0427031585046747, 0.03689408159402486, 0.03083950054517572, 0.024579739738232007, 0.01815657770961341, 0.011613444716468455, 0.005002880749638933},
	{0.004752944691632988, 0.011034788939163166, 0.017256229093724738, 0.023369384832178573, 0.029334955983903753, 0.035115111498131645, 0.04067327684793373, 0.045974301108916926, 0.05098466529212963, 0.05567269034091639, 0.06000873608859619, 0.06396538813868251, 0.06751763096623158, 0.07064300597060895, 0.07332175341426887, 0.07553693732283634, 0.07727455254468223, 0.07852361328737141, 0.07927622256836872, 0.0795276221394431, 0.07927622256836872, 0.07852361328737141, 0.07727455254468223, 0.07553693732283634, 0.07332175341426887, 0.07064300597060895, 0.06751763096623158, 0.06396538813868251, 0.06000873608859619, 0.05567269034091639, 0.05098466529212963, 0.045974301108916926, 0.04067327684793373, 0.035115111498131645, 0.029334955983903753, 0.023369384832178573, 0.017256229093724738, 0.011034788939163166, 0.004752944691632988},
	{0.004521277098530018, 0.010498284531151609, 0.016421058381907345, 0.022245849194166653, 0.027937006980023528, 0.03346019528254768, 0.03878216797447238, 0.043870908185673324, 0.048695807635072405, 0.053227846983937115, 0.05743976909939189, 0.06130624249292932, 0.06480401345660149, 0.0679120458152344, 0.07061164739128717, 0.07288658239580448, 0.07472316905796868, 0.07611036190062674, 0.07703981816424839, 0.07750594797842533, 0.07750594797842533, 0.07703981816424839, 0.07611036190062674, 0.07472316905796868, 0.07288658239580448, 0.07061164739128717, 0.0679120458152344, 0.06480401345660149, 0.06130624249292932, 0.05743976909939189, 0.053227846983937115, 0.048695807635072405, 0.043870908185673324, 0.03878216797447238, 0.03346019528254768, 0.027937006980023528, 0.022245849194166653, 0.016421058381907345, 0.010498284531151609, 0.004521277098530018},
	{0.004306140358161792, 0.009999938773905072, 0.015644938407818807, 0.021201063368779208, 0.026635899207110153, 0.03191821173169939, 0.03701771670350802, 0.04190519519590998, 0.0465526483690147, 0.05093345429461772, 0.055022519242578914, 0.05879642094987231, 0.06223354258096662, 0.06531419645352765, 0.06802073676087711, 0.07033766062081781, 0.07225169686102335, 0.07375188202722383, 0.0748296231762219, 0.0754787470927162, 0.07569553564729874, 0.0754787470927162, 0.0748296231762219, 0.07375188202722383, 0.07225169686102335, 0.07033766062081781, 0.06802073676087711, 0.06531419645352765, 0.06223354258096662, 0.05879642094987231, 0.055022519242578914, 0.05093345429461772, 0.0465526483690147, 0.04190519519590998, 0.03701771670350802, 0.03191821173169939, 0.026635899207110153, 0.021201063368779208, 0.015644938407818807, 0.009999938773905072, 0.004306140358161792},
	{0.004105998604646913, 0.009536220301748407, 0.014922443697357294, 0.020227869569052214, 0.025422959526113627, 0.030479240699603335, 0.035369071097592, 0.040065735180692286, 0.04454357777196598, 0.04877814079280347, 0.05274629569917415, 0.05642636935801852, 0.05979826222758681, 0.06284355804500275, 0.06554562436490913, 0.06788970337652217, 0.06986299249259438, 0.0714547142651712, 0.07265617524380438, 0.07346081345346782, 0.07386423423217317, 0.07386423423217317, 0.07346081345346782, 0.07265617524380438, 0.0714547142651712, 0.06986299249259438, 0.06788970337652217, 0.06554562436490913, 0.06284355804500275, 0.05979826222758681, 0.05642636935801852, 0.05274629569917415, 0.04877814079280347, 0.04454357777196598, 0.040065735180692286, 0.035369071097592, 0.030479240699603335, 0.025422959526113627, 0.020227869569052214, 0.014922443697357294, 0.009536220301748407, 0.004105998604646913},
	{0.0039194902538480176, 0.009103996637401121, 0.01424875643157602, 0.01931990142368387, 0.024290456613839044, 0.029134413261498505, 0.03382649208686005, 0.03834222219413227, 0.04265805719798207, 0.04675149475434644, 0.05060119278438981, 0.05418708031888151, 0.05749046195691038, 0.06049411524999097, 0.06318238044939598, 0.0655412421263225, 0.06755840222936497, 0.06922334419365646, 0.07052738776508476, 0.07146373425251396, 0.07202750197142171, 0.07221575169379876, 0.07202750197142171, 0.07146373425251396, 0.07052738776508476, 0.06922334419365646, 0.06755840222936497, 0.0655412421263225, 0.06318238044939598, 0.06049411524999097, 0.05749046195691038, 0.05418708031888151, 0.05060119278438981, 0.04675149475434644, 0.04265805719798207, 0.03834222219413227, 0.03382649208686005, 0.029134413261498505, 0.024290456613839044, 0.01931990142368387, 0.01424875643157602, 0.009103996637401121, 0.0039194902538480176},
	{0.0037454048031164908, 0.008700481367523676, 0.013619586755579383, 0.018471481736814985, 0.02323148190201923, 0.02787578282128097, 0.03238122281206993, 0.03672534781380876, 0.040886512310346054, 0.04484398408197005, 0.04857804644835181, 0.05207009609170433, 0.0553027355637279, 0.05825985987759541, 0.06092673670156192, 0.06329007973320361, 0.06533811487918127, 0.06706063890629348, 0.06844907026936646, 0.06949649186157239, 0.07019768547355804, 0.07054915778935386, 0.07054915778935386, 0.07019768547355804, 0.06949649186157239, 0.06844907026936646, 0.06706063890629348, 0.06533811487918127, 0.06329007973320361, 0.06092673670156192, 0.05825985987759541, 0.0553027355637279, 0.05207009609170433, 0.04857804644835181, 0.04484398408197005, 0.040886512310346054, 0.03672534781380876, 0.03238122281206993, 0.02787578282128097, 0.02323148190201923, 0.018471481736814985, 0.013619586755579383, 0.008700481367523676, 0.0037454048031164908},
	{0.0035826631552810725, 0.00832318929621773, 0.013031104991582781, 0.017677535257937863, 0.022239847550579454, 0.02669621396757769, 0.031025374934515317, 0.0352066922016093, 0.03922023672930242, 0.04304688070916464, 0.046668387718373366, 0.05006749923795213, 0.05322801673126928, 0.056134878759786656, 0.05877423271884185, 0.06113350083106668, 0.0632014400738202, 0.06496819575072363, 0.06642534844984264, 0.06756595416360778, 0.06838457737866988, 0.06887731697766154, 0.06904182482923223, 0.06887731697766154, 0.06838457737866988, 0.06756595416360778, 0.06642534844984264, 0.06496819575072363, 0.0632014400738202, 0.06113350083106668, 0.05877423271884185, 0.056134878759786656, 0.05322801673126928, 0.05006749923795213, 0.046668387718373366, 0.04304688070916464, 0.03922023672930242, 0.0352066922016093, 0.031025374934515317, 0.02669621396757769, 0.022239847550579454, 0.017677535257937863, 0.013031104991582781, 0.00832318929621773, 0.0035826631552810725},
	{0.0034303008681091456, 0.007969898229724492, 0.012479883770988784, 0.016933514007836395, 0.021309998754136483, 0.025589286397129797, 0.02975182955220257, 0.0337786279991068, 0.03765130535738592, 0.04135219010967875, 0.04486439527731805, 0.04817189510171219, 0.051259598007142824, 0.05411341538585653, 0.056720325843991094, 0.05906843459554615, 0.061147027724650325, 0.06294662106439443, 0.06445900346713893, 0.06567727426778112, 0.06659587476845476, 0.06721061360067808, 0.06751868584903632, 0.06751868584903632, 0.06721061360067808, 0.06659587476845476, 0.06567727426778112, 0.06445900346713893, 0.06294662106439443, 0.061147027724650325, 0.05906843459554615, 0.056720325843991094, 0.05411341538585653, 0.051259598007142824, 0.04817189510171219, 0.04486439527731805, 0.04135219010967875, 0.03765130535738592, 0.0337786279991068, 0.02975182955220257, 0.025589286397129797, 0.021309998754136483, 0.016933514007836395, 0.012479883770988784, 0.007969898229724492, 0.0034303008681091456},
	{0.003287453842531307, 0.007638616295848331, 0.01196284846431249, 0.016235333146433207, 0.02043693814766801, 0.024549211659658725, 0.028554150700643353, 0.032434235515184644, 0.036172496584174964, 0.03975258612253073, 0.043158848648479506, 0.04637638908650575, 0.04939113774736104, 0.052189911780056865, 0.05476047278153011, 0.057091580293231324, 0.05917304094233872, 0.06099575300873949, 0.06255174622092143, 0.06383421660571689, 0.0648375562389456, 0.06555737776654957, 0.06599053358881034, 0.06613512962365524, 0.06599053358881034, 0.06555737776654957, 0.0648375562389456, 0.06383421660571689, 0.06255174622092143, 0.06099575300873949, 0.05917304094233872, 0.057091580293231324, 0.05476047278153011, 0.052189911780056865, 0.04939113774736104, 0.04637638908650575, 0.043158848648479506, 0.03975258612253073, 0.036172496584174964, 0.032434235515184644, 0.028554150700643353, 0.024549211659658725, 0.02043693814766801, 0.016235333146433207, 0.01196284846431249, 0.007638616295848331, 0.003287453842531307},
	{0.0031533460523091796, 0.007327553901276492, 0.011477234579234974, 0.015579315722942928, 0.019616160457355297, 0.023570760839324092, 0.027426509708356882, 0.03116722783279834, 0.03477722256477066, 0.038241351065830674, 0.041545082943464554, 0.0446745608566941, 0.047616658492490284, 0.05035903555385428, 0.05289018948519349, 0.055199503699984054, 0.05727729210040293, 0.05911483969839548, 0.06070443916589358, 0.062039423159892464, 0.06311419228625378, 0.06392423858464795, 0.06446616443594984, 0.06473769681268368, 0.06473769681268368, 0.06446616443594984, 0.06392423858464795, 0.06311419228625378, 0.062039423159892464, 0.06070443916589358, 0.05911483969839548, 0.05727729210040293, 0.055199503699984054, 0.05289018948519349, 0.05035903555385428, 0.047616658492490284, 0.0446745608566941, 0.041545082943464554, 0.038241351065830674, 0.03477722256477066, 0.03116722783279834, 0.027426509708356882, 0.023570760839324092, 0.019616160457355297, 0.015579315722942928, 0.011477234579234974, 0.007327553901276492, 0.0031533460523091796},
	{0.0030272789889268293, 0.00703509959008707, 0.011020551031592718, 0.014962144935625083, 0.018843595853089968, 0.022649201587446474, 0.026363618927066127, 0.02997188462058378, 0.033459466791621775, 0.03681232096300051, 0.04001694576637272, 0.043060436981259324, 0.04593053935559558, 0.04861569588782794, 0.051105094330144415, 0.05338871070825872, 0.05545734967480332, 0.05730268153018716, 0.05891727576002699, 0.06029463095315184, 0.06142920097919265, 0.06231641732005697, 0.06295270746519542, 0.06333550929649147, 0.06346328140479025, 0.06333550929649147, 0.06295270746519542, 0.06231641732005697, 0.06142920097919265, 0.06029463095315184, 0.05891727576002699, 0.05730268153018716, 0.05545734967480332, 0.05338871070825872, 0.051105094330144415, 0.04861569588782794, 0.04593053935559558, 0.043060436981259324, 0.04001694576637272, 0.03681232096300051, 0.033459466791621775, 0.02997188462058378, 0.026363618927066127, 0.022649201587446474, 0.018843595853089968, 0.014962144935625083, 0.011020551031592718, 0.00703509959008707, 0.0030272789889268293},
	{0.0029086225531578685, 0.006759799195745505, 0.01059054838365167, 0.01438082276148571, 0.01811556071348957, 0.021780243170124582, 0.02536067357001259, 0.028842993580534923, 0.032213728223577896, 0.035459835615146026, 0.038568756612587844, 0.0415284630901474, 0.0443275043388031, 0.04695505130394827, 0.049400938449466136, 0.05165570306958092, 0.05371062188899592, 0.05555774480621228, 0.05718992564772815, 0.058600849813222215, 0.059785058704265225, 0.06073797084176991, 0.06145589959031641, 0.06193606742068298, 0.062176616655347, 0.062176616655347, 0.06193606742068298, 0.06145589959031641, 0.06073797084176991, 0.059785058704265225, 0.058600849813222215, 0.05718992564772815, 0.05555774480621228, 0.05371062188899592, 0.05165570306958092, 0.049400938449466136, 0.04695505130394827, 0.0443275043388031, 0.0415284630901474, 0.038568756612587844, 0.035459835615146026, 0.032213728223577896, 0.028842993580534923, 0.02536067357001259, 0.021780243170124582, 0.01811556071348957, 0.01438082276148571, 0.01059054838365167, 0.006759799195745505, 0.0029086225531578685},
	{0.002796807171086596, 0.006500337783252846, 0.01018519129782049, 0.013832634006477582, 0.017428714723400632, 0.020959988401703097, 0.024413300573781594, 0.027775798594162272, 0.031034971290160383, 0.03417869320418841, 0.03719526892326064, 0.040073476285496665, 0.04280260799788018, 0.04537251140765047, 0.047773626240623354, 0.04999702015005761, 0.05203442193669743, 0.05387825231304583, 0.05552165209573906, 0.05695850772025894, 0.05818347398259247, 0.05919199392296185, 0.0599803157775036, 0.0605455069347381, 0.06088546484485665, 0.06099892484120624, 0.06088546484485665, 0.0605455069347381, 0.0599803157775036, 0.05919199392296185, 0.05818347398259247, 0.05695850772025894, 0.05552165209573906, 0.05387825231304583, 0.05203442193669743, 0.04999702015005761, 0.047773626240623354, 0.04537251140765047, 0.04280260799788018, 0.040073476285496665, 0.03719526892326064, 0.03417869320418841, 0.031034971290160383, 0.027775798594162272, 0.024413300573781594, 0.020959988401703097, 0.017428714723400632, 0.013832634006477582, 0.01018519129782049, 0.006500337783252846, 0.002796807171086596},
	{0.002691316950046796, 0.0062555239629720275, 0.009802634579461853, 0.013315114982340117, 0.01678002339630083, 0.020184891507980453, 0.023517513553984442, 0.026765953746504065, 0.02991858114714431, 0.032964109089718835, 0.035891634835097594, 0.03869067831042415, 0.04135121950056041, 0.04386373425900059, 0.046219228372784964, 0.048409269744074994, 0.05042601856634259, 0.052262255383907115, 0.05391140693275745, 0.055367569669302855, 0.056625530902368756, 0.05768078745252701, 0.05852956177181407, 0.059168815466043176, 0.059596260171248326, 0.05981036574529205, 0.05981036574529205, 0.059596260171248326, 0.059168815466043176, 0.05852956177181407, 0.05768078745252701, 0.056625530902368756, 0.055367569669302855, 0.05391140693275745, 0.052262255383907115, 0.05042601856634259, 0.048409269744074994, 0.046219228372784964, 0.04386373425900059, 0.04135121950056041, 0.03869067831042415, 0.035891634835097594, 0.032964109089718835, 0.02991858114714431, 0.026765953746504065, 0.023517513553984442, 0.020184891507980453, 0.01678002339630083, 0.013315114982340117, 0.009802634579461853, 0.0062555239629720275, 0.002691316950046796},
	{0.0025916837205687228, 0.006024276226947747, 0.009441202284940213, 0.0128260261442401, 0.016166725256687685, 0.019451721107636828, 0.022669673057070416, 0.025809482510757608, 0.02886032361782363, 0.031811678459019256, 0.034653372583534035, 0.0373756098034828, 0.03996900584354026, 0.04242462063452008, 0.04473398910367275, 0.04688915034075029, 0.04888267503269898, 0.05070769106929276, 0.05235790722987274, 0.05382763486873103, 0.055111807523933604, 0.056205998381739695, 0.057106435536267174, 0.05781001499171317, 0.058314311362256024, 0.05861758623272024, 0.058718794151164315, 0.05861758623272024, 0.058314311362256024, 0.05781001499171317, 0.057106435536267174, 0.056205998381739695, 0.055111807523933604, 0.05382763486873103, 0.05235790722987274, 0.05070769106929276, 0.04888267503269898, 0.04688915034075029, 0.04473398910367275, 0.04242462063452008, 0.03996900584354026, 0.0373756098034828, 0.034653372583534035, 0.031811678459019256, 0.02886032361782363, 0.025809482510757608, 0.022669673057070416, 0.019451721107636828, 0.016166725256687685, 0.0128260261442401, 0.009441202284940213, 0.006024276226947747, 0.0025916837205687228},
	{0.002497481835760338, 0.005805611015240988, 0.009099369455510098, 0.012363328128846919, 0.01558630303592393, 0.018757527621469608, 0.021866451422853622, 0.024902741467208465, 0.027856309310596104, 0.03071734249787103, 0.03347633646437272, 0.03612412584038348, 0.03865191478210257, 0.041051306136645045, 0.043314329309597006, 0.045433466728276785, 0.04740167880644483, 0.04921242732452895, 0.050859697146188106, 0.05233801619829868, 0.05364247364755353, 0.054768736213057924, 0.05571306256058993, 0.05647231573062589, 0.05704397355879454, 0.05742613705411204, 0.05761753670714698, 0.05761753670714698, 0.05742613705411204, 0.05704397355879454, 0.05647231573062589, 0.05571306256058993, 0.054768736213057924, 0.05364247364755353, 0.05233801619829868, 0.050859697146188106, 0.04921242732452895, 0.04740167880644483, 0.045433466728276785, 0.043314329309597006, 0.041051306136645045, 0.03865191478210257, 0.03612412584038348, 0.03347633646437272, 0.03071734249787103, 0.027856309310596104, 0.024902741467208465, 0.021866451422853622, 0.018757527621469608, 0.01558630303592393, 0.012363328128846919, 0.009099369455510098, 0.005805611015240988, 0.002497481835760338},
	{0.0024083236199831147, 0.005598632266559247, 0.008775746107057643, 0.01192516071984901, 0.015036458333511426, 0.018099614520729283, 0.02110480166801605, 0.024042388009725475, 0.026902961456396427, 0.029677357765160926, 0.03235668922618577, 0.03493237287358967, 0.0373961578679654, 0.03974015187433726, 0.041956846317718864, 0.04403914042160644, 0.0459803639462838, 0.0477742985512007, 0.04941519771155173, 0.05089780512449391, 0.052217371545632024, 0.05336967000160544, 0.05435100932991106, 0.05515824600250864, 0.05578879419528405, 0.05624063407108432, 0.056512318249771994, 0.0566029764445603, 0.056512318249771994, 0.05624063407108432, 0.05578879419528405, 0.05515824600250864, 0.05435100932991106, 0.05336967000160544, 0.052217371545632024, 0.05089780512449391, 0.04941519771155173, 0.0477742985512007, 0.0459803639462838, 0.04403914042160644, 0.041956846317718864, 0.03974015187433726, 0.0373961578679654, 0.03493237287358967, 0.03235668922618577, 0.029677357765160926, 0.026902961456396427, 0.024042388009725475, 0.02110480166801605, 0.018099614520729283, 0.015036458333511426, 0.01192516071984901, 0.008775746107057643, 0.005598632266559247, 0.0024083236199831147},
	{0.002323855375775428, 0.005402522246016065, 0.008469063163307694, 0.011509824340383248, 0.014515089278020676, 0.017475512911400724, 0.02038192988240258, 0.023225351562565236, 0.02599698705839167, 0.028688268473822876, 0.031290876747310147, 0.03379676711561167, 0.03619819387231511, 0.0384877342592475, 0.040658311384744586, 0.042703216084666984, 0.04461612765269215, 0.04639113337300188, 0.04802274679360016, 0.049505924683047514, 0.05083608261779835, 0.05200910915174137, 0.053021378524010704, 0.053869761865714405, 0.05455163687088944, 0.055064895901762376, 0.05540795250324507, 0.05557974630651438, 0.05557974630651438, 0.05540795250324507, 0.055064895901762376, 0.05455163687088944, 0.053869761865714405, 0.053021378524010704, 0.05200910915174137, 0.05083608261779835, 0.049505924683047514, 0.04802274679360016, 0.04639113337300188, 0.04461612765269215, 0.042703216084666984, 0.040658311384744586, 0.0384877342592475, 0.03619819387231511, 0.03379676711561167, 0.031290876747310147, 0.028688268473822876, 0.02599698705839167, 0.023225351562565236, 0.02038192988240258, 0.017475512911400724, 0.014515089278020676, 0.011509824340383248, 0.008469063163307694, 0.005402522246016065, 0.002323855375775428},
	{0.0022437538722474204, 0.0052165334747191466, 0.008178160067822118, 0.011115763732336133, 0.01402027079075377, 0.016882959023441547, 0.019695270699488725, 0.02244880789077644, 0.025135350990918157, 0.027746881402180446, 0.030275604842694002, 0.03271397436637136, 0.03505471278231276, 0.037290834324417564, 0.03941566547548044, 0.04142286487080117, 0.04330644221621514, 0.04506077616138127, 0.04668063107364153, 0.04816117266168779, 0.049497982402019754, 0.050687070724927494, 0.05172488892051787, 0.05260833972917751, 0.05333478658481916, 0.05390206148329861, 0.05430847145249873, 0.05455280360476196, 0.05463432875658407, 0.05455280360476196, 0.05430847145249873, 0.05390206148329861, 0.05333478658481916, 0.05260833972917751, 0.05172488892051787, 0.050687070724927494, 0.049497982402019754, 0.04816117266168779, 0.04668063107364153, 0.04506077616138127, 0.04330644221621514, 0.04142286487080117, 0.03941566547548044, 0.037290834324417564, 0.03505471278231276, 0.03271397436637136, 0.030275604842694002, 0.027746881402180446, 0.025135350990918157, 0.02244880789077644, 0.019695270699488725, 0.016882959023441547, 0.01402027079075377, 0.011115763732336133, 0.008178160067822118, 0.0052165334747191466, 0.0022437538722474204},
	{0.0021677232496301654, 0.005039981612649626, 0.007901973849998231, 0.010741553532878381, 0.013550237112989007, 0.016319874234971013, 0.019042465461893778, 0.02171015614014626, 0.024315252724963578, 0.026850243181981794, 0.029307818044160175, 0.03168089125380902, 0.03396262049341578, 0.03614642686708729, 0.038226013845858595, 0.040195385409867765, 0.04204886332958198, 0.04378110353364021, 0.04538711151481967, 0.046862256729026316, 0.04820228594541772, 0.04940333550896228, 0.050461942479953045, 0.051375054618285655, 0.05214003918366976, 0.052754690526370766, 0.05321723644657896, 0.0535263433040582, 0.05368111986333478, 0.05368111986333478, 0.0535263433040582, 0.05321723644657896, 0.052754690526370766, 0.05214003918366976, 0.051375054618285655, 0.050461942479953045, 0.04940333550896228, 0.04820228594541772, 0.046862256729026316, 0.04538711151481967, 0.04378110353364021, 0.04204886332958198, 0.040195385409867765, 0.038226013845858595, 0.03614642686708729, 0.03396262049341578, 0.03168089125380902, 0.029307818044160175, 0.026850243181981794, 0.024315252724963578, 0.02171015614014626, 0.019042465461893778, 0.016319874234971013, 0.013550237112989007, 0.010741553532878381, 0.007901973849998231, 0.005039981612649626, 0.0021677232496301654},
	{0.0020954922845406714, 0.004872239168265079, 0.0076395294534899365, 0.010385885500996754, 0.013103366306344587, 0.015784347313080888, 0.0184213427536097, 0.0210069982884371, 0.023534105393713523, 0.025995619731298675, 0.028384680200534633, 0.030694627836111515, 0.03291902427104502, 0.035051669636399954, 0.03708661981887089, 0.03901820301616004, 0.04084103553868671, 0.042550036811067574, 0.044140443530297335, 0.045607822940509704, 0.04694808518696196, 0.048157494714606355, 0.049232680679362005, 0.050170646342996866, 0.050968777425393935, 0.051624849390891514, 0.05213703364837538, 0.05250390264782871, 0.052724433859127944, 0.05279801262199038, 0.052724433859127944, 0.05250390264782871, 0.05213703364837538, 0.051624849390891514, 0.050968777425393935, 0.050170646342996866, 0.049232680679362005, 0.048157494714606355, 0.04694808518696196, 0.045607822940509704, 0.044140443530297335, 0.042550036811067574, 0.04084103553868671, 0.03901820301616004, 0.03708661981887089, 0.035051669636399954, 0.03291902427104502, 0.030694627836111515, 0.028384680200534633, 0.025995619731298675, 0.023534105393713523, 0.0210069982884371, 0.0184213427536097, 0.015784347313080888, 0.013103366306344587, 0.010385885500996754, 0.0076395294534899365, 0.004872239168265079, 0.0020954922845406714},
	{0.0020268119688693106, 0.00471272992695454, 0.0073899311633443855, 0.01004755718228753, 0.012678166476815937, 0.015274618596785182, 0.0178299010142081, 0.020337120729457824, 0.022789516943997886, 0.025180477621521515, 0.027503556749924763, 0.0297524915007891, 0.03192121901929624, 0.03400389272494669, 0.035994898051084655, 0.037888867569243576, 0.03968069545238093, 0.0413655512355849, 0.04293889283593564, 0.04439647879578732, 0.04573437971611472, 0.04694898884891243, 0.048037031819971425, 0.04899557545575704, 0.049822035690550354, 0.05051418453250958, 0.05107015606985579, 0.051488451500981164, 0.051767943174910416, 0.051907877631220865, 0.051907877631220865, 0.051767943174910416, 0.051488451500981164, 0.05107015606985579, 0.05051418453250958, 0.049822035690550354, 0.04899557545575704, 0.048037031819971425, 0.04694898884891243, 0.04573437971611472, 0.04439647879578732, 0.04293889283593564, 0.0413655512355849, 0.03968069545238093, 0.037888867569243576, 0.035994898051084655, 0.03400389272494669, 0.03192121901929624, 0.0297524915007891, 0.027503556749924763, 0.025180477621521515, 0.022789516943997886, 0.020337120729457824, 0.0178299010142081, 0.015274618596785182, 0.012678166476815937, 0.01004755718228753, 0.0073899311633443855, 0.00471272992695454, 0.0020268119688693106},
	{0.0019614533616696844, 0.004560924006011563, 0.00715235499174966, 0.009725461830356146, 0.01227326350781197, 0.014789065884938233, 0.01726629298761383, 0.01969847774610118, 0.022079273148319298, 0.024402467187544206, 0.026661998524151336, 0.028851972088183353, 0.03096667436839737, 0.03300058827590729, 0.0349484075165335, 0.03680505042315481, 0.03856567320700798, 0.04022568259099818, 0.041780747790888466, 0.04322681181249605, 0.04456010203508348, 0.04577714005314598, 0.04687475075080901, 0.04785007058509562, 0.048700555056411556, 0.049423985346735574, 0.05001847410817828, 0.050482470386797436, 0.05081476366881837, 0.051014487038697265, 0.05108111944078618, 0.051014487038697265, 0.05081476366881837, 0.050482470386797436, 0.05001847410817828, 0.049423985346735574, 0.048700555056411556, 0.04785007058509562, 0.04687475075080901, 0.04577714005314598, 0.04456010203508348, 0.04322681181249605, 0.041780747790888466, 0.04022568259099818, 0.03856567320700798, 0.03680505042315481, 0.0349484075165335, 0.03300058827590729, 0.03096667436839737, 0.028851972088183353, 0.026661998524151336, 0.024402467187544206, 0.022079273148319298, 0.01969847774610118, 0.01726629298761383, 0.014789065884938233, 0.01227326350781197, 0.009725461830356146, 0.00715235499174966, 0.004560924006011563, 0.0019614533616696844},
	{0.0018992056795127678, 0.00441633345693071, 0.006926041901831181, 0.009418579428419773, 0.011887390117010234, 0.014326191823807299, 0.016728811790177277, 0.019089176658573435, 0.021401322277669787, 0.023659407208682974, 0.02585772695402455, 0.027990728163314448, 0.030053022573989865, 0.03203940058162479, 0.033944844379410775, 0.035764540622768196, 0.037493892582280024, 0.03912853175196313, 0.04066432888241756, 0.04209740441038527, 0.04342413825804749, 0.044641178977124496, 0.04574545221457025, 0.04673416847841558, 0.047604830184101284, 0.04835523796347774, 0.04898349622051791, 0.049488017919699374, 0.04986752859495244, 0.05012106956904338, 0.050248000375256376, 0.050248000375256376, 0.05012106956904338, 0.04986752859495244, 0.049488017919699374, 0.04898349622051791, 0.04835523796347774, 0.047604830184101284, 0.04673416847841558, 0.04574545221457025, 0.044641178977124496, 0.04342413825804749, 0.04209740441038527, 0.04066432888241756, 0.03912853175196313, 0.037493892582280024, 0.035764540622768196, 0.033944844379410775, 0.03203940058162479, 0.030053022573989865, 0.027990728163314448, 0.02585772695402455, 0.023659407208682974, 0.021401322277669787, 0.019089176658573435, 0.016728811790177277, 0.014326191823807299, 0.011887390117010234, 0.009418579428419773, 0.006926041901831181, 0.00441633345693071, 0.0018992056795127678},
	{0.0018398745955790698, 0.004278508346862996, 0.006710291765959956, 0.009125968676326153, 0.011519376076879823, 0.013884612616115835, 0.016215878410338374, 0.018507464460161504, 0.02075376125803898, 0.022949271004890113, 0.025088620553344983, 0.027166574359097945, 0.029178047208280707, 0.031118116622219694, 0.03298203488377931, 0.03476524064535596, 0.03646337008545718, 0.038072267584349374, 0.039587995891544055, 0.041006845759666385, 0.04232534502081564, 0.043540267083027454, 0.044648638825941285, 0.04564774787629253, 0.046535149245383635, 0.047308671312268874, 0.04796642113799502, 0.04850678909788376, 0.048928452820511954, 0.049230380423747444, 0.049411833039918134, 0.049472366623930966, 0.049411833039918134, 0.049230380423747444, 0.048928452820511954, 0.04850678909788376, 0.04796642113799502, 0.047308671312268874, 0.046535149245383635, 0.04564774787629253, 0.044648638825941285, 0.043540267083027454, 0.04232534502081564, 0.041006845759666385, 0.039587995891544055, 0.038072267584349374, 0.03646337008545718, 0.03476524064535596, 0.03298203488377931, 0.031118116622219694, 0.029178047208280707, 0.027166574359097945, 0.025088620553344983, 0.022949271004890113, 0.02075376125803898, 0.018507464460161504, 0.016215878410338374, 0.013884612616115835, 0.011519376076879823, 0.009125968676326153, 0.006710291765959956, 0.004278508346862996, 0.0018398745955790698},
	{0.0017832807216942152, 0.004147033260562923, 0.006504457968979654, 0.008846759826364391, 0.011168139460131466, 0.013463047896718231, 0.015726030476025082, 0.0179517157756973, 0.020134823153530094, 0.022270173808383007, 0.024352702568710853, 0.026377469715054627, 0.028339672614259702, 0.030234657072402495, 0.03205792835485145, 0.03380516183714179, 0.03547221325688232, 0.03705512854024015, 0.03855015317861559, 0.03995374113272035, 0.041262563242623486, 0.0424735151236536, 0.043583724529323464, 0.044590558163756545, 0.045491627927418114, 0.046284796581314375, 0.04696818281621, 0.0475401657148303, 0.04799938859645832, 0.048344762234802954, 0.048575467441503456, 0.04869095700913975, 0.04869095700913975, 0.048575467441503456, 0.048344762234802954, 0.04799938859645832, 0.0475401657148303, 0.04696818281621, 0.046284796581314375, 0.045491627927418114, 0.044590558163756545, 0.043583724529323464, 0.0424735151236536, 0.041262563242623486, 0.03995374113272035, 0.03855015317861559, 0.03705512854024015, 0.03547221325688232, 0.03380516183714179, 0.03205792835485145, 0.030234657072402495, 0.028339672614259702, 0.026377469715054627, 0.024352702568710853, 0.022270173808383007, 0.020134823153530094, 0.0179517157756973, 0.015726030476025082, 0.013463047896718231, 0.011168139460131466, 0.008846759826364391, 0.006504457968979654, 0.004147033260562923, 0.0017832807216942152},
	{0.0017292582512998327, 0.004021524172002136, 0.006307942578972684, 0.008580148266880501, 0.01083267878959809, 0.01306031163999467, 0.015257912146448505, 0.017420421997670153, 0.019542865836750162, 0.02162036128493398, 0.023648129691287097, 0.025621506938037816, 0.027535954088450214, 0.02938706778931075, 0.03117059038018902, 0.03288241967636875, 0.03451861839854914, 0.036075423225565256, 0.03754925344825777, 0.03893671920405134, 0.040234629273005716, 0.041439998417240366, 0.042550054246755994, 0.04356224359580069, 0.044474238395083104, 0.04528394102630035, 0.04598948914665186, 0.04658925997223365, 0.04708187401045469, 0.04746619823288566, 0.047741348681240775, 0.047906692500496006, 0.047961849394466745, 0.047906692500496006, 0.047741348681240775, 0.04746619823288566, 0.04708187401045469, 0.04658925997223365, 0.04598948914665186, 0.04528394102630035, 0.044474238395083104, 0.04356224359580069, 0.042550054246755994, 0.041439998417240366, 0.040234629273005716, 0.03893671920405134, 0.03754925344825777, 0.036075423225565256, 0.03451861839854914, 0.03288241967636875, 0.03117059038018902, 0.02938706778931075, 0.027535954088450214, 0.025621506938037816, 0.023648129691287097, 0.02162036128493398, 0.019542865836750162, 0.017420421997670153, 0.015257912146448505, 0.01306031163999467, 0.01083267878959809, 0.008580148266880501, 0.006307942578972684, 0.004021524172002136, 0.0017292582512998327},
	{0.0016776537440131765, 0.0039016256417437967, 0.006120192018448194, 0.008325388765990637, 0.010512065987705365, 0.012675303981261599, 0.014810265002733906, 0.016912181472245418, 0.018976361722770996, 0.020998199091864487, 0.022973181735326666, 0.02489690251475713, 0.026765068754249843, 0.028573511782931882, 0.030318196218868592, 0.031995228964046725, 0.03360086788611207, 0.03513153016547228, 0.036583800288138964, 0.03795443766594144, 0.03924038386682804, 0.040438769438954685, 0.04154692031324164, 0.04256236377005552, 0.04348283395666718, 0.044306276943152874, 0.04503085530544121, 0.04565495222527288, 0.04617717509791573, 0.04659635863958383, 0.04691156748762055, 0.04712209828764447, 0.04722748126299827, 0.04722748126299827, 0.04712209828764447, 0.04691156748762055, 0.04659635863958383, 0.04617717509791573, 0.04565495222527288, 0.04503085530544121, 0.044306276943152874, 0.04348283395666718, 0.04256236377005552, 0.04154692031324164, 0.040438769438954685, 0.03924038386682804, 0.03795443766594144, 0.036583800288138964, 0.03513153016547228, 0.03360086788611207, 0.031995228964046725, 0.030318196218868592, 0.028573511782931882, 0.026765068754249843, 0.02489690251475713, 0.022973181735326666, 0.020998199091864487, 0.018976361722770996, 0.016912181472245418, 0.014810265002733906, 0.012675303981261599, 0.010512065987705365, 0.008325388765990637, 0.006120192018448194, 0.0039016256417437967, 0.0016776537440131765},
	{0.0016283250352347757, 0.0037870083018259203, 0.0059406931775826755, 0.008081790299023906, 0.010205440034102347, 0.012307003849289061, 0.014381919827200057, 0.016425690622530655, 0.01843388845680485, 0.020402163371343603, 0.022326252196452245, 0.024201987609673112, 0.026025307086213253, 0.02779226166243694, 0.02949902447094573, 0.031141899019472737, 0.032717327191531385, 0.03422189694953685, 0.035652349722745016, 0.03700558746349269, 0.03827867935617967, 0.039468868164309126, 0.040573576201744635, 0.04159041091519937, 0.042517170065830695, 0.04335184649869967, 0.04409263248975118, 0.04473792366088998, 0.04528632245466974, 0.045736641161063844, 0.04608790448976174, 0.046339351682415805, 0.0464904381602648, 0.0465408367035637, 0.0464904381602648, 0.046339351682415805, 0.04608790448976174, 0.045736641161063844, 0.04528632245466974, 0.04473792366088998, 0.04409263248975118, 0.04335184649869967, 0.042517170065830695, 0.04159041091519937, 0.040573576201744635, 0.039468868164309126, 0.03827867935617967, 0.03700558746349269, 0.035652349722745016, 0.03422189694953685, 0.032717327191531385, 0.031141899019472737, 0.02949902447094573, 0.02779226166243694, 0.026025307086213253, 0.024201987609673112, 0.022326252196452245, 0.020402163371343603, 0.01843388845680485, 0.016425690622530655, 0.014381919827200057, 0.012307003849289061, 0.010205440034102347, 0.008081790299023906, 0.0059406931775826755, 0.0037870083018259203, 0.0016283250352347757},
	{0.0015811402563670584, 0.003677366595010882, 0.005768969918731274, 0.007848711393176413, 0.009912001251585405, 0.011954462319769269, 0.013971789174457669, 0.01595973590961423, 0.01791412045792314, 0.019830832087955826, 0.021705839610378082, 0.023535199685876657, 0.025315065045176697, 0.027041692545904116, 0.02871145102748529, 0.03032082893855408, 0.03186644171682134, 0.03334503890398087, 0.034753510979751934, 0.03608889590018012, 0.037348385326186874, 0.03852933052910689, 0.03962924796071256, 0.04064582447595437, 0.04157692219740321, 0.04242058301114277, 0.04317503268464448, 0.043838684597956326, 0.04441014308035301, 0.04488820634542696, 0.045271869018444114, 0.045560324250648605, 0.04575296541606825, 0.04584938738725131, 0.04584938738725131, 0.04575296541606825, 0.045560324250648605, 0.045271869018444114, 0.04488820634542696, 0.04441014308035301, 0.043838684597956326, 0.04317503268464448, 0.04242058301114277, 0.04157692219740321, 0.04064582447595437, 0.03962924796071256, 0.03852933052910689, 0.037348385326186874, 0.03608889590018012, 0.034753510979751934, 0.03334503890398087, 0.03186644171682134, 0.03032082893855408, 0.02871145102748529, 0.027041692545904116, 0.025315065045176697, 0.023535199685876657, 0.021705839610378082, 0.019830832087955826, 0.01791412045792314, 0.01595973590961423, 0.013971789174457669, 0.011954462319769269, 0.009912001251585405, 0.007848711393176413, 0.005768969918731274, 0.003677366595010882, 0.0015811402563670584},
	{0.001535976952791426, 0.00357241673939702, 0.00560457992786983, 0.007625555931201533, 0.009631006150415377, 0.011616796610671757, 0.013578860649076019, 0.015513186543406221, 0.01741582123196991, 0.019282877128849303, 0.021110539639872025, 0.022895074790740898, 0.024632836784542582, 0.026320275416869664, 0.027953943312187562, 0.02953050295790675, 0.031046733517890536, 0.03249953740964631, 0.03388594663083226, 0.03520312882168357, 0.036448393050700585, 0.037619195311641006, 0.03871314372049259, 0.03972800340176169, 0.04066170105406173, 0.04151232918565457, 0.0422781500112806, 0.042957599002305315, 0.04354928808292679, 0.04405200846590931, 0.04446473312204719, 0.04478661887831261, 0.04501700814039987, 0.04515543023614558, 0.045201602377079986, 0.04515543023614558, 0.04501700814039987, 0.04478661887831261, 0.04446473312204719, 0.04405200846590931, 0.04354928808292679, 0.042957599002305315, 0.0422781500112806, 0.04151232918565457, 0.04066170105406173, 0.03972800340176169, 0.03871314372049259, 0.037619195311641006, 0.036448393050700585, 0.03520312882168357, 0.03388594663083226, 0.03249953740964631, 0.031046733517890536, 0.02953050295790675, 0.027953943312187562, 0.026320275416869664, 0.024632836784542582, 0.022895074790740898, 0.021110539639872025, 0.019282877128849303, 0.01741582123196991, 0.015513186543406221, 0.013578860649076019, 0.011616796610671757, 0.009631006150415377, 0.007625555931201533, 0.00560457992786983, 0.00357241673939702, 0.001535976952791426},
	{0.0014927212888433063, 0.003471894893079354, 0.005447111874216002, 0.007411769363190451, 0.009361762769698311, 0.011293184649931497, 0.013202190814677075, 0.015084987865443477, 0.016937836376302633, 0.018757057093133276, 0.020539037824326575, 0.022280240452256746, 0.023977207889100613, 0.02562657090846865, 0.027225054818664274, 0.028769485955808333, 0.030256797980154376, 0.031684037961308524, 0.03304837223937246, 0.03434709204990668, 0.03557761890129241, 0.036737509693672836, 0.03782446156922297, 0.03883631648407337, 0.03977106549277658, 0.04062685273678964, 0.04140197912904528, 0.042094905727284415, 0.0427042567894498, 0.04322882250506874, 0.043667561397201474, 0.044019602390183495, 0.044284246539055466, 0.04446096841724641, 0.04454941715975472, 0.04454941715975472, 0.04446096841724641, 0.044284246539055466, 0.044019602390183495, 0.043667561397201474, 0.04322882250506874, 0.0427042567894498, 0.042094905727284415, 0.04140197912904528, 0.04062685273678964, 0.03977106549277658, 0.03883631648407337, 0.03782446156922297, 0.036737509693672836, 0.03557761890129241, 0.03434709204990668, 0.03304837223937246, 0.031684037961308524, 0.030256797980154376, 0.028769485955808333, 0.027225054818664274, 0.02562657090846865, 0.023977207889100613, 0.022280240452256746, 0.020539037824326575, 0.018757057093133276, 0.016937836376302633, 0.015084987865443477, 0.013202190814677075, 0.011293184649931497, 0.009361762769698311, 0.007411769363190451, 0.005447111874216002, 0.003471894893079354, 0.0014927212888433063},
	{0.0014512673300332772, 0.003375555496731194, 0.005296182844025117, 0.0072068352818319935, 0.009103626461992543, 0.010982860154298297, 0.012840899668088109, 0.01467415533461093, 0.01647908720746238, 0.018252210704678543, 0.019990102932349815, 0.021689409135985615, 0.023346849109223397, 0.024959223494313666, 0.02652341994215781, 0.028036419111741394, 0.029495300493708566, 0.03089724804509056, 0.03223955562344347, 0.03351963220945385, 0.03473500690768202, 0.0358833337156487, 0.03696239605198189, 0.03797011103483097, 0.038904533502262736, 0.03976385976685745, 0.04054643109724669, 0.04125073691986588, 0.04187541773473282, 0.042419267739624386, 0.04288123715758022, 0.0432604342632411, 0.04355612710410835, 0.04376774491340195, 0.04389487921178838, 0.043937284595852145, 0.04389487921178838, 0.04376774491340195, 0.04355612710410835, 0.0432604342632411, 0.04288123715758022, 0.042419267739624386, 0.04187541773473282, 0.04125073691986588, 0.04054643109724669, 0.03976385976685745, 0.038904533502262736, 0.03797011103483097, 0.03696239605198189, 0.0358833337156487, 0.03473500690768202, 0.03351963220945385, 0.03223955562344347, 0.03089724804509056, 0.029495300493708566, 0.028036419111741394, 0.02652341994215781, 0.024959223494313666, 0.023346849109223397, 0.021689409135985615, 0.019990102932349815, 0.018252210704678543, 0.01647908720746238, 0.01467415533461093, 0.012840899668088109, 0.010982860154298297, 0.009103626461992543, 0.0072068352818319935, 0.005296182844025117, 0.003375555496731194, 0.0014512673300332772},
	{0.0014115163939784783, 0.003283169774667923, 0.005151436018788564, 0.007010272321861315, 0.008855996073706261, 0.01068510816535226, 0.012494165619873158, 0.014279769054554373, 0.01603856495028501, 0.017767250789200207, 0.01946258086329457, 0.021121372216440656, 0.022740510555035693, 0.02431695606441899, 0.025847749100656032, 0.027330015738950907, 0.028760973164701855, 0.030137934895375446, 0.031458315822561686, 0.03271963706429363, 0.03391953061828609, 0.03505574380721771, 0.03612614350763786, 0.03712872015450266, 0.038061591513801986, 0.03892300621616951, 0.03971134704483473, 0.04042513397173381, 0.04106302693607495, 0.04162382836013845, 0.042106485397586324, 0.042510091910057585, 0.04283389016833869, 0.0430772722749136, 0.04323978130522252, 0.04332111216548643, 0.04332111216548643, 0.04323978130522252, 0.0430772722749136, 0.04283389016833869, 0.042510091910057585, 0.042106485397586324, 0.04162382836013845, 0.04106302693607495, 0.04042513397173381, 0.03971134704483473, 0.03892300621616951, 0.038061591513801986, 0.03712872015450266, 0.03612614350763786, 0.03505574380721771, 0.03391953061828609, 0.03271963706429363, 0.031458315822561686, 0.030137934895375446, 0.028760973164701855, 0.027330015738950907, 0.025847749100656032, 0.02431695606441899, 0.022740510555035693, 0.021121372216440656, 0.01946258086329457, 0.017767250789200207, 0.01603856495028501, 0.014279769054554373, 0.012494165619873158, 0.01068510816535226, 0.008855996073706261, 0.007010272321861315, 0.005151436018788564, 0.003283169774667923, 0.0014115163939784783},
	{0.0013733764627644432, 0.0031945243772877638, 0.005012538571607, 0.006821631349175216, 0.008618310479532027, 0.01039926099500079, 0.01216122092928036, 0.013900968788314648, 0.015615325433591655, 0.017301158762488854, 0.01895538904867009, 0.020574994420361033, 0.022157016317039948, 0.023698564864219087, 0.025196824137538276, 0.026649057298727193, 0.02805261159057182, 0.029404923180116477, 0.030703521840433436, 0.03194603546197667, 0.033130194385043714, 0.03425383554530198, 0.03531490642472817, 0.03631146880069752, 0.037241702286349536, 0.03810390765573971, 0.03889650994769659, 0.03961806134270594, 0.040267243807559805, 0.04084287150293863, 0.04134389294952528, 0.04176939294869268, 0.042118594254255466, 0.042390858992231384, 0.04258568982601819, 0.042702730864857, 0.04274176831392337, 0.042702730864857, 0.04258568982601819, 0.042390858992231384, 0.042118594254255466, 0.04176939294869268, 0.04134389294952528, 0.04084287150293863, 0.040267243807559805, 0.03961806134270594, 0.03889650994769659, 0.03810390765573971, 0.037241702286349536, 0.03631146880069752, 0.03531490642472817, 0.03425383554530198, 0.033130194385043714, 0.03194603546197667, 0.030703521840433436, 0.029404923180116477, 0.02805261159057182, 0.026649057298727193, 0.025196824137538276, 0.023698564864219087, 0.022157016317039948, 0.020574994420361033, 0.01895538904867009, 0.017301158762488854, 0.015615325433591655, 0.013900968788314648, 0.01216122092928036, 0.01039926099500079, 0.008618310479532027, 0.006821631349175216, 0.005012538571607, 0.0031945243772877638, 0.0013733764627644432},
	{0.0013367616500667935, 0.0031094201498985704, 0.004879179758594387, 0.006640492909114192, 0.008390045433971857, 0.010124694538287148, 0.011841347547500014, 0.013536949411787206, 0.015208484243401491, 0.016852979582024634, 0.018467511308979938, 0.020049208702794957, 0.02159525948167598, 0.023102914774915953, 0.024569493995942555, 0.02599238960072368, 0.027369071719679484, 0.028697092653269814, 0.029974091222461186, 0.031197796965915504, 0.0323660341762169, 0.03347672576782886, 0.034527896969826416, 0.035517678836801035, 0.036444311571658596, 0.03730614765439422, 0.03810165477126334, 0.038829418539137704, 0.03948814502019651, 0.04007666302247699, 0.04059392618219479, 0.04103901482412732, 0.04141113759675357, 0.04170963287924085, 0.041933969957777095, 0.042083749969157036, 0.04215870660994349, 0.04215870660994349, 0.042083749969157036, 0.041933969957777095, 0.04170963287924085, 0.04141113759675357, 0.04103901482412732, 0.04059392618219479, 0.04007666302247699, 0.03948814502019651, 0.038829418539137704, 0.03810165477126334, 0.03730614765439422, 0.036444311571658596, 0.035517678836801035, 0.034527896969826416, 0.03347672576782886, 0.0323660341762169, 0.031197796965915504, 0.029974091222461186, 0.028697092653269814, 0.027369071719679484, 0.02599238960072368, 0.024569493995942555, 0.023102914774915953, 0.02159525948167598, 0.020049208702794957, 0.018467511308979938, 0.016852979582024634, 0.015208484243401491, 0.013536949411787206, 0.011841347547500014, 0.010124694538287148, 0.008390045433971857, 0.006640492909114192, 0.004879179758594387, 0.0031094201498985704, 0.0013367616500667935},
	{0.0013015917173756495, 0.0030276710146050255, 0.004751069185015929, 0.006466464907037747, 0.008170710707328405, 0.009860824916114168, 0.01153387332830483, 0.013186956762824862, 0.014817212289814584, 0.016421817119024986, 0.01799799312564532, 0.01954301152012805, 0.021054197512282775, 0.022528934913865935, 0.023964670653716904, 0.025358919190216336, 0.026709266810120903, 0.028013375804780655, 0.029268988515725975, 0.030473931242214446, 0.03162611800374956, 0.032723554150934066, 0.03376433981833399, 0.03474667321333029, 0.03566885373524038, 0.03652928491929027, 0.03732647720033201, 0.03805905049151351, 0.03872573657343249, 0.03932538128963505, 0.039856946544656255, 0.04031951210114148, 0.04071227717293726, 0.04103456181139203, 0.041285808082467096, 0.04146558103261901, 0.04157356944178118, 0.041609586362141314, 0.04157356944178118, 0.04146558103261901, 0.041285808082467096, 0.04103456181139203, 0.04071227717293726, 0.04031951210114148, 0.039856946544656255, 0.03932538128963505, 0.03872573657343249, 0.03805905049151351, 0.03732647720033201, 0.03652928491929027, 0.03566885373524038, 0.03474667321333029, 0.03376433981833399, 0.032723554150934066, 0.03162611800374956, 0.030473931242214446, 0.029268988515725975, 0.028013375804780655, 0.026709266810120903, 0.025358919190216336, 0.023964670653716904, 0.022528934913865935, 0.021054197512282775, 0.01954301152012805, 0.01799799312564532, 0.016421817119024986, 0.014817212289814584, 0.013186956762824862, 0.01153387332830483, 0.009860824916114168, 0.008170710707328405, 0.006466464907037747, 0.004751069185015929, 0.0030276710146050255, 0.0013015917173756495},
	{0.0012677916340801453, 0.0029491029536403484, 0.00462793522803766, 0.006299180497328108, 0.007959847477239289, 0.009607105414714554, 0.01123816856966751, 0.012850283847510175, 0.014440731748276592, 0.01600682991224884, 0.01754593729147493, 0.019055458467190707, 0.020532847967908028, 0.021975614534416394, 0.02338132530701144, 0.02474760992065992, 0.026072164497986272, 0.027352755531827692, 0.028587223650054207, 0.029773487255905142, 0.03090954603749171, 0.03199348434042196, 0.03302347439779197, 0.03399777941205664, 0.034914756483551135, 0.03577285938071427, 0.036570641147329934, 0.03730675654238187, 0.03797996430840554, 0.03858912926450697, 0.03913322422051868, 0.03961133170906238, 0.040022645532597115, 0.04036647212284434, 0.040642231710295004, 0.04084945930182883, 0.04098780546479425, 0.04105703691622975, 0.04105703691622975, 0.04098780546479425, 0.04084945930182883, 0.040642231710295004, 0.04036647212284434, 0.040022645532597115, 0.03961133170906238, 0.03913322422051868, 0.03858912926450697, 0.03797996430840554, 0.03730675654238187, 0.036570641147329934, 0.03577285938071427, 0.034914756483551135, 0.03399777941205664, 0.03302347439779197, 0.03199348434042196, 0.03090954603749171, 0.029773487255905142, 0.028587223650054207, 0.027352755531827692, 0.026072164497986272, 0.02474760992065992, 0.02338132530701144, 0.021975614534416394, 0.020532847967908028, 0.019055458467190707, 0.01754593729147493, 0.01600682991224884, 0.014440731748276592, 0.012850283847510175, 0.01123816856966751, 0.009607105414714554, 0.007959847477239289, 0.006299180497328108, 0.00462793522803766, 0.0029491029536403484, 0.0012677916340801453},
	{0.0012352911771443755, 0.002873553083652651, 0.004509523600207086, 0.0061382961597557534, 0.007757025950082721, 0.009363023692385841, 0.01095364285391132, 0.01252626736922723, 0.01407831234002644, 0.015607227268749212, 0.017110499906531396, 0.018585660248341247, 0.020030284534315834, 0.021441999205456093, 0.02281848479012957, 0.024157479707955787, 0.025456783981694316, 0.026714262849557826, 0.02792785027127678, 0.029095552321768633, 0.030215450466622867, 0.03128570471390527, 0.032304556637030864, 0.03327033226369833, 0.03418144482611557, 0.035036397367978055, 0.03583378520391182, 0.03657229822732728, 0.03725072306289348, 0.037867945060089156, 0.03842295012455434, 0.03891482638423363, 0.03934276568756996, 0.03970606493128912, 0.040004127215591045, 0.040236462824850903, 0.04040269003221754, 0.04050253572678786, 0.04053583586232543, 0.04050253572678786, 0.04040269003221754, 0.040236462824850903, 0.040004127215591045, 0.03970606493128912, 0.03934276568756996, 0.03891482638423363, 0.03842295012455434, 0.037867945060089156, 0.03725072306289348, 0.03657229822732728, 0.03583378520391182, 0.035036397367978055, 0.03418144482611557, 0.03327033226369833, 0.032304556637030864, 0.03128570471390527, 0.030215450466622867, 0.029095552321768633, 0.02792785027127678, 0.026714262849557826, 0.025456783981694316, 0.024157479707955787, 0.02281848479012957, 0.021441999205456093, 0.020030284534315834, 0.018585660248341247, 0.017110499906531396, 0.015607227268749212, 0.01407831234002644, 0.01252626736922723, 0.01095364285391132, 0.009363023692385841, 0.007757025950082721, 0.0061382961597557534, 0.004509523600207086, 0.002873553083652651, 0.0012352911771443755},
	{0.0012040245660638238, 0.002800868811836366, 0.004395596039459112, 0.005983489944440028, 0.007561843189439228, 0.00912809922725498, 0.010679742157481381, 0.012214284549790273, 0.01372926792014474, 0.015222265680178565, 0.01669088668934382, 0.01813277895498232, 0.019545633343399878, 0.020927187251878147, 0.022275228219114214, 0.02358759746145774, 0.02486219332622279, 0.02609697465510898, 0.02728996405162444, 0.02843925104689755, 0.02954299515860712, 0.030599428838013334, 0.031606860300304934, 0.03256367623368934, 0.03346834438285924, 0.03431941600268937, 0.035115528178217434, 0.03585540600719192, 0.036537864641684945, 0.037161811185498696, 0.037726246444324485, 0.038230266525851264, 0.038673064287257954, 0.03905393062777367, 0.03937225562423342, 0.03962752950781081, 0.039819343480364366, 0.039947390369088336, 0.04001146511842077, 0.04001146511842077, 0.039947390369088336, 0.039819343480364366, 0.03962752950781081, 0.03937225562423342, 0.03905393062777367, 0.038673064287257954, 0.038230266525851264, 0.037726246444324485, 0.037161811185498696, 0.036537864641684945, 0.03585540600719192, 0.035115528178217434, 0.03431941600268937, 0.03346834438285924, 0.03256367623368934, 0.031606860300304934, 0.030599428838013334, 0.02954299515860712, 0.02843925104689755, 0.02728996405162444, 0.02609697465510898, 0.02486219332622279, 0.02358759746145774, 0.022275228219114214, 0.020927187251878147, 0.019545633343399878, 0.01813277895498232, 0.01669088668934382, 0.015222265680178565, 0.01372926792014474, 0.012214284549790273, 0.010679742157481381, 0.00912809922725498, 0.007561843189439228, 0.005983489944440028, 0.004395596039459112, 0.002800868811836366, 0.0012040245660638238},
	{0.0011739301299596256, 0.002730907065755578, 0.004285929113126977, 0.005834459868762667, 0.007373921131330134, 0.008901880982651968, 0.010415946204513391, 0.01191375021511702, 0.013392953344825874, 0.014851245526349678, 0.016286349576191416, 0.017696024624310306, 0.019078069558937517, 0.02043032643814102, 0.021750683846607985, 0.023037080185718796, 0.024287506888799538, 0.025500011555128772, 0.026672700997105663, 0.027803744195446917, 0.028891375157607153, 0.029933895674838146, 0.030929677973524743, 0.03187716725661119, 0.0327748841311307, 0.0336214269180308, 0.034415473840676475, 0.035155785088611086, 0.0358412047533456, 0.03647066263315337, 0.03704317590404666, 0.03755785065432963, 0.03801388328032593, 0.03841056174110401, 0.03874726667023985, 0.03902347234287968, 0.03923874749659457, 0.03939275600474293, 0.03948525740129104, 0.03951610725627119, 0.03948525740129104, 0.03939275600474293, 0.03923874749659457, 0.03902347234287968, 0.03874726667023985, 0.03841056174110401, 0.03801388328032593, 0.03755785065432963, 0.03704317590404666, 0.03647066263315337, 0.0358412047533456, 0.035155785088611086, 0.034415473840676475, 0.0336214269180308, 0.0327748841311307, 0.03187716725661119, 0.030929677973524743, 0.029933895674838146, 0.028891375157607153, 0.027803744195446917, 0.026672700997105663, 0.025500011555128772, 0.024287506888799538, 0.023037080185718796, 0.021750683846607985, 0.02043032643814102, 0.019078069558937517, 0.017696024624310306, 0.016286349576191416, 0.014851245526349678, 0.013392953344825874, 0.01191375021511702, 0.010415946204513391, 0.008901880982651968, 0.007373921131330134, 0.005834459868762667, 0.004285929113126977, 0.002730907065755578, 0.0011739301299596256},
	{0.0011449500031885224, 0.002663533589513713, 0.004180313124695047, 0.005690922451403673, 0.007192904768117152, 0.008683945269261395, 0.010161766041102983, 0.011624114120797644, 0.013068761592400866, 0.014493508040508975, 0.015896183583725406, 0.01727465205626924, 0.018626814208298613, 0.019950610878142407, 0.021244026115781908, 0.02250509024633233, 0.02373188286592992, 0.024922535764115357, 0.02607523576756492, 0.027188227500486207, 0.028259816057276736, 0.02928836958326768, 0.030272321759557783, 0.03121017418811484, 0.03210049867348784, 0.03294193939764526, 0.03373321498461144, 0.034473120451753846, 0.03516052904474753, 0.035794393953415986, 0.03637374990583587, 0.03689771463827592, 0.03736549023873043, 0.03777636436200133, 0.03812971131447754, 0.03842499300695934, 0.038661759774076425, 0.03883965105905189, 0.03895839596276948, 0.03901781365630659, 0.03901781365630659, 0.03895839596276948, 0.03883965105905189, 0.038661759774076425, 0.03842499300695934, 0.03812971131447754, 0.03777636436200133, 0.03736549023873043, 0.03689771463827592, 0.03637374990583587, 0.035794393953415986, 0.03516052904474753, 0.034473120451753846, 0.03373321498461144, 0.03294193939764526, 0.03210049867348784, 0.03121017418811484, 0.030272321759557783, 0.02928836958326768, 0.028259816057276736, 0.027188227500486207, 0.02607523576756492, 0.024922535764115357, 0.02373188286592992, 0.02250509024633233, 0.021244026115781908, 0.019950610878142407, 0.018626814208298613, 0.01727465205626924, 0.015896183583725406, 0.014493508040508975, 0.013068761592400866, 0.011624114120797644, 0.010161766041102983, 0.008683945269261395, 0.007192904768117152, 0.005690922451403673, 0.004180313124695047, 0.002663533589513713, 0.0011449500031885224},
	{0.0011170298471264706, 0.0025986222999291124, 0.004078551113421077, 0.005552611370256507, 0.007018460484931308, 0.008473893785345623, 0.009916741809595911, 0.011344858495415893, 0.012756121115134281, 0.01414843251323594, 0.015519723912464287, 0.016867957867635133, 0.01819113124125582, 0.019487278155601962, 0.02075447290144578, 0.0219908327927516, 0.0231945209602738, 0.024363749078562858, 0.025496780021665697, 0.026591930443220103, 0.027647573276924874, 0.028662140153560632, 0.02963412373090553, 0.030562079933052735, 0.03144463009577403, 0.03228046301473259, 0.033068336893488044, 0.03380708118839621, 0.034495598347659764, 0.03513286544193938, 0.03571793568410447, 0.03624993983586338, 0.03672808749918039, 0.037151668290563655, 0.03752005289647575, 0.037832694008300465, 0.03808912713547551, 0.03828897129558344, 0.038431929580375085, 0.0385177895968846, 0.0385464237829806, 0.0385177895968846, 0.038431929580375085, 0.03828897129558344, 0.03808912713547551, 0.037832694008300465, 0.03752005289647575, 0.037151668290563655, 0.03672808749918039, 0.03624993983586338, 0.03571793568410447, 0.03513286544193938, 0.034495598347659764, 0.03380708118839621, 0.033068336893488044, 0.03228046301473259, 0.03144463009577403, 0.030562079933052735, 0.02963412373090553, 0.028662140153560632, 0.027647573276924874, 0.026591930443220103, 0.025496780021665697, 0.024363749078562858, 0.0231945209602738, 0.0219908327927516, 0.02075447290144578, 0.019487278155601962, 0.01819113124125582, 0.016867957867635133, 0.015519723912464287, 0.01414843251323594, 0.012756121115134281, 0.011344858495415893, 0.009916741809595911, 0.008473893785345623, 0.007018460484931308, 0.005552611370256507, 0.004078551113421077, 0.0025986222999291124, 0.0011170298471264706},
	{0.0010901185952767803, 0.0025360546968549685, 0.003980457937855649, 0.005419276232446696, 0.006850274534182072, 0.008271351818383853, 0.009680440704371174, 0.011075495781759743, 0.012454493401141952, 0.013815433714126713, 0.01515634327076275, 0.01647527776398398, 0.01777032479849845, 0.019039606640178973, 0.020281282926912392, 0.021493553330775163, 0.02267466016491411, 0.023822890930047733, 0.024936580796240927, 0.026014115016016928, 0.02705393126512474, 0.028054521907454194, 0.02901443618076433, 0.02993228230001264, 0.03080672947521564, 0.031636509840900384, 0.0324204202943407, 0.03315732423990723, 0.03384615323699694, 0.034485908549150714, 0.035075662592112714, 0.03561456027872756, 0.036101820258727046, 0.03653673605160773, 0.03691867707095447, 0.03724708953872771, 0.03752149728818508, 0.037741502454275884, 0.037906786050505854, 0.03801710843143529, 0.03807230964014191, 0.03807230964014191, 0.03801710843143529, 0.037906786050505854, 0.037741502454275884, 0.03752149728818508, 0.03724708953872771, 0.03691867707095447, 0.03653673605160773, 0.036101820258727046, 0.03561456027872756, 0.035075662592112714, 0.034485908549150714, 0.03384615323699694, 0.03315732423990723, 0.0324204202943407, 0.031636509840900384, 0.03080672947521564, 0.02993228230001264, 0.02901443618076433, 0.028054521907454194, 0.02705393126512474, 0.026014115016016928, 0.024936580796240927, 0.023822890930047733, 0.02267466016491411, 0.021493553330775163, 0.020281282926912392, 0.019039606640178973, 0.01777032479849845, 0.01647527776398398, 0.01515634327076275, 0.013815433714126713, 0.012454493401141952, 0.011075495781759743, 0.009680440704371174, 0.008271351818383853, 0.006850274534182072, 0.005419276232446696, 0.003980457937855649, 0.0025360546968549685, 0.0010901185952767803},
	{0.0010641682196673942, 0.002475719322545105, 0.0038858594353542953, 0.005290681445860296, 0.0066880516352437825, 0.008075966593123287, 0.009452455092480022, 0.010815566558037566, 0.012163370727798054, 0.013493959512374957, 0.014805449400717964, 0.016095984011935644, 0.017363736673824154, 0.018606912985478705, 0.019823753345654904, 0.021012535437269896, 0.022171576661803635, 0.02329923651890052, 0.02439391892715859, 0.025454074482489278, 0.026478202650673924, 0.027464853890903054, 0.028412631707247477, 0.029320194625104455, 0.03018625808981448, 0.031009596284739156, 0.03178904386622212, 0.03252349761296801, 0.03321191798750499, 0.03385333060751519, 0.034446827624950487, 0.034991569010979565, 0.03548678374494699, 0.0359317709056606, 0.036325900663462245, 0.03666861517167802, 0.036959429356184896, 0.03719793160197668, 0.03738378433575734, 0.037516724503737234, 0.03759656394395506, 0.03762318965260004, 0.03759656394395506, 0.037516724503737234, 0.03738378433575734, 0.03719793160197668, 0.036959429356184896, 0.03666861517167802, 0.036325900663462245, 0.0359317709056606, 0.03548678374494699, 0.034991569010979565, 0.034446827624950487, 0.03385333060751519, 0.03321191798750499, 0.03252349761296801, 0.03178904386622212, 0.031009596284739156, 0.03018625808981448, 0.029320194625104455, 0.028412631707247477, 0.027464853890903054, 0.026478202650673924, 0.025454074482489278, 0.02439391892715859, 0.02329923651890052, 0.022171576661803635, 0.021012535437269896, 0.019823753345654904, 0.018606912985478705, 0.017363736673824154, 0.016095984011935644, 0.014805449400717964, 0.013493959512374957, 0.012163370727798054, 0.010815566558037566, 0.009452455092480022, 0.008075966593123287, 0.0066880516352437825, 0.005290681445860296, 0.0038858594353542953, 0.002475719322545105, 0.0010641682196673942},
	{0.0010391335164544866, 0.002417511265443844, 0.003794591650452313, 0.005166605182747508, 0.006531513687712504, 0.007887405752648421, 0.009232400784190643, 0.010564637623008208, 0.01188227408980137, 0.013183488679182651, 0.014466482789161524, 0.01572948309558371, 0.016970743955211334, 0.0181885497960566, 0.0193812174773188, 0.020547098609756394, 0.021684581830644638, 0.022792095028942052, 0.023868107516958118, 0.024911132145206252, 0.025919727357334523, 0.026892499182197528, 0.027828103160258303, 0.028725246201621677, 0.029582688373110646, 0.0303992446119023, 0.03117378636334549, 0.03190524314069258, 0.03259260400458406, 0.03323491896024033, 0.033831300270425836, 0.034380923682372534, 0.034883029566963125, 0.035336923968601074, 0.035741979564315164, 0.03609763653077238, 0.03640340331800194, 0.036658857328758884, 0.03686364550259016, 0.03701748480379434, 0.037120162612601905, 0.03717153701903387, 0.03717153701903387, 0.037120162612601905, 0.03701748480379434, 0.03686364550259016, 0.036658857328758884, 0.03640340331800194, 0.03609763653077238, 0.035741979564315164, 0.035336923968601074, 0.034883029566963125, 0.034380923682372534, 0.033831300270425836, 0.03323491896024033, 0.03259260400458406, 0.03190524314069258, 0.03117378636334549, 0.0303992446119023, 0.029582688373110646, 0.028725246201621677, 0.027828103160258303, 0.026892499182197528, 0.025919727357334523, 0.024911132145206252, 0.023868107516958118, 0.022792095028942052, 0.021684581830644638, 0.020547098609756394, 0.0193812174773188, 0.0181885497960566, 0.016970743955211334, 0.01572948309558371, 0.014466482789161524, 0.013183488679182651, 0.01188227408980137, 0.010564637623008208, 0.009232400784190643, 0.007887405752648421, 0.006531513687712504, 0.005166605182747508, 0.003794591650452313, 0.002417511265443844, 0.0010391335164544866},
	{0.0010149719089635016, 0.002361331704283739, 0.00370650012575929, 0.00504683842692466, 0.006380398587898551, 0.007705355960383501, 0.009019915439993585, 0.010322300230523926, 0.011610751286703781, 0.012883528856498693, 0.01413891454840072, 0.015375213542389856, 0.01659075683115459, 0.017783903451398273, 0.018953042688182795, 0.020096596243575588, 0.02121302036408954, 0.022300807922839515, 0.023358490452990027, 0.024384640129435687, 0.025377871695866173, 0.026336844334514546, 0.027260263476011272, 0.028146882546865242, 0.028995504652190272, 0.02980498419139585, 0.030574228404650208, 0.03130219884802104, 0.031987912795304836, 0.03263044456464236, 0.033228926768132896, 0.033782551482757654, 0.03429057134102996, 0.03475230053990075, 0.03516711576655591, 0.03553445703985584, 0.03585382846628094, 0.03612479890936258, 0.03634700257169532, 0.03652013948874501, 0.036643975933785815, 0.03671834473341972, 0.03674314549325224, 0.03671834473341972, 0.036643975933785815, 0.03652013948874501, 0.03634700257169532, 0.03612479890936258, 0.03585382846628094, 0.03553445703985584, 0.03516711576655591, 0.03475230053990075, 0.03429057134102996, 0.033782551482757654, 0.033228926768132896, 0.03263044456464236, 0.031987912795304836, 0.03130219884802104, 0.030574228404650208, 0.02980498419139585, 0.028995504652190272, 0.028146882546865242, 0.027260263476011272, 0.026336844334514546, 0.025377871695866173, 0.024384640129435687, 0.023358490452990027, 0.022300807922839515, 0.02121302036408954, 0.020096596243575588, 0.018953042688182795, 0.017783903451398273, 0.01659075683115459, 0.015375213542389856, 0.01413891454840072, 0.012883528856498693, 0.011610751286703781, 0.010322300230523926, 0.009019915439993585, 0.007705355960383501, 0.006380398587898551, 0.00504683842692466, 0.00370650012575929, 0.002361331704283739, 0.0010149719089635016},
	{0.000991643266613615, 0.0023070874888097494, 0.003621439249611204, 0.004931184096959908, 0.0062344591391401884, 0.00752952161219476, 0.008814657101955246, 0.010088168460386557, 0.011348375156177821, 0.012593614678070422, 0.013822244452766613, 0.015032643905081598, 0.016223216549728865, 0.017392392075690537, 0.01853862840671017, 0.019660413729562228, 0.020756268484909128, 0.02182474731692782, 0.02286444097854821, 0.023873978189479155, 0.02485202744439993, 0.02579729876883974, 0.026708545420372348, 0.02758456553285133, 0.028424203701493757, 0.02922635250671015, 0.02998995397466509, 0.030714000972632216, 0.03139753853730298, 0.03203966513429413, 0.03263953384719009, 0.03319635349455176, 0.03370938967341773, 0.034177965727920104, 0.0346014636417379, 0.03497932485321032, 0.03531105099203437, 0.03559620453657567, 0.035834409390924214, 0.03602535138093543, 0.03616877866860084, 0.03626450208420254, 0.036312395375813475, 0.036312395375813475, 0.03626450208420254, 0.03616877866860084, 0.03602535138093543, 0.035834409390924214, 0.03559620453657567, 0.03531105099203437, 0.03497932485321032, 0.0346014636417379, 0.034177965727920104, 0.03370938967341773, 0.03319635349455176, 0.03263953384719009, 0.03203966513429413, 0.03139753853730298, 0.030714000972632216, 0.02998995397466509, 0.02922635250671015, 0.028424203701493757, 0.02758456553285133, 0.026708545420372348, 0.02579729876883974, 0.02485202744439993, 0.023873978189479155, 0.02286444097854821, 0.02182474731692782, 0.020756268484909128, 0.019660413729562228, 0.01853862840671017, 0.017392392075690537, 0.016223216549728865, 0.015032643905081598, 0.013822244452766613, 0.012593614678070422, 0.011348375156177821, 0.010088168460386557, 0.008814657101955246, 0.00752952161219476, 0.0062344591391401884, 0.004931184096959908, 0.003621439249611204, 0.0023070874888097494, 0.000991643266613615},
	{0.0009691097381757348, 0.0022546907537549384, 0.003539271655388117, 0.004819456238501684, 0.00609346204763528, 0.007359623648817653, 0.008616302838488783, 0.009861877713702014, 0.011094741940560695, 0.012313306030048123, 0.013515999118245947, 0.0147012708872398, 0.015867593518826113, 0.017013463643001287, 0.0181374042653544, 0.01923796666535654, 0.020313732260655384, 0.021363314433802724, 0.022385360318485367, 0.02337855254266003, 0.024341610926167583, 0.025273294130557043, 0.026172401258933563, 0.027037773403735973, 0.02786829514042919, 0.028662895965176235, 0.02942055167462312, 0.03014028568601895, 0.030821170295962166, 0.031462327876150824, 0.032062932004589706, 0.03262220853080143, 0.03313943657366203, 0.03361394945057692, 0.034045135536799345, 0.03443243905378225, 0.03477536078554787, 0.03507345872215154, 0.03532634862941022, 0.03553370454416061, 0.035695259194409426, 0.03581080434383377, 0.03588019106018702, 0.03590332990726553, 0.03588019106018702, 0.03581080434383377, 0.035695259194409426, 0.03553370454416061, 0.03532634862941022, 0.03507345872215154, 0.03477536078554787, 0.03443243905378225, 0.034045135536799345, 0.03361394945057692, 0.03313943657366203, 0.03262220853080143, 0.032062932004589706, 0.031462327876150824, 0.030821170295962166, 0.03014028568601895, 0.02942055167462312, 0.028662895965176235, 0.02786829514042919, 0.027037773403735973, 0.026172401258933563, 0.025273294130557043, 0.024341610926167583, 0.02337855254266003, 0.022385360318485367, 0.021363314433802724, 0.020313732260655384, 0.01923796666535654, 0.0181374042653544, 0.017013463643001287, 0.015867593518826113, 0.0147012708872398, 0.013515999118245947, 0.012313306030048123, 0.011094741940560695, 0.009861877713702014, 0.008616302838488783, 0.007359623648817653, 0.00609346204763528, 0.004819456238501684, 0.003539271655388117, 0.0022546907537549384, 0.0009691097381757348},
	{0.0009473355981601172, 0.002204058563145238, 0.003459867667861557, 0.004711479279598937, 0.00595718699613714, 0.007195398459795966, 0.008424547492703152, 0.00964308332205318, 0.010849469775429216, 0.012042186439580964, 0.013219730313628233, 0.01438061760130026, 0.015523385536933604, 0.01664659420821771, 0.017748828360324355, 0.01882869917375565, 0.01988484601127417, 0.020915938130576784, 0.021920676359989965, 0.02289779473478103, 0.023846062091859698, 0.02476428362076878, 0.02565130236896187, 0.026506000699434765, 0.027327301698855354, 0.0281141705344086, 0.02886561575763545, 0.029580690553619438, 0.03025849393394365, 0.03089817187191218, 0.03149891837860495, 0.03205997651840641, 0.03258063936273217, 0.03306025088074669, 0.03349820676595309, 0.033893955197610286, 0.03424699753602011, 0.03455688895080718, 0.03482323898139939, 0.035045712029004306, 0.0352240277794591, 0.035357961556423886, 0.035447344604470785, 0.03549206430171453, 0.03549206430171453, 0.035447344604470785, 0.035357961556423886, 0.0352240277794591, 0.035045712029004306, 0.03482323898139939, 0.03455688895080718, 0.03424699753602011, 0.033893955197610286, 0.03349820676595309, 0.03306025088074669, 0.03258063936273217, 0.03205997651840641, 0.03149891837860495, 0.03089817187191218, 0.03025849393394365, 0.029580690553619438, 0.02886561575763545, 0.0281141705344086, 0.027327301698855354, 0.026506000699434765, 0.02565130236896187, 0.02476428362076878, 0.023846062091859698, 0.02289779473478103, 0.021920676359989965, 0.020915938130576784, 0.01988484601127417, 0.01882869917375565, 0.017748828360324355, 0.01664659420821771, 0.015523385536933604, 0.01438061760130026, 0.013219730313628233, 0.012042186439580964, 0.010849469775429216, 0.00964308332205318, 0.008424547492703152, 0.007195398459795966, 0.00595718699613714, 0.004711479279598937, 0.003459867667861557, 0.002204058563145238, 0.0009473355981601172},
	{0.0009262871051964369, 0.002155112582217011, 0.0033831047924084, 0.0046070873434645235, 0.0058254257887694295, 0.0070365968709893995, 0.008239102525388578, 0.009431459260798143, 0.010612197289971793, 0.011779861580875161, 0.012933013392602376, 0.014070231948644395, 0.015190116144665904, 0.016291286254792318, 0.017372385621502402, 0.018432082321784147, 0.01946907080515168, 0.020482073500400266, 0.021469842388561165, 0.022431160539836435, 0.023364843612455458, 0.024269741311522326, 0.025144738806002615, 0.02598875810207372, 0.02680075937112898, 0.027579742230784503, 0.02832474697730514, 0.029034855767926727, 0.029709193751612444, 0.030346930146849006, 0.030947279265154812, 0.031509501479034224, 0.03203290413318954, 0.03251684239786311, 0.0329607200632611, 0.03336399027407727, 0.033726156203214605, 0.03404677166387099, 0.03432544165923902, 0.03456182286913775, 0.034755624072981356, 0.03490660650856065, 0.035014584166196405, 0.035079424017901956, 0.03510104618127303, 0.035079424017901956, 0.035014584166196405, 0.03490660650856065, 0.034755624072981356, 0.03456182286913775, 0.03432544165923902, 0.03404677166387099, 0.033726156203214605, 0.03336399027407727, 0.0329607200632611, 0.03251684239786311, 0.03203290413318954, 0.031509501479034224, 0.030947279265154812, 0.030346930146849006, 0.029709193751612444, 0.029034855767926727, 0.02832474697730514, 0.027579742230784503, 0.02680075937112898, 0.02598875810207372, 0.025144738806002615, 0.024269741311522326, 0.023364843612455458, 0.022431160539836435, 0.021469842388561165, 0.020482073500400266, 0.01946907080515168, 0.018432082321784147, 0.017372385621502402, 0.016291286254792318, 0.015190116144665904, 0.014070231948644395, 0.012933013392602376, 0.011779861580875161, 0.010612197289971793, 0.009431459260798143, 0.008239102525388578, 0.0070365968709893995, 0.0058254257887694295, 0.0046070873434645235, 0.0033831047924084, 0.002155112582217011, 0.0009262871051964369},
	{0.0009059323712157259, 0.002107778774524567, 0.003308867243337093, 0.004506123613675202, 0.005697981560747534, 0.006882983208462412, 0.00805969494461967, 0.009226696957741538, 0.010382582309893479, 0.011525957889148227, 0.01265544583716832, 0.01376968511233744, 0.014867333088043094, 0.0159470671510065, 0.017007586285222656, 0.01804761263446009, 0.01906589303913717, 0.020061200544639772, 0.02103233587872259, 0.02197812889593415, 0.022897439987163343, 0.0237891614525286, 0.024652218835904866, 0.025485572219443205, 0.026288217476514667, 0.027059187481548053, 0.02779755327530226, 0.028502425184161552, 0.02917295389210082, 0.02980833146403132, 0.03040779231928696, 0.030970614154080957, 0.03149611881181865, 0.031983673100218594, 0.032432689554255635, 0.0328426271440075, 0.033212991926551326, 0.033543337641124216, 0.03383326624683168, 0.034082428402254, 0.03429052388637504, 0.03445730196032425, 0.03458256166949692, 0.03466615208568823, 0.03470797248895009, 0.03470797248895009, 0.03466615208568823, 0.03458256166949692, 0.03445730196032425, 0.03429052388637504, 0.034082428402254, 0.03383326624683168, 0.033543337641124216, 0.033212991926551326, 0.0328426271440075, 0.032432689554255635, 0.031983673100218594, 0.03149611881181865, 0.030970614154080957, 0.03040779231928696, 0.02980833146403132, 0.02917295389210082, 0.028502425184161552, 0.02779755327530226, 0.027059187481548053, 0.026288217476514667, 0.025485572219443205, 0.024652218835904866, 0.0237891614525286, 0.022897439987163343, 0.02197812889593415, 0.02103233587872259, 0.020061200544639772, 0.01906589303913717, 0.01804761263446009, 0.017007586285222656, 0.0159470671510065, 0.014867333088043094, 0.01376968511233744, 0.01265544583716832, 0.011525957889148227, 0.010382582309893479, 0.009226696957741538, 0.00805969494461967, 0.006882983208462412, 0.005697981560747534, 0.004506123613675202, 0.003308867243337093, 0.002107778774524567, 0.0009059323712157259},
	{0.0008862412406751003, 0.002061987122034217, 0.003237045507973795, 0.00440843974730319, 0.005574668047479728, 0.006734334432269666, 0.007886066314628907, 0.0090285041892342, 0.010160300654414872, 0.011280121273769492, 0.012386645903556388, 0.01347857015383048, 0.014554606885208363, 0.015613487707049404, 0.01665396446306089, 0.017674810697521498, 0.018674823098168144, 0.01965282291296886, 0.02060765733859825, 0.021538200878685607, 0.022443356670097222, 0.02332205777559865, 0.02417326844132255, 0.02499598531753465, 0.025789238641235817, 0.026552093379198703, 0.027283650330082787, 0.02798304718432304, 0.028649459540540777, 0.029282101877277113, 0.02988022847890014, 0.030443134314594188, 0.03097015586939625, 0.03146067192629684, 0.03191410429848342, 0.0323299185108651, 0.03270762443007254, 0.033046776842191476, 0.03334697597754954, 0.03360786798193549, 0.03382914533369764, 0.03401054720622884, 0.034151859775409875, 0.03425291647165076, 0.0343135981762311, 0.03433383336170866, 0.0343135981762311, 0.03425291647165076, 0.034151859775409875, 0.03401054720622884, 0.03382914533369764, 0.03360786798193549, 0.03334697597754954, 0.033046776842191476, 0.03270762443007254, 0.0323299185108651, 0.03191410429848342, 0.03146067192629684, 0.03097015586939625, 0.030443134314594188, 0.02988022847890014, 0.029282101877277113, 0.028649459540540777, 0.02798304718432304, 0.027283650330082787, 0.026552093379198703, 0.025789238641235817, 0.02499598531753465, 0.02417326844132255, 0.02332205777559865, 0.022443356670097222, 0.021538200878685607, 0.02060765733859825, 0.01965282291296886, 0.018674823098168144, 0.017674810697521498, 0.01665396446306089, 0.015613487707049404, 0.014554606885208363, 0.01347857015383048, 0.012386645903556388, 0.011280121273769492, 0.010160300654414872, 0.0090285041892342, 0.007886066314628907, 0.006734334432269666, 0.005574668047479728, 0.00440843974730319, 0.003237045507973795, 0.002061987122034217, 0.0008862412406751003},
	{0.0008671851787713772, 0.002017671366259443, 0.003167535943397252, 0.004313895331861211, 0.005455308908001706, 0.0065904393342145935, 0.007717971837373496, 0.00883660405646801, 0.009945045019726314, 0.011042015922635182, 0.012126251362637902, 0.013196500705710693, 0.014251529488954426, 0.01529012082579651, 0.01631107680025589, 0.01731321984368947, 0.018295394090267297, 0.019256466708559485, 0.020195329207187404, 0.02111089871276239, 0.022002119218485886, 0.022867962801892457, 0.02370743081028203, 0.024519555012440925, 0.025303398715313178, 0.02605805784431407, 0.02678266198604026, 0.027476375392164135, 0.028138397943354338, 0.028767966072107024, 0.029364353643422728, 0.029926872792311064, 0.03045487471715822, 0.03094775042804097, 0.031404931449122105, 0.031825890474320016, 0.03221014197549325, 0.03255724276243994, 0.03286679249406559, 0.03313843414012923, 0.033371854393036755, 0.03356678402920363, 0.03372299821957377, 0.03384031678893349, 0.03391860442372246, 0.03395777082810228, 0.03395777082810228, 0.03391860442372246, 0.03384031678893349, 0.03372299821957377, 0.03356678402920363, 0.033371854393036755, 0.03313843414012923, 0.03286679249406559, 0.03255724276243994, 0.03221014197549325, 0.031825890474320016, 0.031404931449122105, 0.03094775042804097, 0.03045487471715822, 0.029926872792311064, 0.029364353643422728, 0.028767966072107024, 0.028138397943354338, 0.027476375392164135, 0.02678266198604026, 0.02605805784431407, 0.025303398715313178, 0.024519555012440925, 0.02370743081028203, 0.022867962801892457, 0.022002119218485886, 0.02111089871276239, 0.020195329207187404, 0.019256466708559485, 0.018295394090267297, 0.01731321984368947, 0.01631107680025589, 0.01529012082579651, 0.014251529488954426, 0.013196500705710693, 0.012126251362637902, 0.011042015922635182, 0.009945045019726314, 0.00883660405646801, 0.007717971837373496, 0.0065904393342145935, 0.005455308908001706, 0.004313895331861211, 0.003167535943397252, 0.002017671366259443, 0.0008671851787713772},
	{0.0008487371680734414, 0.001974768768687738, 0.003100240403099636, 0.004222357382406593, 0.0053397370981683135, 0.006451097794311515, 0.007555179500770054, 0.008650734035428332, 0.009736523941887475, 0.010811323190542671, 0.011873918327447656, 0.012923109753185185, 0.013957713038007545, 0.014976560240671927, 0.01597850121778225, 0.016962404917328654, 0.017927160652813745, 0.018871679355507955, 0.019794894802927843, 0.020695764821868586, 0.021573272464499846, 0.02242642715610953, 0.023254265813157426, 0.024055853930344394, 0.024830286635452416, 0.02557668971075768, 0.026294220579853218, 0.02698206925876261, 0.027639459270270516, 0.028265648520432857, 0.028859930136277544, 0.029421633263748703, 0.02995012382499363, 0.0304448052341351, 0.030905119070722735, 0.03133054571010255, 0.0317206049099921, 0.032074856352598984, 0.03239290014167199, 0.03267437725392214, 0.032918969944304294, 0.03312640210470301, 0.03329643957561553, 0.033428890410482734, 0.03352360509236663, 0.03358047670273268, 0.03359944104214394, 0.03358047670273268, 0.03352360509236663, 0.033428890410482734, 0.03329643957561553, 0.03312640210470301, 0.032918969944304294, 0.03267437725392214, 0.03239290014167199, 0.032074856352598984, 0.0317206049099921, 0.03133054571010255, 0.030905119070722735, 0.0304448052341351, 0.02995012382499363, 0.029421633263748703, 0.028859930136277544, 0.028265648520432857, 0.027639459270270516, 0.02698206925876261, 0.026294220579853218, 0.02557668971075768, 0.024830286635452416, 0.024055853930344394, 0.023254265813157426, 0.02242642715610953, 0.021573272464499846, 0.020695764821868586, 0.019794894802927843, 0.018871679355507955, 0.017927160652813745, 0.016962404917328654, 0.01597850121778225, 0.014976560240671927, 0.013957713038007545, 0.012923109753185185, 0.011873918327447656, 0.010811323190542671, 0.009736523941887475, 0.008650734035428332, 0.007555179500770054, 0.006451097794311515, 0.0053397370981683135, 0.004222357382406593, 0.003100240403099636, 0.001974768768687738, 0.0008487371680734414},
	{0.0008308716126862451, 0.0019332198887263505, 0.0030350658910378845, 0.004133699875408537, 0.00522779428950745, 0.0063161200910360135, 0.0073974692881421215, 0.008470645094534964, 0.009534460832865577, 0.010587740564954049, 0.01162932016112229, 0.012658048497638892, 0.01367278869060694, 0.014672419334499507, 0.015655835732515392, 0.016621951112665415, 0.017569697826143354, 0.01849802852566583, 0.01940591732198177, 0.020292360917010772, 0.02115637971222128, 0.02199701889093982, 0.022813349473355164, 0.02360446934301428, 0.0243695042436691, 0.025107608745352172, 0.025817967178616622, 0.02649979453589149, 0.027152337338966385, 0.027774874471634035, 0.028366717976575972, 0.028927213815606152, 0.02945574259243349, 0.02995172023714369, 0.030414598651642564, 0.03084386631534899, 0.031239048850467264, 0.0315997095462131, 0.031925449841415494, 0.03221590976496016, 0.03247076833358756, 0.032689743906606165, 0.032872594497129426, 0.03301911803949149, 0.033129152612546765, 0.03320257661860668, 0.03323930891781514, 0.03323930891781514, 0.03320257661860668, 0.033129152612546765, 0.03301911803949149, 0.032872594497129426, 0.032689743906606165, 0.03247076833358756, 0.03221590976496016, 0.031925449841415494, 0.0315997095462131, 0.031239048850467264, 0.03084386631534899, 0.030414598651642564, 0.02995172023714369, 0.02945574259243349, 0.028927213815606152, 0.028366717976575972, 0.027774874471634035, 0.027152337338966385, 0.02649979453589149, 0.025817967178616622, 0.025107608745352172, 0.0243695042436691, 0.02360446934301428, 0.022813349473355164, 0.02199701889093982, 0.02115637971222128, 0.020292360917010772, 0.01940591732198177, 0.01849802852566583, 0.017569697826143354, 0.016621951112665415, 0.015655835732515392, 0.014672419334499507, 0.01367278869060694, 0.012658048497638892, 0.01162932016112229, 0.010587740564954049, 0.009534460832865577, 0.008470645094534964, 0.0073974692881421215, 0.0063161200910360135, 0.00522779428950745, 0.004133699875408537, 0.0030350658910378845, 0.0019332198887263505, 0.0008308716126862451},
	{0.0008135642494554402, 0.0018929683779222934, 0.0029719242408186093, 0.004047803316371942, 0.005119330329928406, 0.006185326261032374, 0.007244632443932776, 0.008296100874530385, 0.009338593083876447, 0.010370980703116501, 0.011392146459086072, 0.012400985296115863, 0.013396405534368003, 0.014377330033658984, 0.015342697350288518, 0.016291462880991172, 0.017222599990716934, 0.018135101122045336, 0.01902797888454552, 0.019900267122657335, 0.020751021960784766, 0.021579322824411554, 0.0223842734360694, 0.023165002785071515, 0.02392066606993068, 0.024650445612442538, 0.025353551742431892, 0.026029223652202078, 0.026676730219761333, 0.027295370799930194, 0.027884475982476814, 0.028443408316454845, 0.028971562999960947, 0.0294683685345669, 0.029933287343714098, 0.03036581635440501, 0.030765487541558872, 0.031131868434443974, 0.031464562584638374, 0.03176320999501227, 0.03202748750926767, 0.032257109161614395, 0.03245182648620326, 0.03261142878598212, 0.03273574336068394, 0.03282463569369913, 0.03287800959763198, 0.03289580731838069, 0.03287800959763198, 0.03282463569369913, 0.03273574336068394, 0.03261142878598212, 0.03245182648620326, 0.032257109161614395, 0.03202748750926767, 0.03176320999501227, 0.031464562584638374, 0.031131868434443974, 0.030765487541558872, 0.03036581635440501, 0.029933287343714098, 0.0294683685345669, 0.028971562999960947, 0.028443408316454845, 0.027884475982476814, 0.027295370799930194, 0.026676730219761333, 0.026029223652202078, 0.025353551742431892, 0.024650445612442538, 0.02392066606993068, 0.023165002785071515, 0.0223842734360694, 0.021579322824411554, 0.020751021960784766, 0.019900267122657335, 0.01902797888454552, 0.018135101122045336, 0.017222599990716934, 0.016291462880991172, 0.015342697350288518, 0.014377330033658984, 0.013396405534368003, 0.012400985296115863, 0.011392146459086072, 0.010370980703116501, 0.009338593083876447, 0.008296100874530385, 0.007244632443932776, 0.006185326261032374, 0.005119330329928406, 0.004047803316371942, 0.0029719242408186093, 0.0018929683779222934, 0.0008135642494554402},
	{0.0007967920655551096, 0.0018539607889438041, 0.0029107318179363785, 0.003964554338445037, 0.0050142027429287035, 0.006058545504235144, 0.007096470791153892, 0.008126876925698382, 0.009148671230782973, 0.010160770535008074, 0.011162102099838618, 0.012151604671087984, 0.013128229566961701, 0.014090941772314996, 0.015038721026994937, 0.0159705629025622, 0.016885479864245205, 0.017782502316045244, 0.018660679627411376, 0.01951908114014511, 0.020356797154333334, 0.021172939892191236, 0.021966644438744517, 0.022737069658329327, 0.023483399085926244, 0.024204841792364724, 0.02490063322248356, 0.025570036005349267, 0.026212340735672468, 0.02682686672559171, 0.027412962726029177, 0.02797000761684825, 0.028497411065085323, 0.028994614150555188, 0.029461089958167895, 0.02989634413632837, 0.030299915420827574, 0.030671376123669082, 0.03101033258631377, 0.031316425596861285, 0.03158933077072709, 0.03182875889441097, 0.0320344562319926, 0.03220620479403022, 0.03234382256857588, 0.03244716371406422, 0.032516118713868766, 0.0325506144923631, 0.0325506144923631, 0.032516118713868766, 0.03244716371406422, 0.03234382256857588, 0.03220620479403022, 0.0320344562319926, 0.03182875889441097, 0.03158933077072709, 0.031316425596861285, 0.03101033258631377, 0.030671376123669082, 0.030299915420827574, 0.02989634413632837, 0.029461089958167895, 0.028994614150555188, 0.028497411065085323, 0.02797000761684825, 0.027412962726029177, 0.02682686672559171, 0.026212340735672468, 0.025570036005349267, 0.02490063322248356, 0.024204841792364724, 0.023483399085926244, 0.022737069658329327, 0.021966644438744517, 0.021172939892191236, 0.020356797154333334, 0.01951908114014511, 0.018660679627411376, 0.017782502316045244, 0.016885479864245205, 0.0159705629025622, 0.015038721026994937, 0.014090941772314996, 0.013128229566961701, 0.012151604671087984, 0.011162102099838618, 0.010160770535008074, 0.009148671230782973, 0.008126876925698382, 0.007096470791153892, 0.006058545504235144, 0.0050142027429287035, 0.003964554338445037, 0.0029107318179363785, 0.0018539607889438041, 0.0007967920655551096},
	{0.0007805332219465117, 0.0018161463982113693, 0.0028514092432127885, 0.0038838453294899955, 0.004912276262165032, 0.005935615630788138, 0.006952796096469788, 0.007962759997865299, 0.008964458176698272, 0.00995685042708416, 0.010938906359195909, 0.011909606385330585, 0.01286794274249329, 0.013812920521853025, 0.014743558693237069, 0.015658891119156904, 0.016557967555342203, 0.017439854635807887, 0.01830363684096388, 0.01914841744752783, 0.019973319459107866, 0.02077748651642632, 0.021560083786191713, 0.02232029882766696, 0.023057342436025766, 0.02377044946160281, 0.024458879604187744, 0.025121918181529777, 0.02575887687125671, 0.02636909442542923, 0.026951937356996445, 0.02750680059743016, 0.028033108124862552, 0.02853031356206704, 0.028997900743668283, 0.02943538425198718, 0.029842309920966925, 0.03021825530765583, 0.030562830130758455, 0.030875676675797523, 0.031156470166468872, 0.03140491910180158, 0.031620765558773856, 0.031803785460071364, 0.031953788806708516, 0.03207061987527269, 0.03215415737958533, 0.03220431459661337, 0.03222103945649855, 0.03220431459661337, 0.03215415737958533, 0.03207061987527269, 0.031953788806708516, 0.031803785460071364, 0.031620765558773856, 0.03140491910180158, 0.031156470166468872, 0.030875676675797523, 0.030562830130758455, 0.03021825530765583, 0.029842309920966925, 0.02943538425198718, 0.028997900743668283, 0.02853031356206704, 0.028033108124862552, 0.02750680059743016, 0.026951937356996445, 0.02636909442542923, 0.02575887687125671, 0.025121918181529777, 0.024458879604187744, 0.02377044946160281, 0.023057342436025766, 0.02232029882766696, 0.021560083786191713, 0.02077748651642632, 0.019973319459107866, 0.01914841744752783, 0.01830363684096388, 0.017439854635807887, 0.016557967555342203, 0.015658891119156904, 0.014743558693237069, 0.013812920521853025, 0.01286794274249329, 0.011909606385330585, 0.010938906359195909, 0.00995685042708416, 0.008964458176698272, 0.007962759997865299, 0.006952796096469788, 0.005935615630788138, 0.004912276262165032, 0.0038838453294899955, 0.0028514092432127885, 0.0018161463982113693, 0.0007805332219465117},
	{0.0007647669822709107, 0.001779477041010497, 0.0027938811357221304, 0.003805574085351315, 0.004813422398585957, 0.005816382546440352, 0.0068134294791651045, 0.007803547379100159, 0.008785728467392508, 0.009758973402174116, 0.010722292083224488, 0.011674704577138087, 0.012615242078922222, 0.013542947881029712, 0.014456878338304741, 0.015356103823497877, 0.01623970967045355, 0.017106797103089866, 0.017956484148770463, 0.018787906534905082, 0.019600218567726455, 0.020392593992292138, 0.02116422683277494, 0.021914332212178696, 0.022642147150618613, 0.02334693134134951, 0.024027967903745603, 0.02468456411246125, 0.025316052102026396, 0.025921789546162772, 0.026501160311123907, 0.027053575082396395, 0.027578471964122653, 0.028075317050636442, 0.028543604969528232, 0.02898285939568863, 0.029392633535806793, 0.029772510582829814, 0.03012210413992223, 0.030441058613493596, 0.030729049574893995, 0.03098578409041024, 0.031211001019226577, 0.031404471279046914, 0.03156599807910843, 0.03169541712034957, 0.03179259676252894, 0.031857438158124335, 0.03188987535287677, 0.03188987535287677, 0.031857438158124335, 0.03179259676252894, 0.03169541712034957, 0.03156599807910843, 0.031404471279046914, 0.031211001019226577, 0.03098578409041024, 0.030729049574893995, 0.030441058613493596, 0.03012210413992223, 0.029772510582829814, 0.029392633535806793, 0.02898285939568863, 0.028543604969528232, 0.028075317050636442, 0.027578471964122653, 0.027053575082396395, 0.026501160311123907, 0.025921789546162772, 0.025316052102026396, 0.02468456411246125, 0.024027967903745603, 0.02334693134134951, 0.022642147150618613, 0.021914332212178696, 0.02116422683277494, 0.020392593992292138, 0.019600218567726455, 0.018787906534905082, 0.017956484148770463, 0.017106797103089866, 0.01623970967045355, 0.015356103823497877, 0.014456878338304741, 0.013542947881029712, 0.012615242078922222, 0.011674704577138087, 0.010722292083224488, 0.009758973402174116, 0.008785728467392508, 0.007803547379100159, 0.0068134294791651045, 0.005816382546440352, 0.004813422398585957, 0.003805574085351315, 0.0027938811357221304, 0.001779477041010497, 0.0007647669822709107},
	{0.0007494736467398138, 0.0017439069582158347, 0.002738075873628021, 0.00372964348724204, 0.004717519037520736, 0.005700699773396526, 0.006678200860575141, 0.007649046279334905, 0.008612267615478689, 0.009566904411326498, 0.010512004915524568, 0.011446626951498338, 0.01236983882217502, 0.01328072022265703, 0.014178363149579595, 0.01506187280199032, 0.015930368470960687, 0.016782984416138656, 0.01761887072792446, 0.018437194174178426, 0.01923713903048718, 0.02001790789308651, 0.020778722473594337, 0.021518824374730232, 0.022237475846239405, 0.022933960520251186, 0.023607584125337776, 0.024257675178557085, 0.02488358565478196, 0.025484691632654845, 0.026060393916515476, 0.02661011863368581, 0.02713331780651271, 0.027629469898599088, 0.028098080334680958, 0.02853868199362698, 0.02895083567407332, 0.02933413053222754, 0.029688184491405117, 0.030012644622891115, 0.03030718749774584, 0.03057151950920587, 0.03080537716535635, 0.031008527351785664, 0.031180767563958194, 0.03132192610907524, 0.031431862277221605, 0.03151046648162837, 0.03155766036791128, 0.03157339689217573, 0.03155766036791128, 0.03151046648162837, 0.031431862277221605, 0.03132192610907524, 0.031180767563958194, 0.031008527351785664, 0.03080537716535635, 0.03057151950920587, 0.03030718749774584, 0.030012644622891115, 0.029688184491405117, 0.02933413053222754, 0.02895083567407332, 0.02853868199362698, 0.028098080334680958, 0.027629469898599088, 0.02713331780651271, 0.02661011863368581, 0.026060393916515476, 0.025484691632654845, 0.02488358565478196, 0.024257675178557085, 0.023607584125337776, 0.022933960520251186, 0.022237475846239405, 0.021518824374730232, 0.020778722473594337, 0.02001790789308651, 0.01923713903048718, 0.018437194174178426, 0.01761887072792446, 0.016782984416138656, 0.015930368470960687, 0.01506187280199032, 0.014178363149579595, 0.01328072022265703, 0.01236983882217502, 0.011446626951498338, 0.010512004915524568, 0.009566904411326498, 0.008612267615478689, 0.007649046279334905, 0.006678200860575141, 0.005700699773396526, 0.004717519037520736, 0.00372964348724204, 0.002738075873628021, 0.0017439069582158347, 0.0007494736467398138},
	{0.0007346344905008809, 0.001709392653517807, 0.002683925371554019, 0.003655961201327216, 0.004624450063421818, 0.005588428003865117, 0.00654694845084515, 0.007499073255464816, 0.008443871469668721, 0.009380419653694542, 0.01030780257486916, 0.01122511402318622, 0.012131457662979251, 0.013025947892971715, 0.01390771070371885, 0.014775884527441474, 0.015629621077546098, 0.01646808617614516, 0.017290460568323632, 0.018095940722128407, 0.018883739613374886, 0.01965308749443545, 0.020403232646209593, 0.021133442112527594, 0.02184300241624754, 0.02253122025633626, 0.02319742318525442, 0.023840960265968263, 0.024461202707957153, 0.025057544481579718, 0.025629402910208283, 0.02617621923954582, 0.02669745918357113, 0.02719261344657694, 0.027661198220792507, 0.028102755659101357, 0.028516854322395237, 0.028903089601125278, 0.029261084110638446, 0.029590488059912694, 0.02989097959333295, 0.03016226510516929, 0.030404079526454932, 0.030616186583980524, 0.03079837903115269, 0.030950478850491105, 0.03107233742756666, 0.031163835696210035, 0.03122488425484948, 0.03125542345386349, 0.03125542345386349, 0.03122488425484948, 0.031163835696210035, 0.03107233742756666, 0.030950478850491105, 0.03079837903115269, 0.030616186583980524, 0.030404079526454932, 0.03016226510516929, 0.02989097959333295, 0.029590488059912694, 0.029261084110638446, 0.028903089601125278, 0.028516854322395237, 0.028102755659101357, 0.027661198220792507, 0.02719261344657694, 0.02669745918357113, 0.02617621923954582, 0.025629402910208283, 0.025057544481579718, 0.024461202707957153, 0.023840960265968263, 0.02319742318525442, 0.02253122025633626, 0.02184300241624754, 0.021133442112527594, 0.020403232646209593, 0.01965308749443545, 0.018883739613374886, 0.018095940722128407, 0.017290460568323632, 0.01646808617614516, 0.015629621077546098, 0.014775884527441474, 0.01390771070371885, 0.013025947892971715, 0.012131457662979251, 0.01122511402318622, 0.01030780257486916, 0.009380419653694542, 0.008443871469668721, 0.007499073255464816, 0.00654694845084515, 0.005588428003865117, 0.004624450063421818, 0.003655961201327216, 0.002683925371554019, 0.001709392653517807, 0.0007346344905008809},
};
