# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../nbs/03_data.external.wcrc.ipynb.

# %% auto 0
__all__ = ['load_wetchem', 'bundle']

# %% ../../../nbs/03_data.external.wcrc.ipynb 3
import pandas as pd
import numpy as np
import kennard_stone as ks
from sklearn.model_selection import train_test_split
from fastcore.basics import patch
from fastcore.xtras import mkdir
from pathlib import Path
import glob
import re
from tqdm import tqdm
from typing import Dict, Callable

from ...readers import read_spa

# %% ../../../nbs/03_data.external.wcrc.ipynb 4
def load_wetchem(fname:str, # folder path containing data
                 source:list[str]=['KSSL'], # name of the labs measuring. Possible values are: 'KSSL' and 'NAPT'
                ) -> pd.DataFrame:  # Loaded Wet Chemistry
    "Load wet chemistry (target)"
    df =  pd.read_csv(fname)
    return df[df['source'].isin(source)]

# %% ../../../nbs/03_data.external.wcrc.ipynb 7
def bundle(df_wet:pd.DataFrame, # Wet chemistry
           df_spec:pd.DataFrame, # Spectra
           dest_dir:str, # Destination directory
           analytes:list[str] = ['clay_perc', 'pH_H20', 'carbon_tot_perc',
                                 'carbon_org_perc', 'potassium_cmolkg', 'phosporus_mgkg'], # Analytes of interest
           ks_on_features:bool=True, # Kennard-Stone splitting on 'features' True or 'target' otherwise
          ):
    """Bundle WCRC datasets as follows:
        - /dest_dir/
        -          /organization
        -              /analyte
        -                  /train
        -                      /sample_id
        -                          target.csv
        -                          spectrum.csv
        -                  /test
        -                      /sample_id
        -                          target.csv
        -                          spectrum.csv
    """
    for org, group in tqdm(df_spec.groupby('organization')):
        for analyte in analytes:
            # Get list of sample ids
            df_y = df_wet.dropna(subset=analyte)
            idx_smp = df_y['sample_id'].values
            
            # Select respective spectrum
            spectrum = group.set_index('sample_id').loc[idx_smp,:]
            X = spectrum.iloc[:,2:].values[:, ::-1]
            wns = spectrum.iloc[:,2:].columns[::-1]
            y = df_y[analyte].values
            
            # Train/test split using Kennard-Stone algo. on target
            #if ks_on_features:
            #    y_train, y_test, X_train, X_test, idx_train, idx_test = ks.train_test_split(y.reshape(-1, 1), 
            #                                                                                X, idx_smp, test_size=0.2)

            #else:
            #    X_train, X_test, y_train, y_test, idx_train, idx_test = ks.train_test_split(X, y, 
                                                                                            #idx_smp, test_size=0.2)
            X_train, X_test, y_train, y_test, idx_train, idx_test = train_test_split(X, y, 
                                                                                     idx_smp, test_size=0.2,
                                                                                     random_state=42)
            for ds, (idxs, X, y) in {'train': (idx_train, X_train, y_train),
                                     'test': (idx_test, X_test, y_test)}.items():
                for i, idx in enumerate(idxs):
                    path = Path(dest_dir) / org / analyte / ds / idx
                    mkdir(path, parents=True, overwrite=True)
                    
                    # Write spectrum
                    spectrum = pd.Series(data=X[i,:], index=wns, name='absorbance')
                    spectrum.index.name = 'wavenumber'
                    out_fname = path / 'spectrum.csv'
                    spectrum.to_csv(out_fname)
                    
                    # Write target
                    target = pd.Series(y[i], index=[analyte])
                    target.index.name = 'analyte'
                    target.name = 'value'
                    out_fname = path / 'target.csv'
                    target.to_csv(out_fname)


