import pandas as pd
import pytest


@pytest.fixture(scope="module")
def df_time():
    date_time = [
        "2020-05-15 12:00:00",
        "2020-05-15 12:15:00",
        "2020-05-15 12:30:00",
        "2020-05-15 12:45:00",
        "2020-05-15 13:00:00",
        "2020-05-15 13:15:00",
        "2020-05-15 13:30:00",
        "2020-05-15 13:45:00",
        "2020-05-15 14:00:00",
        "2020-05-15 14:15:00",
        "2020-05-15 14:30:00",
        "2020-05-15 14:45:00",
        "2020-05-15 15:00:00",
        "2020-05-15 15:15:00",
        "2020-05-15 15:30:00",
    ]

    data = {
        "ambient_temp": [
            31.31,
            31.51,
            32.15,
            32.39,
            32.62,
            32.5,
            32.52,
            32.68,
            33.76,
            34.13,
            34.08,
            33.7,
            33.89,
            34.04,
            34.4,
        ],
        "module_temp": [
            49.18,
            49.84,
            52.35,
            50.63,
            49.61,
            47.01,
            46.67,
            47.52,
            49.8,
            55.03,
            54.52,
            47.62,
            46.03,
            44.29,
            46.74,
        ],
        "irradiation": [
            0.51,
            0.79,
            0.65,
            0.76,
            0.42,
            0.49,
            0.57,
            0.56,
            0.74,
            0.89,
            0.47,
            0.54,
            0.4,
            0.45,
            0.57,
        ],
        "color": ["blue"] * 10 + ["green"] * 5,
    }

    df = pd.DataFrame(data, index=date_time)
    df.index = pd.to_datetime(df.index)
    return df
