from setuptools import find_packages, setup
from pathlib import Path


CURRENT_DIR = Path(__file__).parent

with open(CURRENT_DIR / 'README.md') as readme_file:
    readme = readme_file.read()

# get the dependencies and installs
with open(f'{CURRENT_DIR / "requirements.txt"}', "r", encoding="utf-8") as f:
    # Make sure we strip all comments and options (e.g "--extra-index-url")
    # that arise from a modified pip.conf file that configure global options
    # when running kedro build-reqs
    requires = []
    for line in f:
        req = line.split("#", 1)[0].strip()
        if req and not req.startswith("--"):
            requires.append(req)

setup(
    name='pyalgorand',
    version="0.1.0",
    packages=find_packages(exclude=["tests"]),
    long_description=readme,
    long_description_content_type="text/markdown",
    author="Jean-Baptiste Poullet",
    author_email='jeanbaptistepoullet@gmail.com',
    url='https://bitbucket.org/kuiristo/pyalgorand',
    install_requires=requires,
    license='Apache Software License 2.0',
    extras_require={
        "docs": [
            "sphinx~=3.4.3",
            "sphinx_rtd_theme==0.5.1",
            "nbsphinx==0.8.1",
            "nbstripout==0.3.3",
            "recommonmark==0.7.1",
            "sphinx-autodoc-typehints==1.11.1",
            "sphinx_copybutton==0.3.1",
            "ipykernel~=5.3",
        ]
    }
)
