/*
 * Decompiled with CFR 0.152.
 */
package carpet.settings;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.network.ServerNetworkHandler;
import carpet.script.CarpetEventServer;
import carpet.settings.ParsedRule;
import carpet.settings.Rule;
import carpet.settings.Validator;
import carpet.utils.Messenger;
import carpet.utils.Translations;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2554;
import net.minecraft.class_3222;
import net.minecraft.class_3738;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.TriConsumer;

public class SettingsManager {
    private Map<String, ParsedRule<?>> rules = new HashMap();
    public boolean locked;
    private final String version;
    private final String identifier;
    private final String fancyName;
    private MinecraftServer server;
    private List<TriConsumer<class_2168, ParsedRule<?>, String>> observers = new ArrayList();
    private static List<TriConsumer<class_2168, ParsedRule<?>, String>> staticObservers = new ArrayList();

    public SettingsManager(String version, String identifier) {
        this.version = version;
        this.identifier = identifier;
        this.fancyName = identifier;
    }

    public SettingsManager(String version, String identifier, String fancyName) {
        this.version = version;
        this.identifier = identifier;
        this.fancyName = fancyName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void attachServer(MinecraftServer server) {
        this.server = server;
        this.loadConfigurationFromConf();
    }

    public void detachServer() {
        for (ParsedRule<?> rule : this.rules.values()) {
            rule.resetToDefault(null);
        }
        this.server = null;
    }

    public void parseSettingsClass(Class settingsClass) {
        for (Field f : settingsClass.getDeclaredFields()) {
            Rule rule = f.getAnnotation(Rule.class);
            if (rule == null) continue;
            ParsedRule parsed = new ParsedRule(f, rule, this);
            this.rules.put(parsed.name, parsed);
        }
    }

    public void addRuleObserver(TriConsumer<class_2168, ParsedRule<?>, String> observer) {
        this.observers.add(observer);
    }

    public static void addGlobalRuleObserver(TriConsumer<class_2168, ParsedRule<?>, String> observer) {
        staticObservers.add(observer);
    }

    void notifyRuleChanged(class_2168 source, ParsedRule<?> rule, String userTypedValue) {
        this.observers.forEach(observer -> observer.accept((Object)source, (Object)rule, (Object)userTypedValue));
        staticObservers.forEach(observer -> observer.accept((Object)source, (Object)rule, (Object)userTypedValue));
        ServerNetworkHandler.updateRuleWithConnectedClients(rule);
        this.switchScarpetRule(source, rule);
        if (CarpetEventServer.Event.CARPET_RULE_CHANGES.isNeeded()) {
            CarpetEventServer.Event.CARPET_RULE_CHANGES.onCarpetRuleChanges(rule, source);
        }
    }

    void switchScarpetRule(class_2168 source, ParsedRule<?> rule) {
        if (!rule.scarpetApp.isEmpty()) {
            if (rule.getBoolValue() || rule.type == String.class && !rule.get().equals("false")) {
                CarpetServer.scriptServer.addScriptHost(source, rule.scarpetApp, false, false, true);
            } else {
                CarpetServer.scriptServer.removeScriptHost(source, rule.scarpetApp, false, true);
            }
        }
    }

    public void initializeScarpetRules() {
        for (ParsedRule<?> rule : this.rules.values()) {
            if (rule.scarpetApp.isEmpty()) continue;
            this.switchScarpetRule(this.server.method_3739(), rule);
        }
    }

    public Iterable<String> getCategories() {
        HashSet<String> categories = new HashSet<String>();
        this.getRules().stream().map(r -> r.categories).forEach(categories::addAll);
        return categories;
    }

    public ParsedRule<?> getRule(String name) {
        return this.rules.get(name);
    }

    public Collection<ParsedRule<?>> getRules() {
        return this.rules.values().stream().sorted().collect(Collectors.toList());
    }

    public Collection<ParsedRule<?>> findStartupOverrides() {
        Set defaults = ((Map)this.readSettingsFromConf().getLeft()).keySet();
        return this.rules.values().stream().filter(r -> defaults.contains(r.name)).sorted().collect(Collectors.toList());
    }

    public Collection<ParsedRule<?>> getNonDefault() {
        return this.rules.values().stream().filter(r -> !r.isDefault()).sorted().collect(Collectors.toList());
    }

    private File getFile() {
        return this.server.method_27050(class_5218.field_24188).resolve(this.identifier + ".conf").toFile();
    }

    public void disableBooleanCommands() {
        for (ParsedRule<?> rule : this.rules.values()) {
            if (!rule.categories.contains((Object)"command")) continue;
            if (rule.type == Boolean.TYPE) {
                rule.set(this.server.method_3739(), false, "false");
            }
            if (rule.type != String.class || !rule.options.contains((Object)"false")) continue;
            rule.set(this.server.method_3739(), "false", "false");
        }
    }

    private void writeSettingsToConf(Map<String, String> values) {
        if (this.locked) {
            return;
        }
        try {
            FileWriter fw = new FileWriter(this.getFile());
            for (String key : values.keySet()) {
                fw.write(key + " " + values.get(key) + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            CarpetSettings.LOG.error("[CM]: failed write " + this.identifier + ".conf config file");
        }
    }

    public void notifyPlayersCommandsChanged() {
        if (this.server == null || this.server.method_3760() == null) {
            return;
        }
        this.server.method_18858((Runnable)new class_3738(this.server.method_3780(), () -> {
            for (class_3222 entityplayermp : this.server.method_3760().method_14571()) {
                this.server.method_3734().method_9241(entityplayermp);
            }
        }));
    }

    public static boolean canUseCommand(class_2168 source, String commandLevel) {
        switch (commandLevel) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
            case "ops": {
                return source.method_9259(2);
            }
            case "0": 
            case "1": 
            case "2": 
            case "3": 
            case "4": {
                return source.method_9259(Integer.parseInt(commandLevel));
            }
        }
        return false;
    }

    public static int getCommandLevel(String commandLevel) {
        switch (commandLevel) {
            case "true": {
                return 2;
            }
            case "false": {
                return 0;
            }
            case "ops": {
                return 2;
            }
            case "0": 
            case "1": 
            case "2": 
            case "3": 
            case "4": {
                return Integer.parseInt(commandLevel);
            }
        }
        return 0;
    }

    private void loadConfigurationFromConf() {
        for (ParsedRule<?> rule : this.rules.values()) {
            rule.resetToDefault(this.server.method_3739());
        }
        Pair<Map<String, String>, Boolean> conf = this.readSettingsFromConf();
        this.locked = false;
        if (((Boolean)conf.getRight()).booleanValue()) {
            CarpetSettings.LOG.info("[CM]: " + this.fancyName + " features are locked by the administrator");
            this.disableBooleanCommands();
        }
        for (String key : ((Map)conf.getLeft()).keySet()) {
            try {
                if (this.rules.get(key).set(this.server.method_3739(), (String)((Map)conf.getLeft()).get(key)) == null) continue;
                CarpetSettings.LOG.info("[CM]: loaded setting " + key + " as " + (String)((Map)conf.getLeft()).get(key) + " from " + this.identifier + ".conf");
            }
            catch (Exception exc) {
                CarpetSettings.LOG.error("[CM Error]: Failed to load setting: " + key + ", " + exc);
            }
        }
        this.locked = (Boolean)conf.getRight();
    }

    private Pair<Map<String, String>, Boolean> readSettingsFromConf() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.getFile()));
            String line = "";
            boolean confLocked = false;
            HashMap<String, String> result = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                String[] fields;
                if ("locked".equalsIgnoreCase(line = line.replaceAll("[\\r\\n]", ""))) {
                    confLocked = true;
                }
                if ((fields = line.split("\\s+", 2)).length <= 1) continue;
                if (!this.rules.containsKey(fields[0])) {
                    CarpetSettings.LOG.error("[CM]: " + this.fancyName + " Setting " + fields[0] + " is not a valid - ignoring...");
                    continue;
                }
                ParsedRule<?> rule = this.rules.get(fields[0]);
                if (!rule.options.contains((Object)fields[1]) && rule.isStrict) {
                    CarpetSettings.LOG.error("[CM]: The value of " + fields[1] + " for " + fields[0] + "(" + this.fancyName + ") is not valid - ignoring...");
                    continue;
                }
                result.put(fields[0], fields[1]);
            }
            reader.close();
            return Pair.of(result, (Object)confLocked);
        }
        catch (FileNotFoundException e) {
            return Pair.of(new HashMap(), (Object)false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Pair.of(new HashMap(), (Object)false);
        }
    }

    private Collection<ParsedRule<?>> getRulesMatching(String search) {
        String lcSearch = search.toLowerCase(Locale.ROOT);
        return (Collection)this.rules.values().stream().filter(rule -> {
            if (rule.name.toLowerCase(Locale.ROOT).contains(lcSearch)) {
                return true;
            }
            for (String c : rule.categories) {
                if (!c.equals(search)) continue;
                return true;
            }
            return Sets.newHashSet((Object[])rule.description.toLowerCase(Locale.ROOT).split("\\W+")).contains(lcSearch);
        }).sorted().collect(ImmutableList.toImmutableList());
    }

    public int printAllRulesToLog(String category) {
        PrintStream ps = System.out;
        ps.println("# " + this.fancyName + " Settings");
        for (Map.Entry<String, ParsedRule<?>> e : new TreeMap(this.rules).entrySet()) {
            ParsedRule<?> rule = e.getValue();
            if (category != null && !rule.categories.contains((Object)category)) continue;
            ps.println("## " + rule.name);
            ps.println(rule.description + "  ");
            for (String extra : rule.extraInfo) {
                ps.println(extra + "  ");
            }
            ps.println("* Type: `" + rule.type.getSimpleName() + "`  ");
            ps.println("* Default value: `" + rule.defaultAsString + "`  ");
            String optionString = rule.options.stream().map(s -> "`" + s + "`").collect(Collectors.joining(", "));
            ps.println((rule.isStrict ? "* Required" : "* Suggested") + " options: " + optionString + "  ");
            ps.println("* Categories: " + rule.categories.stream().map(s -> "`" + s.toUpperCase(Locale.ROOT) + "`").collect(Collectors.joining(", ")) + "  ");
            boolean preamble = false;
            for (Validator validator : rule.validators) {
                if (validator.description() == null) continue;
                if (!preamble) {
                    ps.println("* Additional notes:  ");
                    preamble = true;
                }
                ps.println("  * " + validator.description() + "  ");
            }
            ps.println("  ");
        }
        return 1;
    }

    private ParsedRule<?> contextRule(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String ruleName = StringArgumentType.getString(ctx, (String)"rule");
        ParsedRule<?> rule = this.getRule(ruleName);
        if (rule == null) {
            throw new SimpleCommandExceptionType((Message)Messenger.c("rb " + Translations.tr("ui.unknown_rule", "Unknown rule") + ": " + ruleName)).create();
        }
        return rule;
    }

    public void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        if (dispatcher.getRoot().getChildren().stream().anyMatch(node -> node.getName().equalsIgnoreCase(this.identifier))) {
            CarpetSettings.LOG.error("Failed to add settings command for " + this.identifier + ". It is masking previous command.");
            return;
        }
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)this.identifier).requires(player -> player.method_9259(2) && !this.locked);
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalargumentbuilder.executes(context -> this.listAllSettings((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(c -> this.listSettings((class_2168)c.getSource(), String.format(Translations.tr("ui.all_%(mod)s_settings", "All %s Settings"), this.fancyName), this.getRules()))).then(class_2170.method_9247((String)"defaults").executes(c -> this.listSettings((class_2168)c.getSource(), String.format(Translations.tr("ui.current_%(mod)s_startup_settings_from_%(conf)s", "Current %s Startup Settings from %s"), this.fancyName, this.identifier + ".conf"), this.findStartupOverrides())))).then(class_2170.method_9244((String)"tag", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9265(this.getCategories(), (SuggestionsBuilder)b)).executes(c -> this.listSettings((class_2168)c.getSource(), String.format(Translations.tr("ui.%(mod)s_settings_matching_'%(query)s'", "%s Settings matching \"%s\""), this.fancyName, Translations.tr("category." + StringArgumentType.getString((CommandContext)c, (String)"tag"), StringArgumentType.getString((CommandContext)c, (String)"tag"))), this.getRulesMatching(StringArgumentType.getString((CommandContext)c, (String)"tag"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"removeDefault").requires(s -> !this.locked)).then(class_2170.method_9244((String)"rule", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9264(this.getRules().stream().map(r -> r.name), (SuggestionsBuilder)b)).executes(c -> this.removeDefault((class_2168)c.getSource(), this.contextRule((CommandContext<class_2168>)c)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setDefault").requires(s -> !this.locked)).then(class_2170.method_9244((String)"rule", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9264(this.getRules().stream().map(r -> r.name), (SuggestionsBuilder)b)).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests((c, b) -> class_2172.method_9265(this.contextRule((CommandContext<class_2168>)c).options, (SuggestionsBuilder)b)).executes(c -> this.setDefault((class_2168)c.getSource(), this.contextRule((CommandContext<class_2168>)c), StringArgumentType.getString((CommandContext)c, (String)"value"))))))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"rule", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9264(this.getRules().stream().map(r -> r.name), (SuggestionsBuilder)b)).requires(s -> !this.locked)).executes(c -> this.displayRuleMenu((class_2168)c.getSource(), this.contextRule((CommandContext<class_2168>)c)))).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests((c, b) -> class_2172.method_9265(this.contextRule((CommandContext<class_2168>)c).options, (SuggestionsBuilder)b)).executes(c -> this.setRule((class_2168)c.getSource(), this.contextRule((CommandContext<class_2168>)c), StringArgumentType.getString((CommandContext)c, (String)"value")))));
        dispatcher.register(literalargumentbuilder);
    }

    private int displayRuleMenu(class_2168 source, ParsedRule<?> rule) {
        String displayName = rule.translatedName();
        Messenger.m(source, "");
        Messenger.m(source, "wb " + displayName, "!/" + this.identifier + " " + rule.name, "^g refresh");
        Messenger.m(source, "w " + rule.translatedDescription());
        rule.translatedExtras().forEach(s -> Messenger.m(source, "g  " + s));
        ArrayList<class_2554> tags = new ArrayList<class_2554>();
        tags.add(Messenger.c("w " + Translations.tr("ui.tags", "Tags") + ": "));
        for (String t : rule.categories) {
            String translated = Translations.tr("category." + t, t);
            tags.add(Messenger.c("c [" + translated + "]", "^g " + String.format(Translations.tr("list_all_%s_settings", "list all %s settings"), translated), "!/" + this.identifier + " list " + t));
            tags.add(Messenger.c("w , "));
        }
        tags.remove(tags.size() - 1);
        Messenger.m(source, tags.toArray(new Object[0]));
        Messenger.m(source, "w " + Translations.tr("ui.current_value", "Current value") + ": ", String.format("%s %s (%s value)", rule.getBoolValue() ? "lb" : "nb", rule.getAsString(), rule.isDefault() ? "default" : "modified"));
        ArrayList<class_2554> options = new ArrayList<class_2554>();
        options.add(Messenger.c("w Options: ", "y [ "));
        for (String o : rule.options) {
            options.add(this.makeSetRuleButton(rule, o, false));
            options.add(Messenger.c("w  "));
        }
        options.remove(options.size() - 1);
        options.add(Messenger.c("y  ]"));
        Messenger.m(source, options.toArray(new Object[0]));
        return 1;
    }

    private int setRule(class_2168 source, ParsedRule<?> rule, String newValue) {
        if (rule.set(source, newValue) != null) {
            Messenger.m(source, "w " + rule.toString() + ", ", "c [" + Translations.tr("ui.change_permanently", "change permanently") + "?]", "^w " + String.format(Translations.tr("ui.click_to_keep_the_settings_in_%(conf)s_to_save_across_restarts", "Click to keep the settings in %s to save across restarts"), this.identifier + ".conf"), "?/" + this.identifier + " setDefault " + rule.name + " " + rule.getAsString());
        }
        return 1;
    }

    private int setDefault(class_2168 source, ParsedRule<?> rule, String stringValue) {
        if (this.locked) {
            return 0;
        }
        if (!this.rules.containsKey(rule.name)) {
            return 0;
        }
        Pair<Map<String, String>, Boolean> conf = this.readSettingsFromConf();
        ((Map)conf.getLeft()).put(rule.name, stringValue);
        this.writeSettingsToConf((Map)conf.getLeft());
        rule.set(source, stringValue);
        Messenger.m(source, "gi " + String.format(Translations.tr("ui.rule_%(rule)s_will_now_default_to_%(value)s", "Rule %s will now default to %s"), rule.translatedName(), stringValue));
        return 1;
    }

    private int removeDefault(class_2168 source, ParsedRule<?> rule) {
        if (this.locked) {
            return 0;
        }
        if (!this.rules.containsKey(rule.name)) {
            return 0;
        }
        Pair<Map<String, String>, Boolean> conf = this.readSettingsFromConf();
        ((Map)conf.getLeft()).remove(rule.name);
        this.writeSettingsToConf((Map)conf.getLeft());
        this.rules.get(rule.name).resetToDefault(source);
        Messenger.m(source, "gi " + String.format(Translations.tr("ui.rule_%(rule)s_not_set_restart", "Rule %s will now not be set on restart"), rule.translatedName()));
        return 1;
    }

    private class_2554 displayInteractiveSetting(ParsedRule<?> rule) {
        String displayName = rule.translatedName();
        ArrayList<String> args = new ArrayList<String>();
        args.add("w - " + displayName + " ");
        args.add("!/" + this.identifier + " " + rule.name);
        args.add("^y " + rule.translatedDescription());
        for (String option : rule.options) {
            args.add((String)this.makeSetRuleButton(rule, option, true));
            args.add("w  ");
        }
        if (!rule.options.contains((Object)rule.getAsString())) {
            args.add((String)this.makeSetRuleButton(rule, rule.getAsString(), true));
            args.add("w  ");
        }
        args.remove(args.size() - 1);
        return Messenger.c(args.toArray(new Object[0]));
    }

    private class_2554 makeSetRuleButton(ParsedRule<?> rule, String option, boolean brackets) {
        String style;
        String string = rule.isDefault() ? "g" : (style = option.equalsIgnoreCase(rule.defaultAsString) ? "e" : "y");
        if (option.equalsIgnoreCase(rule.getAsString())) {
            style = style + "u";
            if (option.equalsIgnoreCase(rule.defaultAsString)) {
                style = style + "b";
            }
        }
        String baseText = style + (brackets ? " [" : " ") + option + (brackets ? "]" : "");
        if (this.locked) {
            return Messenger.c(baseText, "^g " + this.fancyName + " " + Translations.tr("ui.settings_are_locked", "settings are locked"));
        }
        if (option.equalsIgnoreCase(rule.getAsString())) {
            return Messenger.c(baseText);
        }
        return Messenger.c(baseText, "^g " + Translations.tr("ui.switch_to", "Switch to") + " " + option + (option.equalsIgnoreCase(rule.defaultAsString) ? " (default)" : ""), "?/" + this.identifier + " " + rule.name + " " + option);
    }

    private int listSettings(class_2168 source, String title, Collection<ParsedRule<?>> settings_list) {
        Messenger.m(source, String.format("wb %s:", title));
        settings_list.forEach(e -> Messenger.m(source, this.displayInteractiveSetting((ParsedRule<?>)e)));
        return settings_list.size();
    }

    private int listAllSettings(class_2168 source) {
        int count = this.listSettings(source, String.format(Translations.tr("ui.current_%(mod)s_settings", "Current %s Settings"), this.fancyName), this.getNonDefault());
        if (this.version != null) {
            Messenger.m(source, "g " + this.fancyName + " " + Translations.tr("ui.version", "version") + ": " + this.version);
        }
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("w " + Translations.tr("ui.browse_categories", "Browse Categories") + ":\n");
        for (String t : this.getCategories()) {
            String catKey = "category." + t;
            String translated = Translations.tr(catKey, t);
            String translatedPlus = Translations.hasTranslation(catKey) ? String.format("%s (%s)", Translations.tr(catKey, t), t) : t;
            tags.add("c [" + translated + "]");
            tags.add("^g " + String.format(Translations.tr("ui.list_all_%(cat)s_settings", "list all %s settings"), translatedPlus));
            tags.add("!/" + this.identifier + " list " + t);
            tags.add("w  ");
        }
        tags.remove(tags.size() - 1);
        Messenger.m(source, tags.toArray(new Object[0]));
        return count;
    }

    public void inspectClientsideCommand(class_2168 source, String string) {
        String[] res;
        if (string.startsWith("/carpet ") && (res = string.split("\\s+", 3)).length == 3) {
            String setting = res[1];
            String strOption = res[2];
            if (this.rules.containsKey(setting) && this.rules.get((Object)setting).isClient) {
                this.rules.get(setting).set(source, strOption);
            }
        }
    }
}

